/*
 * cwdaemon - morse sounding daemon for the parallel or serial port
 * Copyright (C) 2002 -2003 Joop Stakenborg <pg4i@amsat.org>
 *                       and many authors, see the AUTHORS file.
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

# if HAVE_STDIO_H
# include <stdio.h>
#endif
#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif
#if HAVE_UNISTD_H
# include <unistd.h>
#endif
#if HAVE_SYS_IOCTL_H
# include <sys/ioctl.h>
#endif
#if HAVE_FCNTL_H
# include <fcntl.h>
#endif
#if HAVE_TERMIOS_H
# include <termios.h>
#endif

#include "cwdaemon.h"

/* serial port functions*/

int
ttys_init (cwdevice * dev)
{
	int fd;
	char device[20];

	sprintf (device, "%s%s", "/dev/", dev->desc);
	fd = open (device, O_RDWR | O_NOCTTY | O_NDELAY);
	if (fd < 0)
	{
		errmsg ("Open serial port %s", dev->desc);
		exit (1);
	}
	debug ("Serial port opened");
	dev->fd = fd;
	dev->reset (dev);
	return 0;
}

int
ttys_free (cwdevice * dev)
{
	dev->reset (dev);
	close (dev->fd);
	return 0;
}

int
ttys_reset (cwdevice * dev)
{
	ttys_cw (dev, OFF);
	ttys_ptt (dev, OFF);
	return 0;
}


/* CW keying - bit1 (pin 4 for DB-9) */
int
ttys_cw (cwdevice * dev, int onoff)
{
	int result, y = TIOCM_DTR;

	result = ioctl (dev->fd, onoff ? TIOCMBIS : TIOCMBIC, &y);
	if (result < 0)
	{
		errmsg ("Ioctl serial port %s", dev->desc);
		exit (1);
	}
	return 0;
}

/* SSB PTT keying - 0 bit (pin 7 for DB-9) */
int
ttys_ptt (cwdevice * dev, int onoff)
{
	int result, y = TIOCM_RTS;

	result = ioctl (dev->fd, onoff ? TIOCMBIS : TIOCMBIC, &y);
	if (result < 0)
	{
		errmsg ("Ioctl serial port %s", dev->desc);
		exit (1);
	}
	return 0;
}
