/* InfoDisplayController.m - this file is part of Cynthiune
 *
 * Copyright (C) 2002-2004  Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import <AppKit/AppKit.h>

#import "NSNumberExtensions.h"

#import "FormatTester.h"
#import "InfoDisplayController.h"
#import "Song.h"
#import "utils.h"

#define LOCALIZED(X) NSLocalizedString (X, nil)

@implementation InfoDisplayController : NSObject

- (void) initializeWidgets
{
  NSFont *myFont;

  myFont = [NSFont boldSystemFontOfSize: 12.0];
  [songTitleField setFont: myFont];
  myFont = [NSFont systemFontOfSize: 12.0];
  [songTimerField setFont: myFont];
  [songNumberField setFont: myFont];
  [songArtistField setFont: myFont];
  [songAlbumField setFont: myFont];

  [self hide];
}

- (InfoDisplayController *) init
{
  if ((self = [super init]))
    {
      reverseTimer = NO;
      totalTime = 0;
    }

  return self;
}

- (void) show
{
  [splashImage setImage: [NSImage imageNamed: @"cynthiune-splash-faded"]];

  [songTitleField setSelectable: YES];
  [songNumberField setSelectable: YES];
  [songArtistField setSelectable: YES];
  [songAlbumField setSelectable: YES];
}

- (void) hide
{
  [splashImage setImage: [NSImage imageNamed: @"cynthiune-splash"]];

  [songTitleField setSelectable: NO];
  [songNumberField setSelectable: NO];
  [songArtistField setSelectable: NO];
  [songAlbumField setSelectable: NO];

  [songTitleField setStringValue: @""];
  [songTimerField setStringValue: @""];
  [songNumberField setStringValue: @""];
  [songArtistField setStringValue: @""];
  [songAlbumField setStringValue: @""];
}

- (void) updateInfoFieldsFromSong: (Song *) aSong
{
  NSString *title;

  title = [aSong title];
  if ([title isEqualToString: @""])
    title = [NSString stringWithFormat: @"[%@]", [aSong filename]];
  [songArtistField setStringValue: [aSong artist]];
  [songAlbumField setStringValue: [aSong album]];
  [songTitleField setStringValue: title];
  [songNumberField setStringValue: [aSong trackNumber]];
  totalTime = [[aSong duration] unsignedIntValue];
}

- (void) setReverseTimer: (BOOL) reversed
{
  reverseTimer = reversed;
}

- (BOOL) timerIsReversed
{
  return reverseTimer;
}

- (void) _setTimerFromUnsignedInt: (unsigned int) timer
{
  NSNumber *seconds;

  seconds = [NSNumber numberWithUnsignedInt: timer];

  [songTimerField setStringValue: [seconds timeStringValue]];
}

- (void) setTimerFromSeconds: (unsigned int) seconds
{
  [self _setTimerFromUnsignedInt: ((reverseTimer)
                                   ? totalTime - seconds
                                   : seconds)];
}

- (void) setTimerFromTotalSeconds: (unsigned int) totalSeconds
{
  [songTimerField setFont: [NSFont boldSystemFontOfSize: 12.0]];
  [self _setTimerFromUnsignedInt: totalSeconds];
}

- (void) resetTimerField
{
  [songTimerField setFont: [NSFont systemFontOfSize: 12.0]];
  [songTimerField setStringValue: @""];
}

@end
