/* Player.h - this file is part of Cynthiune
 *
 * Copyright (C) 2002-2004  Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef Player_H
#define Player_H

@class NSNotification;
@class NSString;

@protocol Format;
@protocol Output;

@interface Player : NSObject
{
  id delegate;

  id <Output> output;
  id <Format> stream;

  BOOL paused;
  BOOL muted;
  BOOL playing;
  BOOL awaitingNewStream;

  unsigned int channels;
  unsigned long rate;

  long totalBytes;
}

- (id) init;

- (void) setDelegate: (id) anObject;
- (id) delegate;

- (void) setStream: (id <Format>) newStream;

- (int) timer;

- (BOOL) playing;

- (void) play;
- (void) stop;

- (void) setPaused: (BOOL) aBool;
- (BOOL) paused;

- (void) setMuted: (BOOL) aBool;
- (BOOL) muted;

- (void) seek: (unsigned int) aPos;

@end

@interface NSObject (PlayerDelegate)

- (void) playerPlaying: (NSNotification*) aNotification;
- (void) playerStopped: (NSNotification*) aNotification;
- (void) playerPaused: (NSNotification*) aNotification;
- (void) playerResumed: (NSNotification*) aNotification;
- (void) playerSongEnded: (NSNotification*) aNotification;

@end

#endif /* Player_H */
