/*
 *   Component of the D-ITG v2.7.0-Beta2 platform (http://www.grid.unina.it/software/ITG)
 *
 *   Copyright    : (C) 2004-2009 by Stefano Avallone, Alessio Botta, Alberto Dainotti
 *                                     Walter de Donato, Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and 
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *   email        : stavallo@unina.it , a.botta@unina.it , alberto@unina.it
 *                  walter.dedonato@unina.it , pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 		     
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *				     
 *   For commercial use please refer to D-ITG Professional.
 */




#if defined WIN32 || defined BSD
#define SOL_IP   IPPROTO_IP
#define SOL_IPV6 IPPROTO_IPV6
#endif

#include "../common/ITG.h"
#include "../common/debug.h"

#ifdef LINUX_OS
#include <netdb.h>
#include "newran.h"		
#include <sys/wait.h>
#include <math.h>
#ifdef SCTP
#include <netinet/sctp.h>
#endif
#include <netinet/tcp.h>	
#include <netinet/ip.h>
#include <sys/timeb.h>
#include <sys/shm.h>
#include <pthread.h>
#include <sys/msg.h>
#include <sys/ipc.h>
#endif

#ifdef WIN32
#include "newran/newran.h"	
#include <math.h>
#include <sys/timeb.h>
#include <time.h>
#include <signal.h>
#endif

#include "../common/thread.h"
#include "../common/timestamp.h"
#include "../common/serial.h"
#include "traffic.h"
#include "../common/pipes.h"
#include "ITGSend.h"

#ifdef LINUX_OS
const char DefaultLogFile[] = "/tmp/ITGSend.log";
const char DefaultRecvLogFile[] = "/tmp/ITGRecv.log";
#endif
#ifdef WIN32
char DefaultLogFile[] = "ITGSend.log";
char DefaultRecvLogFile[] = "ITGRecv.log";
#endif
const char DefaultDestIP[] = "127.0.0.1";


flowDescriptor flows[MAX_NUM_THREAD];		
signalChannel signalChannels[MAX_NUM_THREAD];	
pthread_t h_flowParser[MAX_NUM_THREAD];		
flowParserParams parserParams[MAX_NUM_THREAD];	
int multiFlows = 0;
struct addrinfo *logHost = 0;
struct sockaddr_in ManagerIP;
socklen_t ManagerIPslen = sizeof(ManagerIP);
int isFirst = 1;
int isFirstThread = 1;
int isFirstThreadRttm = 1;
int signalChanCount = 0;
char logFile[DIM_LOG_FILE];	
int logging = 0;		
int logremoto = 0;
int logSock;
int logSockSignaling;
int namelogReceiver = 0;
int payloadLogType = 0;        
int mean_adjustment = 1; 
bool setPriority = false;
ofstream out;			
BYTE protoTxLog = DEFAULT_PROTOCOL_TX_LOG;
BYTE protoTx_ServerLogReceiver = DEFAULT_PROTOCOL_TX_LOG_OPZ;
struct addrinfo *serverLogReceiver = 0;

char logFileReceiver[DIM_LOG_FILE];
int logServer = 0;
int managerMode;
bool cmdMode = false;
int managerSock;
#ifdef LINUX_OS

#ifdef SCTP
typedef union {
	struct sockaddr_in v4;
	struct sockaddr_in6 v6;
	struct sockaddr sa;
} sockaddr_storage_t;

sctpSession sctpSessions[MAX_NUM_THREAD];
pthread_mutex_t mutexSctp = PTHREAD_MUTEX_INITIALIZER;
#endif

pthread_mutex_t mutex;
pthread_mutex_t mutexLog;
pthread_mutex_t mutexErrLog;
pthread_mutex_t mutexLogRem;
#endif
#ifdef WIN32
HANDLE mutex;
HANDLE mutexLog;
HANDLE mutexLogRem;
#endif
int termsock = 0;
pthread_t pkey;
char nameProgram[]="ITGSend";

void* waitStopKey(void* s)
{

#ifdef WIN32
	Sleep(1000);
#endif
	while (getchar() != 'C'){}
	termsock = 1;
	printf("Terminated by request\n");
	Terminate(0);
	return NULL;
}


int modeManager(int argc, char *argv[])
{

	int flowCount = 0;

	managerMode = 1;	
	multiFlows = 1;
	struct addrinfo* localHost = 0;
	int size_r = 0, size_s = 0;
	char buffer[80];

	signal(SIGINT, Terminate);
	printf("Press Ctrl-C to terminate\n");
	fflush(stdout);

	argv++;
	argc--;
	parserMultiFlows(argv, argc);


	 getaddrinfo("0.0.0.0", NULL, NULL, &localHost);
	 managerSock = socket(localHost->ai_family, SOCK_DGRAM, 0);
	if (managerSock <0) {
			printf("XXX error socket()!\n");
			fflush(stdout);
	}

	
	SET_PORT(localHost, htons(DEFAULT_PORT_SENDER_MANAGER));
	
	if (bind(managerSock, localHost->ai_addr, localHost->ai_addrlen)) {
			printf("XXX error bind()!\n");
	}


	do {
		size_r = recvfrom(managerSock, buffer, sizeof(buffer), 0,(struct sockaddr *) &ManagerIP, &ManagerIPslen);
		PRINTD(1,"Data received from SignalManager %d, \n",size_r);

		buffer[size_r] = '\n';
		buffer[size_r + 1] = '\0';
		
		strcpy(parserParams[flowCount].line, buffer);
		
		parserParams[flowCount].flowId = flowCount + 1;

		
		memmove(buffer + 2 * sizeof(int), buffer, size_r);
		((int *) buffer)[0] = MNG_FLOWSTART;	
		((int *) buffer)[1] = size_r;	

		size_s = sendto(managerSock, buffer, size_r + 2 * sizeof(int), 0,  (struct sockaddr *) &ManagerIP, ManagerIPslen);
		PRINTD(1,"Notify ITGManager about the start of the generation %d, \n",size_s);

		CREATE_THREAD(&parserParams[flowCount], flowParser, NULL, h_flowParser[flowCount]);
		if (h_flowParser[flowCount] < 0) {
			cerr << "Cannot create a process to handle flow " << flowCount +
			    1 << endl;
		}
		flowCount++;
	} while (1);
 return 0;
}


int modeScript(int argc, char *argv[])
{
	char temp[MAX_SCRIPT_LINE_SIZE];
	char line[MAX_SCRIPT_LINE_SIZE];
	int flowCount = 0;

	multiFlows = 1;
	FILE *batch;

	if ((batch = fopen(argv[0], "r")) == NULL) {
		
		perror("ITGServer Main: ");
		memClean();
		cerr << "Cannot open '" << argv[0] << "' for reading" << endl;
		exit(1);
	}
	argv++;
	argc--;
	parserMultiFlows(argv, argc);
	
	if (fgets(line, sizeof(line) - 1, batch) == NULL) {
		cerr << "errore" << endl;
		memClean();
		exit(1);
	}

	
	strcpy(temp, line);
	do {
		if(strcmp(temp,"\n")!=0){
			
			strcpy(parserParams[flowCount].line, temp);
			
			parserParams[flowCount].flowId = flowCount + 1;
			CREATE_THREAD(&parserParams[flowCount], flowParser, NULL, h_flowParser[flowCount]);
			if (h_flowParser[flowCount] < 0) {
				perror("ITGSend Main: ");
				cerr << "Cannot create a process to handle flow "
			    	<< flowCount + 1 << endl;
			}
			flowCount++;
		}
	} while (fgets(temp, sizeof(temp) - 1, batch));
	fclose(batch);


	
	joinThread(flowCount, h_flowParser);
 return 0;
}


int modeCommandLine(int argc, char *argv[])
{
	PRINTD(1,"modeCommandLine() started\n");
	parserParams[0].flowId = 1;
	cmdMode = true;
	argvToString(argv, argc, parserParams[0].line);
	flowParser(&parserParams[0]);

	return (0);
}

int main(int argc, char *argv[])
{
	
	strcpy(programName, argv[0]);
	argv++;
	argc--;
 	if (!argc) {
		printf("\nMissing argument!!!\nTry ITGSend -h or --help for more information\n");
		exit(1);
	} else if (((argv[0][0] == '-') && (argv[0][1] == 'h')) || ((argv[0][0] == '-')
		&& (argv[0][1] == '-') && (argv[0][2] == 'h'))) {
		printHelp();
		exit(1);
	}

	
	MUTEX_THREAD_INIT(mutex);
	MUTEX_THREAD_INIT(mutexLog);
	MUTEX_THREAD_INIT(mutexLogRem);

	
 	createThread((void*)"wait", &waitStopKey, NULL, pkey);

	strcpy(logFile, DefaultLogFile);
	strcpy(logFileReceiver, DefaultRecvLogFile);
#ifdef WIN32
	MUTEX_THREAD_INIT(mutex_numPipes);
	if (!InitializeWinsock(MAKEWORD(1, 1))) {
		printf("** ERROR ** WSAStartup() failed\n");
		exit(1);
	}
#endif

	for (int i = 0; i < MAX_NUM_THREAD; i++) {
		signalChannels[i].socket = -1;
		signalChannels[i].flows = 0;
		signalChannels[i].errorLog = false;

#ifdef SCTP
		sctpSessions[i].parsedStreams = 0;
#endif
	}

	
	if ((argc > 0) && (argv[0][0] == '-') && (argv[0][1] == 'Q'))
		modeManager(argc, argv);
	else if ((argc > 0) && (argv[0][0] != '-') && (findL7Proto(argv[0]) == LX_ERROR_BYTE)) {
		modeScript(argc, argv);
	} else {
		modeCommandLine(argc, argv);
	}

	
	Terminate(0);

} 

void parserMultiFlows(char *argv[], int argc)
{
	strcpy(logFile, DefaultLogFile);
	getaddrinfo(DefaultDestIP, NULL, NULL, &logHost);
	SET_PORT(logHost, htons(DEFAULT_LOG_PORT));
	protoTxLog = DEFAULT_PROTOCOL_TX_LOG;

	getaddrinfo(DefaultDestIP, NULL, NULL, &serverLogReceiver);
	SET_PORT(serverLogReceiver, htons(DEFAULT_LOG_PORT));
	protoTx_ServerLogReceiver = DEFAULT_PROTOCOL_TX_LOG_OPZ;

	while (argc > 0) {
		if (argv[0][0] == '-') {
			switch (argv[0][1]) {
			case 'h':
				printHelp();
				Terminate(0);
				break;
			case 'l':
				logging = 1;
				if ((argc < 2) || (argv[1][0] == '-') || !findL7Proto(argv[1])) {
					strcpy(logFile, DefaultLogFile);
					argc -= 1;
					argv += 1;
				} else {
					strcpy(logFile, argv[1]);
					argc -= 2;
					argv += 2;
				}
				break;
			case 'L':
				logging = 1;
				logremoto = 1;
				
				if ((argc < 2) || (argv[1][0] == '-') ||
				    (findL7Proto(argv[1]) != LX_ERROR_BYTE)){
					argc -= 1;
					argv += 1;
				} else {    
					
					if (findL4Proto(argv[1]) == LX_ERROR_BYTE){
                   				if (logHost)
							freeaddrinfo(logHost);
						
						if (getaddrinfo(argv[1], NULL, NULL, &logHost))
							ReportErrorAndExit("General parser",
									   " Invalid log-server address or protocol", programName, 0);
						argc -= 1;
						argv += 1;
					} else {
						
						protoTxLog = findL4Proto(argv[1]);
            					argc -= 1;
						argv += 1;
					}  
					if ((argc >= 2) && (argv[1][0] != '-') && (findL7Proto(argv[1]) == LX_ERROR_BYTE)) {
						if (findL4Proto(argv[1]) == LX_ERROR_BYTE){
                        				if (logHost)
								freeaddrinfo(logHost);
							
							if (getaddrinfo(argv[1], NULL, NULL, &logHost))
								ReportErrorAndExit("General parser",
										   " Invalid log-server address", programName, 0);
							argc -= 2;
							argv += 2;
						} else {
							
							protoTxLog = findL4Proto(argv[1]);
            					        argc -= 2;
	       				                argv += 2;
						}  
					} 
					else {
						argc -= 1;
						argv += 1;
					}
				} 
				break;
			case 'X':
				logServer = 1;
				
				if ((argc < 2) || (argv[1][0] == '-') ||
				    (findL7Proto(argv[1]) != LX_ERROR_BYTE)){
					argc -= 1;
					argv += 1;
				} else {    
					
					if (findL4Proto(argv[1]) == LX_ERROR_BYTE){
                   				if (serverLogReceiver)
							freeaddrinfo(serverLogReceiver);
						
						if (getaddrinfo(argv[1], NULL, NULL, &serverLogReceiver))
							ReportErrorAndExit("General parser",
									   " Invalid log-server address or protocol", programName, 0);
						argc -= 1;
						argv += 1;
					} else {
						
						protoTx_ServerLogReceiver = findL4Proto(argv[1]);
            					argc -= 1;
						argv += 1;
					}  
					if ((argc >= 2) && (argv[1][0] != '-') && (findL7Proto(argv[1]) == LX_ERROR_BYTE)) {
						if (findL4Proto(argv[1]) == LX_ERROR_BYTE){
							if (serverLogReceiver)
								freeaddrinfo(serverLogReceiver);
							
							if (getaddrinfo(argv[1], NULL, NULL, &serverLogReceiver))
								ReportErrorAndExit("General parser",
										   " Invalid log-server address", programName, 0);
							argc -= 2;
							argv += 2;
						} else {
							
							protoTx_ServerLogReceiver = findL4Proto(argv[1]);
            					        argc -= 2;
	       				                argv += 2;
						}  
					} 
					else {
						argc -= 1;
						argv += 1;
					}
				} 
				break;
			case 'x':
				namelogReceiver = 1;
				if ((argc < 2) || (argv[1][0] == '-') || !findL7Proto(argv[1])){
					argc -= 1;
					argv += 1;
				} else {
					strcpy(logFileReceiver, argv[1]);
					argc -= 2;
					argv += 2;
				}
				break;
			default:
				char tempS[sizeof("Option ") + sizeof(argv[0][1])+sizeof(" can not be used as a global option in the multy flow mode !")];
				strcpy(tempS,"Option ");
				strcat(tempS,argv[0]);
				strcat(tempS, " can not be used as a global option in the multy flow mode !");
				ReportErrorAndExit("General parser", tempS,programName, 0);
				break;
			} 
		} 
	} 
} 



void *flowParser(void *param)
{
	int argc;
	char *argv[200];
	char *token;
	flowParserParams *para = (flowParserParams *)param;
#ifdef WIN32
	struct _timeb tstruct;
#endif
	char *ManagerMsg = NULL;
	double seed = 0.0;
#ifdef LINUX_OS
	timeval timeout;
#endif
	int j = 0;
	int h = 0;
	int id = para->flowId;
	long int Delay = DefaultDelay;
	int chanId;
	struct pipeMsg msg;


	PRINTD(1,"flowParser() started\n");
	
	flows[id].id = id;
	flows[id].iface = NULL;
	flows[id].meter = METER_OWDM;
	flows[id].l7Proto = LX_PROTO_NONE;
	flows[id].l4Proto = L4_PROTO_UDP;
	flows[id].DSByte = DefaultDSByte;
	flows[id].Duration = DefaultDuration;
	flows[id].icmptype = 8;
	flows[id].TTL = 0;
	flows[id].Nagle = true;
	flows[id].srcPortSpecify = false;
	flows[id].minPayloadSize = StandardMinPayloadSize;
	flows[id].payloadLogType = payloadLogType;
	flows[id].mean_adjustment = mean_adjustment;

	strcpy(flows[id].serialReceiver,"noSerial");
	flows[id].serial = INVALID_HANDLE_VALUE;

	
	if (para->line[strlen(para->line) - 1] == '\n') {
		para->line[strlen(para->line) - 1] = '\0';
	} else {
		cerr << " No newline at the end of file" << endl;
		memClean();
		exit(1);
	}

	if (managerMode) {
		ManagerMsg = (char *) malloc(sizeof(char) * strlen(para->line) + sizeof(int) * 2);
		strcpy(ManagerMsg, para->line);
	}

	
	getaddrinfo(DefaultDestIP, NULL, NULL, &flows[id].DestHost);
	SET_PORT(flows[id].DestHost, htons(DEFAULT_PORT));

	
	getaddrinfo(DefaultDestIP, NULL, NULL, &flows[id].SrcHost);

	
	if (!multiFlows) {
		strcpy(logFile, DefaultLogFile);
		getaddrinfo(DefaultDestIP, NULL, NULL, &logHost);
		SET_PORT(logHost, htons(DEFAULT_LOG_PORT));
		protoTxLog = DEFAULT_PROTOCOL_TX_LOG;

		getaddrinfo(DefaultDestIP, NULL, NULL, &serverLogReceiver);
		SET_PORT(serverLogReceiver, htons(DEFAULT_LOG_PORT));
		protoTx_ServerLogReceiver = DEFAULT_PROTOCOL_TX_LOG_OPZ;
	}

	
	flows[id].IntArrivDistro = pdConstant;
	ConstantRV = new Constant(1);
	flows[id].IntArriv = new SumRandom(1000.0 / DefaultPktPerSec * (*ConstantRV));

	
	flows[id].PktSizeDistro = pdConstant;
	ConstantRV = new Constant(1);
	flows[id].PktSize = new SumRandom(DefaultPktSize * (*ConstantRV));

	
#ifdef ONOFF
	
	flows[id].OnOff = false;
#endif
	


	
	token = strtok(para->line, cmdMode ? "^" : " ");
	while (token != NULL) {
		argv[j] = token;
		PRINTD(2,"TOKEN %d: %s\n", j, token);
		j++;
		token = strtok(NULL, cmdMode ? "^" : " ");
	}
	argc = j;
	while (argc > 0) {
		PRINTD(1,"Parsing option %c \n",argv[h][1]);

		if (argv[h][0] == '-') {
			char *tail;

			long int temp = 0;
			Real a, b;
			switch (argv[h][1]) {
			case 'p':
				PRINTD(1,"Parsing of p option \n");
				if ((argc < 2) || (argv[h+1][0] == '-'))
					ReportErrorAndExit("General parser", "Invalid payload log type",
							   programName, 0);
				flows[id].payloadLogType = atoi(argv[h+1]);
				if ((flows[id].payloadLogType < 0) || (flows[id].payloadLogType > 2)) {
					printf("Warning !! Incorrect \"payload log type\" definition.Admissible values are: \n 0 normal\n; 1 short\n; 2 none \n. Default value %d assumed",payloadLogType);
					flows[id].payloadLogType = payloadLogType;
				}
				PRINTD(1,"Payload type %d \n",flows[id].payloadLogType);
				if ((flows[id].payloadLogType != 0) && (flows[id].meter == METER_RTTM ))
					ReportErrorAndExit("General parser", "It is possible to use the RTT meter only with the standard payload type", programName, 0);
				if (flows[id].payloadLogType == PL_SHORT) 
					flows[id].minPayloadSize = ShortMinPayloadSize;

				else if (flows[id].payloadLogType == PL_NONE) 
					flows[id].minPayloadSize = NoneMinPayloadSize;

#ifdef SCTP
			   	if (flows[id].l4Proto == L4_PROTO_TCP || flows[id].l4Proto == L4_PROTO_SCTP)
#else
				if (flows[id].l4Proto == L4_PROTO_TCP)
#endif
					flows[id].minPayloadSize = flows[id].minPayloadSize + sizeof(int);
				PRINTD(1,"Payload minimum size %d \n",flows[id].minPayloadSize);
				h += 2;
				argc -= 2;
				break;
			case 'm':
				PRINTD(1,"Flow id %d \n  ", id);
				PRINTD(1,"Meter option found\n");
				flows[id].meter = findMeter(argv[h + 1]);
				if (flows[id].meter == 255)
					ReportErrorAndExit("General parser", "Invalid measure type",
					    programName, 0);
				if ( (flows[id].meter == METER_RTTM) && ( flows[id].minPayloadSize < StandardMinPayloadSize) )
					{
						printf ( "%d != %d ", flows[id].minPayloadSize,StandardMinPayloadSize);
				  	ReportErrorAndExit("General parser",
							   "It is possible to use the RTT meter only with the standard payload type",
							   programName, 0);}
				h += 2;
				argc -= 2;
				break;
			case 'a':
			{
 				in_port_t tmp_port=0;
				if (flows[id].DestHost) {
					GET_PORT(flows[id].DestHost, tmp_port);
					freeaddrinfo(flows[id].DestHost);
				}
				if ((argc < 2) || getaddrinfo(argv[h + 1], NULL, NULL, &flows[id].DestHost))
					ReportErrorAndExit("General parser",
					    "Invalid destination address", programName, id);
				if (flows[id].DestHost->ai_family == PF_INET6 &&
					IN6_IS_ADDR_LINKLOCAL(((struct sockaddr_in6 *)(flows[id].DestHost->ai_addr))->sin6_addr.s6_addr32) &&
					((struct sockaddr_in6 *)(flows[id].DestHost->ai_addr))->sin6_scope_id == 0)
					printf("** WARNING **: IPv6 address scope id not specified by the sender\n");

				SET_PORT(flows[id].DestHost, tmp_port);
				h += 2;
				argc -= 2;
				break;
			}
#ifdef LINUX_OS
			case 'i':
			{
				if (argc < 2)
					ReportErrorAndExit("General parser", "Invalid interface", programName, id);
				flows[id].iface = (char*)malloc(strlen(argv[h + 1]) + 1);
				strcpy(flows[id].iface, argv[h + 1]);
				h += 2;
				argc -= 2;
				break;
			}
#endif
			case 'r':
				if (argv[h][2] == 'p') {
					if (argc < 2)
			        		ReportErrorAndExit("General parser", "Invalid port number", programName, id);
					SET_PORT(flows[id].DestHost, htons(atoi(argv[h + 1])));
					h += 2;
					argc -= 2;
				}
			        else if (argv[h][2] == 'k') {
					if (argc < 2)
						ReportErrorAndExit("General parser", "Invalid Serial Port", programName, id);
					strcpy(flows[id].serialReceiver, argv[h+1]);
					PRINTD(1,"at Receiver Side %s is up \n", argv[h + 1]);
					h += 2;
					argc -= 2;
				}
				else {
					char tempS[sizeof("What is  ?") + sizeof(argv[h])];
					ReportErrorAndExit("General parser", strcat(strcat(strcpy(tempS, "What is "), argv[h]), " ?"), programName, id);
				}
				break;
			case 'f':
				if (argc < 2)
					ReportErrorAndExit("General parser", "Invalid TTL",
					    programName, id);
				temp = strtol(argv[h + 1], &tail, 0);
				strcpy(flows[id].serialReceiver,"noSerial");if ((tail == argv[h + 1]) || (temp < 0) || (temp > 255))
					ReportErrorAndExit("General parser", "Invalid TTL",
					    programName, id);
				flows[id].TTL = temp;
				h += 2;
				argc -= 2;
				break;
   			case 't':
				if ((argc < 2) || ((temp = strtol(argv[h + 1], NULL, 10)) <= 0))
					ReportErrorAndExit("General parser", "Invalid Duration",
					    programName, id);
				flows[id].Duration = temp;
				h += 2;
				argc -= 2;
				break;
			case 'd':
				if (argc < 2)
					ReportErrorAndExit("General parser", "Invalid Delay",
					    programName, id);
				temp = strtol(argv[h + 1], &tail, 10);
				if ((tail == argv[h + 1]) || (temp < 0))
					ReportErrorAndExit("General parser", "Invalid Delay",
					    programName, id);
				Delay = temp;
				h += 2;
				argc -= 2;
				break;
			case 'b':
				if (argc < 2)
					ReportErrorAndExit("General parser", "Invalid DS Byte",
					    programName, id);
				temp = strtol(argv[h + 1], &tail, 0);
				if ((tail == argv[h + 1]) || (temp < 0) || (temp > 255))
					ReportErrorAndExit("General parser", "Invalid DS Byte",
					    programName, id);
				flows[id].DSByte = temp;
				h += 2;
				argc -= 2;
				break;
			case 'j': 
				if (argc < 2)
					ReportErrorAndExit("General parser", "j option needs either 1 or 0",
					    programName, id);
				flows[id].mean_adjustment = atoi(argv[h+1]);
				if ((flows[id].mean_adjustment != 0) && (flows[id].mean_adjustment != 1))
					ReportErrorAndExit("General parser", "j option needs either 1 or 0",
					    programName, id);
				h += 2;
				argc -= 2;
				break;
			case 'L':
				if (multiFlows)
					ReportErrorAndExit("General parser",
					    "-L option not allowed into script file", programName,
					    id);
				logging = 1;
				logremoto = 1;
				
				if ((argc < 2) || (argv[h+1][0] == '-') ||
                            (findL7Proto(argv[h+1]) != LX_ERROR_BYTE)){
				    argc -= 1;
					h += 1;
				} else {    
                            
                            if (findL4Proto(argv[h + 1]) == LX_ERROR_BYTE){
                   				if (logHost)
                                   freeaddrinfo(logHost);
                                 
                                if (getaddrinfo(argv[h + 1], NULL, NULL, &logHost))
                                  ReportErrorAndExit("General parser",
            					    " Invalid log-server address or protocol", programName, id);
                       		    argc -= 1;
                     		    h += 1;
               		        } else {
                                
           						protoTxLog = findL4Proto(argv[h + 1]);
            					argc -= 1;
		       				    h += 1;
                            }  
                            if ((argc >= 2) && (argv[h+1][0] != '-') && (findL7Proto(argv[h+1]) == LX_ERROR_BYTE)) {
                                   if (findL4Proto(argv[h + 1]) == LX_ERROR_BYTE){
                        				if (logHost)
                                       freeaddrinfo(logHost);
                                     
                                     if (getaddrinfo(argv[h + 1], NULL, NULL, &logHost))
                                       ReportErrorAndExit("General parser",
            					       " Invalid log-server address", programName, id);
                       		         argc -= 2;
                     		         h += 2;
               		               } else {
                                        
                    			     	protoTxLog = findL4Proto(argv[h + 1]);
            					        argc -= 2;
	       				                h += 2;
                                    }  
                             } 
                             else {
                       		    argc -= 1;
                     		    h += 1;
               		         }
                 } 
				break;
			case 'X':
				if (multiFlows)
					ReportErrorAndExit("General parser",
					    "-X option not allowed into script file", programName,
					    id);



				logServer = 1;
				
				if ((argc < 2) || (argv[h+1][0] == '-') ||
                            (findL7Proto(argv[h+1]) != LX_ERROR_BYTE)){
				    argc -= 1;
					h += 1;
				} else {    
                            
                            if (findL4Proto(argv[h + 1]) == LX_ERROR_BYTE){
                   				if (serverLogReceiver)
                   				freeaddrinfo(serverLogReceiver);
                                 
                                if (getaddrinfo(argv[h + 1], NULL, NULL, &serverLogReceiver))
                                  ReportErrorAndExit("General parser",
            					    " Invalid log-server address or protocol", programName, id);
                       		    argc -= 1;
                     		    h += 1;
               		        } else {
                                
           						protoTx_ServerLogReceiver = findL4Proto(argv[h + 1]);
            					argc -= 1;
		       				    h += 1;
                            }  
                            if ((argc >= 2) && (argv[h+1][0] != '-') && (findL7Proto(argv[h+1]) == LX_ERROR_BYTE)) {
                                   if (findL4Proto(argv[h + 1]) == LX_ERROR_BYTE){
                       				if (serverLogReceiver)
                       					freeaddrinfo(serverLogReceiver);
                                     
                                     if (getaddrinfo(argv[h + 1], NULL, NULL, &serverLogReceiver))
                                       ReportErrorAndExit("General parser",
            					       " Invalid log-server address", programName, id);
                       		         argc -= 2;
                     		         h += 2;
               		               } else {
                                        
                    			     	protoTx_ServerLogReceiver = findL4Proto(argv[h + 1]);
            					        argc -= 2;
	       				                h += 2;
                                    }  
                             } 
                             else {
                       		    argc -= 1;
                     		    h += 1;
               		         }
                 } 
				break;
			case 'T':
				if (argc < 2)
					ReportErrorAndExit("General parser", "Invalid Protocol Type", programName, id);

				flows[id].l4Proto = findL4Proto(argv[h + 1]);
				PRINTD(1,"Level 4 Protocol: %s\n", invFindL4Proto(flows[id].l4Proto));

				
				if (flows[id].l4Proto == LX_ERROR_BYTE)
					ReportErrorAndExit("General parser", "Invalid Protocol Type", programName, id);

				
				if ((flows[id].l4Proto == L4_PROTO_TCP)) 
					flows[id].minPayloadSize = flows[id].minPayloadSize + sizeof(int);

				
				if (flows[id].l4Proto == L4_PROTO_ICMP) {
					if ((argc > 2) && (argv[h + 2][0] != '-')) {
						flows[id].icmptype = atoi(argv[h + 2]);
						h += 1;
						argc--;
					}
				}
#ifndef DCCP
				if (flows[id].l4Proto == L4_PROTO_DCCP )
					ReportErrorAndExit("General parser", "Invalid protocol type.\nPlease, to generate DCCP traffic flows "
										"recompile D-ITG with the DCCP feature enabled  "
										"(see manual for more details).", programName, id);
#endif
#ifdef SCTP
				
				if (flows[id].l4Proto == L4_PROTO_SCTP) {
					int sctpId;
					int sctpStreams;

					if (argc < 4 || (argv[h + 2][0] == '-') || (argv[h + 3][0] == '-'))
						ReportErrorAndExit ("General parser", "SCTP protocol needs parameters (syntax: -T SCTP <association_id> <max_streams>)",
							programName, id);

					
					if (argv[h + 2][0] > '0' || argv[h + 2][0] < '9')
						sctpId = atoi(argv[h + 2]);
					else
						ReportErrorAndExit ("General parser", "Invalid SCTP id option", programName, id);

					
					if (argv[h + 3][0] > '0' || argv[h + 3][0] < '9')
						sctpStreams = atoi(argv[h + 3]);
					else
						ReportErrorAndExit ("General parser", "Invalid SCTP num_streams option", programName, id);
					
				  	flows[id].minPayloadSize = flows[id].minPayloadSize + sizeof(int);
					PRINTD(2, "in sctp settato flows[id].minPayloadSize: %d\n", flows[id].minPayloadSize);
					
					if (sctpStreams > 1)
						ReportErrorAndExit ("General parser", "** SCTP multi-streaming support is not yet available **", programName, id);

					MUTEX_THREAD_LOCK(mutexSctp);
					
					if (sctpSessions[sctpId].parsedStreams == 0) {
						sctpSessions[sctpId].numStreams = sctpStreams;
						sctpSessions[sctpId].busyStreams = 0;
						sctpSessions[sctpId].parsedStreams = 1;
						sctpSessions[sctpId].sock = -1;
						PRINTD(1,"Rilevata sessione SCTP (id = %d) con %d streams al suo interno\n", sctpId, sctpStreams);
					}
					else sctpSessions[sctpId].parsedStreams++;
					flows[id].sctpId = sctpId;
					PRINTD(1,"Rilevato stream #%d della sessione SCTP %d\n", sctpSessions[sctpId].parsedStreams, sctpId);
					MUTEX_THREAD_UNLOCK(mutexSctp);

					if (sctpSessions[sctpId].parsedStreams > sctpSessions[sctpId].numStreams)
						ReportErrorAndExit ("General parser", "Too many streams defined into SCTP session", programName, id);

					h += 2;
					argc -= 2;
				}

#else
				if (flows[id].l4Proto == L4_PROTO_SCTP)
					ReportErrorAndExit("General parser", "Invalid protocol type.\nPlease, to generate SCTP traffic flows "
										"recompile D-ITG with the SCTP feature enabled "
										"(see manual for more details).", programName, id);
#endif

				h += 2;
				argc -= 2;
				break;
			case 's':
				if (strlen(argv[h])==2){
				  	if ((argc < 2) || ((seed = strtod(argv[h + 1], NULL)) >= 1.0)
				    		|| (seed <= 0.0))
					ReportErrorAndExit("General parser",
					    "Invalid seed (0 < seed < 1)", programName, id);
					h += 2;
					argc -= 2;

			    }
			    else if (argv[h][2] == 'p') {
			   		if (argc < 2)
			   			ReportErrorAndExit("General parser", "Invalid port number",
					    programName, id);
				    SET_PORT(flows[id].SrcHost, htons(atoi(argv[h + 1])));
				    flows[id].srcPortSpecify = true;
 				    h += 2;
				    argc -= 2;
			    }
			    else if (argv[h][2] == 'k'){
       					if (argc < 2)
					ReportErrorAndExit("General parser", "Invalid Serial Port",
					    programName, id);
	                		flows[id].serial = serialUp(argv[h + 1]);
				    	if (flows[id].serial == INVALID_HANDLE_VALUE)
                         			printf("Error opening interface \n");
				    	strcpy(flows[id].serialReceiver,"noSerial");
					h += 2;
					argc -= 2;

					PRINTD(1,"at Sender Side %s is up \n", argv[h + 1]);
			    } else {
        	        	  	char tempS[sizeof("What is  ?") + sizeof(argv[h])];
                	  		ReportErrorAndExit("General parser", strcat(strcat(strcpy(tempS,
					                  	"What is "), argv[h]), " ?"), programName, id);
                  		}
				break;
			case 'l':
				if (multiFlows)	ReportErrorAndExit("General parser",
					    							"-l option not allowed into script file", programName, id);
				logging = 1;
				if ((argc < 2) || (argv[h + 1][0] == '-') || !findL7Proto(argv[h + 1])) {
					strcpy(logFile, DefaultLogFile);
					argc -= 1;
					h += 1;
				} else {
					strcpy(logFile, argv[h + 1]);
					argc -= 2;
					h += 2;
				}
				break;
			case 'x':
				if (multiFlows)
					ReportErrorAndExit("General parser",
					    "-x option not allowed into script file", programName,
					    id);
	            		namelogReceiver = 1;
	            		if ((argc < 2) || (argv[h + 1][0] == '-') || !findL7Proto(argv[h + 1])){
					argc -= 1;
					h += 1;
				} else {
			     	strcpy(logFileReceiver, argv[h+1]);
					argc -= 2;
					h += 2;
				}
				break;
			case 'C':	
				if ((argc < 2) ||  (strtod(argv[h+1],NULL) <= 0.))
					ReportErrorAndExit("Protocol Parser",
					    "Invalid pkts per sec", programName, id);
				flows[id].IntArrivDistro = pdConstant;
				delete flows[id].IntArriv;
				ConstantRV = new Constant(1);
				flows[id].IntArriv =
				new SumRandom(1000.0 /  strtod(argv[h+1],NULL) * (*ConstantRV));
				h += 2;
				argc -= 2;
				break;
    			case 'U':
   				if ((argc < 3) ||  (strtod(argv[h+1],NULL) <= 0.)
				    ||  (strtod(argv[h+2],NULL) <= strtod(argv[h+1],NULL)) )
					ReportErrorAndExit("Protocol Parser",
					    "Invalid pkts per sec", programName, id);
				delete flows[id].IntArriv;
				flows[id].IntArrivDistro = pdUniform;
				a = (1000.0 / strtod(argv[h+2],NULL));
				b = (1000.0 / strtod(argv[h+1],NULL)) - a ;
				UniformRV = new Uniform;
				flows[id].IntArriv = new SumRandom( b * (*UniformRV) +  a);
				h += 3;
				argc -= 3;
				break;
			case 'E':
				if ((argc < 2) || (strtod(argv[h+1],NULL) <= 0.))
					ReportErrorAndExit("Protocol Parser",
					    "Invalid pkts per sec", programName, id);
				delete flows[id].IntArriv;
				flows[id].IntArrivDistro = pdExponential;
				ExponentialRV = new Exponential;
				flows[id].IntArriv =
				new SumRandom(1000.0 /  strtod(argv[h+1],NULL) * (*ExponentialRV));
				h += 2;
				argc -= 2;
				break;
			case 'V':
				if ((argc < 3) || (strtod(argv[h + 1], NULL) <= 0)
				    || (strtod(argv[h + 2], NULL) <= 0))
					ReportErrorAndExit("Protocol Parser",
					    "Invalid Pareto Distribution parameter values",
					    programName, id);
				a = (Real) strtod(argv[h + 1], NULL);
				b = (Real) strtod(argv[h + 2], NULL);
				ParetoRV = new Pareto(a);
				delete flows[id].IntArriv;
				flows[id].IntArrivDistro = pdPareto;
				flows[id].IntArriv = new SumRandom(b * (*ParetoRV));
				h += 3;
				argc -= 3;
				break;
			case 'Y':
				if ((argc < 3) || (strtod(argv[h + 2], NULL) <= 0))	
					ReportErrorAndExit("Protocol Parser",
					    "Invalid pkts per sec", programName, id);
				flows[id].IntArrivDistro = pdCauchy;
				b = strtod(argv[h + 1], NULL); 
				a = strtod(argv[h + 2], NULL); 
				delete flows[id].IntArriv;
				CauchyRV = new Cauchy;
				flows[id].IntArriv = new SumRandom(a * (*CauchyRV) + b);
				h += 3;
				argc -= 3;
				break;
			case 'N':
				if ((argc < 3) || (argv[h + 2] <= 0))	
					ReportErrorAndExit("Protocol Parser",
					    "Invalid pkts per sec", programName, id);
				flows[id].IntArrivDistro = pdNormal;
				b = strtod(argv[h + 1], NULL); 	
				a = strtod(argv[h + 2], NULL); 	
                		delete flows[id].IntArriv;
				NormalRV = new Normal;
				flows[id].IntArriv = new SumRandom(a * (*NormalRV) + b);
				h += 3;
				argc -= 3;
				break;
			case 'O':
				if ((argc < 2) || (strtod(argv[h + 1], NULL) <= 0))	
					ReportErrorAndExit("Protocol Parser",
					    "Invalid pkts per sec", programName, id);
				a = strtod(argv[h + 1], NULL);
				delete flows[id].IntArriv;
				
				PoissonRV = new Poisson(a);
				flows[id].IntArrivDistro = pdPoisson;
				flows[id].IntArriv = new SumRandom(1000.0 / (*PoissonRV));
				h += 2;
				argc -= 2;
				break;
			case 'G':
				if ((argc < 3) || (strtod(argv[h + 1], NULL) <= 0) || (strtod(argv[h + 2], NULL) <= 0))	
					ReportErrorAndExit("Protocol Parser",
					    "Invalid Gamma Distribution parameter values",
					    programName, id);
				a = (Real) strtod(argv[h + 1], NULL);
				b = (Real) strtod(argv[h + 2], NULL);
    				delete flows[id].IntArriv;
				
				GammaRV = new Gamma(a);
				flows[id].IntArrivDistro = pdGamma;
				flows[id].IntArriv = new SumRandom(b * (*GammaRV));
				h += 3;
				argc -= 3;
				break;
			   
			case 'W':
			   if ((argc < 3) || (strtod(argv[h + 1], NULL) <= 0) ||
			       (strtod(argv[h + 2], NULL) <= 0))
			     ReportErrorAndExit("Protocol Parser","Invalid Weibull Distribution parameter values", programName, id);
			   a = (Real) strtod(argv[h+1],NULL);
			   b = (Real) strtod(argv[h+2],NULL);
			   delete flows[id].IntArriv;
			   WeibullRV = new Weibull(a,b);
			   flows[id].IntArrivDistro = pdWeibull;
			   flows[id].IntArriv = new SumRandom( 1 * (*WeibullRV));
			   h += 3;
			   argc -= 3;
			   break;
			   

			   
#ifdef ONOFF
			case 'B': 
				if ( argc < 3 )
					ReportErrorAndExit("Protocol Parser",
					    "Invalid settings for the On/Off periods1",
					    programName, id);
				h += 1;
				argc -= 1;
				onOffParser(h, argv, argc, flows[id].id, &flows[id].OnPeriod, &flows[id].OffPeriod,
				    flows[id].OnPeriodDistro, flows[id].OffPeriodDistro);
				flows[id].OnOff = true;
				break;
#endif
			   
			case 'c':
				if ((argc < 2) || (atoi(argv[h + 1]) < 1))
					ReportErrorAndExit("Protocol Parser", "Invalid pkt size",
					    programName, id);
				delete flows[id].PktSize;
				flows[id].PktSizeDistro = pdConstant;
				ConstantRV = new Constant(1);
				flows[id].PktSize = new SumRandom(atoi(argv[h + 1]) * (*ConstantRV));
				h += 2;
				argc -= 2;
				break;
			case 'u':
				if ((argc < 3) || (atoi(argv[h + 1]) < 1)
				    || (atoi(argv[h + 2]) <= atoi(argv[h + 1])))
					ReportErrorAndExit("Protocol Parser", "Invalid pkt size",
					    programName, id);
				delete flows[id].PktSize;
				flows[id].PktSizeDistro = pdUniform;
	 			b = atoi(argv[h + 1]);
				a = atoi(argv[h + 2]) - b;
				UniformRV = new Uniform;
				flows[id].PktSize = new SumRandom(a * (*UniformRV) + b);
				argc -= 3;
				h += 3;
				break;
			case 'e':
				if ((argc < 2) || (atoi(argv[h + 1]) < 1))
					ReportErrorAndExit("Protocol Parser", "Invalid pkt size",
					    programName, id);
				delete flows[id].PktSize;
				flows[id].PktSizeDistro = pdExponential;
				ExponentialRV = new Exponential;
				flows[id].PktSize = new SumRandom(atoi(argv[h + 1]) * (*ExponentialRV));
				h += 2;
				argc -= 2;
				break;
			case 'v':
				if ((argc < 3) || (strtod(argv[h + 2], NULL) <= 0))	
					ReportErrorAndExit("Protocol Parser",
					    "Invalid Pareto Distribution parameter values",
					    programName, id);
				a = (Real) strtod(argv[h + 1], NULL);
				b = (Real) strtod(argv[h + 2], NULL);
				delete flows[id].PktSize;
				ParetoRV = new Pareto(a);
				flows[id].PktSizeDistro = pdPareto;
				flows[id].PktSize = new SumRandom(b * (*ParetoRV));
				argc -= 3;
				h += 3;
				break;
			case 'y':
				if ((argc < 3) || (atoi(argv[h + 2]) <= 0))	
					ReportErrorAndExit("Protocol Parser",
					    "Invalid pkts per sec", programName, id);
				delete flows[id].PktSize;
				flows[id].PktSizeDistro = pdCauchy;
				b = (Real) atoi(argv[h + 1]);	
				a = (Real) atoi(argv[h + 2]);	
				CauchyRV = new Cauchy;
				flows[id].PktSize = new SumRandom(a * (*CauchyRV) + b);
				h += 3;
				argc -= 3;
				break;
			case 'n':
				if ((argc < 3) || (argv[h + 2] <= 0))	
					ReportErrorAndExit("Protocol Parser", "Invalid pkt size",
					    programName, id);
				delete flows[id].PktSize;
				flows[id].PktSizeDistro = pdNormal;
				b = (Real) atoi(argv[h + 1]);	
				a = (Real) atoi(argv[h + 2]);	
				NormalRV = new Normal;
				flows[id].PktSize = new SumRandom(a * (*NormalRV) + b);
				h += 3;
				argc -= 3;
				break;
			case 'o':
				if ((argc < 2) || (atoi(argv[h + 1]) < 0))	
					ReportErrorAndExit("Protocol Parser", "Invalid pkt size",
					    programName, id);
				a = atoi(argv[h + 1]);
				delete flows[id].PktSize;
				
				PoissonRV = new Poisson(a);
				flows[id].PktSizeDistro = pdPoisson;
				flows[id].PktSize = new SumRandom(1 * (*PoissonRV));
				h += 2;
				argc -= 2;
				break;
			case 'g':
				if ((argc < 3) || (strtod(argv[h + 2], NULL) <= 0))
					ReportErrorAndExit("Protocol Parser",
					    "Invalid Gamma Distribution parameter values",
					    programName, id);
				delete flows[id].PktSize;
				a = (Real) strtod(argv[h + 1], NULL);
				b = (Real) strtod(argv[h + 2], NULL);
				
				GammaRV = new Gamma(a);
				flows[id].PktSizeDistro = pdGamma;
				flows[id].PktSize = new SumRandom(b * (*GammaRV));
				h += 3;
				argc -= 3;
				break;
			   
			case 'w':
			  if ((argc < 3) || (strtod(argv[h + 1], NULL) <= 0) || (strtod(argv[h + 2], NULL) <= 0))
			    ReportErrorAndExit("Protocol Parser","Invalid Weilbull Distribution Parameter values",programName, id);
			  a = (Real) strtod(argv[h+1],NULL);
			  b = (Real) strtod(argv[h+2],NULL);
			  WeibullRV = new Weibull(a,b);
			  flows[id].PktSizeDistro = pdWeibull;
			  flows[id].PktSize = new SumRandom( 1*(*WeibullRV));
			  h += 3;
			  argc -= 3;
			  break;
			   
			case 'D':
				
				
				PRINTD(1,"Nagle algorithm disabled\n");
				flows[id].Nagle=false;
				h += 1;
				argc -= 1;
				break;
#ifdef WIN32
			case 'P':
				
				
				if (SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS) == 0){
				        printf("Error - Impossible set priority class - %d \n", (int) GetLastError());
				        fflush(stdout);
			    }
				PRINTD(1," Enabled thread priority \n");
				setPriority = true;
				h += 1;
				argc -= 1;
				break;
#endif
			default:
				char temp[sizeof("What is  ?") + sizeof(argv[h])];
				ReportErrorAndExit("General parser", strcat(strcat(strcpy(temp,
						"What is "), argv[h]), " ?"), programName, id);
				break;
			} 
		} else {
			flows[id].l7Proto = findL7Proto(argv[h]);
			switch (flows[id].l7Proto) {
			case L7_PROTO_TELNET:

				telnetParser(&flows[id].IntArriv, &flows[id].PktSize, flows[id].IntArrivDistro, flows[id].PktSizeDistro);
				flows[id].l4Proto = L4_PROTO_TCP;
				h++;
				argc--;
				break;
			case L7_PROTO_VOIP:

				voIPParser(h, argv, argc, flows[id].id, &flows[id].IntArriv, &flows[id].PktSize,
				    flows[id].IntArrivDistro, flows[id].PktSizeDistro);
#ifdef DCCP
				if ( flows[id].l4Proto != L4_PROTO_UDP && flows[id].l4Proto != L4_PROTO_DCCP)
#endif
					flows[id].l4Proto = L4_PROTO_UDP;
				break;
			case L7_PROTO_DNS:

				dnsParser(&flows[id].IntArriv, &flows[id].PktSize, flows[id].IntArrivDistro, flows[id].PktSizeDistro);
				h++;
				argc--;
				break;
			
			case L7_PROTO_CSATTIVA:
				CSParsera(&flows[id].IntArriv, &flows[id].PktSize, flows[id].IntArrivDistro, flows[id].PktSizeDistro);
				flows[id].l4Proto= L4_PROTO_UDP;                
				h++;
				argc--;
				break;
			case L7_PROTO_CSINATTIVA:
				CSParseri(&flows[id].IntArriv, &flows[id].PktSize, flows[id].IntArrivDistro, flows[id].PktSizeDistro);
				flows[id].l4Proto= L4_PROTO_UDP;                
				h++;
				argc--;
				break;
			case L7_PROTO_QUAKE:
				QuakeParser(&flows[id].IntArriv, &flows[id].PktSize, flows[id].IntArrivDistro, flows[id].PktSizeDistro);
				flows[id].l4Proto= L4_PROTO_UDP;                
				h++;
				argc--;
				break;
			case LX_ERROR_BYTE:
				char temp[sizeof("What is  ?") + sizeof(argv[h])];
				ReportErrorAndExit("General parser", strcat(strcat(strcpy(temp,	"What is "), argv[h]), " ?"), programName, id);
				break;
			} 
		} 
	} 
	PRINTD(1,"Terminate Parser flow %d\n",id);

#ifdef WIN32
	if ((flows[id].l4Proto == L4_PROTO_ICMP) && (flows[id].DestHost->ai_family == PF_INET6)) {
		printf("Error: traffic ICMP with protocol IPv6 is not supported \n");
		memClean();
	exit(1);
	}
#endif
	
	if (seed == 0.0) {
#ifdef WIN32
		_ftime(&tstruct);
		seed = 0.49 * sin(tstruct.millitm) + 0.50;	
#endif
#ifdef LINUX_OS
		struct timeval tv;	
		gettimeofday(&tv, NULL);
		seed = 0.49 * sin((double)tv.tv_usec) + 0.50;	
#endif
	}

	
	MotherOfAll urng(seed);              
	Random::Set(urng);                   


	
	if (createNewPipe(flows[id].parserPipe) < 0) {
		printf("Error in flowParser() trying to create a new pipe. [flow %d]\n", id);
		exitThread();
	}

	
	
	if (Delay) {
#ifdef LINUX_OS
		timeout.tv_sec = Delay / 1000;
		timeout.tv_usec = (Delay % 1000) * 1000;
		long int result;
		do
			result = (long int) (select(0, NULL, NULL, NULL, &timeout));
		while (result == -1L && errno == EINTR);
#endif
#ifdef WIN32
		Sleep(Delay);
#endif
	}

	
	
	
 	
	int rit = identifySignalManager(id, &chanId, flows[id].DestHost);
	if (rit == -1) {
		printf("Error into function identifySignalManager() n");
		exitThread();
	}

	if ((namelogReceiver == 1) || (logServer == 1)) {
		if (signalChannels[chanId].errorLog == true){
			printf("Error log file specified is already open \n");
  			isChannelClosable(chanId);
			if (multiFlows)
	   			exitThread();
			else return 0;
		}
	}


	
	msg.code = MSG_SM_NEWFLOW;
	msg.flowId = id;
	if (sendPipeMsg(signalChannels[chanId].pipe, &msg) < 0) {
		perror("flowParser sending msg");
		exitThread();
	}

	
	if (recvPipeMsg(flows[id].parserPipe, &msg) < 0) {
		perror("flowParser receiving msg");
		exitThread();
	}

	PRINTD(1,"msg received from signal manager %d\n",msg.code);

	switch (msg.code) {
	case MSG_FP_END:
		break;
	case MSG_FP_ERR1:
		printf("Error at Receiver side \n");
		break;
	case MSG_FP_ERR2:
		printf("Error - FlowSender interrupted by an error\n");
		break;
	default:
		printf("Error undefined message received from signal manager\n");
		break;
	}
	fflush(stdout);

	

	if (managerMode) {
		
		int length = strlen(ManagerMsg);
		memmove(ManagerMsg + 2 * sizeof(int), ManagerMsg, length);
		((int *) ManagerMsg)[0] = MNG_FLOWEND;	
		((int *) ManagerMsg)[1] = length;	
		sendto(managerSock, ManagerMsg, length + sizeof(int) * 2, 0, (struct sockaddr *) &ManagerIP,
		    ManagerIPslen);
		PRINTD(1,"Notify ITGManager about the end of the generation \n");
	}

	
   	closePipe(flows[id].parserPipe);


    

	if (multiFlows)
	   exitThread();
    return 0;
}

void *signalManager(void *id)
{
	int	chanId, sock, size;
	BYTE	type;
	uint32_t flowId;
	struct pipeMsg msg;
#ifdef LINUX_OS
	int fd, maxfd;
	fd_set	rset;
#endif
#ifdef WIN32
	HANDLE fd, namedPipe;
	HANDLE	events[2];
	DWORD available = 0;
	DWORD waited;
	unsigned long pending;
#endif

	PRINTD(1,"signalManager() started\n");

	
	chanId = *(int *)id;
	sock = signalChannels[chanId].socket;
	fd = signalChannels[chanId].pipe[0];
#ifdef WIN32
	events[0] = WSACreateEvent();
	WSAEventSelect(sock, events[0], FD_READ);
	events[1] = signalChannels[chanId].pipe[1];
	namedPipe = signalChannels[chanId].pipe[2];
#endif

#ifdef LINUX_OS
	maxfd = max(fd, sock) + 1;
	FD_ZERO(&rset);
#endif

	
	for (;;) {
		
#ifdef LINUX_OS
		FD_SET(sock, &rset);
		FD_SET(fd, &rset);
		if (select(maxfd, &rset, NULL, NULL, NULL) == -1) {
			if (errno == EINTR)
				continue;
			printf("error during select in signalManager %d\n", chanId);
			exitThread();
		}
		
		if (FD_ISSET(sock, &rset)) {
#endif

#ifdef WIN32
		PRINTD(1,"before waitformultiple...\n");
		waited = WaitForMultipleObjects(2, (const HANDLE *)events, FALSE, INFINITE);
		PRINTD(1,"out of waitformultiple...\n");
		
		
		ResetEvent(events[0]);
		
		pending = 0;
		ioctlsocket(sock, FIONREAD, &pending);
		PRINTD(1,"pending: %lu\n", pending);
		while (pending > 0) {
#endif
			

			
			size = recv(sock, (char *) &type, sizeof(type), 0);
			PRINTD(1,"received type %d on socket\n", type);
			switch (type) {
			case TSP_ACK_CLOSED_FLOW:

				
				recv(sock, (char *) &flowId, sizeof(flowId), 0);
				flowId = ntohl(flowId);
				PRINTD(1,"received ack closed flow %d\n", flowId);

				

				
				if ( isChannelClosable(chanId))  {
					
					msg.code = MSG_FP_END;
					msg.flowId = flowId;
					if (sendPipeMsg(flows[flowId].parserPipe, &msg) < 0) {
						perror("signalManager sending msg");
						exitThread();
					}
					exitThread();
				} else {
					
					msg.code = MSG_FP_END;
					msg.flowId = flowId;
					if (sendPipeMsg(flows[flowId].parserPipe, &msg) < 0) {
						perror("signalManager sending msg");
						exitThread();
					}
				}
				break;
			case TSP_ACK_SEND_FLOW:
				
				recv(sock, (char *) &flowId, sizeof(flowId), 0);
				flowId = ntohl(flowId);
				
				CREATE_THREAD(&(flows[flowId]), flowSender, NULL, flows[flowId].handle);
#ifdef WIN32
				if (setPriority == true){
					if (SetThreadPriority(flows[flowId].handle, THREAD_PRIORITY_TIME_CRITICAL) == 0)
					printf("Error - Impossible set priority for thread - %d \n", (int) GetLastError());
 				}
#endif
				break;
			case TSP_DISCOVERY:
				sendType(sock, TSP_ACK_DISCOVERY);
				break;
			case TSP_ERR_MSG_2:
				recv(sock, (char *) &flowId, sizeof(flowId), 0);
				flowId = ntohl(flowId);
				printf("Error - Busy port on receiver side\n");
				
				if ( isChannelClosable(chanId))  {
					
					msg.code = MSG_FP_ERR1;
					msg.flowId = flowId;
					if ( sendPipeMsg(flows[flowId].parserPipe, &msg) < 0) {
						perror("signalManager sending msg");
						exitThread();
					}
			 		exitThread();
				} else {
					msg.code = MSG_FP_ERR1;
					msg.flowId = flowId;
					if ( sendPipeMsg(flows[flowId].parserPipe, &msg) < 0) {
						perror("signalManager sending msg");
						exitThread();
				 	}
				}
				break;
			case TSP_ERR_MSG_3:
				recv(sock, (char *) &flowId, sizeof(flowId), 0);
				flowId = ntohl(flowId);
				printf("** To generate ICMP traffic sender and receiver must be root\n");
				
				if (isChannelClosable(chanId))  {
					
					msg.code = MSG_FP_ERR1;
				 	msg.flowId = flowId;
				 	if (sendPipeMsg(flows[flowId].parserPipe, &msg) < 0) {
						perror("signalManager sending msg");
						exitThread();
				 	}
			 		exitThread();
				}else {
					
				 	msg.code = MSG_FP_ERR1;
				 	msg.flowId = flowId;
				 	if (sendPipeMsg(flows[flowId].parserPipe, &msg) < 0) {
						perror("signalManager sending msg");
						exitThread();
				 	}
				}
    				break;
			default:
				printf("Error - Got unknown message from receiver: %d\n",(int) type);
				break;
			} 
			fflush(stdout);
#ifdef WIN32
			ioctlsocket(sock, FIONREAD, &pending);
#endif
		} 

#ifdef LINUX_OS
		
		if (FD_ISSET(fd, &rset)) {
#endif
#ifdef WIN32
		
		if (PeekNamedPipe(namedPipe, NULL , 0 , NULL , &available , NULL) == 0) {
			printf("Error in peek named pipe\n");
			exitThread();
		}
		PRINTD(1,"available: %d\n", (int) available);

		while(available > 0) {
#endif
			
			if (recvPipeMsg(signalChannels[chanId].pipe, &msg) < 0) {
				perror("signalManager receiving msg");
				exitThread();
			}
			PRINTD(1,"signal manager received msg code: %d\n", msg.code);
			switch(msg.code) {
			case MSG_SM_NEWFLOW:
				PRINTD(1,"perform a new request to send \n");
				flows[msg.flowId].sigChanId = chanId;
			       	requestToSend(msg.flowId, sock);
				break;
			case MSG_SM_ENDFLOW:
				
				PRINTD(1,"SM: sending request on signalling channel to close flow #%d\n", msg.flowId);
				closedFlow(msg.flowId, sock);
				break;
			case MSG_SM_ERRFLOW:
				
				PRINTD(1,"recover from an receiver error notification \n");
				msg.code = MSG_FP_ERR2;
				if (sendPipeMsg(flows[msg.flowId].parserPipe, &msg) < 0) {
					perror("signalManager sending msg");
					exitThread();
				}
				closedFlowErr(msg.flowId, sock);
				
				if ( isChannelClosable(chanId))
					exitThread();
				break;
			default:
				printf("Got unknown message from queue\n");
				fflush(stdout);
				break;
			}
#ifdef WIN32
			
			if (PeekNamedPipe(fd, NULL , 0 , NULL , &available , NULL) == 0) {
				printf("Error in peek named pipe\n");
				exitThread();
			}
#endif
		} 

	} 
}


int isChannelClosable(int id)
{
	MUTEX_THREAD_LOCK(mutex);
	signalChannels[id].flows--;
	if (signalChannels[id].flows == 0) {
		sendRelease(signalChannels[id].socket);

		if (closeSock(signalChannels[id].socket) < 0){
			printf("error closing socket\n");
			fflush(stdout);
		}
		signalChannels[id].socket = -1;
		signalChannels[id].errorLog = false;

		closePipe(signalChannels[id].pipe);

  		MUTEX_THREAD_UNLOCK(mutex);
		PRINTD(1,"closing signalling channel\n");
		return(1);
	}
	MUTEX_THREAD_UNLOCK(mutex);
	return(0);
}


int identifySignalManager(int flowId, int *chanId, struct addrinfo *DestHost)
{
#ifdef LINUX_OS
	int signalSock;
#else
	unsigned int signalSock;
#endif
	char type =0;
	MUTEX_THREAD_LOCK(mutex);

	
	if (checkDestHostIP(chanId, DestHost) == false) {
		
		createTransportChan(signalSock, DestHost);	
		createSignalChan(signalSock);			

		
		if ((namelogReceiver == 1) && (logServer == 0)){
     		if (sendNameLog(signalSock, logFileReceiver,sizeof(logFileReceiver))<0) {
				printf("sendNameLog() error \n");
				fflush(stdout);
				return(-1);
			}
			recv(signalSock, (char *) &type, sizeof(type), 0);
		}
		if (logServer == 1){
			if (sendLog(signalSock, serverLogReceiver, protoTx_ServerLogReceiver, logFileReceiver)<0){
				printf("sendLog() error \n");
				fflush(stdout);
				return(-1);
			}
			recv(signalSock, (char  *) &type, sizeof(type), 0);
		}

		
		
		*chanId = 0;
		while (signalChannels[*chanId].socket != -1)
			(*chanId)++;
		
		if (createNewPipe(signalChannels[*chanId].pipe) < 0) {
			printf("signalManager() could not open pipe for flowId %d\n", flowId);
			fflush(stdout);
			return(-1);
		}
		
		signalChannels[*chanId].DestAddr = DestHost;
		signalChannels[*chanId].flows = 1;
		signalChannels[*chanId].socket = signalSock;

		if ((logServer ==1 ) || (namelogReceiver ==1)){
			if (type == TSP_ERR_MSG_4){
				printf("signalManager() TSP_ERR_MSG_4\n");
				fflush(stdout);
				signalChannels[*chanId].errorLog = true;
			}
		}
		if (signalChannels[*chanId].errorLog == false){
			
			CREATE_THREAD(chanId, signalManager, NULL, signalChannels[*chanId].handle);

			
			signalChanCount++;
		}
		MUTEX_THREAD_UNLOCK(mutex);
		return(1);

	} else {
		MUTEX_THREAD_UNLOCK(mutex);
		return(0);
	}
}



void *flowSender(void *para)
{
	flowDescriptor *param = (flowDescriptor *)para;
	int id = param->id;
   	struct addrinfo *SrcHost =	flows[id].SrcHost;
	struct addrinfo *DestHost =	flows[id].DestHost;
#if ! defined BSD
	char* iface =			flows[id].iface;
#endif
	BYTE meter =	    		flows[id].meter;
	BYTE l4Proto = 		    	flows[id].l4Proto;
	BYTE l7Proto = 		    	flows[id].l7Proto;
	int icmptype = 			flows[id].icmptype;
	int DSByte =			flows[id].DSByte;
	unsigned long Duration = 	flows[id].Duration;
	int TTL = 			flows[id].TTL;
	SumRandom * IntArriv = 		flows[id].IntArriv;
	SumRandom * PktSize = 		flows[id].PktSize;
	int sigChanId =            	flows[id].sigChanId;
	bool Nagle =               	flows[id].Nagle;
	struct info *infos = 		(struct info *) malloc(DIM * sizeof(info));
	bool SrcPortSpecify =       	flows[id].srcPortSpecify;
	unsigned char payload[MAX_PAYLOAD_SIZE];
	unsigned char *ptrSeqNum = payload + sizeof(unsigned int);
	unsigned char *ptrTimeSec = ptrSeqNum + sizeof(unsigned int);
	unsigned char *ptrTimeUsec = ptrTimeSec + sizeof(long int);
	unsigned char *ptrSize = NULL;

	fd_set read_set, active_set;
	int exitflag, size, size_r = 0;
	long int time, time1, time2;
	struct TTicker Ticker;
	struct timeval start_time, end_time, RcvTime, timeout;

	int socktype;
	int prototype = 0;
	unsigned int seqNum = 1;
	Real wait;
	int count = 0;
	int sockchk = 0;
	struct pipeMsg msg;

	char HelpSrcAddress[INET6_ADDRSTRLEN];
	char HelpDstAddress[INET6_ADDRSTRLEN];
	int tmpPort_SrcPort = 0;
	int tmpPort_DstPort = 0;
#ifdef WIN32
	LARGE_INTEGER _tstart, _tend, _tprec;
	unsigned long secondi = 0, microsecondi = 0;
	int first = 1;
	int first_update = 1;
#endif

#ifdef SCTP
	int sctpId = flows[id].sctpId;
	int sctpStream;
	bool newSock = false;
	int ppid;
#endif

	
#ifdef ONOFF
	double OnDuration; 
	double OffDuration; 
	struct timeval StartOnTime, FinishOnTime, WaitTime;
	SumRandom * OnPeriod = 		flows[id].OnPeriod;
	SumRandom * OffPeriod = 	flows[id].OffPeriod;
#endif
	

	PRINTD(1,"flowSender() started\n");

	
	UniformRV = new Uniform;
	for (int i=0; i<MAX_PAYLOAD_SIZE;i++)
		payload[i]=(unsigned char)(255*UniformRV->Next());

	
	msg.flowId = id;

 	
 	if (SrcPortSpecify == true) {
 	    GET_PORT(flows[id].SrcHost, tmpPort_SrcPort);
 	}

  	
	SrcHost->ai_family = DestHost->ai_family;
	SrcHost->ai_addrlen = DestHost->ai_addrlen;
	SrcHost->ai_addr = (struct sockaddr *) malloc(SrcHost->ai_addrlen);

	
	switch (l4Proto) {
	case L4_PROTO_UDP:
		socktype = SOCK_DGRAM;
		break;
	case L4_PROTO_ICMP:
		socktype = SOCK_RAW;
		if (meter == METER_OWDM)
			prototype = (DestHost->ai_family == AF_INET) ? IPPROTO_ICMP : IPPROTO_ICMPV6;
		else if (meter == METER_RTTM)
			prototype = IPPROTO_RAW;
		break;
#ifdef SCTP
	case L4_PROTO_SCTP:
		socktype = SOCK_STREAM;
		prototype = IPPROTO_SCTP;
		DestHost->ai_family = PF_INET;
		break;
#endif
#ifdef DCCP
	case L4_PROTO_DCCP:
		socktype = SOCK_DCCP;
		PRINTD(1,"socktype DCCP  \n");
		break;
#endif
	default:
		socktype = SOCK_STREAM;
		break;
	}


#ifdef LINUX_OS
	int sock;

	
	PRINTD(1,"Try to create an IPv6 Socket\n");
	if (getaddrinfo("::", NULL, NULL, &SrcHost) < 0)  {
		
		PRINTD(1,"Try to create an IPv4 Socket\n");
		if (SrcHost) freeaddrinfo(SrcHost);
		if (getaddrinfo("0.0.0.0", NULL, NULL, &SrcHost) < 0) {
			perror("flowSender");
			printf("Error into getaddrinfo Flow ID: %d\n", id);
			msg.code = MSG_SM_ERRFLOW;

			
			if (sendPipeMsg(signalChannels[sigChanId].pipe, &msg) < 0)
				perror("flowSender sending msg");
			exitThread();
		}
	}

#ifdef SCTP
	else if (l4Proto == L4_PROTO_SCTP) {
		DestHost->ai_family = PF_INET6;
		SrcHost->ai_family = PF_INET6;
	}
#endif
#endif

#ifdef WIN32
	unsigned int sock;
 #ifdef IPv6RECV
	if (getaddrinfo("::", NULL, NULL, &SrcHost) <0){
 #else
	if (getaddrinfo("0.0.0.0", NULL, NULL, &SrcHost)<0){
 #endif
		perror("flowSender");
		printf("Error into getaddrinfo Flow ID: %d\n", id);
		msg.code = MSG_SM_ERRFLOW;
		
		if (sendPipeMsg(signalChannels[sigChanId].pipe, &msg) < 0)
			perror("flowSender sending msg");
		exitThread();
	}
#endif

#ifdef SCTP
	MUTEX_THREAD_LOCK(mutexLog);
    if (l4Proto == L4_PROTO_SCTP && sctpSessions[sctpId].sock != -1) {
		
		sock = sctpSessions[sctpId].sock;
	} else {
    	
		sock = socket(DestHost->ai_family, socktype, prototype);
		sctpSessions[sctpId].sock = sock;
		newSock = true;
	}
	sctpStream = sctpSessions[sctpId].busyStreams++;
 	MUTEX_THREAD_UNLOCK(mutexLog);
#else
    
	sock = socket(DestHost->ai_family, socktype, prototype);
#endif
	if (sock < 0) {
		perror("flowSender");
		printf("Could not create a new socket. Flow ID: %d\n", id);
		msg.code = MSG_SM_ERRFLOW;
		
		if (sendPipeMsg(signalChannels[sigChanId].pipe, &msg) < 0)
			perror("flowSender sending msg");
		exitThread();
	}

#ifdef SCTP
	
	if (l4Proto == L4_PROTO_SCTP && newSock)
	{
		struct sctp_initmsg ginmsg;		

		ginmsg.sinit_num_ostreams = sctpSessions[sctpId].numStreams;
		ginmsg.sinit_max_instreams = sctpSessions[sctpId].numStreams;
		ginmsg.sinit_max_attempts = 0;
		ginmsg.sinit_max_init_timeo = 0;
		int initmsglen = sizeof(struct sctp_initmsg);
		if (setsockopt(sock, IPPROTO_SCTP, SCTP_INITMSG, &ginmsg, initmsglen) < 0){
			printf("flowSender sending msg\n");
			fflush(stdout);
		}
	}
#endif

#ifdef DCCP
	if (l4Proto == L4_PROTO_DCCP) {
		int optval = 0;
		if (setsockopt(sock, SOL_DCCP, DCCP_SOCKOPT_SERVICE, &optval, sizeof(optval))<0)
			printf("Error: flowSender setsockopt DCCP_SERVICE\n");
		PRINTD(1,"setsockopt DCCP_SERVICE \n");
	}
#endif

	
#ifdef LINUX_OS
	int reuse = 1;
	int optlen = sizeof(reuse);
 #ifdef SCTP
	if (l4Proto != L4_PROTO_SCTP)
 #endif
	if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char*)&reuse, optlen)<0){
		printf("flowSender sending msg");
	}
#endif

	
	if (SrcPortSpecify == true){
		PRINTD(1,"Set Port on Sender Side. Port number: %d \n",tmpPort_SrcPort);


	    SET_PORT(SrcHost, tmpPort_SrcPort);
#ifdef SCTP
    	if (l4Proto != L4_PROTO_SCTP || (l4Proto == L4_PROTO_SCTP && newSock))
#endif
		if (bind(sock, SrcHost->ai_addr, SrcHost->ai_addrlen) != 0){
			perror("flowSender");
			printf("Could not bind a new socket. Flow ID: %d\n", id);
			msg.code = MSG_SM_ERRFLOW;
			
			if (sendPipeMsg(signalChannels[sigChanId].pipe, &msg) < 0)
				perror("flowSender sending msg");
			exitThread();
		}
	}  


	
	if ((l7Proto != L7_PROTO_TELNET && l7Proto != L7_PROTO_DNS) && socktype == SOCK_STREAM
        && Nagle == false) {
		printf("Nagle algorithm disabled\n");
		fflush(stdout);
#ifdef LINUX_OS
		int no_delay = 1;
		if (setsockopt(sock, getprotobyname("TCP")->p_proto, TCP_NODELAY, &no_delay,
			sizeof(no_delay)) < 0) {
#endif
#ifdef WIN32
		char *no_delayWin;
		no_delayWin = "1";
		if (setsockopt(sock, getprotobyname("TCP")->p_proto, TCP_NODELAY, no_delayWin,
			sizeof(no_delayWin)) < 0) {
#endif
			printf("** WARNING ** Flow %d. Cannot disable Nagle Algorithm\n", id);
			fflush(stdout);
		}
	}
#if defined LINUX_OS && ! defined BSD
	
	if (iface) {
		int dontRoute = 1;
		printf("Binding to device %s\n",iface);
		if (setsockopt(sock, SOL_SOCKET, SO_BINDTODEVICE, iface, strlen(iface)) < 0) {
			printf("** WARNING ** Flow %d. Cannot bind to device %s (hint: you must be root)\n", id, iface);
			fflush(stdout);
		}
		else if (setsockopt(sock, SOL_SOCKET, SO_DONTROUTE, &dontRoute, sizeof(int)) < 0) {
			printf("** WARNING ** Flow %d. Cannot set don't route (hint: you must be root)\n", id);
			fflush(stdout);
		}
	}
#endif
	
 	MUTEX_THREAD_LOCK(mutexLog);
	if ((logging && isFirstThread == 1) || (meter == METER_RTTM && isFirstThreadRttm == 1)) {
		PRINTD(1,"Log!  \n");
		isFirstThread = 0;
		isFirstThreadRttm = 0;
		if (!logremoto) {
			out.open(logFile, ios::out | ios::binary | ios::trunc);
			if (!out) {
				printf("** WARNING ** Flow %d. Cannot create local logfile\n", id);
				fflush(stdout);
				logging = 0;
			}
		}
		else
			createRemoteLogFile(logHost, protoTxLog);
	}
	MUTEX_THREAD_UNLOCK(mutexLog);

	
#ifdef SCTP
	if (l4Proto != L4_PROTO_SCTP || (l4Proto == L4_PROTO_SCTP && newSock))
#endif

	if (connect(sock, DestHost->ai_addr, DestHost->ai_addrlen) < 0) {
		perror("flowSender");
		printf("Error in connect(). Flow ID: %d\n", id);
		
		msg.code = MSG_SM_ERRFLOW;
		if (sendPipeMsg(signalChannels[sigChanId].pipe, &msg) < 0)
			perror("flowSender sending msg");
		exitThread();
	}

    	PRINTD(1,"DS byte %d\n",DSByte);

	if (DSByte && (DestHost->ai_family == AF_INET) && setsockopt(sock,  SOL_IP,  IP_TOS, (char *) &DSByte, sizeof(DSByte)) < 0)
		printf("** WARNING ** Flow %d. Could not set DS byte to: %d\n", id, DSByte);

	if (DSByte && (DestHost->ai_family == AF_INET6))
#ifdef WIN32
		printf("** WARNING ** Flow %d. Windows does not allow to set the Traffic Class field in IPv6 headers\n",id);
#endif
#ifdef LINUX_OS
#ifdef IPV6_TCLASS
		if (setsockopt(sock, SOL_IPV6, IPV6_TCLASS, (char *) &DSByte, sizeof(DSByte)) < 0)
			printf("** WARNING ** Flow %d. Could not set DS byte to: %d. Linux kernel >= 2.6.14 is required\n", id, DSByte);
#else
		printf("** WARNING ** Flow %d. Could not set DS byte to: %d. libc >= 2.4 is required\n", id, DSByte);
#endif
#endif


	PRINTD(1,"TTL %d\n", TTL);
	if (TTL >0 && (setsockopt(sock, IPPROTO_IP, IP_TTL, (char *) &TTL, sizeof(TTL)) < 0))
		printf("** WARNING ** Flow %d. Could not set TTL to: %d\n", id, TTL);


#ifdef LINUX_OS
	getsockname(sock, SrcHost->ai_addr, &SrcHost->ai_addrlen);
#endif
#ifdef WIN32
	getsockname(sock, SrcHost->ai_addr, (int *) &SrcHost->ai_addrlen);
#endif

   	
	getInfo(SrcHost, tmpPort_SrcPort, HelpSrcAddress);
	
	getInfo(DestHost, tmpPort_DstPort, HelpDstAddress);

#ifdef SCTP
   	if (l4Proto == L4_PROTO_TCP || l4Proto == L4_PROTO_SCTP) {
#else
	if (l4Proto == L4_PROTO_TCP) {
#endif
		if (flows[id].payloadLogType == PL_STANDARD)
			ptrSize = ptrTimeUsec + sizeof(int);
		else if (flows[id].payloadLogType == PL_SHORT)
			ptrSize = ptrSeqNum + sizeof(unsigned int);
		else
			ptrSize = payload + sizeof(unsigned int);
	}

	printf("Started sending packets of flow ID: %d\n", id);
	fflush(stdout);

	Ticker.count = 0.0;
	unsigned int net_id = htonl(id); 
	memcpy(payload, &net_id, sizeof(unsigned int));

	TSTART(_tstart, secondi, microsecondi, first, meter, 0);

	GET_TIME_OF_DAY(&start_time, _tend, _tstart, secondi, microsecondi, meter, 0);

	
	end_time.tv_sec = start_time.tv_sec + Duration / 1000 + (end_time.tv_usec =
	    start_time.tv_usec + (Duration % 1000) * 1000) / 1000000;
	end_time.tv_usec %= 1000000;

	
	if (meter == METER_RTTM) {
		
		start_time.tv_sec = 0;
		start_time.tv_usec = 0;
		
		FD_ZERO(&active_set);
		FD_SET(sock, &active_set);
	}

#ifdef WIN32
	if (flows[id].serial != INVALID_HANDLE_VALUE){
		RTS_Enable (flows[id].serial);
		RTS_Disable(flows[id].serial);
		DTR_Enable (flows[id].serial);
	}
#endif

#ifdef LINUX_OS
	if (flows[id].serial != INVALID_HANDLE_VALUE){
		RTS_Disable(flows[id].serial);
	}
#endif

	GET_TIME_OF_DAY(&Ticker.lastTime, _tend, _tstart, secondi, microsecondi, meter, 0);
	
	size = (int) PktSize->Next();
#ifdef SCTP
	if (l4Proto == L4_PROTO_TCP || l4Proto == L4_PROTO_SCTP) {
#else
	if (l4Proto == L4_PROTO_TCP) {
#endif
		if (size > MAX_PAYLOAD_SIZE)
			size = MAX_PAYLOAD_SIZE;
		else if (size < (flows[id].minPayloadSize + (int) sizeof(int)))
			size = flows[id].minPayloadSize + (int) sizeof(int);
	} else {
		if (size > MAX_PAYLOAD_SIZE)
			size = MAX_PAYLOAD_SIZE;
		else if (size < flows[id].minPayloadSize)
			size = flows[id].minPayloadSize;
	}

 	
#ifdef ONOFF

	if (flows[id].OnOff) 
	{
		
		OnDuration = (double) OnPeriod->Next();
		PRINTD(1,"On Duration = %lf\n",OnDuration);
	}
	else
	{
		
		OnDuration = (double)Duration;
	}
#endif
	

	
	do {
		
#ifdef ONOFF
		do {
			
			gettimeofday(&StartOnTime, NULL);

			
			Ticker.count = 0.0;
		
#endif
		

		time = Ticker.lastTime.tv_sec % 86400L;

		
		long int net_seqNum = htonl(seqNum);
		long int net_TimeSec = htonl(time);
		long int net_TimeUsec = htonl(Ticker.lastTime.tv_usec);
		int net_size = htonl(size);
		

		
		if ( flows[id].payloadLogType == 0 ) { 
			memcpy(ptrSeqNum, &net_seqNum, sizeof(unsigned int));
			memcpy(ptrTimeSec, &net_TimeSec, sizeof(long int));
			memcpy(ptrTimeUsec, &net_TimeUsec, sizeof(long int));
		} else if ( flows[id].payloadLogType == 1 ) 
			memcpy(ptrSeqNum, &net_seqNum, sizeof(unsigned int));
#ifdef SCTP
		if (l4Proto == L4_PROTO_TCP || l4Proto == L4_PROTO_SCTP)
#else
		if (l4Proto == L4_PROTO_TCP)
#endif
			memcpy(ptrSize, &net_size, sizeof(int));

		if ((l4Proto == L4_PROTO_ICMP) && (meter == METER_OWDM)) {
				if (DestHost->ai_family == AF_INET) {
					icmppkt pkt;
					pkt.icmp_buf.icmp_type = icmptype;
					pkt.icmp_buf.icmp_code = 0;
					pkt.icmp_buf.icmp_cksum = 0;
					memcpy(&pkt.packet, payload, size);
					pkt.icmp_buf.icmp_cksum =
			    		checksum((unsigned short *) &pkt, size + sizeof(icmp));
					sockchk =
					  sendto(sock, (char *) &pkt, size + sizeof(icmp), 0,  DestHost->ai_addr,
						 DestHost->ai_addrlen);
				} else 	if (DestHost->ai_family == AF_INET6) {
#ifdef LINUX_OS
					icmppktv6 pkt;
					pkt.icmp_buf.icmp_type = icmptype;
					pkt.icmp_buf.icmp_code = 0;
					pkt.icmp_buf.icmp_cksum = 0;
					memcpy(&pkt.packet, payload, size);
					pkt.icmp_buf.icmp_cksum =
				    		checksum((unsigned short *) &pkt, size + sizeof(icmpv6));
					struct sockaddr_in6 from;
					from.sin6_family=AF_INET6;
					from.sin6_port=0;
					from.sin6_addr=((struct sockaddr_in6*)(DestHost->ai_addr))->sin6_addr;
					sockchk =
			    			sendto(sock, (char *) &pkt, size + sizeof(icmpv6), 0,  (sockaddr *)&from,
			    		sizeof(from));
#endif
			    }
#ifndef SCTP
		} else {
			sockchk = send(sock, (char *) payload, size, 0);
		}
#else
		} else if (l4Proto != L4_PROTO_SCTP) {
			sockchk = send(sock, (char *) payload, size, 0);
		} else {
			ppid = rand();
			sockchk = sctp_sendmsg(sock, (char *) payload, size, (struct sockaddr *)DestHost->ai_addr,
					       DestHost->ai_addrlen, ppid, 0, sctpStream, 0, 0);
		}
#endif

		if (flows[id].serial != INVALID_HANDLE_VALUE){
	         DTR_Disable(flows[id].serial);
                 DTR_Enable(flows[id].serial);
		}

        if (sockchk < 0 && !termsock) {
			printf("** WARNING ** flow: %d Packet: %d not sent\n", id, seqNum);
			fflush(stdout);
		}
		else {
			
			if ((logging) && (meter == METER_OWDM)) {
				if (l7Proto == L7_PROTO_TELNET)
					size = size - 20;
				if ( logremoto == 0) {
				   	writeInBufferStandard(&infos[count], id, seqNum, HelpSrcAddress, HelpDstAddress, tmpPort_SrcPort, tmpPort_DstPort, time, time, Ticker.lastTime.tv_usec, Ticker.lastTime.tv_usec,size);
				} else {
				    writeInBufferStandard(&infos[count],*(unsigned int *) payload ,*(unsigned int *) ptrSeqNum, HelpSrcAddress, HelpDstAddress, tmpPort_SrcPort,tmpPort_DstPort, 0,0,0,0,htonl(size));
					infos[count].srcPort = htonl(infos[count].srcPort);
               	        		infos[count].destPort = htonl(infos[count].destPort);
               			 	infos[count].txTime1 = htonl(time);
                			
                			infos[count].txTime2 = htonl(Ticker.lastTime.tv_usec);
                			infos[count].txTime3 = 0;
                			infos[count].rxTime1 = htonl(time);
                			
                			infos[count].rxTime2 = htonl(Ticker.lastTime.tv_usec);
                			infos[count].rxTime3 = 0;
				}

				count++;
				
				if (count == DIM) {
					flushBuffer(infos, count);
					count = 0;
				}
			}
		}

		
		size = (int) PktSize->Next();
#ifdef SCTP
		if (l4Proto == L4_PROTO_TCP || l4Proto == L4_PROTO_SCTP) {
#else
		if (l4Proto == L4_PROTO_TCP) {
#endif
			if (size > MAX_PAYLOAD_SIZE)
				size = MAX_PAYLOAD_SIZE;
			else if (size < (flows[id].minPayloadSize + (int) sizeof(int)))
				size = flows[id].minPayloadSize + (int) sizeof(int);
		} else {
			if (size > MAX_PAYLOAD_SIZE)
				size = MAX_PAYLOAD_SIZE;
			else if (size < flows[id].minPayloadSize)
				size = flows[id].minPayloadSize;
		}

		
		wait = IntArriv->Next();	
		UPDATE_TICKER(&Ticker, _tend, _tprec, _tstart, first_update);
		if (flows[id].mean_adjustment == 0)	
			Ticker.count = 0;
        exitflag = 0;
        while (!exitflag){
			if (wait <= Ticker.count){
				exitflag = 1;
				timeout.tv_sec = 0;
				timeout.tv_usec = 0;
			}
			else {
				wait -= Ticker.count;
				Ticker.count = 0.0;
				timeout.tv_sec = (long) wait / 1000;
				timeout.tv_usec = (long) (wait - (timeout.tv_sec * 1000)) * 1000;
			}
			
			if (meter == METER_RTTM) {
				read_set = active_set;
				if (select(FD_SETSIZE, &read_set, NULL, NULL, &timeout) < 0) {
					perror("flowSender");
					printf("invalid fd or operation interrupted by signal\n");
					
					msg.code = MSG_SM_ERRFLOW;
					if (sendPipeMsg(signalChannels[sigChanId].pipe, &msg) < 0)
						perror("flowSender sending msg");
					exitThread();
				} 

				if (FD_ISSET(sock, &read_set)) {
					GET_TIME_OF_DAY(&RcvTime, _tend, _tstart, secondi, microsecondi, meter, 0);
					if (l4Proto == L4_PROTO_TCP)
                        
                        size_r = TCPrecvPacket((unsigned char*)payload, sock, flows[id].minPayloadSize, flows[id].payloadLogType);
#ifdef SCTP
           				else if (l4Proto == L4_PROTO_SCTP) {
						size_r = SCTPrecvPacket((unsigned char*)payload, sock, sctpId, flows[id].minPayloadSize, flows[id].payloadLogType);
						PRINTD(2, "in sctp settato flows[id].minPayloadSize: %d\n", flows[id].minPayloadSize);
					}
#endif
#ifdef DCCP			
					
					
#endif
                   			else
						size_r = recv(sock, (char *) payload, MAX_PAYLOAD_SIZE, 0);
						time1 = ntohl((*(long int *) ptrTimeSec)); 
						time2 = RcvTime.tv_sec % 86400L;

					
					if (((logging) && (size_r > 0)) || (meter == METER_RTTM)) {
						if (logremoto == 0) {
			                        	int net_TimeUsec = ntohl(*(unsigned int *) ptrTimeUsec); 
							writeInBufferStandard(&infos[count], *(unsigned int *) payload, *(unsigned int *) ptrSeqNum, HelpSrcAddress, HelpDstAddress, tmpPort_SrcPort, tmpPort_DstPort, time1,time2, net_TimeUsec,RcvTime.tv_usec,size_r);
							
							infos[count].flowId = ntohl(infos[count].flowId);
							infos[count].seqNum = ntohl(infos[count].seqNum);
							
						} else {
				                	writeInBufferStandard(&infos[count],*(unsigned int *) payload,*(unsigned int *) ptrSeqNum,
  			                             	HelpSrcAddress, HelpDstAddress, tmpPort_SrcPort, tmpPort_DstPort, 0,0,0,0,htonl(size_r));
							infos[count].srcPort = htonl(infos[count].srcPort);
                					infos[count].destPort = htonl(infos[count].destPort);
			                	       	infos[count].txTime1 = *(unsigned int *) ptrTimeSec;
                        				infos[count].txTime2 = *(unsigned int *) ptrTimeUsec;
			               	        	infos[count].txTime3 = 0;
                        				infos[count].rxTime1 = htonl(time2);
			                	        infos[count].rxTime2 = htonl(RcvTime.tv_usec);
                        				infos[count].rxTime3 = 0;
						}
						count++;
						
						if (count == DIM) {
							flushBuffer(infos, count);
						   	count = 0;
						} 
					} 
		        } 
			} 
			else {


       				select(1, NULL, NULL, NULL, &timeout);
			}

			if(!exitflag)
				UPDATE_TICKER(&Ticker, _tend, _tprec, _tstart, first_update);
			else Ticker.count -= wait;
     	} 

#ifdef WIN32
		GET_TIME_OF_DAY(&Ticker.lastTime, _tend, _tstart, secondi, microsecondi, meter, 0);
#endif
		seqNum++;
			
#ifdef ONOFF

			

			
			gettimeofday(&FinishOnTime, NULL);
			
			OnDuration -= ( (double) (FinishOnTime.tv_sec - StartOnTime.tv_sec) * 1000.0 +
  				(double) (FinishOnTime.tv_usec - StartOnTime.tv_usec) / 1000.0);
			PRINTD(2,"onDuration = %lf\n",OnDuration);

		} while ( (OnDuration > 0) && ((Ticker.lastTime.tv_sec < end_time.tv_sec)
			|| ((Ticker.lastTime.tv_sec == end_time.tv_sec) && (Ticker.lastTime.tv_usec < end_time.tv_usec))) );
		PRINTD(1,"Exited from while with onDuration = %lf\n",OnDuration);

		if (flows[id].OnOff)
		{
			
			OffDuration = (double) OffPeriod->Next();
			WaitTime.tv_sec = (long int)OffDuration / 1000;
			WaitTime.tv_usec = (OffDuration - (WaitTime.tv_sec * 1000)) * 1000;
			PRINTD(1,"offDuration = %lf\n",OffDuration);
			
			select(1, NULL, NULL, NULL, &WaitTime);
			
			OnDuration = (double) OnPeriod->Next();
			PRINTD(1,"On Duration = %lf\n",OnDuration);
		}

#endif
	


	} while (Ticker.lastTime.tv_sec < end_time.tv_sec
	    || (Ticker.lastTime.tv_sec == end_time.tv_sec && Ticker.lastTime.tv_usec < end_time.tv_usec));

	if (flows[id].serial != INVALID_HANDLE_VALUE)
		RTS_Enable(flows[id].serial);

	

	if (meter == METER_RTTM) {
	        bool flag = true;
		while (flag) {
			start_time.tv_sec = rttmDelay;
			read_set = active_set;
			if (select(FD_SETSIZE, &read_set, NULL, NULL, &start_time) < 0) {
				perror("send_packrttm");
				flag = true;
			} else {
				
				if (FD_ISSET(sock, &read_set)) {
					GET_TIME_OF_DAY(&RcvTime, _tend, _tstart, secondi, microsecondi,
					    meter,0);

					if (l4Proto == L4_PROTO_TCP)
                        TCPrecvPacket((unsigned char*)payload, sock, flows[id].minPayloadSize, flows[id].payloadLogType);
#ifdef SCTP
					else if (l4Proto == L4_PROTO_SCTP) {
						SCTPrecvPacket((unsigned char*)payload, sock, sctpId, flows[id].minPayloadSize, flows[id].payloadLogType);
					}
#endif
#ifdef DCCP			
  					
					
#endif
					else
						size_r = recv(sock, (char *) payload, MAX_PAYLOAD_SIZE, 0);

					time1 = ntohl(*(long int *) ptrTimeSec); 
					time2 = RcvTime.tv_sec % 86400L;

					
					
					   if (((logging) && (size_r > 0)) || (meter == METER_RTTM)) {
						if (logremoto == 0){
				                        int net_TimeUsec = ntohl(*(unsigned int *) ptrTimeUsec); 
			               		writeInBufferStandard(&infos[count],*(unsigned int *) payload,*(unsigned int *) ptrSeqNum, HelpSrcAddress, HelpDstAddress,  tmpPort_SrcPort, tmpPort_DstPort, time1,time2, net_TimeUsec,RcvTime.tv_usec,size);
							
                        	                        infos[count].flowId = ntohl(infos[count].flowId);
                                	                infos[count].seqNum = ntohl(infos[count].seqNum);
                                        	        
						} else {
							writeInBufferStandard(&infos[count],*(unsigned int *) payload,*(unsigned int *) ptrSeqNum,
                                                	HelpSrcAddress, HelpDstAddress, tmpPort_SrcPort, tmpPort_DstPort,
							0,0,0,0,htonl(size));
							infos[count].srcPort = htonl(infos[count].srcPort);
                                        	      	infos[count].destPort = htonl(infos[count].destPort);
							infos[count].txTime1 = *(unsigned int *) ptrTimeSec;
                                       			infos[count].txTime2 = *(unsigned int *) ptrTimeUsec;
                                              		infos[count].txTime3 = 0;
                                               		infos[count].rxTime1 = htonl(time2);
                                                	infos[count].rxTime2 = htonl(RcvTime.tv_usec);
                                                	infos[count].rxTime3 = 0;
						}
						count++;

      					
      					if (count == DIM) {
							flushBuffer(infos, count);
							count = 0;
   						}
					} 
				} else {
					
					flag = false;
				} 
			} 
		} 
	}

	
	printf("Finished sending packets of flow ID: %d\n", id);
	fflush(stdout);

	
	if ((logging) || (meter == METER_RTTM)) {
		flushBuffer(infos, count);
		count = 0;
	}
	free(infos);
#ifdef SCTP
	MUTEX_THREAD_LOCK(mutexSctp);
	sctpSessions[sctpId].busyStreams--;
	MUTEX_THREAD_UNLOCK(mutexSctp);
	if (l4Proto != L4_PROTO_SCTP || (l4Proto == L4_PROTO_SCTP && sctpSessions[sctpId].busyStreams == 0))
#endif
	closeSock(sock);

	
	msg.code = MSG_SM_ENDFLOW;
	if (sendPipeMsg(signalChannels[sigChanId].pipe, &msg) < 0) {
		perror("flow Sender sending msg");
		exitThread();
	}
	return NULL;
}




void Terminate(int sig)
{
	
	if (logremoto) {
		signaling signaling_log;
		signaling_log.stop = true;
		sendto(logSockSignaling, (char *) &signaling_log, sizeof(signaling_log), 0,
		    logHost->ai_addr, logHost->ai_addrlen);
		if (closeSock(logSock) < 0)
			printf("Error into close  log sock\n");
		if (closeSock(logSockSignaling) < 0)
			printf("Error into close log sock signaling\n");
	} else if (logging) {
		out.close();
	}

	
	
	
#ifdef LINUX_OS
	memClean();
	exit(1);
#endif
#ifdef WIN32
	WSACleanup();
	memClean();
#endif
}

void printHelp()
{
	cout << " Name " << endl;
	cout << "	 ITGSend - Sender componet of D-ITG platform" << endl << endl;
	cout << " Synopsis" << endl <<endl;
	cout << "   - In case of using a script file to generate multiple flows:" << endl;
	cout << "   ./ITGSend <script_file> [-l [<logfile>]] [-L [<log_server_addr>]" <<endl;
	cout << "             [<logging_protocol_type>]] [-X [<log_server_addr>] [<logging_protocol_type>]]" <<endl;
	cout << "             [-x [<receiver_logfile>]] "<<endl<<endl;
	cout << "   - If you want to remotely control the sender, launch it in daemon mode:" << endl;
	cout << "   ./ITGSend -Q [-l [<logfile>]] [-L [<log_server_addr>] [<logging_protocol_type>]]" << endl;
	cout << "	   [-x [<receiver_logfile>]] [-X [<log_server_addr>] [<logging_protocol_type>]]" << endl << endl;
	cout << "   - Otherwise:" << endl;
	cout << "   ./ITGSend [-m <msr_type>][-a <destination_address>][-rp <destination_port>]" <<endl;
	cout << "	   [-sk <sender_serial_iface>]  [-rk <receiver_serial_iface>]" << endl;
	cout << "	   [-b <DS byte>] [-l [<logfile>]] [-L [<log_server_addr>]" << endl;
	cout << "	   [<logging_protocol _type>]] [-X [<log_server_addr>] [<logging_protocol_type>]]" << endl;
	cout << "	   [-x [<logfile_receiver>]] [-t <duration>] [-d <gen_delay>]" << endl;
	cout << " 	   [-T <protocol_type>] [-s <seed>] [-D] [-f <TTL>] [-j <enable_idt_recovery>]"<<endl;
	cout <<"           [-p <payload_log_type] ";
#ifdef WIN32
    cout << " [-P] ";
#endif
    cout << " [-sp <source_port>] [-i <interface>]" << endl ;

#ifdef ONOFF
	cout << "	   [ -B  <onDistro> <params> <offDistro> <params> ]" << endl;
#endif

	cout << "	   [[ -C <pkts_per_s> | -U <min_pkts_per_s max_pkts_per_s> | " << endl;
	cout << "	   -E <average_pkts_per_s> | -V <shape> <scale> | -Y <shap> <scale> |" << endl;
	cout << "	   -N <mean> <std_dev> | -O <average_pkts_per_s> | -G <shape scale>] " << endl;
	cout << "	   [ -u <min_pkt_size> <max_pkt_size> | -e <average_pkt_size> |" << endl;
	cout << "	   -v <shape> <scale> | -y <shape> <scale> | -n <mean> <std_dev> |  " << endl;
	cout << "	   -o <average_pkt_size> | -g <shape> <scale> | -c <pkt_size> ]] | " << endl;
	cout << "	   [[Telnet] [DNS] [Quake3] [CSa] [CSi] [[VoIP] [-x <codec_type>] [-h <protocol_type>] " << endl;
	cout << "	   [-VAD]]]" << endl;
	cout << endl << " Options" << endl << endl;
	cout << "  -m  <msr_type>\t\t\tSet the type of meter.\n\t\t\t\t\tValues: owdm (one way delay meter)"
			"\n\t\t\t\t\trttm (round trip time meter)\n\t\t\t\t\t(Default: owdm)" << endl;
	cout << "  -a  <destination_address>\t\tSet the destination address\n\t\t\t\t\t\(Default: " << DefaultDestIP << ")" << endl;
	cout << "  -rp <destination_port>\t\tSet the destination port \n\t\t\t\t\t\(Default: " << DEFAULT_PORT << ") " << endl;
	cout << "  -sp <source_port>\t\t\tSet the source port \n\t\t\t\t\t\(Default: Set by O.S.)" << endl;
	cout << "  -sk <sender_serial_iface>\t\tSender serial interface"<<endl;
	cout << "  -rk <receiver_serial_iface>\t\tReceiver serial interface"<<endl;
	cout << "  -s  <seed>\t\t\t\tSet the seed \n\t\t\t\t\t\(Default: Random)" << endl;
#ifdef LINUX_OS
	cout << "  -i <interface>\t\t\tBind to the given interface\n\t\t\t\t\t(Default: don't bind to any interface)" << endl;
#endif
	cout << "  -t  <duration>\t\t\tSet the generation duration\n\t\t\t\t\t(Default: " << DefaultDuration << " msecs)" << endl;
	cout << "  -d <generation_delay>\t\t\tSet the generation delay\n\t\t\t\t\t\(Default: " << DefaultDelay << " msecs)" << endl;
	cout << "  -D \t\t\t\t\tNagle Algorithm Disabled" << endl;
#ifdef WIN32
	cout << "  -P \t\t\t\t\tEnable thread high priority  " << endl;
#endif

    cout << "  -l <logfile>\t\t\t\tGenerate log file\n\t\t\t\t\t(Default: " << DefaultLogFile << ")" << endl;;
	cout << "  -x  <receiver_logfile>\t\tGenerate log file at the receiver side \n\t\t\t\t\t(Default: " << DefaultRecvLogFile << ")" << endl;;
	cout << "  -L <log_server_address> \t\tRemote log file \n\t<logging_protocol_type> \t\t(Default: <" <<
	    DEFAULT_LOG_IP << "> <" << invFindL4Proto(DEFAULT_PROTOCOL_TX_LOG) << ">)"<< endl;;
	cout << "  -X <log_server_address>  \t\tReceiver remote log file\n\t<logging_protocol_type>\t\t\t(Default: <"
	    << DEFAULT_LOG_IP << "> <" <<invFindL4Proto(DEFAULT_PROTOCOL_TX_LOG) << ">)" << endl;
	cout << "  -p <payload_log_type>\t\t\tSet the type of information sent in the pyload of each packet (please, for details see the documentation)" << endl;
	cout << "  -j <enable_idt_recovery>\t\tenable (1) or disable (0) the strategy used to guaranty the mean bitrate"<<endl;
	cout << "  -T <protocol_type>\t\t\t(Default: " << invFindL4Proto(L4_PROTO_UDP) << ") NOTE: Protocol\n\t\t\t\t\tTypes are: UDP,TCP, ICMP";
#ifdef SCTP
	cout << ", SCTP <association_id> <max_streams>";
#endif
#ifdef DCCP
	cout << ", DCCP";
#endif
	cout << endl;
	cout << "  -b <DS_byte>\t\t\t\tSet the DS byte for QoS tests\n\t\t\t\t\t(Default: " << DefaultDSByte << ")" << endl;
	cout << "  -f <TTL byte>\t\t\t\tSet the time to live (TTL) \n\t\t\t\t\t(Default:  64)" << endl;

#ifdef ONOFF
	cout << "  -B <onDistro> <params> \t\tSet random distribution of the on/off periods" << endl;
	cout << "\t<offDistro> <params>\t\tAll the supported distributions can be used" << endl;
#endif

	cout <<
	    "  -C <pkts_per_s>\t\t\t[DEFAULT] constant inter-arrival\n\t\t\t\t\t(Default: " <<
	    DefaultPktPerSec << " pkts/s)" << endl;
	cout <<
	    "  -U <min_pkts_per_s> <max_pkts_per_s>\tuniformly distributed\n\t\t\t\t\tinter-arrival"
	    << endl;
	cout <<
	    "  -E <average_pkts_per_s>\t\texponentially distributed\n\t\t\t\t\tinter-arrival"
	    << endl;
	cout << "  -V <shape> <scale>\t\t\tpareto distributed\n\t\t\t\t\tinter-arrival" << endl;
	cout << "  -Y <shape> <scale>\t\t\tcauchy distributed\n\t\t\t\t\tinter-arrival" << endl;
	cout << "  -N <mean> <std_dev>\t\t\tnormal distributed\n\t\t\t\t\tinter-arrival" <<
	    endl;
	cout << "  -O <mean>\t\t\t\tpoisson distributed\n\t\t\t\t\tinter-arrival" << endl;
	cout << "  -G <shape> <scale>\t\t\tgamma distributed\n\t\t\t\t\tinter-arrival" << endl;
	cout << "  -W <shape> <scale>\t\t\tweibull distributed\n\t\t\t\t\tinter-arrival" << endl;
	cout << "  -c <pkt_size>\t\t\t\t[DEFAULT] constant payload size\n\t\t\t\t\t(Default: "
	    << DefaultPktSize << " bytes)" << endl;
	cout <<
	    "  -u <min_pkt_size> <max_pkt_size>\tuniformly distributed\n\t\t\t\t\tpayload size"
	    << endl;
	cout << "  -e <average_pkt_size>\t\t\texponentially distributed\n\t\t\t\t\tpayload size"
	    << endl;
	cout << "  -v <shape> <scale>\t\t\tpareto distributed\n\t\t\t\t\tpayload size" << endl;
	cout << "  -y <shape> <scale>\t\t\tcauchy distributed\n\t\t\t\t\tpayload size" << endl;
	cout << "  -n <mean> <std_dev>\t\t\tnormal distributed\n\t\t\t\t\tpayload size" << endl;
	cout << "  -o <mean>\t\t\t\tpoisson distributed\n\t\t\t\t\tpayload size" << endl;
	cout << "  -g <shape> <scale>\t\t\tgamma distributed\n\t\t\t\t\tpayload size" << endl;
	cout << "  -w <shape> <scale>\t\t\tweibull distributed\n\t\t\t\t\tpayload size" << endl;
	cout << " Upper Protocol Options: \n" << endl;
	cout << "  Telnet (without any other option)" << endl;
	cout << "  DNS (without any other option)" << endl;
	cout << "  Quake3 (without any other option)" << endl;
	cout << "  CSa (Counterstrike active)" << endl;
	cout << "  CSi (Counterstrike inactive)" << endl;
	cout << "  VoIP (with option: )\t-x <codec_type>\tCodec:  G.711.<1 or 2> (samples per pkt)"
	    << endl;
	cout << " \t\t\t\t\t\tG.729.<2 or 3> (samples per pkt)" << endl;
	cout << " \t\t\t\t\t\tG.723.1" << endl;
	cout << " \t\t\t\t\t\t(Default: G.711.1)" << endl;
	cout << "  \t\t\t-h <protocol_type>\t(Default: RTP)" << endl;
	cout << "  \t\t\t-VAD \t\t\t Voice_Activity_Detection>" << endl;
	cout << endl;
	cout << " For more information consult " "help" " file in the same directory" << endl;

	exit(1);
}

void ReportErrorAndExit(const char *function, const char *msg, char *pname, int fid)
{
	printf(" ** ERROR **  Flow %d aborted:  %s : %s \n ",fid, function, msg);
	printf("Type %s for help \n", pname);
	memClean();
	exit(1);
}


#ifdef LINUX_OS
void createTransportChan(int &signalSock, struct addrinfo *DestHost)
#else
void createTransportChan(unsigned int &signalSock, struct addrinfo *DestHost)
#endif
{
	signalSock = socket(DestHost->ai_family, SOCK_STREAM, 0);
	struct sockaddr *locale = (struct sockaddr *) malloc(DestHost->ai_addrlen);
	memcpy(locale, DestHost->ai_addr, DestHost->ai_addrlen);
	if (DestHost->ai_family == PF_INET)
		((struct sockaddr_in *) locale)->sin_port = htons(DEFAULT_PORT_SIGNALING);
	else if (DestHost->ai_family == PF_INET6)
		((struct sockaddr_in6 *) locale)->sin6_port = htons(DEFAULT_PORT_SIGNALING);

	if (connect(signalSock, locale, DestHost->ai_addrlen) < 0) {
		perror("Connect error in createTransportChan()");
		memClean();
		exit(1);
	}
}


void sendType(int signalSock, BYTE type)
{
	int err;
	char msg[1];

	putValue(&msg, (void *) &type, sizeof(type));

#ifdef LINUX_OS
        err = send(signalSock, (char *) &msg, sizeof(msg), MSG_DONTWAIT);
      	if (err == EAGAIN) PRINTD(1,"** Send type would block! **\n");
#endif

#ifdef WIN32
      	int timeo= 100000;
      	if (setsockopt(signalSock, SOL_SOCKET, SO_SNDTIMEO, (char*)&timeo,sizeof(timeo)) < 0)
          	printf("Error on setting timeout for sending 1\n");
      	err = send(signalSock, (char *) &msg, sizeof(msg), 0);
      	if(err<0)
         	PRINTD(1,"Send type would block!\n");
      	timeo=0;
      	if (setsockopt(signalSock, SOL_SOCKET, SO_SNDTIMEO, (char*)&timeo,sizeof(timeo)) < 0)
          	printf("Error on setting timeout for sending 2\n");
#endif

}


#ifdef LINUX_OS
void createSignalChan(int signalSock)
#else
void createSignalChan(unsigned int signalSock)
#endif
{
	timeval timeout;
	int numSend = 0;
	fd_set active_set;
	int exit = 0;
	do {
		
		sendType(signalSock, TSP_CONNECT);
		PRINTD(1,"sent TSP_CONNECT\n");

		
		FD_ZERO(&active_set);
		FD_SET(signalSock, &active_set);
		timeout.tv_sec = TIME_OUT;
		timeout.tv_usec = 0;
		if (select(FD_SETSIZE, &active_set, NULL, NULL, &timeout) < 0) {
			printf("Error ** : Invalid file descriptor\n");
		}
		if (FD_ISSET(signalSock, &active_set)) {
			recvAck(signalSock);
			exit = 1;
		}
		numSend++;
	} while ((exit != 1) && (numSend < 2));

	if (numSend == 2){
		printf("** ERROR ** Receiver is down !\n");
		fflush(stdout);
	}
}


#ifdef LINUX_OS
void sendRelease(int signalSock)
#else
void sendRelease(unsigned int signalSock)
#endif
{
	timeval timeout;
	int numSend = 0;
	fd_set active_set;
	int exit = 0;
	do {
		sendType(signalSock, TSP_RELEASE);
		PRINTD(1,"sent TSP_RELEASE\n");
		FD_ZERO(&active_set);
		FD_SET(signalSock, &active_set);
		timeout.tv_sec = TIME_OUT;
		timeout.tv_usec = 0;
		if (select(FD_SETSIZE, &active_set, NULL, NULL, &timeout) < 0) {
			printf("Error ** : Invalid file descriptor\n");
		}
		if (FD_ISSET(signalSock, &active_set)) {
			recvAck(signalSock);
			PRINTD(1,"received ack to release signal channel\n");
			exit = 1;
		}
		numSend++;
	} while ((exit != 1) && (numSend < 2));
	if (numSend == 2) {
		printf("** ERROR ** Receiver is down !\n");
		fflush(stdout);
	}
}


int sendNameLog(int signalSock, char *FileName, int sizeFileName)
{
	char Messaggio[DIM_LOG_FILE + sizeof(BYTE)];
	char *next;
	BYTE type = TSP_SEND_NAME_LOG;
	int ret = 0;
	int sizeMessag;
	next = putValue(&Messaggio, (void *) &type, sizeof(type));
	next = putValue(next, (void *) FileName, sizeFileName);
	sizeMessag = sizeof(type) + sizeFileName;
	ret  = send(signalSock, (char *) &Messaggio, sizeMessag, 0);
	return (ret);
}




int sendLog(int signalSock, struct addrinfo *logHost, BYTE logProtocol, char *FileName)
{
	char Messaggio[DIM_LOG_FILE + 20];
	char *next;
	BYTE type = TSP_SEND_FLOW_LOG;
	int ret, sizeMessag;
	int net_ai_family = htonl(logHost->ai_family); 
	next = putValue(&Messaggio, (void *) &type, sizeof(type));
	next = putValue(next, &net_ai_family, sizeof(int));
	if (logHost->ai_family == PF_INET) {
		next =
		    putValue(next,
		    (void *) &(((struct sockaddr_in *) logHost->ai_addr)->sin_addr.s_addr),
		    sizeof(in_addr_t));
		next =
		    putValue(next, (void *) &(((struct sockaddr_in *) logHost->ai_addr)->sin_port),
		    sizeof(in_port_t));
	} else if (logHost->ai_family == PF_INET6) {
		next =
		    putValue(next,
		    (void *) (((struct sockaddr_in6 *) logHost->ai_addr)->sin6_addr.s6_addr32),
		    4 * sizeof(in_addr_t));
		next =
		    putValue(next,
		    (void *) &((
		    (struct sockaddr_in6 *) logHost->ai_addr)->sin6_port),
		    sizeof(in_port_t));
		
	}
	next = putValue(next, (void *) &logProtocol, sizeof(logProtocol));
	next = putValue(next, (void *) FileName, DIM_LOG_FILE);

	sizeMessag = sizeof(type) + sizeof(int) + sizeof(in_port_t) + sizeof(BYTE) + DIM_LOG_FILE;
	if (logHost->ai_family == PF_INET)
		sizeMessag += sizeof(in_addr_t);
	else if (logHost->ai_family == PF_INET6)
		sizeMessag += 4 * sizeof(in_addr_t);

	ret = send(signalSock, (char *) &Messaggio, sizeMessag, 0);
	return (ret);
}


void recvAck(int signalSock)
{
	int i;
	char buffer;
	i = recv(signalSock, (char *) &buffer, sizeof(BYTE), 0);
}


void closedFlowErr(int flowId, int signalSock)
{
	char *next;
	BYTE type = TSP_CLOSED_ERR;
	int sizeMessag = sizeof(int) + sizeof(type);
	char Messaggio[sizeMessag];
	int net_flowId = htonl(flowId); 

	next = putValue(&Messaggio, (void *) &type, sizeof(type));
	next = putValue(next, (void *) &net_flowId, sizeof(int));
	int size;
	size = send(signalSock, (char *) &Messaggio, sizeMessag, 0);
	if (size < 0) {
		printf("error into send\n");
		memClean();
		exit(1);
	}
}


int closedFlow(int flowId, int signalSock)
{
	char *next;
	BYTE type = TSP_CLOSED_FLOW;
	int sizeMessag = sizeof(int) + sizeof(type);
	char Messaggio[sizeMessag];
	int net_flowId = htonl(flowId); 

	next = putValue(&Messaggio, (void *) &type, sizeof(type));
	next = putValue(next, (void *) &net_flowId, sizeof(int));

	if (send(signalSock, (char *) &Messaggio, sizeMessag, 0) < 0) {
		printf("Error in request to close\n");
		fflush(stdout);
		return(-1);
	}

	return (0);
}


int requestToSend(int flowId, int signalSock)
{
	PRINTD(1,"requestToSend  function\n");
	char Messaggio[100];
	char *next;
	BYTE type = 3;
	int sizeMessag;

   	struct addrinfo *DestHost = flows[flowId].DestHost;
	BYTE l4Proto = flows[flowId].l4Proto;
	BYTE l7Proto = flows[flowId].l7Proto;
	BYTE meter = flows[flowId].meter;
	
	int net_ai_family = htonl(DestHost->ai_family);
        int net_flowId = htonl(flowId);
	
	int plType = flows[flowId].payloadLogType;

 	
	
	
	

	next = putValue(&Messaggio, (void *) &type, sizeof(type));
	next = putValue(next, (void *) &l4Proto, sizeof(type));
	next = putValue(next, (void *) &l7Proto, sizeof(type));
	next = putValue(next, (void *) &meter, sizeof(type));
	next = putValue(next, (void *) &net_ai_family, sizeof(int));
	next = putValue(next, (void *) &net_flowId, sizeof(int));
	next = putValue(next, (void *) &plType, sizeof(int));
 	next = putValue(next, (void *) &flows[flowId].serialReceiver, DIM_NAME_SERIAL_INTERFACE);


	if (DestHost->ai_family == PF_INET) {
		
		next = putValue(next, (void *) &(((struct sockaddr_in *) DestHost->ai_addr)->sin_port), sizeof(in_port_t));
		
		next = putValue(next, (void *) &(((struct sockaddr_in *) DestHost->ai_addr)->sin_addr.s_addr), sizeof(in_addr_t));
	} else if (DestHost->ai_family == PF_INET6) {
		
		next = putValue(next, (void *) &(((struct sockaddr_in6 *) DestHost->ai_addr)->sin6_port), sizeof(in_port_t));
		
		next = putValue(next, (void *) (((struct sockaddr_in6 *) DestHost->ai_addr)->sin6_addr.s6_addr32), 4 * sizeof(in_addr_t));
		
		PRINTD(1, "-- ScopeID = %d --\n", ((struct sockaddr_in6 *) DestHost->ai_addr)->sin6_scope_id);
		next = putValue(next, (void *) &(((struct sockaddr_in6 *) DestHost->ai_addr)->sin6_scope_id), sizeof(uint32_t));
	}

	sizeMessag = 4 * sizeof(type) + 3 * sizeof(int) + sizeof(in_port_t) + DIM_NAME_SERIAL_INTERFACE;
	if (DestHost->ai_family == PF_INET)
		sizeMessag += sizeof(in_addr_t);
	else if (DestHost->ai_family == PF_INET6)
		sizeMessag += 4 * sizeof(in_addr_t) + sizeof(uint32_t);

	PRINTD(1,"new flow message prepared \n");

	if (send(signalSock, (char *) &Messaggio, sizeMessag, 0) < 0) {
		printf("Error in request to send\n");
		fflush(stdout);
		return(-1);
	}
	PRINTD(1,"new flow message sent \n");
	return(0);
}


bool checkDestHostIP(int * chanId, struct addrinfo * DestHost)
{
	int i = 0;

	while (i < MAX_NUM_THREAD) {
		

		if ((signalChannels[i].socket != -1)
		  && (ARE_INET_ADDR_EQUAL(DestHost, signalChannels[i].DestAddr))) {
		      signalChannels[i].flows++;
		      *chanId = i;
		      return true;
        }
		i++;
	}
	return false;
}

void argvToString(char *argv[], int argc, char line[200])
{
	int i = 0;

	strcpy(line, "^");
	while (argc > 0) {
		strcat(line, argv[i]);
		strcat(line, "^");
		argc--;
		i++;
	}
	strcat(line, "\n");
}


void flushBuffer(info *infos, int count)
{
	if (logremoto) {
		MUTEX_THREAD_LOCK(mutexLogRem);
		if(sendto(logSock, (char *) infos, count * sizeof(struct info), 0, logHost->ai_addr,
		    logHost->ai_addrlen) < 0) {
			printf("ERROR Sending infos to logger....\n");
			fflush(stdout);
		}
		MUTEX_THREAD_UNLOCK(mutexLogRem);
	} else {
		MUTEX_THREAD_LOCK(mutexLog);
		out.write((const char *) infos, count * sizeof(struct info));
		MUTEX_THREAD_UNLOCK(mutexLog);
	}
}


void memClean()
{
#ifdef WIN32
 	
 	ExitProcess(0);
#endif
}




void createRemoteLogFile(struct addrinfo *logHost, BYTE protocolLog)
{
	
	
	
	

	uint32_t port;
	

	createSignalingLogChannel(protocolLog);

	

	switch(protocolLog) {
		case L4_PROTO_UDP :
		
			logSock = socket(logHost->ai_family, SOCK_DGRAM, 0);
			if (logSock < 0)
				ReportErrorAndExit("createRemoteLogFile","socket DATAGRAM - Cannot create socket logSock", programName, 0);
			break;
		case L4_PROTO_TCP :
            
			logSock = socket(logHost->ai_family, SOCK_STREAM, 0);
			if (logSock < 0)
				ReportErrorAndExit("createRemoteLogFile","socket STREAM - Cannot create socket logSock", programName, 0);
			break;
		default :
			break;
	}
	
	if ( recv(logSockSignaling, (char *) &port, sizeof(port), 0) < 0)
		ReportErrorAndExit("createRemoteLogFile","Cannot receive on signaling socket", programName, 0);
	port = ntohl(port);
	PRINTD(1,"Port received for log : %d\n",port);


	
	SET_PORT(logHost, htons(port));
	sleep(1);
    
	if (connect(logSock, logHost->ai_addr, logHost->ai_addrlen) < 0)
		ReportErrorAndExit("createRemoteLogFile","Error into connect with logsender!", programName, 0);
}



void createSignalingLogChannel(BYTE protocolLog)
{
	
	signaling signal;
	
	char buffer[1];

	

	logSockSignaling = socket(logHost->ai_family, SOCK_STREAM, 0);
	if (logSockSignaling < 0)
		ReportErrorAndExit("createSignalingLogChannel","Cannot create socket logSockSignaling!", programName, 0);
	
	SET_PORT(logHost, htons(DEFAULT_LOG_PORT_SIGNALING));
	
	signal.protocol = protocolLog;
	
	strcpy(signal.logFile, logFile);
	
	if (connect(logSockSignaling, logHost->ai_addr, logHost->ai_addrlen) < 0)
		ReportErrorAndExit("createSignalingLogChannel","Error into connect !", programName, 0);
	
	do {
		if (recv(logSockSignaling, (char *) &buffer, sizeof(BYTE), 0) < 0)
		ReportErrorAndExit("createSignalingLogChannel","Error into receive!", programName, 0);
	
  	} while (*(BYTE *) buffer != LOG_CONNECT);
	PRINTD(1,"Log Signal Manager : Received LOG_CONNECT Message\n");

	
	if (send(logSockSignaling, (char *) &signal, sizeof(signal), 0) < 0)
		ReportErrorAndExit("createSignalingLogChannel","Cannot send infos to LogServer !", programName, 0);

	PRINTD(1,"Log Signal Manager : Sent to LogServer infos for creating signaling channel\n");
}

