/*
 *   Component of the D-ITG v2.7.0-Beta2 platform (http://www.grid.unina.it/software/ITG)
 *
 *   Copyright    : (C) 2004-2009 by Stefano Avallone, Alessio Botta, Alberto Dainotti
 *                                     Walter de Donato, Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and 
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *   email        : stavallo@unina.it , a.botta@unina.it , alberto@unina.it
 *                  walter.dedonato@unina.it , pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 		     
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *				     
 *   For commercial use please refer to D-ITG Professional.
 */



#include "ITG.h"

#ifdef LINUX_OS
struct sched_param p;
#endif


const char *meters[] = { "", "OWDM", "RTTM", " " };
const char *l4Protocols[] = { "", "TCP", "UDP", "ICMP", "SCTP", "DCCP", " " };
const char *l7Protocols[] = { "", "Telnet", "VoIP", "DNS", "AoM", "CSa", "CSi", "Quake3", " " };
char programName[100];		
char DEFAULT_LOG_IP[10] = "127.0.0.1";	

extern const int StandardMinPayloadSize = 2*sizeof(unsigned int) + 2 * sizeof(long int);
extern const int ShortMinPayloadSize = 2*sizeof(unsigned int);
extern const int NoneMinPayloadSize = sizeof(unsigned int);



USHORT checksum(USHORT * buffer, int size)
{
	unsigned long cksum = 0;

	while (size > 1) {
		cksum += *buffer++;
		size -= sizeof(USHORT);
	}

	if (size) {
		cksum += *(UCHAR *) buffer;
	}

	cksum = (cksum >> 16) + (cksum & 0xffff);
	cksum += (cksum >> 16);
	return (USHORT) (~cksum);
}

#ifdef WIN32
int InitializeWinsock(WORD wVersionRequested)
{
	WSADATA wsaData;
	int err;

	err = WSAStartup(wVersionRequested, &wsaData);

	
	
	if (err != 0)
		return 0;	

	
	
	
	

	
	
	
	
	

	
	if (LOBYTE(wsaData.wVersion) != 1 || HIBYTE(wsaData.wVersion) != 1)
		return 0;

	
	return 1;
}




void sleep(int tempo)
{
	Sleep(tempo * 1000);
}
#endif





char *putValue(void *startPos, void *data, int size)
{
	
	char *endPos;
	
	memcpy(startPos, data, size);
	
	endPos = (char *) startPos + size;
	return endPos;
}

BYTE findMeter(char *s)
{
	int i = 1;

	while (strcmp(meters[i], " "))
		if (!strcasecmp(s, (char *) meters[i]))
			return(i);
		else
			i++;
	return LX_ERROR_BYTE;
}

BYTE findL4Proto(char *s)
{
	int i = 1;
	while (strcmp(l4Protocols[i], " "))
		if (!strcasecmp(s, (char *) l4Protocols[i]))
			return(i);
		else
			i++;
	return LX_ERROR_BYTE;
}

BYTE findL7Proto(char *s)
{
	int i = 1;
	while (strcmp(l7Protocols[i], " "))
		if (!strcasecmp(s, (char *) l7Protocols[i]))
			return(i);
		else
			i++;
	return LX_ERROR_BYTE;
}

const char* invFindMeter(BYTE meter)
{
	return meters[meter];
}

const char* invFindL4Proto(BYTE proto)
{
	return l4Protocols[proto];
}

const char* invFindL7Proto(BYTE proto)
{
	return l7Protocols[proto];
}
