<?php
/* daCode _ http://www.dacode.org/
 * $Id: gen.php3,v 1.77.2.17 2002/08/11 15:11:39 pterjan Exp $
 */

	$topdir = '.';

	require $topdir."/dacode.php3";

//	// Load the Html class
//	$html = LoadClass('Html');

	// If the site is not accessible yet, display a waiting page.
	if ($config->nodb == 1) {
		$title = $config->titledefault;
		$text = lecho("Sorry but the site is currently down for maintenance.<br />\n").
			lecho("Thank you to come back in a few minutes!");
		$template = 'basic.tmpl';
		$nobanner = false;
		// Load the Html class
		$html = LoadClass('Html');
		$html->parsetemplate($template);
		exit;
	}

	//  Variable used in this file
	$utils = LoadClass('Utils');
	$cache = LoadClass('Cache');

	// Remove cache directory from $HTTP_SERVER_VARS['PATH_INFO']
	if (!ereg('\?$', $config->newsfile)) {
		if (isset($HTTP_SERVER_VARS['PATH_INFO'])) {
			$path = ereg_replace('^/'.$config->htmldir, '/',
				$HTTP_SERVER_VARS['PATH_INFO']);
		} else {
			$path = '/';
		}
	} else {
		if (!empty($HTTP_SERVER_VARS['QUERY_STRING']) &&
			preg_match('/\//', $HTTP_SERVER_VARS['QUERY_STRING'])){
			$path = ereg_replace('^/'.$config->htmldir.'(.*)&.*', '/\\1',
				$HTTP_SERVER_VARS['QUERY_STRING']);
		} else {
			$path = '/';
		}
	}
	if (ereg('^(.*)\.(html|'.$config->php.')', $path, $res)) {
		$path = $res[1];
		$config->ext = '.'.$res[2];
	}


	// Adjust theme
	$config->score = $session->score;
	$config->hide_sig = $session->hide_sig;
	$config->userboxes = $session->has_user_boxes;

	if (ereg('^([^,]*)(,.+)$', $path, $res)) {
		$path = $res[1];

		$opts = explode(',', $res[2]);
		$nbopts = count($opts);
		if ($nbopts >= 5) {
			$config->hide_sig  = $opts[1];
			$config->score     = $opts[2];
			$config->theme 	   = $opts[3];
			$config->userboxes = $opts[4];
		} elseif ($nbopts == 4) {
			$config->hide_sig  = $opts[1];
			$config->score     = $opts[2];
			$config->theme     = $opts[3];
		} elseif ($nbopts == 3) {
			$config->score     = $opts[1];
			$config->theme     = $opts[2];
		}

		// $config->theme = $opts[$nbopts-1];
		$config->theme_name = $config->listofthemes[$config->theme];
		//  Make sure this theme is valid
		if (empty($config->theme_name)) {
			$config->theme = $config->dft_prefs['theme'];
			$config->theme_name=$config->listofthemes[$config->theme];
		}
		$config->ext = ','.$config->theme.",".$config->userboxes.$config->ext;

	}
	// Load the Html class
	$html = LoadClass('Html');

	// and prepends cache directory to $file. This oddity is because
	// requests may have this cache directory prepended or not.
	$file = $config->htmldir . substr($path, 1);

	if(!empty($config->baselink))
		$path = ereg_replace('^/'.$config->baselink,'/',$path);

	//   Initialize variables
	$section = $topic = $news_id = $date = $title = $template = '';

	$view = 1;
	if (ereg('^/section/([^/]+)$', $path, $res)) {
		$section  = urldecode($res[1]);
		$title    = $section;
		$view     = 0;
		$template = 'newsindex.tmpl';
	} elseif (ereg('^/topic/([^/]+)$', $path, $res)) {
		$topic    = urldecode($res[1]);
		$title    = $topic;
		$view     = 0;
		$template = 'newsindex.tmpl';
	} elseif (ereg('^/([0-9]+/[0-9]+/[0-9]+)/([0-9]+)$', $path, $res)) {
		$news_id  = $res[2];
		$template = 'news.tmpl';
	} elseif (ereg('^/section/([^/]+)/([0-9]+)$', $path, $res)) {
		$section  = urldecode($res[1]);
		$news_id  = $res[2];
		$template = 'news.tmpl';
	} elseif (ereg('^/topic/([^/]+)/([0-9]+)$', $path, $res)) {
		$topic    = urldecode($res[1]);
		$news_id  = $res[2];
		$template = 'news.tmpl';
	} elseif (ereg('^/([0-9]+)/([0-9]+)/([0-9]+)/index$', $path, $res)) {
		$date     = $res[1] . $res[2] . $res[3];
		$pageday  = $res[3];
		$pagemonth= $res[2];
		$pageyear = $res[1];

		$title    = $config->titledefault .': '.$utils->stamp2date($date,"short");
		$template = 'newsindex.tmpl';
	} elseif ($path == '/index' || $path == '/') {
		$file     = $config->htmldir.'index';
		$title    = $config->titledefault;
		$template = 'newsindex.tmpl';
	} else {
		$title    = lecho("Error 404");
		$text     = lecho("Error 404.<br />It seems that this page doesn't exist.<br />If you come here after clicking on an URI, please mail ").
			'<a href="mailto:'.$config->mailadmin.'">'.$config->mailadmin.'</a>'.
			lecho(" or go back to ").'<a href="'.$config->basehref.'">'.
			$config->baseurl.'</a><br /><br />';
		$template = 'basic.tmpl';
		$nobanner = false;
		$html->parsetemplate($template);
		exit;
	}
	$config->extraopts = ','.$config->hide_sig.','.$config->score;
	$file .= $config->extraopts;

	if (!$date) {
		$pageday   = date("d");
		$pagemonth = date("n");
		$pageyear  = date("Y");
	}

	//   Check whether file already exists
	if (isset($config->htmldir) && $config->htmldir != "") {
		$temp = ereg_replace('^'.$config->htmldir,'', $file.$config->ext);
		$cache->check_html($temp);
	}

	//  Declare all variables found in above template files
	$news = LoadClass('News');
	if(!empty($news_id)&&!($news->is_approved($news_id))){
		$title = lecho("This news doesn't exist.");	
		$text = lecho("This news doesn't exist.").'<br />'.
		lecho("Please go back to").' <a href="'.$config->basehref.'">'.
		$config->baseurl.'</a><br /><br />';
		$nobanner = false;
		$template = 'basic.tmpl';
		$html->parsetemplate($template);
		exit;
	}
	$comments = LoadClass('Comments');
	$user = LoadClass('User');
	if ($config->ldap_hostname) {
		$ldap  = LoadClass('Ldap');
	}
	$sidebox = LoadClass('Sidebox');
	$hits = LoadClass('Hits');
	$admin = LoadClass('Admin');
	$board = LoadClass('Board');
	$message = LoadClass('Message');
	$poll = LoadClass('Poll');
	$webcam = LoadClass('Webcam');
	$backends = LoadClass('Backends');
	$fortune  = LoadClass('Fortunes');
	$cal  = LoadClass('Cal');
	$tips = LoadClass('Tips');

	$text = $html->parsetemplate($template);

	//  And write text to file
	$cache->write_html($file.$config->ext,$text);
?>
