<?php
/**
 * Class to handle tips.
 *
 * http://www.dacode.org
 * daCode http://www.dacode.org/
 * $Id: tips.php3,v 1.38.2.15 2002/08/04 20:40:48 ruffy Exp $
 *
 * Depends: Config Db Html User
 */
Class Tips {

	/**
	 * Database abstraction layer
	 *@var object Db
	 */
	var $db;

	/**
	 * HTML rendering package
	 *@var object Html
	 */
	var $html;

	/**
	 * Session handling instance
	 *@var object Session
	 */
	var $session;

	/**
	 * Cache abstraction layer
	 *@var object Cache
	 */
	var  $cache;

	/**
	 * Utils package
	 *@var object Utils
	 */
	var $utils;

	/**
	 * Cache for optimizing multiple requests
	 *@var array $sqlCache
	 */
	var $sqlCache;


	/**
	 * Boolean to indicate wether smg is in sqlCache
	 *@var bool $isCached
	 */
	var $isCached;

	/**
	 *@var integer resType
	 */
	var $resType = 2;

	/**
	 * Constructor
	 */
	Function Tips() {
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->html = LoadClass('Html');
		$this->cache = LoadClass('Cache');
		$this->utils = LoadClass('Utils');
		$this->user = LoadClass('User');
	}

	/**
	 * Checks wether the item selected is "commentable"
	 *@param int $tip_id the ID of the item
	 *@return mixed a string (an error message) if the item is not to be commented, NULL otherwise.
	 *@access public
	 */
	Function checkResource($tip_id) {

		//Shall first determine if resource exists
		$this->loadResources(array($tip_id));
		if (isset($this->sqlCache[$tip_id])) {
			return;
		} else {
			//Resource not found...
			return "404: file not found";
		}

		//Next shall control if user allowed to view
		//Last shall control if open to comments

	}

	/**
	 * Preview the item selected.
	 *@param int $tips_id ID of the tip to display
	 *@return string the HTML for the item
	 *@access public
	 */
	Function viewResource($tips_id) {
		global $config;

		if (!ereg("^[0-9]+$",$tips_id)) {
			return;
		}

		$this->utils->debug("Tips:".__LINE__." viewRessource: start; res_id=".$tips_id.";\n");
		$cachetmp = array($this->session->checked,$config->ext,$tips_id,
			$this->session->is_moderator||$this->session->is_admin);

		//Check if it's in the disk cache
		$fcontents = $this->cache->check_box("0","tips", $cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		if ($r = $this->checkResource($tips_id)) {
			//We got an error message...
			die ($r);
		} else {
			//We have to fetch supplementary info.
			$author_id = $this->sqlCache[$tips_id]['user_id'];
			$sqlc_q = "SELECT login, fname, lname FROM " .
				 $config->tables['users'] . 
				 " WHERE id = $author_id";
			
			//echo $sqlc_q;
			$ret = $this->db->query($sqlc_q);
			if (!$ret ) {
				echo "<!--SQL failed: ".$this->db->error()." $sqlc_q-->\n";
				if (!$ret) return;
			}
			
			$row = $this->db->fetch_array();
			$this->db->free();
			
			$this->sqlCache['tip'] = $this->utils->url_conv($this->sqlCache[$tips_id]['tip']);

			$tmp = "<center><b>" . 
				 $this->sqlCache[$tips_id]['tip_section'] . 
				 " - " . $this->sqlCache[$tips_id]['name'] .
				 "</b></center><br />\n" . 
				 $this->sqlCache[$tips_id]['tip'] . 
				 "<br /><br />-- ";
			if (!empty($row['fname']) || !empty($row['lname'])) {
				$tmp .= htmlentities($row['fname'].' '.$row['lname']);
			} else {
				$tmp .= htmlentities($row['login']);
			}
			//We need to call the comment class
			$comment = LoadClass('Comments');
			$tmp .= '<center><a href="'.$config->basehref.'/'.
				 $config->tipsViewFile.
				 '?tip_id='.$tips_id.'"> '. 
				 $comment->numberOfComments($this->sqlCache[$tips_id]['id'], $config->resTypes['Tips']) . 
				 "</a></center>";
			$title = '<!-- TIPTITLE:'.$tips_id.
				 ' --><a href="'.$config->basehref.
				 'tips/" class="boxheader">'.lecho("Tip").'</a>';
			// Administrators have a got link to edit this tip.
			if ($this->session->is_moderator ||
			$this->session->is_admin) {
				$title .= ' - <a href="'.$config->basehref.'tips/'.
					 $config->tipsadminfile.'?tip_id='.$tips_id.
					 '" class="boxheader">'.lecho("Edit!").'</a>';
			}
			$title .= "<!-- /TIPTITLE -->\n";


			$tmp = $this->html->sidebox($title,$tmp);
			$this->cache->write_box("tips",$cachetmp,$tmp);
			return $tmp;
		}
	}

	/**
	 * Returns the URL where the tip && comments can be found
	 *@param integer $tip_id the ID of tip viewed
	 *@param integer $absolute URL is absolute or not.
	 *@param integer $score the threshold for displaying comments
	 *@param mixed $order TODO
	 *@param integer $theme TODO
	 *@return string the URL where to view it. Not HTML-escaped!
	 *@access public
	 */
	Function getTopicUrl($tip_id, $absolute=1, $score=-2, $order="", $theme=0) {
		global $config;

		if ($absolute) {
			$href = $config->baseurl;
		} else {
			$href = $config->basehref;
		}
		if ($score == -2) {
			$score = $config->score;
			$scoreUrl = "/" . $score ;
		} else {
			$scoreUrl = "/" . $score;
		}
		return $href."/".$config->tipsViewFile."/".$tip_id.$scoreUrl;
	}

	/**
	 * Abreviated view of the resource (eg the title)
	 *@param integer $res_id the id of the item
	 *@return string the short view, HTML-escaped.
	 */
	Function viewShort($res_id) {
		if (!$this->isCached || empty($this->sqlCache[$res_id]) ) {
			//Got a pb. We do a DB query
			$this->loadResources(array($res_id));
		}
		return '(' . lecho("Tip") . ')' . ' ' . $this->sqlCache[$res_id]['ts'] .
			' : ' . $this->sqlCache[$res_id]['name'] ;

	}
	/**
	 * Preloads some infos about the resources. For optimizatiuon only.
	 * FIXME: maybe other stuff neede here...
	 * Implementation details: shall cache as much info as needed.
	 * Everything needed to produced a 'short view' shall be cached,
	 * plus ids, timpstamps & that kind of stuff.
	 *@param array $res_ids the list of IDs of the resouces to preload
	 *@return bool true if SQL succeeded, false otherwise.
	 *@access public
	 */
	Function loadResources($res_ids) {
		global $config;

		//Check wether the resources are already in cache
		reset($res_ids);
		while(list(,$id) = each ($res_ids)) {
			if (!isset($this->sqlCache[$id])) {
				//Not in cache, we'll fetch it
				$ids[] = $id;
			} //Else we forget it.
		}
		if (empty($ids)) {
			//Nothing to do...
			return true;
		}

		//trying to simplify the writing of the query.
		//$t is tablez tips
		//$ts is table tips_section
		$t = $config->tables['tips'];
		$ts =$config->tables['tips_sections'];
		$sql_q = "SELECT $t.id as tid, " .
			 "$t.tip_section_id as section_id, " . 
			 "$t.tip as tip,".
			 "$t.name as name, ".
			 "$t.timestamp as timestamp, ". 
			 "$t.user_id as user_id, " .
			 "$ts.tip_section as tip_section, " . 
			 "$ts.id" .
			" FROM $t, $ts " .
			"WHERE $t.id IN (" . join(',', $ids) .
			") AND $t.tip_section_id = $ts.id";

		$ret = $this->db->query($sql_q);
		if (!$ret) {
			echo "<!-- Tips::loadResources error! SQL was: \n$sql_q\n" .
				"and MySql answered: " . $this->db->error();
			return false;
		}

		while ($row = $this->db->fetch_array() ) {
			$this->sqlCache[$row['tid']] = $row;
		}

		$this->isCached = 1;
		$this->db->free();
		return true;

	}
	
	/**
	 * Select a random tip
	 *@return string the sidebox with the selected tip.
	 *@access public
	 */
	Function get_random() {
		global $config;

		$cachetmp = array ($this->session->checked,$config->ext,
			$this->session->is_moderator||$this->session->is_admin,$config->depth);

		$fcontents = $this->cache->check_box("300","tips", $cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$sqlc_q = "SELECT id FROM ".$config->tables['tips'].
			" WHERE state='1'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Tips:".__LINE__." get_random: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			return;
		}

		$nb = $this->db->num_rows();
		$this->utils->debug("Tips:".__LINE__." get_random: NB rows: |$nb|\n");
		if ($nb == 0) {
			$tmp = "<center>".lecho("No tips yet")."</center>";
			$title = lecho("Tip");
			$tmp = $this->html->sidebox($title,$tmp);
			$this->cache->write_box("tips",$cachetmp,$tmp);
			return $tmp;
		} else {
			if ($nb >= 2) {
				$number = mt_rand(0,($nb - 1));
			} else {
				$number = 0;
			}
		}
		$this->utils->debug("Tips:".__LINE__." get_random: Row number: |$number|\n");
		for ($i=0; $i<=$number; $i++){
			$row = $this->db->fetch_array();
			if (!$row) {
				$this->utils->debug("Tips:".__LINE__." get_random: ".
					lecho("SQL Failed: ").$this->db->error().
					" SQL: ".$sqlc_q."\n");
			}
		}
		$this->utils->debug_dump($row);
		$this->db->free();
		return $this->viewResource($row['id']);
	}

	/**
	 * Creates o list of tips on 2 columns
	 *@param integer number of tips to display
	 *@param string ID of tips section (an integer)
	 *@param integer offset of start of tip list
	 *@return string the list of tips
	 *@access public
	 */
	Function tips_list($nb_tips,$tip_section,$tip_index) {
		global $config;

		$sqlc_q = "SELECT count(*) AS nb FROM ".$config->tables['tips'].
			" WHERE state='1'";
		if ($tip_section<>"") {
			$sqlc_q .= " AND ".$config->tables['tips'].".tip_section_id='".
				addslashes($tip_section)."'";
		}
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()."-->\n";
			return;
		}
		$row = $this->db->fetch_array();
		$this->db->free();

		$i=0;
		if ($row['nb'] == 0) {
			$tmp = "<center>".lecho("No tips yet")."</center>";
			$title = lecho("Tip");
		} else {

			$nb_tips_total = $row['nb'];

			$sqlc_q = "SELECT ".
				$config->tables['tips'].".tip,".
				$config->tables['tips'].".name,".
				$config->tables['users'].".login,".
				$config->tables['users'].".fname,".
				$config->tables['users'].".lname,".
				$config->tables['tips_sections'].".tip_section,".
				$config->tables['tips'].".id AS id".
				" FROM ".$config->tables['tips'].",".
				$config->tables['users'].",".
				$config->tables['tips_sections'] . " WHERE ".
				$config->tables['tips'].".user_id=".
				$config->tables['users'].".id AND ".
				$config->tables['tips'].".tip_section_id=".
				$config->tables['tips_sections'].".id AND ";

			if ($tip_section<>"") {
				$sqlc_q .= $config->tables['tips'].".tip_section_id=".
					addslashes($tip_section)." AND ";
			}

			$sqlc_q .= $config->tables['tips'].".state='1' ".
				"ORDER BY ".$config->tables['tips'].".timestamp DESC ";

			if ($tip_index<>"") {
				$sqlc_q .= $this->db->compat_limit($nb_tips,$tip_index);
			} else {
				$sqlc_q .= $this->db->compat_limit($nb_tips,0);
			}

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: ".$this->db->error()."-->\n";
				return;
			}

			$page = "<table width=\"100%\">\n";
			while($row=$this->db->fetch_array()) {
				$i++;

				$row['tip'] = $this->utils->url_conv($row['tip']);

				$tmp = "<b><center>" . htmlentities($row['name']).
					"</center></b><br />".htmlentities($row['tip']).
					"<br /><br /><center> (";

				if (!empty($row['fname']) || !empty($row['lname'])) {
					$tmp .= htmlentities($row['fname'])." ".htmlentities($row['lname']);
				} else {
					$tmp .= htmlentities($row['login']);
				}

				$tmp .= ") <br />\n";

				$title = htmlentities($row['tip_section']);

				if ($this->session->checked &&
						($this->session->is_admin ||
						$this->session->is_moderator)) {
					$title .= " - <a href=\"".$config->basehref.
						"tips/".$config->tipsadminfile.
						"?tip_id=".$row['id']."\" class=\"boxheader\">".lecho("Edit!").
						"</a>\n";
				}
				$comments = LoadClass('Comments');
				$tmp .= '<a href="'.$config->basehref.'/'.$config->tipsViewFile.
					'?tip_id='.$row['id'].'">'. 
					 $comments->numberOfComments($row['id'],  
					 $config->resTypes['Tips']) . '</a>';
				$tmp .= "</center>\n";

				$i % 2 ?
					$page .= "<tr><td valign=\"top\" width=\"50%\">".
					$this->html->sidebox($title,$tmp)."</td>" :
					$page .= "<td valign=\"top\" width=\"50%\">".
					$this->html->sidebox($title,$tmp)."</td></tr>";
			}
			$this->db->free();
		}
		if ( $i != 0 ) {
			$i % 2 ? $page .= "</tr></table>\n" : $page .= "</table>\n";
		}
		$url_section='';
		if ($tip_section<>"") {
			$url_section = "tip_section=$tip_section&amp;";
		}

		$prev = $next = "";
		if ($tip_index >= $nb_tips) {
			$prev = "<a href=\"index.".$config->php."?".$url_section."tip_index=";
			$prev .= $tip_index-$nb_tips;
			$prev .= "\"> &lt;&lt; ".lecho("Previous Tips")."</a>";
		}
		if ($tip_index+$nb_tips <= $nb_tips_total) {
			$next = "<a href=\"index.".$config->php."?".$url_section."tip_index=";
			$next .= $tip_index+$nb_tips;
			$next .= "\">".lecho("Next Tips")." &gt;&gt; </a>";
		}

		$page .= "<table width=\"100%\"><tr><td class=\"newstext\" ".
			"width=\"50%\" align=\"left\">". $prev .
			"</td><td class=\"rightnewstext\" width=\"50%\" ".
			"align=\"right\">". $next ."</td></tr></table>";

		return $page;
	}

	/**
	 * Creates HTML code for the list of tips to moderate
	 *@return string HTML code
	 *@access public
	 */
	Function tips_to_moderate() {
		global $config;
		$tmp = "";

		if (!$this->session->checked || !$this->session->is_admin &&
			!$this->session->is_moderator) {
			return;
		}

		$sqlc_q = "SELECT ".
			$config->tables['tips'].".id AS id,".
			$config->tables['tips'].".tip,".
			$config->tables['tips'].".name,".
			$config->tables['tips_sections'].".tip_section".
			" FROM ".$config->tables['tips'].",".
			$config->tables['tips_sections'] . " WHERE ".
			$config->tables['tips'].".tip_section_id=".
			$config->tables['tips_sections'].".id AND ".
			$config->tables['tips'].".state='0'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return lecho("Tips: SQL Error!")."<br />\n";
		}

		while($row=$this->db->fetch_array()) {
			$row['id'] = htmlentities(stripslashes($row['id']));
			$row['name'] = htmlentities(stripslashes($row['name']));
			$row['tip'] = htmlentities(stripslashes($row['tip']));

			$tmp .= "&nbsp;-&nbsp;[".lecho("Tip")."]&nbsp;".$row['tip_section'].
				"-<a href=\"". $config->basehref."tips/".$config->tipsadminfile.
				"?tip_id=".$row['id']."\">".$row['name']."</a><br />\n";

		}

		$this->db->free();

		return $tmp;
	}

	/**
	 * Creates the moderation form for a tip
	 *@param integer ID of the tip
	 *@return string the HTML code
	 *@access public
	 */
	Function show_tips_to_moderate($id) {
		global $config;

		if (!ereg("^[0-9]+$",$id)) {
			return;
		}

		if (!$this->session->checked || !$this->session->is_admin &&
			!$this->session->is_moderator) {
			return;
		}

		$tmp = "";
		$sqlc_q = "SELECT ".
			$config->tables['tips'].".tip,".
			$config->tables['tips'].".name,".
			$config->tables['users'].".login,".
			$config->tables['users'].".fname,".
			$config->tables['users'].".lname,".
			$config->tables['tips_sections'].".tip_section,".
			$config->tables['tips'].".id AS id".
			" FROM ".$config->tables['tips'].",".
			$config->tables['users'].",".
			$config->tables['tips_sections'] . " WHERE ".
			$config->tables['tips'].".user_id=".
			$config->tables['users'].".id AND ".
			$config->tables['tips'].".tip_section_id=".
			$config->tables['tips_sections'].".id AND ".
			$config->tables['tips'].".id='".
			addslashes($id)."'";

		$ret=$this->db->query($sqlc_q);
		if(!$ret) {
			return lecho("Tips: SQL Request Failed: ")."\n".$sqlc_q."\n";
		}

		$row=$this->db->fetch_array();

		$tmp .= "<form action=\"".$config->basehref."tips/".
			$config->tipschangefile."\" method=\"post\">";

		$tmp .= "<b><center>\n<select name=\"table[tip_section]\">\n";
		$sqlc_q = "SELECT id,tip_section FROM ". $config->tables['tips_sections'].
			" ORDER BY tip_section";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return lecho("Tips: SQL Request Failed: ")."\n".$sqlc_q."\n";
		}

		while($sectionrow=$this->db->fetch_array()) {
			if ($sectionrow['tip_section'] == $row['tip_section'] ) {
				$tmp .= "<option value=\"".$sectionrow['id'].
					"\" selected=\"selected\">".
					$sectionrow['tip_section']."</option>\n";
			} else {
				$tmp .= "<option value=\"".$sectionrow['id']."\">".
					$sectionrow['tip_section']."</option>\n";
			}
		}

		$tmp .= "</select>\n - <input type=\"text\" name=\"table[name]\" ".
			"value=\"".htmlentities(stripslashes($row['name']));
		$tmp .= "\" /></b><br />";
		$tmp .= "<textarea name=\"table[tip]\" rows=\"10\" cols=\"50\">" .
			htmlentities(stripslashes($row['tip'])) . "</textarea><br />\n (";

		if (!empty($row['fname']) || !empty($row['lname'])) {
			$tmp .= htmlentities($row['fname']) . " " . htmlentities($row['lname']);
		} else {
			$tmp .= htmlentities($row['login']);
		}

		$tmp .= ")<br /><br />\n";

		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"".
			$row['id']."\" />".
			"<input type=\"submit\" value=\"".lecho("Confirm").
			"\" name=\"table[submit]\" />".
			"<input type=\"reset\" value=\"".lecho("Erase").
			"\" name=\"table[submit]\" />".
			"</form></center>";

		$title = lecho("Moderate a tip");
		return $this->html->sidebox($title,$tmp);
	}

	/**
	 * Take moderator's choices into account
	 * May call echo on failure, may return a string on failure
	 *@param array values????
	 *@access public
	 */
	Function do_moderate($row) {
		global $config;

		if (!$this->session->checked || !$this->session->is_moderator &&
			!$this->session->is_admin) {
			return;
		}

		if ($row['submit'] == lecho("Confirm")) {
			$sqlc_q = "UPDATE ". $config->tables['tips']." SET ".
				"state='1',".
				"name='".addslashes($row['name'])."',".
				"tip='".addslashes($row['tip'])."',".
				"tip_section_id='".addslashes($row['tip_section'])."' WHERE ".
				"id='".addslashes($row['id'])."'";
		} elseif ($row['submit'] == lecho("Erase")) {
			$sqlc_q = "DELETE FROM ". $config->tables['tips']." WHERE id='".
				addslashes($row['id'])."'";
		} else {
			return;
		}

		$ret=$this->db->query($sqlc_q);
		if(!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()."-->\n";
			return lecho("Tips: SQL Request Failed: ")."\n".$sqlc_q."\n";
		}

		$this->cache->delete_boxfiles('tips',0,0,0,'.');
		$this->cache->delete_boxfiles('tips_sections',0,0,0,'.');

		return;
	}

	/**
	 * Creates the list of of tips sections
	 *@return string
	 *@access public
	 */
	Function tips_sections() {
		global $config;

		$fcontents = $this->cache->check_box("300","tips_sections", $config->ext);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = "";
		$sqlc_q = "SELECT id,tip_section FROM ". $config->tables['tips_sections'].
			" ORDER BY tip_section";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL Failed: ".$this->db->error()."-->";
			return;
		}

		while($row=$this->db->fetch_array()) {
			$out .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				"tips/index.".$config->php."?tip_section=" .
				$row['id'] . "\">" . $row['tip_section'] . "</a><br />";
		}
		$title = "<a href=\"".$config->basehref."tips/\" class=\"boxheader\">".
		lecho("Tip")."</a>";

		$out = $this->html->sidebox($title,$out);
		$this->cache->write_box("tips_sections",$config->ext,$out);
		return $out;
	}

	/**
	 * Creates the form to submit a new tip
	 *@retrun string 
	 *@access public
	 */
	Function formNewTip() {
		global $config;

		$sqlc_q = 'SELECT id,tip_section FROM '.$config->tables['tips_sections'].
			' ORDER BY tip_section';
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return $this->db->error();
		}
		if ($this->db->num_rows() == 0) {
			$tmp = lecho("No tip section available");
		} else {
			$tmp = '<form method="post" action="'.$config->basehref.'tips/submit.'.
				$config->php.'">'.lecho("Tip's section:");
			$tmp .= '<select name="tip_section_id">';
			while($sections = $this->db->fetch_array()) {
				$tmp .= '<option value="'.$sections[0].'">'.$sections[1].'</option>';
			}
			$this->db->free();
			$tmp .= '</select><br />';

			$tmp .= lecho("Tip's subject:").'<input type="text" size="45" '.
				'name="name" value=""><br /><textarea name="tip" rows="10" cols="50">'.
				lecho("Place your tip here.").'</textarea><br /><input type="submit" '.
				'name="submit" value="'.lecho("Submit").'"></form>';
		}

		return $tmp;
	}

	/**
	 * Add a new tip in DB
	 * calls exit and echo on failure
	 * calls header ot redirect to main page and exits on success
	 *@param array coming from form submission
	 *@access public
	 */
	Function addNewTip($row) {
		global $config;

		$sqlc_q = "INSERT INTO ".$config->tables['tips'].
			" (user_id,name,tip,tip_section_id) VALUES ('".
			addslashes($this->user->user_id)."','".
			addslashes($row['name'])."','".
			addslashes($row['tip'])."','".
			addslashes($row['tip_section_id'])."')";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo '<!-- '.lecho("SQL Failed: ").$this->db->error()."-->\n";
			echo '<!-- '.lecho("SQL command was: ").$sqlc_q." -->\n";
			exit;
		}

		header("Location: ".$config->basehref);
		exit;
	}

}

?>
