<?php
/**
 * Will contain all usefull functions that don't fit somewhere else
 *
 * daCode http://www.dacode.org/
 * src/phplib/utils.php3
 * $Id: utils.php3,v 1.119.2.28 2002/10/23 17:18:24 ruffy Exp $
 */
Class Utils {

	/**
	 * Database abstraction layer
	 *@var object Db
	 */
	var $db;

	/**
	 * Constructor. Loads class DB and launches ip_start().
	 */
	Function Utils() { 
		//echo "here"; flush();
		$this->db = LoadClass('Db'); //echo "loadsed"; flush();
		$this->ip_start();
	}

	/**
	 * We set up the right REMOTE_ADDR and right HTTP_HOST
	 *@access private
	 */
	Function ip_start() {
		global $config;
		global $HTTP_SERVER_VARS;

		/*  Looks like we have a proxy. We try to get the real client IP.
		 *  We don't pay any attention to internal network IP as we don't
		 *  care. We want to real Internet IP of the remote client.
		 */
		if (!empty($HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR']) && 
				$HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'] != "unknown") {
			$ip_tmp = array();
			$ip_tmp = split(",",$HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR']);

			while ($cur = current($ip_tmp)) {
				// We remove the space added by split().
				$cur = ereg_replace("^ ", "", $cur);
				/*
				 *  We use substr to not use ereg which is apparently
				 *  slower
				 */
				if (substr($cur,0,8) == "192.168." ||
					substr($cur,0,3) == "10." ||
					$cur == "unknown") {
					next($ip_tmp);
					continue;
				}

				// We remove 172.16/12
				for ($i=16;$i<=31;$i++) {
					if (substr($cur,0,7) == "172.$i.") {
						next($ip_tmp);
						continue 2;
					}
				}

				$config->REMOTE_ADDR = $cur;

				next($ip_tmp);
			}

			if (empty($config->REMOTE_ADDR)) {
				$config->REMOTE_ADDR = isset($HTTP_SERVER_VARS['REMOTE_ADDR'])?
					$HTTP_SERVER_VARS['REMOTE_ADDR']:'';
			}

		} else {

			$config->REMOTE_ADDR = isset($HTTP_SERVER_VARS['REMOTE_ADDR'])?
				$HTTP_SERVER_VARS['REMOTE_ADDR']:'';;

		}

		if (!empty($HTTP_X_HOST)) {
			$config->HTTP_HOST = isset($HTTP_SERVER_VARS['HTTP_X_HOST'])?
				$HTTP_SERVER_VARS['HTTP_X_HOST']:'';
		} else {
			$config->HTTP_HOST = isset($HTTP_SERVER_VARS['HTTP_HOST'])?
				$HTTP_SERVER_VARS['HTTP_HOST']:'';
		}

	}

	/**
	 * 
	 * Return IP of the $HTTP_SERVER_VARS['REMOTE_ADDR'] or 
	 * $HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'] if it exists
	 *@param integer $i if 0, converts the decimal IP into hexadecimal one
	 *@return string the IP in decimal.
	 *@access public
	 */
	Function ip($i=0) {
		global $config;
		$ip=$config->REMOTE_ADDR;
		if ($i==1) {
			return $ip;
		} else {
			if ($ip == '') {
				return '00000000';
			} else {
				$i=explode(".",$ip);
				return sprintf("%02x%02x%02x%02x",$i[0],$i[1],$i[2],$i[3]);
			}
		}
	}

	/**
	 * Convert hexadecimal IP into decimal IP
	 *@param int $ip IP in hexadecimal 
	 *@return string IP in decimal type (XXX.XXX.XXX.XXX)
	 *@access public
	 */
	Function convertip($ip) {
		preg_match('/^(.{2})(.{2})(.{2})(.{2})$/',$ip,$a);
		$newip = hexdec($a[1]).".".hexdec($a[2]).".".hexdec($a[3]).".".hexdec($a[4]);
		return $newip;
	}


	/**
	 * Function which takes a timestamp(14) as input and returns a Unix timestamp
	 * timestamp(14): "20010806110649"
	 * Unix timestamp: 997088809
	 *@param string $t value in the SQL type timestamp(14)
	 *@return integer the Unix timestamp corresponding (maybe a string?)
	 *@access private
	 */
	Function timestamp14_to_unix_stamp ($t) {
		return $timestamp = mktime(substr($t,8,2),substr($t,10,2),substr($t,12,2),
			substr($t,4,2),substr($t,6,2),substr($t,0,4));
	}

	/**
	 * Function which takes a Unix timestamp as input and returns a timestamp(14)
	 * Unix timestamp: 997088809
	 * timestamp(14): "20010806110649"
	 *@param integer $t the Unix timestamp
	 *@return string the same converted to SQL type timestamp(14)
	 *@access private
	 */
	Function unix_stamp_to_timestamp14($t) {
		$date = getdate( $t);
		$yea = $date['year'];
		$mon = $date['mon'];
		if ($mon < 10) {
			$mon = "0$mon";
		}
		$mday = $date['mday'];
		if ($mday < 10) {
			$mday = "0$mday";
		}
		$hrs = $date['hours'];
		if ($hrs < 10) {
			$hrs = "0$hrs";
		}
		$min = $date['minutes'];
		if ($min < 10) {
			$min = "0$min";
		}
		$sec = $date['seconds'];
		if ($sec < 10) {
			$sec = "0$sec";
		}
		return "$yea$mon$mday$hrs$min$sec";
	}

	/**
	 * Converts a SQL timestamp into an array (YYYY, MM, DD)
	 * Input: timestamp(14)
	 * Output: array( YYYY, MM, DD)
	 *@param string $t the SQL timestamp(14)
	 *@return array (Year, Month, Day)
	 *@access public
	 */
	Function stamp2array( $t) {
		ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $t, $regs);
		return $regs;
	}

	/**
	 *Converts a SQL timestamp into YYYY-MM-DD hh:mm:ss
	 * Input: timestamp(14)
	 * Output: YYYY-MM-DD hh:mm:ss
	 *@param string $t the SQL timestamp(14)
	 *@return string the formatted date YYYY-MM-DD hh:mm:ss
	 *@access public
	 */
	Function stamp2datetime( $t) {
		global $config;
		if(isset($config->TZ)&&$config->TZ){
			$timestamp = $this->timestamp14_to_unix_stamp($t);
			$timestamp += $config->TZ * 3600;
			$t = $this->unix_stamp_to_timestamp14($timestamp);
		} 
		return ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})', 
		                    '\1-\2-\3 \4:\5:\6', $t);
	}

	/**
	 * Function which takes a timestamp as input and returns the date
	 * Thanks to mose mose@mose.com
	 * type=0 $t timestamp 14
	 * type=1 $t UNIX timestamp
	 * type=2 $t unused
	 *@param string $t the timestamp
	 *@param string $mode the output format.
	 *@param integer $type the type of the timestamp
	 *@return string the formated date.
	 *@access public
	 */
	Function stamp2date ($t, $mode, $type=0) {
		global $LANG, $config;
		if ($type == 0) {
			$timestamp = $this->timestamp14_to_unix_stamp($t);
		} elseif ($type == 1) {
			$timestamp = $t;
		} elseif ($type == 2) {
			$timestamp = time();
		}

		if(isset($config->TZ)&&$config->TZ){
			$timestamp += $config->TZ * 3600;
		}

		$dval   = date("w",$timestamp);
		$mval   = (int) date("m",$timestamp);
		$nval   = date("d",$timestamp);
		$Yval   = date("Y",$timestamp);
		$hval   = date("h",$timestamp);
		$Hval   = date("H",$timestamp);
		$Aval   = date("A",$timestamp);
		$ival   = date("i",$timestamp);

		$day = array(lecho("sunday"),lecho("monday"),lecho("tuesday"),
				lecho("wednesday"),lecho("thursday"),lecho("friday"),
				lecho("saturday"));

		$month = array('',lecho("january"),lecho("february"),
				lecho("march"),lecho("april"),lecho("may"),lecho("june"),
				lecho("july"),lecho("august"), lecho("september"),
				lecho("october"),lecho("november"),lecho("december"));

		switch ($mode) {
		case "long":
			if ($LANG=="fr") {
				$out = ucfirst($day[$dval]). " $nval ".
					ucfirst($month[$mval]) . "  $Hval:$ival";
			} else {
				$out = ucfirst($day[$dval]). " ".
					ucfirst($month[$mval]) . " $nval, @$hval:$ival$Aval";
			}
			break;
		case "longwyear":
			if ($LANG=="fr") {
				$out = ucfirst($day[$dval]). " $nval ".
					ucfirst($month[$mval]) . " $Yval  $Hval:$ival";
			} else {
				$out = ucfirst($day[$dval]). " ".
					ucfirst($month[$mval]) . " $nval $Yval, @$hval:$ival$Aval";
			}
			break;
		case "short":
			if ($LANG=="fr") {
				$out = ucfirst($day[$dval]). " $nval ".
					ucfirst($month[$mval]);
			} else {
				$out = ucfirst($day[$dval]). " ".
					ucfirst($month[$mval]) . " $nval";
			}
			break;
		case "shortwyear":
			if ($LANG=="fr") {
				$out = ucfirst($day[$dval]). " $nval ".
					ucfirst($month[$mval])." $Yval";
			} else {
				$out = ucfirst($day[$dval]). " ".
					ucfirst($month[$mval]) . " $nval $Yval";
			}
			break;
		}

		return $out;
	}

	/**
	 * Function which takes a timestamp(14) as input and returns the time
	 * Thanks to mose mose@mose.com
	 *@param string $t the timestamp
	 *@param string $mode the format of the output
	 *@return string the formated time
	 *@access public
	 */
	Function stamp2time ($t, $mode) {
		global $LANG, $config;
		$timestamp = $this->timestamp14_to_unix_stamp($t);

		if (isset ($config->TZ)&&$config->TZ) {
			$timestamp += $config->TZ * 3600;
		}

		$hval   = date("h",$timestamp);
		$Hval   = date("H",$timestamp);
		$Aval   = date("A",$timestamp);
		$ival   = date("i",$timestamp);

		switch ($mode) {
			case "long":
				if ($LANG == "fr") {
					$out =  substr($t,8,2) . ":" . substr($t,10,2). ":" .
							substr($t,12,2);
				} else {
					$out = $hval.":".$ival.":".substr($t,12,2).$Aval;
				}
				break;
			case "short":
				if ($LANG=="fr") {
					$out = "$Hval:$ival";
				} else {
					$out = "$hval:$ival$Aval";
				}
				break;
		}
		return $out;
	}

	/**
	 * This returns the time elapsed between two SGBD timestamps.
	 * "1, 10:20" means one day, ten hours, twenty minutes.
	 *@param string $t1 the first SQL timestamp
	 *@param string $t2 the second SQL timestamp
	 *@access public
	 *@return string the time difference.
	 */
	Function interval($t1,$t2) {
		$tu1 = $this->timestamp14_to_unix_stamp($t1);
		$tu2 = $this->timestamp14_to_unix_stamp($t2);

		if ($tu1>$tu2) {
			$d = ($tu1 - $tu2)/60;
		} else {
			$d = ($tu2 - $tu1)/60;
		}

		$min = $d%60 ;  $d -= $min ;  $d /= 60;
		$hour = $d%24 ; $d -= $hour ; $d /= 24;
		return floor($d).lecho("d")." ".$hour.lecho("h")." ".$min.lecho("m");
	}

	/**
	 * Returns random characters
	 *@param integer $nb the number of characters to return
	 *@return string a random string of $nb characters
	 *@access public
	 */
	Function makerand($nb=8) {
		$seed = ((time() % 4096 - 2048)+((double)microtime()))*1000000;
		mt_srand($seed);
		$r="";
		$r1=array(48,65,97);
		$r2=array(57,90,122);
		for($i=1; $i<=$nb; $i++) {
			$j=mt_rand(0,2);
			$r.=sprintf("%c",mt_rand($r1[$j],$r2[$j]));
		}
		return $r;
	}

	/**
	 * Create new ipsession and returns it
	 * Calls exit on SQL failure
	 * FIXME: unused
	 *@return string the ID of the session.
	 *@access private
	 */
	Function make_ipsession() {
		global $config;
		$idsession = $this->makerand(20);
		$sqlc_q = "INSERT INTO ".$config->tables['ip_sessions'].
			" (id,ip) VALUES ('".addslashes($idsession).
			"','".addslashes($this->ip())."')";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()." -->\n";
			exit;
		}
		return $idsession;
	}

	/**
	 * Check ipsession
	 * FIXME: unused
	 *@param string $idsession the session to check
	 *@return bool true if the session is valid, false if not.
	 */
	Function check_ipsession($idsession="") {
		global $config;
		if (empty($idsession)) {
			echo lecho("Something went wrong. ")."<br />\n";
			exit;
		}
		$sqlc_q = "SELECT id FROM ".$config->tables['ip_sessions'].
			" WHERE ip='".addslashes($this->ip())."' AND id='".
			addslashes($idsession)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()." -->\n";
			exit;
		}
		if ($this->db->num_rows() >= 1) {
			return 1;
		} else {
			return 0;
		}
		$this->db->free();
	}

	/**
	 * Change accent to visible thing for WAP
	 * FIXME: unused
	 *@param string $text the text to escape
	 *@return string the escaped text.
	 *@access public
	 */
	Function spec_chars($text) {

		for ($i = 161; $i < 255; $i++) {
			$text = str_replace(chr($i), "&#".$i.";", $text);
		}

		return $text;
	}

	/**
	 * Create directories recursively
	 *@access public
	 *@param string $dir the directory hierarchy to create
	 *@param integer $mode the mode of the created dirs
	 *@return bool 1 if success, 0 otherwise
	 */
	Function createdir ($dir="",$mode=0755) {
		if (empty($dir)) {
			return 0;
		}
		if (file_exists($dir) &&
			is_dir($dir)) {
			return 1;
		}

		$dir_tmp = split("/", $dir);
		if (gettype($dir_tmp) != "array") {
			return 0;
		}
		$globaldir = (ereg("^/", $dir) ? "" : ".");
		while(list($key,$val) = each ($dir_tmp)) {
			if (!empty($val)) {
				$globaldir .= "/".$val;
				if (file_exists($globaldir) &&
					is_dir($globaldir)) {
					continue;
				} elseif (mkdir ($globaldir, $mode)) {
				/* Allow the cache to work with tuxfamily */
					chmod($globaldir, $mode);
				} else {
					return 0;
				}
			}
		}
		return 1;
	}

	/**
	 * Define the getcwd function, for compatibility with PHP 3
	 *@return string the current working directory
	 *@access public
	 */
	Function getcwd () {
		if (function_exists('getcwd')) {
			return getcwd();
		}
		$pwd = getenv("PATH_TRANSLATED");
		return dirname($pwd);
	}

	/**
	 * Define the realpath function, for compatibility with PHP 3
	 *@param string the path  to convert
	 *@return string "Canonicalized absolute pathname"
	 *@access public
	 */
	Function realpath ($path) {
		if (function_exists('realpath')) {
			return realpath($path);
		}
		$dir = dirname($path);
		$old_cwd = $this->getcwd();
		if (!chdir($dir)) {
			return;
		}
		$result = $this->getcwd();
		if (!empty($old_cwd)) {
			chdir($old_cwd);
		}
		return $result;
	}

	/**
	 * Write text to a file using a temporary file to avoid
	 * concurrent writings.
	 *@param string $file the filename
	 *@param string $text the text to write
	 *@access public
	 */
	Function write_file ($file,$text="") {
		global $config;
		$dir = dirname($file);
		if (!$this->createdir($dir)) {
			exit;
		}
		//  The realpath function can be called only after
		//  directory being created.
		$dir = $this->realpath($dir."/foo");
		$tempfile = tempnam($dir, "write");
		$fpwrite = @fopen($tempfile, 'wb');
		if($fpwrite) {
			$bytes_written = fputs($fpwrite,$text);
			fclose($fpwrite);
			// the rename function does not work across filesystems
			if ($bytes_written == strlen($text)) {
				copy($tempfile,$file);
			} else {
				$config->nosave = 1;
			}
			unlink($tempfile);
		} else {
			//   Maybe SAFE MODE is activated
			//   In this case, write directly to file
			$fpwrite = @fopen($file, 'wb');
			if(!$fpwrite) {
				// we should probably log something somewhere...
				exit;
			}
			$bytes_written = fputs($fpwrite,$text);
			fclose($fpwrite);
			if ($bytes_written != strlen($text)) {
				//   Something wrong happened, this file is
				//   corrupted and then removed
				@unlink($file);
				$config->nosave = 1;
			}
		}
	}

	/**
	 * Returns the timestamp of the news
	 * FIXME: MIGHT BE MOVED INTO THE NEWS CLASS
	 *@param integer ID of the news
	 *@return array year, month, day, id
	 *@access public
	 */
	Function gettimestampnews($news_id) {
		global $config;

		$sqlc_q = "SELECT timestamp FROM ".$config->tables['news'].
			" WHERE id='".addslashes($news_id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()." -->\n";
			exit;
		}
		$row = $this->db->fetch_array();
		$this->db->free();
		if (ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $row['timestamp'], $res)) {
			return array($res[1],$res[2],$res[3],$news_id);
		}
	}

	/**
	 * Checks if server load is not too high
	 * Returns 1 if actual load is higher than a level which is configured in
	 * config.php3
	 * else returns 0
	 *@return bool 1 if too high, 0 otherwise
	 *@access public
	 */
	Function loadishigh() {
		global $config;
		if (file_exists("/proc/loadavg")) {
			$loadtempo = file("/proc/loadavg");
			$loadtempo[0] = ereg("^([^ ]+)",$loadtempo[0], $regs);
			if ($regs[1] > $config->highload) {
				return 1;
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}

	/**
	 * Returns the actual load of the server
	 *@return string the server load
	 *@access public
	 */
	Function loadis() {
		if (file_exists("/proc/loadavg")) {
			$loadtempo = file("/proc/loadavg");
			$loadtempo[0] = ereg("^([^ ]+)",$loadtempo[0], $regs);
			return $regs[1];
		} else {
			return 0;
		}
	}

	/**
	 * Compare two arrays and return true if they are equal.
	 * PHP3 does not handle compar. of objects.
	 *@param array $table1
	 *@param array $table2
	 *@return bool 1 if identical, 0 otherwise
	 *@access public
	 */
	Function cmp_array($table1,$table2) {
		if (!is_array($table1) || !is_array($table2))
			return 0;

		reset($table1);
		while(list($key,$value)=each($table1)) {
			if (isset($value) && is_array($value) ||
					isset($table2[$key]) && is_array($table2[$key])) {
				if (!cmp_array($value, $table2[$key]))
					return 0;
			} elseif (!isset($table2[$key]) || $table2[$key] != $value) {
				return 0;
			}
		}
		reset($table2);
		while(list($key,$value)=each($table2)) {
			if (isset($value) && is_array($value) ||
					isset($table1[$key]) && is_array($table1[$key])) {
				if (!cmp_array($value, $table1[$key]))
					return 0;
			} elseif (!isset($table1[$key]) || $table1[$key] != $value) {
				return 0;
			}
		}
		return 1;
	}

	/**
	 * Returns the html <select> with the list of a topics
	 *@return string the HTML list of topics
	 *@access public
	 */
	Function make_topics_button() {
		global $config;
		$button = "<select name=\"topic\">\n".
			'<option value="-1" selected="selected"> '.lecho("All")." </option>\n";

		$sqlc_q = "SELECT id,topic FROM ".$config->tables['topics'].
			" ORDER BY topic";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) return lecho("query failed:").$sqlc_q;
		while($topics_tmp=$this->db->fetch_array()) {
			$button .="<option value='".$topics_tmp['id']."'>".$topics_tmp['topic'].
				"</option>\n";
		}
		$this->db->free();

		$button .= "</select>\n";
		return $button;
	}

	/**
	 * Returns the html <select> with the list of a sections
	 *@return string the HTML list
	 *@access public
	 */
	Function make_sections_button() {
		global $config;
		$button = "<select name='section'>\n".
			'<option value="-1" selected="selected"> '.lecho("All")." </option>\n";

		$sqlc_q = "SELECT id,section FROM ".$config->tables['sections'].
		" ORDER BY section";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) return lecho("query failed:").$sqlc_q;
		while ($sections_tmp=$this->db->fetch_array()) {
			$button .= "<option value='".$sections_tmp['id']."'>".
				$sections_tmp['section']."</option>\n";
		}
		$this->db->free();

		$button .= "</select>\n";
		return $button;
	}

	/**
	 *  Escape unauthorized tags for the board
	 *@param string $text the text to escape
	 *@return string the escaped text
	 *@access public
	 */
	Function htmlspecial_board($text) {
		global $config;

		$htmlright = htmlentities($text);
		$newhtml = $htmlleft = '';
		if ($config->valid_tags_board) {
			$regexptag = '&lt;(' .
				join('|',$config->valid_tags_board) .
				'|/' .
				join('|/',$config->valid_tags_board) .
				')&gt;(.*)';
			$pos = 0;
			//   Cut string into pieces
			while (eregi($regexptag, $htmlright, $regs)) {
				$thetag = strtolower($regs[1]);
				$prefix = $htmlleft.substr($htmlright,0,-strlen($regs[0]));
				if ($thetag == '/'.$tag[$pos]) {
					$htmlleft = $before[$pos].
						"<$tag[$pos]>".$prefix."<$thetag>";
					$pos--;
				} else {
					$pos++;
					$before[$pos] = $prefix;
					$tag[$pos] = $thetag;
					$htmlleft = "";
				}
				$htmlright = $regs[2];
			}
			//   Rebuild text
			for ($i=1 ; $i<=$pos ; $i++) {
				$newhtml .= $before[$i]."&lt;".$tag[$i]."&gt;";
			}
		}
		$newhtml .= $htmlleft.$htmlright;

		return $newhtml;
	}

	/**
	 *  Escape unauthorized tags
	 *@param string $text the text to escape
	 *@param string $url_conv 1 to convert URLS into  link
	 *@return string the escaped text
	 *@access public
	 */
	Function htmlspecial($text,$url_conv="0") {
		global $config;

		$htmlright = htmlspecialchars($text);
		$newhtml = $htmlleft = '';
		if ($config->valid_tags) {
			$regexptag = '&lt;(' .
				join('|',$config->valid_tags) .
				'|/' .
				join('|/',$config->valid_tags) .
				')&gt;(.*)';
			$size = 0;
			//   Cut string into pieces
			while (eregi($regexptag, $htmlright, $regs)) {
				$thetag = strtolower($regs[1]);
				$prefix = $htmlleft.substr($htmlright,0,-strlen($regs[0]));
				if ($thetag == '/'.$tag[$size]) {
					$htmlleft = $before[$size].
						"<$tag[$size]>$prefix<$thetag>";
					$size--;
				} else {
					$size++;
					$before[$size] = $prefix;
					$tag[$size] = $thetag;
					$htmlleft = "";
				}
				$htmlright = $regs[2];
			}
			//   Rebuild text
			for ($i=1 ; $i<=$size ; $i++) {
				$newhtml .= "$before[$i]&lt;$tag[$i]&gt;";
			}
		}
		$newhtml .= $htmlleft.$htmlright;

		//   Additionnally replace URLs by links
		if ($url_conv) {
			$newhtml = $this->url_conv($newhtml);
		}
		return $newhtml;
	}

	/**
	 * Function to replace URL by link and reduce the length of the link.
	 * will fail on URL containing )
	 *@param string $text
	 *@return string
	 *@access public
	 */
	Function url_conv($text){
		$validchars="-;/?:@=&\$_.+!*'(~#%,";
		return ereg_replace(
			"((ftp|https?)://(([[:alnum:]]|[$validchars]){1,40})".
			"([[:alnum:]]|[$validchars])*)","<a href=\"\\0\">\\3</a>",$text);
	}



	/**
	 * Function to encrypt password 
	 * so we can change the encrypt method if we need to.
	 * Returns encrypted password if one argument,
	 * Returns 1 if 2 arguments and they match,
	 * Returns 0 if 2 arguments and they don't match.
	 *@param string $passwd
	 *@param string $encrypted_password
	 *@return mixed
	 *@access public
	 */
	Function crypt_dacode($passwd,$encrypted_password="") {

		if (empty($encrypted_password)) {
			return crypt($passwd,$this->makerand("2"));
		} else {
			if ($encrypted_password == crypt($passwd,$encrypted_password)) {
				return 1;
			} else {
				return 0;
			}
		}
	}

	/**
	 * Function to send a mail.
	 *
	 *@param string $to
	 *@param string $subject
	 *@param string $message
	 *@param string $from
	 *@return bool 1 if the mail has been sent, 0 otherwise
	 *@access public
	 */
	Function send_email($to="",$subject="",$message="",$from="") {
		global $config;
		if (empty($to) || empty($subject) || empty($message)) {
			return 0;
		}

		$message = $this->quote_text($message,0,72,"\n",'');

		$h = "From: ".($from ? $from : $config->mailadmin).
			($from ? "\nCc: ".$from : "").
			"\nReply-To: ".($from ? $from : $config->mailadmin).
			"\nX-Mailer: daCode ".$config->version.
			"\nMIME-Version: 1.0".
			"\nContent-Type: text/plain; charset=".$config->encodingcharset.
			"\nContent-Disposition: inline".
			"\nContent-Transfer-Encoding: 8bit";

		if (!empty($config->mail_login) && !empty($config->mail_password)) {
			$to = urlencode($to);
			$subject=urlencode($subject);
			$message=urlencode($message);
			$l=urlencode($config->mail_login);
			$p=urlencode($config->mail_password);
			$h = urlencode($h);

			$fp = @fopen("http://m.dacode.org/?login=".$l.
				"&password=".$p."&to=".$to."&subject=".
				$subject."&message=".$message."&h=".$h, "rb");
			if (!$fp) {
				return 0;
			}
			$response = fread($fp, 256);
			fclose($fp);
			if (substr($response, 0, 2) != 'ok') {
				return 0;
			}
		} else {
			mail($to,$subject,$message,$h);
		}
		return 1;
	}

	/**
	 * Make sure there is no '<' sign in text
	 *
	 *@param mixed $var (string) the text to check. May be an array of strings to check
	 *@return bool 1 if no <, 0 otherwise
	 *@access public
	 */
	Function html_safe($var) {
		if (is_array($var)) {
			reset($var);
			while (list($key,$val) = each($var)) {
				if (strstr($val, '<')) {
					return 0;
				}
			}
		} else {
			if (strstr($var, '<')) {
				return 0;
			}
		}
		return 1;
	}

	/**
	 * Wraps the text:
	 *
	 *@param string $text Text to quote [necessary]
	 *@param integer $quote When set, $begin_quote is user. Set by default.
	 *@param integer $buff_size Size of the line in chars. 70 by default.
	 *@param string $end_quote Chars to add at the end of the line. \n by default
	 *@param string $begin_quote Chars to add at the beginning of the line. '> ' by default.
	 *@return string the wrapped text
	 *@access public
	 */
	Function quote_text($text, $quote=1, $buff_size=70, $end_quote = "\n",
											$begin_quote='> ') {
		$tmp = '';
		$lines = explode($end_quote, trim($text));
		$i = count($lines);

		for ($cpt = 0; $cpt < $i ;$cpt++) {
			if (strlen($lines[$cpt]) > $buff_size) {
				$str = $lines[$cpt];
				while (strlen($str) > $buff_size) {
					$position = strrpos(trim(substr($str, 0, $buff_size)), ' ');
					if (empty($position))
						break;
					if (!empty($quote)) {
						$tmp .= $begin_quote;
					}
					$tmp .= substr($str, 0, $position).$end_quote;
					$str = trim(substr($str, $position));
				}

				if (!empty($quote)) {
					$tmp .= $begin_quote;
				}
				$tmp .= $str.$end_quote;
			} else {
				if (!empty($quote)) {
					$tmp .= $begin_quote;
				}
				$tmp .= $lines[$cpt].$end_quote;
			}
		}
		return $tmp;
	}

	/**
	 * Warns the user about the HTTP_REFERER http header.
	 *@return string the formated warning.
	 *@access public
	 */
	Function warn_referer() {
		global $config;
		return lecho("<b>Warning</b>: your webbrowser didn't sent").
			lecho(" informations about HTTP_REFERER.").
			lecho("<br />Consult ").
			"<a href=\"http://lwn.net/2000/features/Redirect.phtml\">".
			"http://lwn.net/2000/features/Redirect.phtml</a>".
			lecho(" to understand why it's a problem.").
			lecho("<p>If you are behind a proxy, which deletes").
			lecho(" this information, you can post").
			lecho(" by choosing in your ").
			"<a href=\"".$config->basehref.
			"users/?a=mu\">".lecho("preferences")."</a>".
			lecho(" to disable this verification.</p>");
	}


	/**
	 * Function to direct debugging output.
	 * The output may be directed to stdout, a file or socket
	 * depending on Config::debug and Config::debugFile
	 *@param string $debugMsg the message to print
	 *@access public
	 */
	Function debug($debugMsg) {
		global $config;

		switch ($config->debug) {
			case "none" : {
				return;
				break;
			}
			case "stdout": {
				echo "<h1>DEBUG FROM DACODE</h1>\n<pre>".$debugMsg."</pre>\n";
				break;
			}
			case "file": {
				$fp = @fopen($config->debugFile, 'ab');
				fwrite($fp, $debugMsg);
				break;
			}
			case "socket" : {
				$a = split(":", $config->debugFile);
				$sock = fsockopen($a[0], $a[1]);
				fputs($sock, $debugMsg);
				fclose($sock);
				usleep(50);
				break;
			}
		}
	}

	/**
	 * Traps a var_dump call and directs it to the selected debug output.
	 * Warning: don't try it with recursive structures ($GLOBALS)
	 *@param mixed $var the variable to dump
	 *@param integer $level used to dump in php3
	 *@return string if $level != 0
	 *@access public
	 */
	Function debug_dump($var, $level=0) {
		global $config;

		if ($config->debug == "none") {
			return;
		} elseif ($config->debug == "stdout") {
			var_dump($var);
		} else {
			// Modify the test if you want to get a real var_dump to a
			//file or socket (est it to true)
			//Change it to 1 if you want to use PHP4-pecific code...
			if (0) {
				ob_start();
				var_dump($var);
				$ct = ob_get_contents();
				ob_end_clean();
				$this->debug($ct);
			} else {
				//WARNING : this is as recursive as var_dump()....
				// dont try it with $GLOBALS!
				$ct = gettype($var);
				$ct .= ": {\n";

				for ($i = 0, $offset = ""; $i < $level; $i++) {
					$offset .= "  ";
				}

				if (is_array($var)) {
					reset($var);

					while (list($key, $val) = each($var) ) {
						$ct .= "$offset  [$key] => " . $this->debug_dump($val, $level + 1);
					}

				} elseif (is_object($var)) {
					$ct .= " Not dumped\n";
				} else {
					$ct .= "$offset    ";
					if (is_string($var)) {
						$tmp ='"';
					} else {
						$tmp = '';
					}
					$ct .= $tmp. $var . $tmp . "\n";
				}

				$ct .= $offset ."}\n";
				if ($level) {
					return $ct;
				}
				$this->debug($ct);
			}
		}
	}

	/**
	 * Generates the No Access message
	 *@return string the no access string, to be printed out by the caller
	 *@access public
	 */
	Function no_access_msg() {
		global $config;

		return $config->no_access_msg;
	}

}

?>
