<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>
  <!-- $Id: manpage-stylesheet.xsl 2276 2009-04-14 21:07:13Z FEDROOT::SVN:brachman $ -->

  <xsl:import href="docbook-xsl/manpages/docbook.xsl"/>

  <xsl:param name="toc.section.depth">3</xsl:param>
  <xsl:param name="annotate.toc">0</xsl:param>
  <xsl:param name="man.funcsynopsis.style">ansi</xsl:param>

  <!-- See http://www.sagehill.net/docbookxsl/Variablelists.html -->
  <!-- Couldn't make http://www.sagehill.net/docbookxsl/LineBreaks.html work -->
  <xsl:param name="variablelist.term.break.after">1</xsl:param>
  <xsl:param name="variablelist.term.separator"> </xsl:param>

  <!-- Point man page links to the online docs -->
  <xsl:param name="man.base.url.for.relative.links">http://dacs.dss.ca/man/</xsl:param>

<!-- Shuts up warnings about "missing" refentry markup -->
<xsl:param name="refentry.meta.get.quietly">1</xsl:param>

  <!-- Disable the REFERENCES section -->
  <xsl:param name="man.links.list.enabled">0</xsl:param>
  <xsl:param name="man.links.are.numbered">0</xsl:param>

  <xsl:template match="sect1" mode="toc">
    <xsl:param name="toc-context" select="."/>
    <xsl:call-template name="subtoc">
      <xsl:with-param name="toc-context" select="$toc-context"/>
      <xsl:with-param name="nodes" 
        select="sect2|refentry|bridgehead[$bridgehead.in.toc != 0]"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="sect2" mode="toc">
    <xsl:param name="toc-context" select="."/>

    <xsl:call-template name="subtoc">
      <xsl:with-param name="toc-context" select="$toc-context"/>
      <xsl:with-param name="nodes" 
        select="sect3|refentry|bridgehead[$bridgehead.in.toc != 0]"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="processing-instruction('textcode')">
    <xsl:variable name="codefile" select="document(normalize-space(.),/)"/>
    <xsl:copy-of select="$codefile/*/node()"/>
  </xsl:template>

</xsl:stylesheet>
