/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "action_node.hpp"

#include "visitor.hpp"
#include "const_visitor.hpp"

namespace dammit {

intrusive_ptr<node> action_node::apply(visitor &v)
{
	return v.visit(*this);
}

void action_node::apply(const_visitor &v) const
{
	v.visit(*this);
}

}
