/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "temporary_node.hpp"

#include "visitor.hpp"
#include "const_visitor.hpp"

namespace dammit {

intrusive_ptr<node> temporary_node::apply(visitor &v)
{
	return v.visit(*this);
}

void temporary_node::apply(const_visitor &v) const
{
	v.visit(*this);
}

}
