#ifdef RCS
static char rcsid[]="$Id: confmode.c,v 1.1.1.1 2000/11/13 02:42:40 holsta dancer.c $";
#endif
/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/confmode.c,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:40 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

/*****************************************************************************

                               CONFERENCE MODE

Confoper - person that admins the conference
Victim   - one or more persons that are the target of all questions
Users    - the crowd asking questions to the victims

----

  On frequent occations, there have been press-conference style conferences
held in IRC channels. Some things that are common in these situations:

  - The channel is moderated (+m)
  - Very many people join. Amounts larger than 300 have been seen several
    times.
  - One or a few people receive questions from the crowd and reply to them.
    (They are of course +v)
  - Usually, one poor person gets the "honor" receiving all requests to ask
    a question and then hands a +v to the guys one at a time to ask the
    question. When one question has been answered, the next guy in line gets
    +v and the former person is again -v.
  - Logging the channel and what is said is generally important and considered
    very interesting afterwards.

  - The majority of people only read what's happening and are prevented from
    talking bullshit by not having ops nor voice.

Defense

  * trigger nick-flood easier
  * ban faster on multiple abuses
  * raise level requirement for the OP command (100 or 200)

  * possibly even consider non-victims being abusive if they talk in the
    channel (if they happen to be +o or +v). This way, we can let people have
    ops in greater amounts for protective reasons. At least, the bot should
    remove ops and voice from "talkers".

How it could be done:

  - No or only a few people should have ops. They should not interfere with
    the talking.

  - Joining users get a short instruction message about how to submit
    questions.

  - The bot keeps the queue of questions. To ask a question, enter the ASK
    command to the bot and enter the full question.

  - ASKDEL removes a question if the same person put it there. Or if the
    user is a CONFOPER, another user's question can be removed. (The user's
    'ask' field should be lowered too.)

  - The bot features a command, ASKME, that takes the first question in the
    queue and asks it. Typically, this is used by the victims, or by choice,
    by a CONFOPER. No user get +v or -v.

  - Logging must be improved to log the bots output since otherwise the
    questions won't be logged by the bot itself. The bot logs all respones to
    the question it has just asked to make a perfect interview log. It should
    also offer quick replays on-demand on-line if someone runs off a minute
    and comes back a few questions later with the ASKLIST command.

  - If a user that has posted a question leaves, his/hers question will be
    postponed for his return, up to N minutes. N shouldn't be more than 10
    minutes and it should be posted anyway if the end of the queue is reached.

  - [OPTION] Let the victims connect to the bot with DCC (thus not joined
    in the conference channel) and relay all questions and answers through
    the bot, with the bot not presenting the victims' actual nicks to the
    channel.

                                   COMMANDS
                                   ========
The commands are grouped in 3 groups, all using their own prefixes.

CONF - Conference oriented command, setting or getting information about the
       conference as a whole.
ASK  - Ask a question or get information about single questions.
Q    - Question Queue Qontrol ;)



CONF [INIT/END] <Title of conference>

  - INIT
  General initing command that starts this "conference mode". This command
  sets +m and deops all persons that are lower than X, where X is larger than
  the normal op-level. The victims should be deopped but given +v. The title
  parameter entered will be used in the help text presented to all joiners of
  the channel during conference mode. The one entering this command
  automatically becomes CONFOPER.

  - PAUSE
  This makes the bot _not_ consider the conference being actively held. Lines
  entered to the channel are not treated as response to the last question and
  somewhat less strict abuse rules may be used.

  - CONT
  Continues after a PAUSE. The conference is yet again considered running.

  - END
  Stops the conference mode, removes the +m mode and sets back everything to
  "normal". The logfile should be kept to enable later browsing and 'flushing'
  it to people across DCC and to disk for the bot maintainer.

ASK <question>
  Ask a question (enters the question to the queue). If the user is qbanned,
  the reason why will be returned back. If this command is used more than 3
  times within 10 seconds by the same user, it will be considered ASKFLOODING
  and qbanning will trigger automatically as well as the user's ALL un-posted
  questions will be deleted from the list. Repeated questions will be ignored,
  the 3rd repeated question considered an askflood.

  Having a max-frequency for questions could be useful to make the question
  asking more spread among the users: Each time a person asks a question, the
  person has an 'ask' field that is used to set the question queue priority.
  The 'ask' field is set to *at least* the current time. Each time a qeustion
  is asked, the 'ask' field is increased with X. (How to set X is still yet to
  be discussed!)

        Example (X is 20 in this example):

        Person A: asks a question at time Y, which makes the prio of that Q
                  get Y. The 'ask' field is then set to Y + 20.
        Person A: asks another question at time Y+1, which makes the Q get
                  prio Y+20. The 'ask' field is yet again increased to U+40.
        Person B: asks a question at time Y+3, which makes prio Y+3, and thus
                  will get asked before A's second Q.
        etc

ASKME (CONFOPERs and victims only)
  Presents the first question in the queue to the channel. The question will
  be presented as "[*]{ID}<nick> <question>" where the '*' indicates if the
  question was altered by a CONFOPER after <nick> asked it.

ASKINFO
  General status information about the questions in the queue:
   * how many questions there are in line
   * how many that have passed through this far
   * how many un-asked questions there are until the users next question is
     up (+ an estimated time, based on time/question so far)

ASKLIST [-N] <X>
  Lists the X coming questions in the queue. With the -<number> specified, it
  starts listing with that ID. Each question has the following fields:
   * question
   * who wrote it
   * hong long ago was it written
   * if it has been altered and if then by who
  Possibly also:
   * when was it posted to the channel
   * when was the last response-time (the last line of reply to the question)
   * the response (X number of lines)

CONFINFO
  Presents conference information:
   * how long ago the conference started
   * number of posted/answered questions
   * list of victims and their descriptions

CONFHELP
  This help text should instruct the user on how to submit questions.


           The following commands are only available for CONFOPERs

CONFVICT [-D] <NICK> <Description>
  Marks a user as 'victim' in this conference. The description is useful and
  presented in the CONFINFO result output. Enter this command once for each
  victim. -D is used to delete the vitim status from a person joined.  All
  persons that leave the channel lose their victim status and can't get it
  back unless CONFVICT is used again.

CONFOPER [-D] <nick>
  Makes the specified person CONFOPER. If -D is used, the person gets the
  CONFOPER flag removed. If no CONFOPERs exist in the channel, CONFOPER will
  be possible to use for 200+ users (in order to prevent the conference from
  getting all screwed up due to the loss of all CONFOPERs).

QHALT [-U] <id>
  Halt a question - makes it not being posted even if it is first in the queue
  (the next one is picked instead). This way a CONFOPER can get some time to
  rewrite a long question. Use of -U toggles off the HALT state,

QDEL <id>
  Deletes someone's question.

QREV <id> <question>
  Post a revised question, thus no need to delete it if only a tiny correction
  or change needs to be done. This removes the HALTed state if the question.
  This does not change the author information, only mark it as 'adjusted'.

QPRIO <id> <+/- steps>
  Change a question's priority a specified amount of steps. (only possible to
  do on not yet posted questions)

QBAN <+/-><nick/pattern> <reason>
  Prevent a nick or pattern from further asking. + adds a nick or pattern
  together with a reason, - removes it, no argument lists all qbans. Argument
  without leading + or - lists only qbans that match that pattern.

QSNOOP
  Subscribe to ASK commands and get all questions sent via the dcc chat
  whenever an ASK is submitted by a user. Auto-QBANS (due to ASKFLOOD) will
  also be announced to QSNOOPers. A second invoke toggles QSNOOP off.

*****************************************************************************/

#ifdef CONFMODE

#include "dancer.h"
#include "trio.h"
#include "strio.h"

extern itemident *current;

/* BCS => BotChannelStat */
#define BCS_CONFMODE (1<<0) /* conference mode */
#define BCS_PAUSE    (1<<1) /* paused something */

long botchannelstat; /* pure soft information about the status of the bot
                        and channel. see the BCS* defines */

int Conf(char *from, char *line)
{
  char title[BIGBUFFER];
  char command[32];

  if (1 == StrScan(line, "%31s", command)) {
    if (StrEqual(command, "INIT")) {
      /* Conference mode started */
      line += StrLength(command);
      if (1 == StrScan(line, "%"BIGBUFFERTXT"[^\n]", title)) {
        /* Set channel mode +m */
        /* Deop the lower status people */
        current->guest->flags.confoper = 1; /* make current user conference
                                               operator */
        botchannelstat |= BCS_CONFMODE;  /* conference mode */
      }
      else
        return 0;
    }
    else if (StrEqual(command, "END")) {
      /* Remove channel -m */
      botchannelstat &= ~BCS_CONFMODE;  /* terminate conference mode */
    }
    else if (StrEqual(command, "PAUSE")) {
      botchannelstat |= BCS_PAUSE;
    }
    else if (StrEqual(command, "CONT")) {
      botchannelstat &= ~BCS_PAUSE;
    }
  }
  else
    return 0;
}
#endif
