/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/country.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:40 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef COUNTRY_H
#define COUNTRY_H

enum {
  eu=0, /* europe */
  as, /* asia */
  af, /* africa */
  au, /* australia */
  na, /* north america */
  sa, /* south america */
  an  /* antarctica */
};

typedef struct {
  char  continent;
  char *code;
  char *country;
  char *fullname;
  char *onemoney; /* name of one unit of the country's currency */
  char *currency; /* three-letter name of the currency */
  ulong sig;
  ulong let;  /* Marks used letters */
} land;

extern char *continents[];


void CountryInit(void);
void Country(char *, char *);
land *FindByCode(char *);
land *FindByCurrency(char *);
land *FindByCountry(char *);

#endif /* COUNTRY_H */
