/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/language.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:44 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef LANGUAGE_H
#define LANGUAGE_H

#define XMSG(x) extern char *(x)[]

/* languages are two-letter unique strings */
typedef enum {
  LANG_ENGLISH = 0,
  LANG_DANISH,
  LANG_SWEDISH,
  LANG_NORWEGIAN,
  LANG_DUTCH,
  LANG_FRENCH,
  LANG_GERMAN,
  LANG_SPANISH,
  LANG_FINNISH,

  LANG_LASTLANGUAGE
} LangNum;

/* default language */
#define LANG_DEF LANG_ENGLISH

extern LangNum defaultlang;
extern LangNum uselang;

LangNum LanguageNum(char *string);
char *LanguageShort(LangNum lang);
char *LanguageLocal(LangNum lang);
void LanguageList(char *from);
char *GetText(char *[]);
char *GetDefaultText(char *[]);

XMSG(msg_syntax_error);
XMSG(msg_usage);
XMSG(msg_not_implemented);
XMSG(msg_no_explaination);
XMSG(msg_shutdown_in_progress);
XMSG(msg_help_short);
XMSG(msg_help_help);
XMSG(msg_help_syntax);
XMSG(msg_help_explain);
XMSG(msg_help_rules);
XMSG(msg_help_seen);
XMSG(msg_help_sview);
XMSG(msg_help_cmd);
XMSG(msg_help_uptime);
XMSG(msg_help_split);
XMSG(msg_help_tellme);
XMSG(msg_help_alias);
XMSG(msg_help_wholeft);
XMSG(msg_help_show);
XMSG(msg_help_pass);
XMSG(msg_help_newpass);
XMSG(msg_help_comment);
XMSG(msg_help_convert);
XMSG(msg_help_tz);
XMSG(msg_help_spell);
XMSG(msg_help_mynick);
XMSG(msg_help_find);
XMSG(msg_help_country);
XMSG(msg_help_calc);
XMSG(msg_help_topic);
XMSG(msg_help_tell);
XMSG(msg_help_telldel);
XMSG(msg_help_telllist);
XMSG(msg_help_toplist);
XMSG(msg_help_invite);
XMSG(msg_help_op);
XMSG(msg_help_voice);
XMSG(msg_help_devoice);
XMSG(msg_help_userlist);
XMSG(msg_help_say);
XMSG(msg_help_me);
XMSG(msg_help_talk);
XMSG(msg_help_quiet);
XMSG(msg_help_lag);
XMSG(msg_help_reportadd);
XMSG(msg_help_reportdel);
XMSG(msg_help_kicklist);
XMSG(msg_help_join);
XMSG(msg_help_leave);
XMSG(msg_help_ban);
XMSG(msg_help_unban);
XMSG(msg_help_banlist);
XMSG(msg_help_chban);
XMSG(msg_help_vrfy);
XMSG(msg_help_host);
XMSG(msg_help_finger);
XMSG(msg_help_status);
XMSG(msg_help_cmode);
XMSG(msg_help_ckey);
XMSG(msg_help_nick);
XMSG(msg_help_set);
XMSG(msg_help_mute);
XMSG(msg_help_warnlist);
XMSG(msg_help_warnadd);
XMSG(msg_help_warndel);
XMSG(msg_help_clientlist);
XMSG(msg_help_do);
XMSG(msg_help_backlog);
XMSG(msg_help_expadd);
XMSG(msg_help_defpass);
XMSG(msg_help_spyadd);
XMSG(msg_help_spydel);
XMSG(msg_help_debugadd);
XMSG(msg_help_debugdel);
XMSG(msg_help_reload);
XMSG(msg_help_wall);
XMSG(msg_help_shutdown);
XMSG(msg_help_quit);
XMSG(msg_help_server);
XMSG(msg_help_names);
XMSG(msg_help_moderate);
XMSG(msg_help_cut);
XMSG(msg_help_chgcmdlev);
XMSG(msg_help_webster);
XMSG(msg_help_log);
XMSG(msg_help_useradd);
XMSG(msg_help_usermod);
XMSG(msg_help_client);
XMSG(msg_help_expdel);
XMSG(msg_help_email);
XMSG(msg_help_setemail);
XMSG(msg_help_serveradd);
XMSG(msg_help_serverlist);
XMSG(msg_help_serverdel);
XMSG(msg_help_serverstat);
XMSG(msg_help_chat);
XMSG(msg_help_link);
XMSG(msg_help_linklist);
XMSG(msg_help_kick);
XMSG(msg_help_userdel);
XMSG(msg_help_exchange);
XMSG(msg_help_used);
XMSG(msg_need_higher_level);
XMSG(msg_nothing_shown);
XMSG(msg_command_restored);
XMSG(msg_changed_command_level);
XMSG(msg_chat_mode_off);
XMSG(msg_left_chat);
XMSG(msg_echo_has_been_turned);
XMSG(msg_unknown_command);
XMSG(msg_already_explained);
XMSG(msg_explaination_too_big);
XMSG(msg_added_explaination);
XMSG(msg_removed_explaination);
XMSG(msg_explaination_was_not_found);
XMSG(msg_no_public_wildcards);
XMSG(msg_no_public_options);
XMSG(msg_report_level);
XMSG(msg_a_comment);
XMSG(msg_yours_or_higher);
XMSG(msg_sview_user);
XMSG(msg_no_more_mr_nice_bot);
XMSG(msg_usually_kicks_X);
XMSG(msg_flooders);
XMSG(msg_no_flooding);
XMSG(msg_shouters);
XMSG(msg_no_shouting);
XMSG(msg_repeaters);
XMSG(msg_no_repeaters);
XMSG(msg_not_implemented_yet);
XMSG(msg_ctcp_bomb_detected);
XMSG(msg_tsunami_detected);
XMSG(msg_beep_flood_detected);
XMSG(msg_nick_not_found);
XMSG(msg_pattern_would_include_myself);
XMSG(msg_ban_report_timed);
XMSG(msg_ban_report);
XMSG(msg_banned_already);
XMSG(msg_use_pass_first);
XMSG(msg_password_ok);
XMSG(msg_invalid_password);
XMSG(msg_notop);
XMSG(msg_use_chat);
XMSG(msg_reload_done);
XMSG(msg_cant_show);
XMSG(msg_no_such_alias);
XMSG(msg_available_commands);
XMSG(msg_level);
XMSG(msg_beepers);
XMSG(msg_kickmsg_no_beepers);
XMSG(msg_kickmsg_no_colours);
XMSG(msg_helpset_autojoin);
XMSG(msg_helpset_bomb);
XMSG(msg_helpset_ctcp);
XMSG(msg_helpset_deop);
XMSG(msg_helpset_flood);
XMSG(msg_helpset_invite);
XMSG(msg_helpset_key);
XMSG(msg_helpset_kickban);
XMSG(msg_helpset_mode);
XMSG(msg_helpset_limit);
XMSG(msg_helpset_multi);
XMSG(msg_helpset_netsplit);
XMSG(msg_helpset_nick);
XMSG(msg_helpset_repeat);
XMSG(msg_helpset_reportban);
XMSG(msg_helpset_say);
XMSG(msg_helpset_talk);
XMSG(msg_helpset_upper);
XMSG(msg_helpset_warn);
XMSG(msg_helpset_welcome);
XMSG(msg_helpset_xdcc);
XMSG(msg_helpset_ckey);
XMSG(msg_helpset_cmode);
XMSG(msg_helpset_climit);
XMSG(msg_helpset_autoop);
XMSG(msg_helpset_comment);
XMSG(msg_helpset_beep);
XMSG(msg_helpset_colour);
XMSG(msg_helpset_floodrate);
XMSG(msg_helpset_floodtime);
XMSG(msg_helpset_floodrepeatrate);
XMSG(msg_helpset_floodrepeattime);
XMSG(msg_helpset_floodbeeps);
XMSG(msg_helpset_helpsyntax);
XMSG(msg_helpset_bantime);
XMSG(msg_helpset_execprotect);
XMSG(msg_helpset_identprotect);
XMSG(msg_helpset_autounban);
XMSG(msg_helpset_botbantime);
XMSG(msg_helpset_floodjoins);
XMSG(msg_helpset_strictop);
XMSG(msg_helpset_banuserkicks);
XMSG(msg_setgroup_thres);
XMSG(msg_setgroup_flood);
XMSG(msg_setgroup_verbose);
XMSG(msg_setgroup_misc);
XMSG(msg_setgroup_owner);
XMSG(msg_setgroup_ban);
XMSG(msg_kickmsg);
XMSG(msg_cant_op);
XMSG(msg_seen_already_here);
XMSG(msg_ban_by);
XMSG(msg_ban_another);
XMSG(msg_ban_ago);
XMSG(msg_unban_ago);
XMSG(msg_time_ban);
XMSG(msg_report_unban_nick);
XMSG(msg_report_unban);
XMSG(msg_report_unbanforce_nick);
XMSG(msg_report_unbanforce);
XMSG(msg_kick_repeated_misbehavior);
XMSG(msg_kick_learn_your_lesson);
XMSG(msg_kicklist_item);
XMSG(msg_no_matching_kick);
XMSG(msg_X_out_of_Y_items);
XMSG(msg_warn_pattern_removed);
XMSG(msg_is);
XMSG(msg_warn_list_all);
XMSG(msg_warn_not_warned);
XMSG(msg_warn_by_when);
XMSG(msg_unknown);
XMSG(msg_no_reason);
XMSG(msg_alerts);


XMSG(msg_spycast_outofchannel);
XMSG(msg_snoop_hidden);
XMSG(msg_snoop_prevented);
XMSG(msg_snoop_line);
XMSG(msg_backlog_entry);
XMSG(msg_uptime_result);
XMSG(msg_yours_or_higher);
XMSG(msg_lowered);
XMSG(msg_raised);
XMSG(msg_added);
XMSG(msg_sview_who_did_what);
XMSG(msg_confirmed);

XMSG(msg_sview_op);
XMSG(msg_sview_dcc);
XMSG(msg_email);
XMSG(msg_regged_nick);
XMSG(msg_comment);
XMSG(msg_sview_joins);
XMSG(msg_warnings);
XMSG(msg_last_talked);
XMSG(msg_hasnt_said_anything);
XMSG(msg_messages);
XMSG(msg_netsplit);
XMSG(msg_nick_not_found);

XMSG(msg_and);
XMSG(msg_second);
XMSG(msg_seconds);
XMSG(msg_minute);
XMSG(msg_minutes);
XMSG(msg_hour);
XMSG(msg_hours);
XMSG(msg_day);
XMSG(msg_days);
XMSG(msg_month);
XMSG(msg_months);

XMSG(msg_split_ago);
XMSG(msg_split_partly_healed);
XMSG(msg_last_netsplit);
XMSG(msg_no_netsplits);
XMSG(msg_never_seen);
XMSG(msg_yes_i_am_here);
XMSG(msg_yes_i_see_you);

XMSG(msg_seenleave);
XMSG(msg_seenquit);
XMSG(msg_seenkick);
XMSG(msg_seenleft);
XMSG(msg_seenquited);
XMSG(msg_seenkicked);
XMSG(msg_seenchange);

XMSG(msg_defpass_done);
XMSG(msg_defpass_inform);
XMSG(msg_comment_set);
XMSG(msg_comment_removed);
XMSG(msg_youre_not_registered);
XMSG(msg_no_registered_user);
XMSG(msg_cant_undo_delete);
XMSG(msg_no_longer_deleted);
XMSG(msg_already_deleted);
XMSG(msg_userdel_inform);
XMSG(msg_userdel_done);
XMSG(msg_and_informed);

XMSG(msg_ident_forbidden);
XMSG(msg_help_ident);
XMSG(msg_ident_defpass);
XMSG(msg_ident_noauth);
XMSG(msg_ident_already_known);

XMSG(msg_email_set);
XMSG(msg_email_address);
XMSG(msg_no_information);
XMSG(msg_unknown_user);
XMSG(msg_chat_mode_on);
XMSG(msg_chat_mode_off);
XMSG(msg_joined_chat);
XMSG(msg_left_chat);
XMSG(msg_already_client);
XMSG(msg_no_change_done);
XMSG(msg_user_modified);
XMSG(msg_modified_inform);
XMSG(msg_nick_no_pattern);
XMSG(msg_nick_in_use);
XMSG(msg_user_already_level);
XMSG(msg_cant_change_higher_user);
XMSG(msg_illegal_pattern);
XMSG(msg_cant_add_current_to_offline);
XMSG(msg_no_nick);

XMSG(msg_im_on_server);
XMSG(msg_unknown_server);
XMSG(msg_dont_send_raw);

XMSG(msg_no_user_matched);
XMSG(msg_userlist_aborted);
XMSG(msg_no_user_to_unban);
XMSG(msg_no_such_ban);
XMSG(msg_changed_the_ban);

XMSG(msg_channel_modes);
XMSG(msg_no_channel_modes);
XMSG(msg_channel_key);
XMSG(msg_say_is_off);
XMSG(msg_talk_on);
XMSG(msg_talk_already);
XMSG(msg_quiet_on);
XMSG(msg_quiet_already);
XMSG(msg_mute_talkative);
XMSG(msg_mute_grave);
XMSG(msg_lag);
XMSG(msg_no_info_for_toplist);

XMSG(msg_need_pattern_offchannel);
XMSG(msg_another_nick_added);
XMSG(msg_already_added);
XMSG(msg_added_inform);
XMSG(msg_user_added);
XMSG(msg_with_nondefault_password);

XMSG(msg_language_set_to);
XMSG(msg_language);
XMSG(msg_help_language);
XMSG(msg_flags);

XMSG(msg_cant_use_in_public);

XMSG(msg_illegal_name);
XMSG(msg_helpset_fakename);

XMSG(msg_topic_set);
XMSG(msg_topic_not_set);

XMSG(msg_help_newslist);
XMSG(msg_help_newsadd);
XMSG(msg_help_newsdel);

XMSG(msg_colour_users);
XMSG(msg_chat_mode_cmd);
XMSG(msg_no_dcc_clients);
XMSG(msg_find_no_match_found);
XMSG(msg_find_no_index);
XMSG(msg_silly_username);
XMSG(msg_not_found);
XMSG(msg_cannot_x_beyond_split);
XMSG(msg_give_op);
XMSG(msg_give_voice);
XMSG(msg_remove_voice);
XMSG(msg_not_allowed_target);
XMSG(msg_no_bans_set);
XMSG(msg_sview_users);
XMSG(msg_sview_commands);
XMSG(msg_sview_bans);
XMSG(msg_sview_ignoring_ctcp);
XMSG(msg_shutdown_canceled);
XMSG(msg_shutdown_already_in_progress);
XMSG(msg_shutdown_in_progress_left);
XMSG(msg_no_shutdown);
XMSG(msg_server_cannot_connect_to_port);
XMSG(msg_passwd_changed);
XMSG(msg_moderate_is);
XMSG(msg_tell_already_here);
XMSG(msg_tell_no_information);
XMSG(msg_warnlist_no_match);
XMSG(msg_warnadd_could_not_find);
XMSG(msg_warnadd_include_me);
XMSG(msg_warnadd_added);
XMSG(msg_warnadd_not_added);
XMSG(msg_report_on);
XMSG(msg_report_already_on);
XMSG(msg_report_off);
XMSG(msg_report_already_off);
XMSG(msg_spy_on);
XMSG(msg_spy_already_on);
XMSG(msg_spy_off);
XMSG(msg_spy_already_off);
XMSG(msg_debug_on);
XMSG(msg_debug_already_on);
XMSG(msg_debug_off);
XMSG(msg_debug_already_off);
XMSG(msg_alias_aliases);
XMSG(msg_alias_no_aliases);
XMSG(msg_alias_command_not_found);
XMSG(msg_identify_no_match);
XMSG(msg_identify_already_linked);
XMSG(msg_identify_already_unified);
XMSG(msg_identify_no_nick);
XMSG(msg_identify_only_dcc);
XMSG(msg_cut_closed);
XMSG(msg_cut_closed_by);
XMSG(msg_cut_no_client);
XMSG(msg_top_unknown);
XMSG(msg_invite_already_here);
XMSG(msg_log_logging);
XMSG(msg_log_nothing);
XMSG(msg_i_need_a_nick);
XMSG(msg_serveradd_added);
XMSG(msg_serveradd_already_added);

XMSG(msg_helpset_banprotect);
XMSG(msg_helpset_loopservers);
XMSG(msg_helpset_oplevel);
XMSG(msg_helpset_mute);
XMSG(msg_mute_is_on);
XMSG(msg_mute_is_off);
XMSG(msg_userdel_inform_real);
XMSG(msg_userdel_done_real);
XMSG(msg_no_invitation);
XMSG(msg_no_ops_allowed);
XMSG(msg_execprotect_on);
XMSG(msg_cannot_do_that);
XMSG(msg_done);
XMSG(msg_matches_several_groups);
XMSG(msg_matches_several_items);
XMSG(msg_set);
XMSG(msg_group);
XMSG(msg_group_doesnt_exist);
XMSG(msg_item_doesnt_exist);
XMSG(msg_in_that_group);
XMSG(msg_no_access);
XMSG(msg_cant_find_set_keyword);
XMSG(msg_i_dont_understand);
XMSG(msg_dont_touch_this);
XMSG(msg_news_report);
XMSG(msg_news_list);
XMSG(msg_unread);
XMSG(msg_no_news);
XMSG(msg_internal_error);
XMSG(msg_seensplit);
XMSG(msg_seen_bad_pattern);
XMSG(msg_never_seen_match);
XMSG(msg_helpset_language);
XMSG(msg_unknown_unit);
XMSG(msg_convert_length);
XMSG(msg_convert_temperature);
XMSG(msg_convert_mass);
XMSG(msg_convert_volume);
XMSG(msg_convert_area);
XMSG(msg_specify_tz);
XMSG(msg_unknown_zone);
XMSG(msg_time_equals_time_in);
XMSG(msg_current_time);
XMSG(msg_pattern_doesnt_match);
XMSG(msg_limit_searchpattern);
XMSG(msg_ahead_of);
XMSG(msg_behind);
XMSG(msg_is_the_same_as);
XMSG(msg_no_currency_info);
XMSG(msg_no_country_or_currency);
XMSG(msg_currency_is);
XMSG(msg_permission_denied);
XMSG(msg_channel_not_invite_only);
XMSG(msg_could_not_delete_news);
XMSG(msg_news_removed);
XMSG(msg_news_added);
XMSG(msg_failed_to_send_news);
XMSG(msg_cant_ban_banprotected);
XMSG(msg_cant_delete_current_server);
XMSG(msg_could_not_find_server);
XMSG(msg_server_removed);
XMSG(msg_server_not_in_list);
XMSG(msg_said);
XMSG(msg_ago);
XMSG(msg_i_have_tells);
XMSG(msg_msg);
XMSG(msg_msgs);
XMSG(msg_news_items);
XMSG(msg_you_have_more);
XMSG(msg_no_msgs_or_news);
XMSG(msg_please_join_channel);
XMSG(msg_message_stored);
XMSG(msg_error_message_pattern);
XMSG(msg_had_been_removed);
XMSG(msg_not_your_messageid);
XMSG(msg_no_such_id);
XMSG(msg_you_have_stored_these);
XMSG(msg_tell_list_empty);
XMSG(msg_warn_nick_collide);
XMSG(msg_is_joined_now);
XMSG(msg_regged_user_with_nick);
XMSG(msg_not_his_nick);
XMSG(msg_who_is_now);
XMSG(msg_most_recently_used_by);
XMSG(msg_from_which_host);
XMSG(msg_most_often_used_by);
XMSG(msg_and_also_most_often_used);
XMSG(msg_x_not_found);
XMSG(msg_is_from);
XMSG(msg_cannot_find_info);
XMSG(msg_has_country_code);
XMSG(msg_has_country_assuming);
XMSG(msg_is_unknown);
XMSG(msg_thanks_for_ops);
XMSG(msg_slaps_for_deop);
XMSG(msg_alert_banlist_full);
XMSG(msg_available_languages);
XMSG(msg_spy_hidden_command);
XMSG(msg_spy_who_did_what);
XMSG(msg_spy_auth_failed);
XMSG(msg_helpset_opprotect);

#endif /* LANGUAGE_H */
