#ifdef RCS
static char rcsid[]="$Id: list.c,v 1.1.1.1 2000/11/13 02:42:45 holsta dancer.c $";
#endif
/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/list.c,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:45 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#include "list.h"
#include <stdlib.h>
#include <string.h>


/* --- InsertFirst ------------------------------------------------ */

void InsertFirst(void *list, void *entry)
{
  if (list && entry) {
    ((header *)entry)->prev = NULL;
    if (((header *)entry)->next = ((header *)list)->next) {
      ((header *)(((header *)list)->next))->prev = entry;
    }
    else { /* List was empty so this is also the last entry */
      ((header *)list)->prev = entry;
    }
    ((header *)list)->next = entry;
  }
}

/* --- InsertLast ------------------------------------------------- */

void InsertLast(void *list, void *entry)
{
  if (list && entry) {
    ((header *)entry)->next = NULL;
    if (((header *)entry)->prev = ((header *)list)->prev) {
      ((header *)(((header *)list)->prev))->next = entry;
    }
    else { /* List was empty so this is also the first entry */
      ((header *)list)->next = entry;
    }
    ((header *)list)->prev = entry;
  }
}

/* --- InsertEntry ------------------------------------------------ */

void InsertEntry(void *list, void *entry, void *after)
{
  if (list && entry) {
    if (after) {
      if (((header *)entry)->next = ((header *)after)->next) {
        ((header *)(((header *)after)->next))->prev = entry;
      }
      else {
        ((header *)list)->prev = entry;
      }
      ((header *)entry)->prev = after;
      ((header *)after)->next = entry;
    }
    else { /* InsertFirst */
      ((header *)entry)->prev = NULL;
      if (((header *)entry)->next = ((header *)list)->next) {
        ((header *)(((header *)list)->next))->prev = entry;
      }
      else { /* List was empty so this is also the last entry */
        ((header *)list)->prev = entry;
      }
      ((header *)list)->next = entry;
    }
  }
}

/* --- RemoveEntry ------------------------------------------------ */

void RemoveEntry(void *list, void *entry)
{
  if (list && entry) {
    if (((header *)entry)->next) {
      ((header *)(((header *)entry)->next))->prev = ((header *)entry)->prev;
    }
    else { /* Last entry */
      ((header *)list)->prev = ((header *)entry)->prev;
    }
    if (((header *)entry)->prev) {
      ((header *)(((header *)entry)->prev))->next = ((header *)entry)->next;
    }
    else { /* First entry */
      ((header *)list)->next = ((header *)entry)->next;
    }
  }
}

/* --- DeleteEntry ------------------------------------------------ */

void DeleteEntry(void *list, void *entry, void (*cleanerFunc)(void *))
{
  if (list && entry) {
    RemoveEntry(list, entry);
    if (cleanerFunc)
      (*cleanerFunc)(entry);
    free(entry);
  }
}

/* --- FlushList -------------------------------------------------- */

void FlushList(void *list, void (*cleanerFunc)(void *))
{
  void *v, *next;

  if (list) {
    for (v = ((header *)list)->next; v; v = next) {
      next = ((header *)v)->next;
      if (cleanerFunc)
        (*cleanerFunc)(v);
      free(v);
    }
    ((header *)list)->next = ((header *)list)->prev = NULL;
  }
}

/* --- List_DeleteList -------------------------------------------- */

void List_DeleteList(void **list, void (*cleanerFunc)(void *))
{
  if (list && *list) {
    FlushList(*list, cleanerFunc);
    free(*list);
    *list = NULL;
  }
}

/* --- FreeList --------------------------------------------------- */

void FreeList(void *v)
{
  itemlist *l;

  l = (itemlist *)v;
  if (l) {
    if (l->pointer)
      free(l->pointer);
  }
}

/* --- SortList --------------------------------------------------- */

void SortList(void *list, int offset)
{
  void *v, *vv, *next;

  if (list) {
    for (v = ((header *)list)->next; v; v = next) {
      while ((next = ((header *)v)->next) && (0 < strcasecmp(*(char **)((long)v + offset), *(char **)((long)next + offset) ))) {
        for (vv = ((header *)list)->next; vv; vv = ((header *)vv)->next) {
          if (0 < strcasecmp(*(char **)((long)vv + offset), *(char **)((long)next + offset))) {
            RemoveEntry(list, next);
            InsertEntry(list, next, ((header *)vv)->prev);
            break;
          }
        }
      }
    }
  }
}
