/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/list.h,v $
 * $Revision: 1.2 $
 * $Date: 2003/05/29 12:26:59 $
 * $Author: elho $
 * $State: Exp $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef LIST_H
#define LIST_H

#ifndef NULL
#define NULL 0
#endif

typedef struct Header {
  void *next;
  void *prev;
} header;

typedef struct Liststruct {
  struct Header h;
  void *pointer;
} itemlist;

/* First returns the first entry in a list */
#define First(list) ((NULL == (list)) ? NULL : ((header *)(list))->next)
/* Last returns the last entry in a list */
#define Last(list)  ((NULL == (list)) ? NULL : ((header *)(list))->prev)

/* Next returns the next entry relative to the given entry */
#define Next(entry) (((header *)(entry))->next)
/* Prev returns the previous entry relative to the given entry */
#define Prev(entry) (((header *)(entry))->prev)

/* Emptylist proves TRUE if there are no entries in the list */
#define EmptyList(list) \
  ((NULL == (list)) || (NULL == ((header *)(list))->next))

/* NewList creates a header for a list of the specified type */
#define NewList(type) (type *)calloc(1, sizeof(type))

/* NewEntry allocates a new entry of the specified type */
#define NewEntry(type) (type *)calloc(1, sizeof(type))

#define RemoveFirst(list) RemoveEntry((list), (list).h->next)
#define RemoveLast(list)  RemoveEntry((list), (list).h->prev)

/* Move entry from source-list to the first entry in target-list */
#define MoveFirst(source, entry, target) \
  do { \
    RemoveEntry((source), (entry)); \
    InsertFirst((target), (entry)); \
  } while (0)

/* Move entry from source-list to the last entry in target-list */
#define MoveLast(source, entry, target) \
  do { \
    RemoveEntry((source), (entry)); \
    InsertLast((target), (entry)); \
  } while (0)


/* Insert entry as the first entry in a list */
void InsertFirst(void *list, void *entry);
/* Insert entry as the last entry in a list */
void InsertLast(void *list, void *entry);
/* Insert entry into a list after another entry */
void InsertEntry(void *list, void *entry, void *after);
/* Remove entry from a list */
void RemoveEntry(void *list, void *entry);
/* Remove entry from a list and free the resources */
void DeleteEntry(void *list, void *entry, void (*cleanerFunc)(void *));

/* Remove all entries except the header */
void FlushList(void *list, void (*cleanerFunc)(void *));
/* Remove an entire list including the header */
#define DeleteList(list, cleanerFunc) \
        List_DeleteList((void **)&(list), (cleanerFunc))
void List_DeleteList(void **list, void (*cleanerFunc)(void *));

/* Aux func for itemlist */
void FreeList(void *);

/* Sorts the list into alphabetical order; use the offsetof macro to
   calculate the offset of the member (beware of NULL pointers) */
void SortList(void *list, int offset);

#endif /* LIST_H */
