/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/seen.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:47 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef SEEN_H
#define SEEN_H

#include "dancer.h"
#include "user.h"

typedef struct Auxstruct {
  struct Auxstruct *link;   /* all nick belonging to the same nick */
  struct Auxstruct *next;   /* for hash table */
  struct Seenstruct *root;
  char *nick;
  long count;
  time_t departure; /* 4.0beta3 entry */
  ulong signature;
} itemaux;

typedef struct Seenstruct {
  struct Seenstruct *link;   /* single-list of all users */
  struct Seenstruct *next;   /* next chained collided hash entry */
  struct Auxstruct *first;   /* head of single list of all nick for this user */
  char *usite;               /* This is the key */
  char *host;                /* This is only used for wildcards */
  time_t departure;
  int type;
  char *by;
  char *msg;
  ulong signature;
} itemseen;

enum seentypes {
  SEENLEAVE = 1, SEENQUIT,     SEENKICK,
  SEENLEFT,      SEENQUITED,   SEENKICKED,
  SEENERROR,     SEENCHANGE
};


bool SeenInit(void);
void SeenCleanup(void);
void Seen(char *, char *);
void SeenNick(char *, char *, char);
void SeenMatch(char *, char *);
void SeenInsert(itemguest *, int, char *, char *);
void SeenInsertAll(int, char *, char *);
void SeenSave(void);
itemaux *SeenMostNick(char *);
itemaux *SeenRecentNick(char *);

#endif /* SEEN_H */
