/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* thumbnail_table.h */

#ifndef __THUMBNAIL_TABLE_H__

#define __THUMBNAIL_TABLE_H__

#include <gtk/gtk.h>
#include "main.h"
#include "option_menu.h"
#include "thumbnail.h"
#include "typedefs.h"

/* Constant definitions */
#define TYPE_JPG   1
#define TYPE_BMP   2
#define TYPE_PNG   4
#define TYPE_XPM   8
#define TYPE_XBM  16
#define TYPE_TIF  32
#define TYPE_GIF  64
#define TYPE_PCX 128

#define THUMBNAIL_TABLE_ROWS_BASE  384

/* Structures */

/* Public functions */
void thumbnail_table_init_structure             (ThumbnailTable*      );

void thumbnail_table_destroy_structure          (ThumbnailTable*      );

void thumbnail_table_create                     (TopLevel*        , 
                                                 gchar*           ,
                                                 gboolean             );

void thumbnail_table_reload_all                 (TopLevel*        , 
                                                 gboolean             );

void thumbnail_table_refresh                    (TopLevel*            );

void thumbnail_table_set_position_after_refresh (TopLevel*        ,
                                                 gint             ,
                                                 gint                 );

void thumbnail_table_display_prev_page          (TopLevel*            );

void thumbnail_table_display_next_page          (TopLevel*            );

void thumbnail_table_display_current_page       (TopLevel*         ,
                                                 gint              ,
                                                 gint                 );

/*
 * Delete this line because configure_event will be emitted only when
 * the window is moved.
 * -- It seems that configure_event will not be emitted when the window  
 *    is resized.
 */
/*
void thumbnail_table_cb_configure               (GtkWidget*        , 
                                                 GdkEventConfigure*,
                                                 gpointer             );
*/

#endif  /* __THUMBNAIL_TABLE_H__ */

