<?xml version="1.0" encoding="utf-8"?>

<!--
 template for converting darcs' `annotate` output from XML to XHTML.  This
 template expects the following external variables:

   cgi-program    - path to the CGI executable, to place in links
   sort-by        - field to sort by
   stylesheet     - path to the CSS stylesheet

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:include href="common.xslt"/>

  <xsl:template match="path">
    <h1 class="target">
      annotations for <span class="path"><xsl:apply-templates/></span>
    </h1>
  </xsl:template>

  <!-- patch annotate tags -->
  <xsl:template match="/darcs/patch">
    <h2 class="patch">
      patch "<span class="path"><xsl:value-of select="name"/></span>"
    </h2>
  </xsl:template>
  
  <xsl:template match="summary">
    <table>
      <tr class="annotate">
        <th>file</th>
        <th>change</th>
        <th></th>
        <th></th>
      </tr>

      <xsl:apply-templates/>
    </table>
  </xsl:template>
  
  <xsl:template match="modify_file">
    <xsl:variable name="file" select="text()"/>
    <xsl:variable name="hash" select="/darcs/patch/@hash" />
      
    <tr class="modified-file">
      <td><xsl:value-of select="$file"/></td>

      <td class="line-count">
        <xsl:for-each select="added_lines">
          +<xsl:value-of select="@num"/>/
        </xsl:for-each>
        <xsl:for-each select="removed_lines">-<xsl:value-of select="@num"/>
        </xsl:for-each>
        lines
      </td>

      <td><a href="{$command}{$file}?c=annotate&amp;p={$hash}">annotate</a></td>
      <td><a href="{$command}{$file}?c=patches">patches</a></td>
    </tr>
  </xsl:template>

  <xsl:template match="add_file">
    <xsl:variable name="file" select="text()"/>
    <xsl:variable name="hash" select="/darcs/patch/@hash" />
    
    <tr class="add-remove-file">
      <td><xsl:value-of select="$file"/></td>
      <td>added file</td>
      <td><a href="{$command}{$file}?c=annotate&amp;p={$hash}">annotate</a></td>
      <td><a href="{$command}{$file}?c=patches">patches</a></td>
    </tr>
  </xsl:template>

  <xsl:template match="move_file">
    <xsl:variable name="file" select="text()"/>
    <xsl:variable name="hash" select="/darcs/patch/@hash" />
    
    <tr class="add-remove-file">
      <td><xsl:value-of select="$file"/></td>
      <td>moved file</td>
      <td><a href="{$command}{$file}?c=annotate&amp;p={$hash}">annotate</a></td>
      <td><a href="{$command}{$file}?c=patches">patches</a></td>
    </tr>
  </xsl:template>

  <xsl:template match="remove_file">
    <xsl:variable name="file" select="text()"/>
    <xsl:variable name="hash" select="/darcs/patch/@hash" />
    
    <tr class="add-remove-file">
      <td><xsl:value-of select="$file"/></td>
      <td>removed file</td>
      <td><a href="{$command}{$file}?c=annotate&amp;p={$hash}">annotate</a></td>
      <td><a href="{$command}{$file}?c=patches">patches</a></td>
    </tr>
  </xsl:template>

  <xsl:template match="add_directory">
    <xsl:variable name="dir" select="text()"/>
    <xsl:variable name="hash" select="/darcs/patch/@hash" />
    
    <tr class="add-remove-file">
      <td><xsl:value-of select="$dir"/></td>
      <td>added directory</td>
      <td><a href="{$command}{$dir}/?c=annotate&amp;p={$hash}">annotate</a></td>
      <td><a href="{$command}{$dir}/?c=patches">patches</a></td>
    </tr>
  </xsl:template>

  <xsl:template match="remove_directory">
    <xsl:variable name="dir" select="text()"/>
    <xsl:variable name="hash" select="/darcs/patch/@hash" />
    
    <tr class="add-remove-file">
      <td><xsl:value-of select="$dir"/></td>
      <td>removed directory</td>
      <td><a href="{$command}{$dir}/?c=annotate&amp;p={$hash}">annotate</a></td>
      <td><a href="{$command}{$dir}/?c=patches">patches</a></td>
    </tr>
  </xsl:template>
  
  <!-- directory annotate templates -->
  <xsl:template match="/darcs/directory">
    <xsl:variable name="patch" select="modified/patch/name"/>
    
    <h2 class="patch">
      patch "<span class="path"><xsl:value-of select="$patch"/></span>"
    </h2>

    <table>
      <tr class="annotate">
        <th>file</th>
        <th>change</th>
        <th></th>
        <th></th>
      </tr>

      <xsl:apply-templates/>
    </table>
  </xsl:template>
  
  <xsl:template match="directory/modified/modified_how">
    <xsl:variable name="hash" select="../patch/@hash" />
    <xsl:variable name="how" select="substring(text(), 0, 10)"/>
    <xsl:variable name="target" select="/darcs/@target"/>

    <!--
      annotating a directory outputs the directory itself as well as
      any contents.  this ugly code checks if the matching element is
      the original directory so that the 'annotate' and 'patch' links
      don't append the directory twice.
    -->
    <xsl:variable name="last" select="//darcs/path/directory[last()]"/>
    <xsl:variable name="name" select="../../@name"/>
    <xsl:variable name="dir">
      <xsl:choose>
        <xsl:when test="$last = $name"></xsl:when>
        <xsl:otherwise><xsl:value-of select="$name"/>/</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <tr class="add-remove-file">
      <td><xsl:value-of select="$name"/></td>
      <td>
        <xsl:choose>
          <xsl:when test="$how = 'Dir added'">added directory</xsl:when>
          <xsl:when test="$how = 'Dir moved'">moved directory</xsl:when>
          <xsl:when test="$how = 'Dir remov'">removed directory</xsl:when>
        </xsl:choose>
      </td>
      <td>
        <a href="{$command}{$dir}?c=annotate&amp;p={$hash}">annotate</a>
      </td>
      <td><a href="{$command}{$dir}?c=patches">patches</a></td>
    </tr>
  </xsl:template>

  <xsl:template match="directory/file/modified/modified_how">
    <xsl:variable name="file" select="../../@name"/>
    <xsl:variable name="hash" select="../patch/@hash" />
    <xsl:variable name="how" select="substring(text(), 0, 11)"/>
    
    <tr class="add-remove-file">
      <td><xsl:value-of select="$file"/></td>
      <td>
        <xsl:choose>
          <xsl:when test="$how = 'File added'">added file</xsl:when>
          <xsl:when test="$how = 'File moved'">moved file</xsl:when>
          <xsl:when test="$how = 'File remov'">removed file</xsl:when>
        </xsl:choose>
      </td>
      <td><a href="{$command}{$file}?c=annotate&amp;p={$hash}">annotate</a></td>
      <td><a href="{$command}{$file}?c=patches">patches</a></td>
    </tr>
  </xsl:template>
   
  <!-- file annotate templates -->
  <xsl:template match="/darcs/file/modified/modified_how">
    <h2 class="patch">
      patch "<span class="path"><xsl:value-of select="../patch/name"/></span>"
    </h2>

    <!-- don't display table of changes when file's contents are modified -->
    <xsl:if test="text() != 'File modified'">
      <xsl:variable name="file" select="../../@name"/>
      <xsl:variable name="hash" select="../patch/@hash" />
      <xsl:variable name="how" select="substring(text(), 0, 11)"/>
      
      <table>
        <tr class="annotate">
          <th>file</th>
          <th>change</th>
          <th></th>
          <th></th>
        </tr>

        <tr class="add-remove-file">
          <td><xsl:value-of select="$file"/></td>
          <td>
            <xsl:choose>
              <xsl:when test="$how = 'File added'">added file</xsl:when>
              <xsl:when test="$how = 'File moved'">moved file</xsl:when>
              <xsl:when test="$how = 'File remov'">removed file</xsl:when>
            </xsl:choose>
          </td>
          <td><a href="{$command}?c=annotate&amp;p={$hash}">annotate</a></td>
          <td><a href="{$command}?c=patches">patches</a></td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="added_line">
    <xsl:variable name="hash" select="*/patch/@hash"/>
    
    <pre>
      <a class="added-line" href="{$command}?c=annotate&amp;p={$hash}">
        <xsl:value-of select="text()"/>
      </a><br/>
    </pre>
  </xsl:template>

  <xsl:template match="normal_line">
    <xsl:variable name="hash" select="*/patch/@hash"/>
    
    <pre>
      <a class="normal-line" href="{$command}?c=annotate&amp;p={$hash}">
        <xsl:value-of select="text()"/>
      </a><br/>
    </pre>
  </xsl:template>

  <xsl:template match="removed_line">
    <xsl:variable name="hash" select="*/patch/@hash"/>
    
    <!-- don't display removed lines when a file is removed -->
    <xsl:if test="../modified/modified_how/text() != 'File removed'">
      <pre>
        <a class="removed-line" href="{$command}?c=annotate&amp;p={$hash}">
          <xsl:value-of select="text()"/>
        </a><br/>
      </pre>
    </xsl:if>
  </xsl:template>

  <!-- ignore <name>, <comment> and <modified_how> children -->
  <xsl:template match="name"/>
  <xsl:template match="comment"/>
  <xsl:template match="modified_how"/>
</xsl:stylesheet>
