module Main where

import Data.List (intersperse)
import System.Environment (getArgs)
import System.IO (hGetContents, stdin)

main :: IO ()
main = do [modulename, varname] <- getArgs
          thedata <- hGetContents stdin
          let pretty_data = concat $ intersperse "\\n\\\n \\"
                          $ map (init . tail . show) $ lines thedata
          putStrLn $ "module " ++ modulename ++ " (" ++ varname ++ ") where"
          putStrLn $ varname ++ " :: String"
          putStrLn $ varname ++ " = \"" ++ pretty_data ++ "\""

