#!/usr/bin/env perl

# Some tests for 'darcs mv'

use lib ('lib/perl');
use Test::More tests => 4;
use Test::Darcs;
use Cwd;
use Shell::Command;
use strict;
use Carp;

cleanup 'temp1';
mkdir 'temp1';
chdir 'temp1';
darcs 'init';

###

my $test_name = 'adding a directory with more than one ../ in it should work.';
mkpath('foo.d/second/third','foo.d/other') || die "mkpath failed: $!";

my $out = `ls ./foo.d/other`;
print $out;

touch './foo.d/other/date.t';
darcs qw/add -r foo.d/;

chdir 'foo.d/second/third';

my $mv_out = darcs qw!mv ../../other/date.t ../../other/date_moved.t!;
unlike($mv_out, qr/darcs failed/, $test_name);

TODO: {
    local $TODO = 'waiting on code for mv to work with absolute paths.';

    touch 'abs_path.t';
    darcs qw/add abs_path.t/;

    {
        my $mv_out =  darcs 'mv ', cwd(),qw!/abs_path.t abs_path_new.t!;
        unlike($mv_out, qr/darcs failed/, 'mv should work with absolute path as a src argument.');
    }
    {
        my $mv_out = darcs 'mv ', qw!/abs_path.t !, cwd(), qw!/abs_path_new.t!;
        unlike($mv_out, qr/darcs failed/, 'mv should work with absolute path as a target argument.');
    }

}

###

chdir '../../../';
cleanup 'temp1';
ok((!-d 'temp1'), 'temp1 directory was deleted');




