#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs

rm -rf temp1
mkdir temp1
cd temp1
$DARCS init
echo hello world > foo
$DARCS add foo
$DARCS record -a -m add -A x
echo goodbye world >> foo
echo y/y | tr / \\012 | $DARCS revert
cmp foo _darcs/pristine/foo

# Now let's test a trickier revert where changes commute nontrivially.

cat > foo <<EOF
a
b
c
d
e
EOF

$DARCS record -a -A me -m cleanup

mv foo foo.tmp
cat foo.tmp | grep -v b | grep -v d > foo

echo "nyy" | $DARCS revert

DARCS_DONT_COLOR=1 $DARCS wh > whatsnew
cat > correct <<EOF
{
hunk ./foo 2
-b
}
EOF
diff -u correct whatsnew

# Try a situation where earlier (kept) changes are depended upon by the
# changes we want to revert:

$DARCS record -a -A me -m cleanup

echo hello world > bar
$DARCS add bar
$DARCS replace hello goodbye bar

echo "nnyy/y" | tr / \\012 | $DARCS revert

DARCS_DONT_COLOR=1 $DARCS wh > whatsnew
cat > correct <<EOF
{
addfile ./bar
hunk ./bar 1
+hello world
}
EOF
diff -u correct whatsnew

cd ..
rm -rf temp1

