
module RawMode (get_raw_mode, set_raw_mode) where

#ifdef WIN32

import Monad ( liftM )
import DarcsUtils ( catchall )
import System.Posix.Internals ( getEcho, setCooked, setEcho )

get_raw_mode :: IO Bool
get_raw_mode = not `liftM` getEcho 0
  `catchall` return False -- getEcho sometimes fails when called from scripts

set_raw_mode :: Bool -> IO ()
set_raw_mode raw = setCooked 0 normal >> setEcho 0 normal
 where normal = not raw

#else

get_raw_mode :: IO Bool
get_raw_mode = return False

set_raw_mode :: Bool -> IO ()
set_raw_mode _ = return ()

#endif

