#!/usr/bin/env perl

# Issue244
# darcs changes should be able to pull up the history for a file 
#   using its moved and not-yet recorded new name");

# Also find the right path from the bugs directory. 
use lib ('lib/perl', '../tests/lib/perl');
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;

$ENV{EMAIL} = 'tester';

cleanup 'temp1';
ok(mkpath('temp1'), "temp1 created");
ok(chdir('temp1'), "chdir temp1");
darcs 'init';

touch 'b';
darcs 'add b';
darcs 'rec -am 11';
darcs 'mv b c';
like(darcs('changes c'), qr/11/, "changes should be able to show the history for a file moved and not-yet recorded using the new name");
