#!/usr/bin/env perl

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use File::Slurp;
use strict;
use File::Temp 'tempdir';
chdir tempdir( CLEANUP => 1 );

mkpath 'temp1';
chdir 'temp1';
darcs 'init';
mkpath 'foo';

write_file "foo/bar","hello world\n"; 
write_file "foo/baz","hello world\n"; 

mkpath 'foo/dir';
darcs 'add foo foo/bar foo/dir foo/baz';
darcs 'record -a -m add ';
cleanup 'foo';
like(darcs('show files --no-pending --no-dir'), qr(foo/baz));
like(darcs('show files --no-pending --no-dir'), qr(foo/bar));
like(darcs('show files --no-pending --no-fil'), qr(foo/dir));
like(darcs('show files --no-pending --no-fil'), qr(foo));
darcs 'record -a -m del ';
unlike(darcs('show files --no-pending --no-dir'), qr(foo/baz));
unlike(darcs('show files --no-pending --no-dir'), qr(foo/bar));
unlike(darcs('show files --no-pending --no-fil'), qr(foo/dir));
unlike(darcs('show files --no-pending --no-fil'), qr(foo));
chdir '..';

cleanup 'temp1';
cleanup 'temp2';
