#!/usr/bin/env perl

# issue157: A test for how rollback handles dependencies and conflicts. 

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use File::Slurp;
use strict;
use warnings;
use File::Temp 'tempdir';
chdir tempdir( CLEANUP => 1 );

# setup
 ok(mkpath('temp1'), "temp1 created");
 ok(chdir('temp1'), "chdir temp1");
 darcs 'init --darcs-2';

# Create three patches
    write_file 'foo','a';
    darcs 'record -lam AA';
    write_file 'foo','b';
    darcs 'record  -lam BB';
    write_file 'foo','c';
    darcs 'record  -lam CC';

# Rollback the last one
   darcs "rollback -a -p CC -m 'rollback CC'";
   like(read_file('foo'), qr/b/, "reality check");

# Now get just the first two patches into a new repo...ignoring the third patch and the rollback.
  ok(chdir '..');
  darcs 'get --to-patch BB temp1 temp2';
  ok((chdir 'temp2'));

# Now in the second repo, rollback the second patch.
  darcs "rollback -a -p BB -m 'rollback BB'";
  like(read_file('foo'), qr/a/, "reality check");

  # finally, pull the third patch and the rollback of it. 
  # Because the two patches should cancel each other other, there should be no change here. 
  darcs 'pull -a ../temp1';

  like(read_file('foo'), qr/^v v v.*a.*b/ms, "expect a conflict between the contents being 'a' or 'b' ");
