#!/usr/bin/env perl

# Some tests for 'darcs unpull'

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use Carp 'verbose';

init_tmp_repo();

touch 'a.txt';
darcs "add a.txt";
darcs "record -a -m 'adding a' a.txt";

touch 'b.txt';
darcs "add b.txt";
darcs "record -a -m 'adding b' b.txt";

like(
  echo_to_darcs("unpull -p add","an"),
  qr/really unpull/i, 
  "additional confirmation is given when 'all' option is selected");

like(
  echo_to_darcs("unpull --last 1","n"),
  qr/adding b/, 
  "unpull --last 1 gives expected result");


# Add a patch that depends on 'adding a' and try to unpull 'adding a'

`date >> a.txt`;
darcs "record -a -m 'modifying a' a.txt";

like(
  echo_to_darcs("unpull -p 'adding a'","n"),
  qr/modifying a/ && qr/No patches selected/,
  "unpull asks about depending patches");
