/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _PREVIEW_INFO_H_
#define _PREVIEW_INFO_H_

class QImage;
class QByteArray;
#include "RawImageInfo.h"

class PreviewInfo {
  public:
    PreviewInfo( RawImageInfoSP _rawImageInfo, int _width, int _height, const QByteArray& _data, bool _isSixteenBits);
    ~PreviewInfo();
    int width() const;
    int height() const;
    const QByteArray& data() const;
    bool isSixteenBits() const;
    QImage asQImage() const;
    /**
     * Add this preview info to be managed by the cache
     */
    void appendToCache( );
  private:
    struct Private;
    Private* const d;
};

#endif
