/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public abstract class PredicatedNodeTest
extends NodeTest
implements SubContextList {
    protected transient boolean m_foundLast = false;
    protected LocPathIterator m_lpi;
    transient int m_predicateIndex = -1;
    private Expression[] m_predicates;
    protected transient int[] m_proximityPositions;
    static final boolean DEBUG_PREDICATECOUNTING = false;

    PredicatedNodeTest() {
    }

    PredicatedNodeTest(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short acceptNode(int n) {
        XPathContext xPathContext;
        block6: {
            short s;
            xPathContext = this.m_lpi.getXPathContext();
            try {
                try {
                    xPathContext.pushCurrentNode(n);
                    XObject xObject = this.execute(xPathContext, n);
                    if (xObject == NodeTest.SCORE_NONE) break block6;
                    if (this.getPredicateCount() > 0) {
                        this.countProximityPosition(0);
                        if (!this.executePredicates(n, xPathContext)) {
                            short s2 = 3;
                            Object var5_7 = null;
                            xPathContext.popCurrentNode();
                            return s2;
                        }
                    }
                    s = 1;
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException(transformerException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            Object var5_8 = null;
            xPathContext.popCurrentNode();
            return s;
        }
        Object var5_9 = null;
        xPathContext.popCurrentNode();
        return 3;
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getPredicate(n2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PredicatedNodeTest predicatedNodeTest = (PredicatedNodeTest)super.clone();
        if (this.m_proximityPositions != null && this.m_proximityPositions == predicatedNodeTest.m_proximityPositions) {
            predicatedNodeTest.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, predicatedNodeTest.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        if (predicatedNodeTest.m_lpi == this) {
            predicatedNodeTest.m_lpi = (LocPathIterator)predicatedNodeTest;
        }
        return predicatedNodeTest;
    }

    protected void countProximityPosition(int n) {
        if (n < this.m_proximityPositions.length) {
            int n2 = n;
            this.m_proximityPositions[n2] = this.m_proximityPositions[n2] + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean executePredicates(int n, XPathContext xPathContext) throws TransformerException {
        block10: {
            boolean bl;
            block9: {
                int n2 = this.getPredicateCount();
                if (n2 == 0) {
                    return true;
                }
                PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
                try {
                    this.m_predicateIndex = 0;
                    xPathContext.pushSubContextList(this);
                    xPathContext.pushNamespaceContext(this.m_lpi.getPrefixResolver());
                    xPathContext.pushCurrentNode(n);
                    int n3 = 0;
                    while (n3 < n2) {
                        XObject xObject = this.m_predicates[n3].execute(xPathContext);
                        if (xObject.getType() == 2) {
                            int n4 = this.getProximityPosition(this.m_predicateIndex);
                            if (n4 != (int)xObject.num()) {
                                boolean bl2 = false;
                                Object var7_10 = null;
                                xPathContext.popCurrentNode();
                                xPathContext.popNamespaceContext();
                                xPathContext.popSubContextList();
                                this.m_predicateIndex = -1;
                                return bl2;
                            }
                            if (this.m_predicates[n3].isStableNumber()) {
                                this.m_foundLast = true;
                            }
                        } else if (!xObject.bool()) {
                            bl = false;
                            break block9;
                        }
                        this.countProximityPosition(++this.m_predicateIndex);
                        ++n3;
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    xPathContext.popCurrentNode();
                    xPathContext.popNamespaceContext();
                    xPathContext.popSubContextList();
                    this.m_predicateIndex = -1;
                    throw throwable;
                }
            }
            Object var7_11 = null;
            xPathContext.popCurrentNode();
            xPathContext.popNamespaceContext();
            xPathContext.popSubContextList();
            this.m_predicateIndex = -1;
            return bl;
        }
        Object var7_12 = null;
        xPathContext.popCurrentNode();
        xPathContext.popNamespaceContext();
        xPathContext.popSubContextList();
        this.m_predicateIndex = -1;
        return true;
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        int n2 = this.getPredicateCount();
        int n3 = 0;
        while (n3 < n2) {
            this.m_predicates[n3].fixupVariables(vector, n);
            ++n3;
        }
    }

    public abstract int getLastPos(XPathContext var1);

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    protected int getProximityPosition(int n) {
        return n >= 0 ? this.m_proximityPositions[n] : 0;
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition();
    }

    protected void initPredicateInfo(Compiler compiler, int n) throws TransformerException {
        int n2 = compiler.getFirstPredicateOpPos(n);
        if (n2 > 0) {
            this.m_predicates = compiler.getCompiledPredicates(n2);
        }
    }

    public void initProximityPosition(int n) throws TransformerException {
        this.m_proximityPositions[n] = 0;
    }

    public boolean isReverseAxes() {
        return false;
    }

    protected String nodeToString(int n) {
        if (n != -1) {
            DTM dTM = this.m_lpi.getXPathContext().getDTM(n);
            return String.valueOf(dTM.getNodeName(n)) + "{" + (n + 1) + "}";
        }
        return "null";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_predicateIndex = -1;
            this.resetProximityPositions();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public void resetProximityPositions() {
        int n = this.getPredicateCount();
        if (n > 0) {
            if (this.m_proximityPositions == null) {
                this.m_proximityPositions = new int[n];
            }
            int n2 = 0;
            while (n2 < n) {
                try {
                    this.initProximityPosition(n2);
                }
                catch (Exception exception) {
                    throw new WrappedRuntimeException(exception);
                }
                ++n2;
            }
        }
    }

    public void setLocPathIterator(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    public void setPredicateCount(int n) {
        if (n > 0) {
            Expression[] expressionArray = new Expression[n];
            int n2 = 0;
            while (n2 < n) {
                expressionArray[n2] = this.m_predicates[n2];
                ++n2;
            }
            this.m_predicates = expressionArray;
        } else {
            this.m_predicates = null;
        }
    }
}

