/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class WalkingIterator
extends LocPathIterator {
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;

    protected WalkingIterator(PrefixResolver prefixResolver) {
        super(prefixResolver);
    }

    WalkingIterator(Compiler compiler, int n, int n2, boolean bl) throws TransformerException {
        super(compiler, n, n2, bl);
        int n3 = OpMap.getFirstChildPos(n);
        if (bl) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, n3, 0);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WalkingIterator walkingIterator = (WalkingIterator)super.clone();
        if (this.m_firstWalker != null) {
            walkingIterator.m_firstWalker = this.m_firstWalker.cloneDeep(walkingIterator, null);
        }
        return walkingIterator;
    }

    public void detach() {
        this.m_lastUsedWalker = null;
        super.detach();
    }

    public void fixupVariables(Vector vector, int n) {
        this.m_predicateIndex = -1;
        AxesWalker axesWalker = this.m_firstWalker;
        while (axesWalker != null) {
            axesWalker.fixupVariables(vector, n);
            axesWalker = axesWalker.getNextWalker();
        }
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public int nextNode() {
        if (this.m_cachedNodes != null) {
            if (this.m_next < this.m_cachedNodes.size()) {
                this.m_lastFetched = this.m_currentContextNode = this.m_cachedNodes.elementAt(this.m_next);
                int n = this.m_currentContextNode;
                this.incrementNextPosition();
                return n;
            }
            if (this.m_foundLast) {
                this.m_lastFetched = -1;
                return -1;
            }
        }
        if (this.m_stackFrame == -1) {
            if (this.m_firstWalker.getRoot() == -1) {
                this.setNextPosition(0);
                this.m_firstWalker.setRoot(this.m_context);
                this.m_lastUsedWalker = this.m_firstWalker;
            }
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack variableStack = this.m_execContext.getVarStack();
        int n = variableStack.getStackFrame();
        variableStack.setStackFrame(this.m_stackFrame);
        if (this.m_firstWalker.getRoot() == -1) {
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(this.m_context);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
        int n2 = this.returnNextNode(this.m_firstWalker.nextNode());
        variableStack.setStackFrame(n);
        return n2;
    }

    public void reset() {
        super.reset();
        if (this.m_firstWalker != null) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
        }
    }

    public final void setLastUsedWalker(AxesWalker axesWalker) {
        this.m_lastUsedWalker = axesWalker;
    }
}

