/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.ConnectionPoolManager;
import org.apache.xalan.lib.sql.DefaultConnectionPool;
import org.apache.xalan.lib.sql.QueryParameter;
import org.apache.xalan.lib.sql.SQLDocument;
import org.apache.xalan.lib.sql.SQLErrorDocument;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBooleanStatic;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XConnection {
    private static final boolean DEBUG = false;
    private ConnectionPool m_ConnectionPool = null;
    private boolean m_DefaultPoolingEnabled = false;
    private Vector m_OpenSQLDocuments = new Vector();
    private ConnectionPoolManager m_PoolMgr = new ConnectionPoolManager();
    private Vector m_ParameterList = new Vector();
    private SQLErrorDocument m_Error = null;
    private boolean m_IsDefaultPool = false;
    private boolean m_IsStreamingEnabled = false;

    public XConnection() {
    }

    public XConnection(ExpressionContext expressionContext, String string) {
        this.connect(expressionContext, string);
    }

    public XConnection(ExpressionContext expressionContext, String string, String string2) {
        this.connect(expressionContext, string, string2);
    }

    public XConnection(ExpressionContext expressionContext, String string, String string2, String string3, String string4) {
        this.connect(expressionContext, string, string2, string3, string4);
    }

    public XConnection(ExpressionContext expressionContext, String string, String string2, Element element) {
        this.connect(expressionContext, string, string2, element);
    }

    public XConnection(ExpressionContext expressionContext, NodeList nodeList) {
        this.connect(expressionContext, nodeList);
    }

    public void addParameter(String string) {
        this.addParameterWithType(string, null);
    }

    public void addParameterFromElement(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("type");
        Node node2 = element.getFirstChild();
        if (node2 != null) {
            String string = node2.getNodeValue();
            if (string == null) {
                string = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(string, node.getNodeValue()));
        }
    }

    public void addParameterFromElement(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.addParameters((Element)nodeList.item(n2));
            ++n2;
        }
    }

    public void addParameterWithType(String string, String string2) {
        this.m_ParameterList.addElement(new QueryParameter(string, string2));
    }

    private void addParameters(Element element) {
        Node node = element.getFirstChild();
        if (node == null) {
            return;
        }
        do {
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("type");
            String string = node2 == null ? "string" : node2.getNodeValue();
            Node node3 = node.getFirstChild();
            if (node3 == null) continue;
            String string2 = node3.getNodeValue();
            if (string2 == null) {
                string2 = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(string2, string));
        } while ((node = node.getNextSibling()) != null);
    }

    private void buildErrorDocument(ExpressionContext expressionContext, Exception exception) {
        try {
            DTMManager dTMManager = ((XPathContext.XPathExpressionContext)expressionContext).getDTMManager();
            DTMManagerDefault dTMManagerDefault = (DTMManagerDefault)dTMManager;
            int n = dTMManagerDefault.getFirstFreeDTMID();
            this.m_Error = new SQLErrorDocument(dTMManager, n << 20, exception);
            dTMManagerDefault.addDTM(this.m_Error, n);
        }
        catch (Exception exception2) {
            this.m_Error = null;
        }
    }

    private void buildErrorDocument(ExpressionContext expressionContext, SQLException sQLException) {
        try {
            DTMManager dTMManager = ((XPathContext.XPathExpressionContext)expressionContext).getDTMManager();
            DTMManagerDefault dTMManagerDefault = (DTMManagerDefault)dTMManager;
            int n = dTMManagerDefault.getFirstFreeDTMID();
            this.m_Error = new SQLErrorDocument(dTMManager, n << 20, sQLException);
            dTMManagerDefault.addDTM(this.m_Error, n);
        }
        catch (Exception exception) {
            this.m_Error = null;
        }
    }

    public void clearParameters() {
        this.m_ParameterList.removeAllElements();
    }

    public void close() throws SQLException {
        while (this.m_OpenSQLDocuments.size() != 0) {
            SQLDocument sQLDocument = (SQLDocument)this.m_OpenSQLDocuments.elementAt(0);
            sQLDocument.close();
            this.m_OpenSQLDocuments.removeElementAt(0);
        }
    }

    public void close(SQLDocument sQLDocument) throws SQLException {
        int n = this.m_OpenSQLDocuments.size();
        int n2 = 0;
        while (n2 < n) {
            SQLDocument sQLDocument2 = (SQLDocument)this.m_OpenSQLDocuments.elementAt(n2);
            if (sQLDocument2 == sQLDocument) {
                sQLDocument2.close();
                this.m_OpenSQLDocuments.removeElementAt(n2);
            }
            ++n2;
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, String string) {
        try {
            this.m_ConnectionPool = this.m_PoolMgr.getPool(string);
            if (this.m_ConnectionPool == null) {
                throw new IllegalArgumentException("Invalid Pool Name");
            }
            this.m_IsDefaultPool = false;
            return new XBooleanStatic(true);
        }
        catch (Exception exception) {
            this.buildErrorDocument(expressionContext, exception);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, String string, String string2) {
        try {
            this.init(string, string2, new Properties());
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.buildErrorDocument(expressionContext, sQLException);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.buildErrorDocument(expressionContext, exception);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, String string, String string2, String string3, String string4) {
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", string3);
            ((Hashtable)properties).put("password", string4);
            this.init(string, string2, properties);
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.buildErrorDocument(expressionContext, sQLException);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.buildErrorDocument(expressionContext, exception);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, String string, String string2, Element element) {
        try {
            Properties properties = new Properties();
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                ((Hashtable)properties).put(namedNodeMap.item(n).getNodeName(), namedNodeMap.item(n).getNodeValue());
                ++n;
            }
            this.init(string, string2, properties);
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.buildErrorDocument(expressionContext, sQLException);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.buildErrorDocument(expressionContext, exception);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, Element element) {
        try {
            this.initFromElement(element);
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.buildErrorDocument(expressionContext, sQLException);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.buildErrorDocument(expressionContext, exception);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext expressionContext, NodeList nodeList) {
        try {
            this.initFromElement((Element)nodeList.item(0));
            return new XBooleanStatic(true);
        }
        catch (SQLException sQLException) {
            this.buildErrorDocument(expressionContext, sQLException);
            return new XBooleanStatic(false);
        }
        catch (Exception exception) {
            this.buildErrorDocument(expressionContext, exception);
            return new XBooleanStatic(false);
        }
    }

    public void disableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = false;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (!this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.setPoolEnabled(false);
    }

    public void disableStreamingMode() {
        this.m_IsStreamingEnabled = false;
    }

    public void enableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = true;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.setPoolEnabled(true);
    }

    public void enableStreamingMode() {
        this.m_IsStreamingEnabled = true;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {}
    }

    public DTM getError() {
        return this.m_Error;
    }

    private void init(String string, String string2, Properties properties) throws SQLException {
        String string3;
        ConnectionPool connectionPool;
        String string4;
        Connection connection = null;
        String string5 = properties.getProperty("user");
        if (string5 == null) {
            string5 = "";
        }
        if ((string4 = properties.getProperty("password")) == null) {
            string4 = "";
        }
        if ((connectionPool = this.m_PoolMgr.getPool(string3 = String.valueOf(string) + string2 + string5 + string4)) == null) {
            DefaultConnectionPool defaultConnectionPool = new DefaultConnectionPool();
            defaultConnectionPool.setDriver(string);
            defaultConnectionPool.setURL(string2);
            if (this.m_DefaultPoolingEnabled) {
                defaultConnectionPool.setPoolEnabled(true);
            }
            this.m_PoolMgr.registerPool(string3, defaultConnectionPool);
            this.m_ConnectionPool = defaultConnectionPool;
        }
        this.m_IsDefaultPool = true;
        try {
            try {
                connection = this.m_ConnectionPool.getConnection();
            }
            catch (SQLException sQLException) {
                if (connection != null) {
                    this.m_ConnectionPool.releaseConnectionOnError(connection);
                    connection = null;
                }
                throw sQLException;
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.m_ConnectionPool.releaseConnection(connection);
            throw throwable;
        }
        this.m_ConnectionPool.releaseConnection(connection);
    }

    private void initFromElement(Element element) throws SQLException {
        Properties properties = new Properties();
        String string = "";
        String string2 = "";
        Node node = element.getFirstChild();
        if (node == null) {
            return;
        }
        do {
            Object object;
            Object object2;
            String string3;
            if ((string3 = node.getNodeName()).equalsIgnoreCase("dbdriver")) {
                string = "";
                object2 = node.getFirstChild();
                if (object2 != null) {
                    string = object2.getNodeValue();
                }
            }
            if (string3.equalsIgnoreCase("dburl")) {
                string2 = "";
                object2 = node.getFirstChild();
                if (object2 != null) {
                    string2 = object2.getNodeValue();
                }
            }
            if (string3.equalsIgnoreCase("password")) {
                object2 = "";
                object = node.getFirstChild();
                if (object != null) {
                    object2 = object.getNodeValue();
                }
                ((Hashtable)properties).put("password", object2);
            }
            if (string3.equalsIgnoreCase("user")) {
                object2 = "";
                object = node.getFirstChild();
                if (object != null) {
                    object2 = object.getNodeValue();
                }
                ((Hashtable)properties).put("user", object2);
            }
            if (!string3.equalsIgnoreCase("protocol")) continue;
            object2 = "";
            object = node.getAttributes();
            Node node2 = object.getNamedItem("name");
            if (node2 == null) continue;
            String string4 = "";
            object2 = node2.getNodeValue();
            Node node3 = node.getFirstChild();
            if (node3 != null) {
                string4 = node3.getNodeValue();
            }
            ((Hashtable)properties).put(object2, string4);
        } while ((node = node.getNextSibling()) != null);
        this.init(string, string2, properties);
    }

    public DTM pquery(ExpressionContext expressionContext, String string) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            Object object2;
            try {
                connection = this.m_ConnectionPool.getConnection();
                statement = connection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (connection != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(connection);
                    }
                }
                catch (Exception exception) {}
                throw sQLException;
            }
            try {
                object2 = this.m_ParameterList.elements();
                int n = 1;
                while (object2.hasMoreElements()) {
                    object = (QueryParameter)object2.nextElement();
                    this.setParameter(n, (PreparedStatement)statement, (QueryParameter)object);
                    ++n;
                }
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (connection != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(connection);
                    }
                }
                catch (Exception exception) {}
                throw sQLException;
            }
            object2 = ((XPathContext.XPathExpressionContext)expressionContext).getDTMManager();
            object = (DTMManagerDefault)object2;
            int n = ((DTMManagerDefault)object).getFirstFreeDTMID();
            SQLDocument sQLDocument = new SQLDocument((DTMManager)object2, n << 20, this.m_ConnectionPool, connection, statement, resultSet, this.m_IsStreamingEnabled);
            if (sQLDocument != null) {
                ((DTMManagerDefault)object).addDTM(sQLDocument, n);
                this.m_OpenSQLDocuments.addElement(sQLDocument);
                return sQLDocument;
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.buildErrorDocument(expressionContext, sQLException);
            return null;
        }
        catch (Exception exception) {
            this.buildErrorDocument(expressionContext, exception);
            return null;
        }
    }

    public DTM pquery(ExpressionContext expressionContext, String string, String string2) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            Object object2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                object = (QueryParameter)this.m_ParameterList.elementAt(n);
                if (object != null) {
                    ((QueryParameter)object).setType((String)object2);
                }
                ++n;
            }
            try {
                connection = this.m_ConnectionPool.getConnection();
                statement = connection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (connection != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(connection);
                    }
                }
                catch (Exception exception) {}
                throw sQLException;
            }
            try {
                object2 = this.m_ParameterList.elements();
                n = 1;
                while (object2.hasMoreElements()) {
                    object = (QueryParameter)object2.nextElement();
                    this.setParameter(n, (PreparedStatement)statement, (QueryParameter)object);
                    ++n;
                }
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (connection != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(connection);
                    }
                }
                catch (Exception exception) {}
                throw sQLException;
            }
            object2 = ((XPathContext.XPathExpressionContext)expressionContext).getDTMManager();
            object = (DTMManagerDefault)object2;
            int n2 = ((DTMManagerDefault)object).getFirstFreeDTMID();
            SQLDocument sQLDocument = new SQLDocument((DTMManager)object2, n2 << 20, this.m_ConnectionPool, connection, statement, resultSet, this.m_IsStreamingEnabled);
            if (sQLDocument != null) {
                ((DTMManagerDefault)object).addDTM(sQLDocument, n2);
                this.m_OpenSQLDocuments.addElement(sQLDocument);
                return sQLDocument;
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.buildErrorDocument(expressionContext, sQLException);
            return null;
        }
        catch (Exception exception) {
            this.buildErrorDocument(expressionContext, exception);
            return null;
        }
    }

    public DTM query(ExpressionContext expressionContext, String string) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        DTMManagerDefault dTMManagerDefault = null;
        SQLDocument sQLDocument = null;
        try {
            if (this.m_ConnectionPool == null) {
                return null;
            }
            try {
                connection = this.m_ConnectionPool.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (connection != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(connection);
                    }
                }
                catch (Exception exception) {}
                throw sQLException;
            }
            DTMManager dTMManager = ((XPathContext.XPathExpressionContext)expressionContext).getDTMManager();
            dTMManagerDefault = (DTMManagerDefault)dTMManager;
            int n = dTMManagerDefault.getFirstFreeDTMID();
            sQLDocument = new SQLDocument(dTMManager, n << 20, this.m_ConnectionPool, connection, statement, resultSet, this.m_IsStreamingEnabled);
            if (sQLDocument != null) {
                dTMManagerDefault.addDTM(sQLDocument, n);
                this.m_OpenSQLDocuments.addElement(sQLDocument);
                return sQLDocument;
            }
            return null;
        }
        catch (SQLException sQLException) {
            if (sQLDocument != null && dTMManagerDefault != null) {
                sQLDocument.closeOnError();
                dTMManagerDefault.release(sQLDocument, true);
            }
            this.buildErrorDocument(expressionContext, sQLException);
            return null;
        }
        catch (Exception exception) {
            if (sQLDocument != null && dTMManagerDefault != null) {
                sQLDocument.closeOnError();
                dTMManagerDefault.release(sQLDocument, true);
            }
            this.buildErrorDocument(expressionContext, exception);
            return null;
        }
    }

    public void setParameter(int n, PreparedStatement preparedStatement, QueryParameter queryParameter) throws SQLException {
        Number number;
        String string = queryParameter.getType();
        if (string.equalsIgnoreCase("string")) {
            preparedStatement.setString(n, queryParameter.getValue());
        }
        if (string.equalsIgnoreCase("bigdecimal")) {
            preparedStatement.setBigDecimal(n, new BigDecimal(queryParameter.getValue()));
        }
        if (string.equalsIgnoreCase("boolean")) {
            number = new Integer(queryParameter.getValue());
            boolean bl = (Integer)number == 0;
            preparedStatement.setBoolean(n, bl);
        }
        if (string.equalsIgnoreCase("bytes")) {
            preparedStatement.setBytes(n, queryParameter.getValue().getBytes());
        }
        if (string.equalsIgnoreCase("date")) {
            preparedStatement.setDate(n, Date.valueOf(queryParameter.getValue()));
        }
        if (string.equalsIgnoreCase("double")) {
            number = new Double(queryParameter.getValue());
            preparedStatement.setDouble(n, (Double)number);
        }
        if (string.equalsIgnoreCase("float")) {
            number = new Float(queryParameter.getValue());
            preparedStatement.setFloat(n, ((Float)number).floatValue());
        }
        if (string.equalsIgnoreCase("long")) {
            number = new Long(queryParameter.getValue());
            preparedStatement.setLong(n, (Long)number);
        }
        if (string.equalsIgnoreCase("short")) {
            number = new Short(queryParameter.getValue());
            preparedStatement.setShort(n, (Short)number);
        }
        if (string.equalsIgnoreCase("time")) {
            preparedStatement.setTime(n, Time.valueOf(queryParameter.getValue()));
        }
        if (string.equalsIgnoreCase("timestamp")) {
            preparedStatement.setTimestamp(n, Timestamp.valueOf(queryParameter.getValue()));
        }
    }
}

