/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemSort;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.NodeSorter;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.xml.sax.ContentHandler;

public class ElemForEach
extends ElemTemplateElement {
    protected Expression m_selectExpression = null;
    protected Vector m_sortElems = null;

    public ElemTemplateElement appendChild(ElemTemplateElement elemTemplateElement) {
        int n = elemTemplateElement.getXSLToken();
        if (n == 64) {
            this.setSortElem((ElemSort)elemTemplateElement);
            return elemTemplateElement;
        }
        return super.appendChild(elemTemplateElement);
    }

    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        super.compose(stylesheetRoot);
        int n = this.getSortElemCount();
        int n2 = 0;
        while (n2 < n) {
            this.getSortElem(n2).compose(stylesheetRoot);
            ++n2;
        }
        Vector vector = stylesheetRoot.getComposeState().getVariableNames();
        if (this.m_selectExpression != null) {
            this.m_selectExpression.fixupVariables(vector, stylesheetRoot.getComposeState().getGlobalsSize());
        } else {
            this.m_selectExpression = this.getStylesheetRoot().m_selectDefault.getExpression();
        }
    }

    public void endCompose(StylesheetRoot stylesheetRoot) throws TransformerException {
        int n = this.getSortElemCount();
        int n2 = 0;
        while (n2 < n) {
            this.getSortElem(n2).endCompose(stylesheetRoot);
            ++n2;
        }
        super.endCompose(stylesheetRoot);
    }

    public void execute(TransformerImpl transformerImpl) throws TransformerException {
        transformerImpl.pushCurrentTemplateRuleIsNull(true);
        try {
            if (TransformerImpl.S_DEBUG) {
                transformerImpl.getTraceManager().fireTraceEvent(this);
            }
            this.transformSelectedNodes(transformerImpl);
        }
        finally {
            Object var3_2 = null;
            transformerImpl.popCurrentTemplateRuleIsNull();
        }
    }

    public String getNodeName() {
        return "for-each";
    }

    public Expression getSelect() {
        return this.m_selectExpression;
    }

    public ElemSort getSortElem(int n) {
        return (ElemSort)this.m_sortElems.elementAt(n);
    }

    public int getSortElemCount() {
        return this.m_sortElems == null ? 0 : this.m_sortElems.size();
    }

    protected ElemTemplateElement getTemplateMatch() {
        return this;
    }

    public int getXSLToken() {
        return 28;
    }

    public void setSelect(XPath xPath) {
        this.m_selectExpression = xPath.getExpression();
    }

    public void setSortElem(ElemSort elemSort) {
        if (this.m_sortElems == null) {
            this.m_sortElems = new Vector();
        }
        this.m_sortElems.addElement(elemSort);
    }

    public DTMIterator sortNodes(XPathContext xPathContext, Vector vector, DTMIterator dTMIterator) throws TransformerException {
        NodeSorter nodeSorter = new NodeSorter(xPathContext);
        dTMIterator.setShouldCacheNodes(true);
        dTMIterator.runTo(-1);
        xPathContext.pushContextNodeList(dTMIterator);
        try {
            nodeSorter.sort(dTMIterator, vector, xPathContext);
            dTMIterator.setCurrentPos(0);
        }
        finally {
            Object var6_5 = null;
            xPathContext.popContextNodeList();
        }
        return dTMIterator;
    }

    public void transformSelectedNodes(TransformerImpl transformerImpl) throws TransformerException {
        XPathContext xPathContext = transformerImpl.getXPathContext();
        int n = xPathContext.getCurrentNode();
        DTMIterator dTMIterator = this.m_selectExpression.asIterator(xPathContext, n);
        try {
            int n2;
            Vector vector;
            Vector vector2 = vector = this.m_sortElems == null ? null : transformerImpl.processSortKeys(this, n);
            if (vector != null) {
                dTMIterator = this.sortNodes(xPathContext, vector, dTMIterator);
            }
            if (TransformerImpl.S_DEBUG) {
                transformerImpl.getTraceManager().fireSelectedEvent(n, this, "select", new XPath(this.m_selectExpression), new XNodeSet(dTMIterator));
            }
            ResultTreeHandler resultTreeHandler = transformerImpl.getResultTreeHandler();
            ContentHandler contentHandler = resultTreeHandler.getContentHandler();
            xPathContext.pushCurrentNode(-1);
            int[] nArray = xPathContext.getCurrentNodeStack();
            int n3 = xPathContext.getCurrentNodeFirstFree() - 1;
            xPathContext.pushCurrentExpressionNode(-1);
            int[] nArray2 = xPathContext.getCurrentExpressionNodeStack();
            int n4 = xPathContext.getCurrentExpressionNodesFirstFree() - 1;
            xPathContext.pushSAXLocatorNull();
            xPathContext.pushContextNodeList(dTMIterator);
            transformerImpl.pushElemTemplateElement(null);
            DTM dTM = xPathContext.getDTM(n);
            int n5 = n & 0xFFC00000;
            while ((n2 = dTMIterator.nextNode()) != -1) {
                nArray[n3] = n2;
                nArray2[n4] = n2;
                if ((n2 & 0xFFC00000) != n5) {
                    dTM = xPathContext.getDTM(n2);
                    n5 = n & 0xFFC00000;
                }
                int n6 = dTM.getExpandedTypeID(n2);
                int n7 = n6 >> ExpandedNameTable.ROTAMOUNT_TYPE;
                if (TransformerImpl.S_DEBUG) {
                    transformerImpl.getTraceManager().fireTraceEvent(this);
                }
                ElemTemplateElement elemTemplateElement = this.m_firstChild;
                while (elemTemplateElement != null) {
                    xPathContext.setSAXLocator(elemTemplateElement);
                    transformerImpl.setCurrentElement(elemTemplateElement);
                    elemTemplateElement.execute(transformerImpl);
                    elemTemplateElement = elemTemplateElement.m_nextSibling;
                }
            }
        }
        finally {
            Object var6_18 = null;
            if (TransformerImpl.S_DEBUG) {
                transformerImpl.getTraceManager().fireSelectedEndEvent(n, this, "select", new XPath(this.m_selectExpression), new XNodeSet(dTMIterator));
            }
            xPathContext.popSAXLocator();
            xPathContext.popContextNodeList();
            transformerImpl.popElemTemplateElement();
            xPathContext.popCurrentExpressionNode();
            xPathContext.popCurrentNode();
            dTMIterator.detach();
        }
    }
}

