/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseTraversers
extends DTMDefaultBase {
    public DTMDefaultBaseTraversers(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl) {
        super(dTMManager, source, n, dTMWSFilter, xMLStringFactory, bl);
    }

    public DTMAxisTraverser getAxisTraverser(int n) {
        DTMAxisTraverser dTMAxisTraverser;
        if (this.m_traversers == null) {
            this.m_traversers = new DTMAxisTraverser[Axis.names.length];
            dTMAxisTraverser = null;
        } else {
            dTMAxisTraverser = this.m_traversers[n];
            if (dTMAxisTraverser != null) {
                return dTMAxisTraverser;
            }
        }
        switch (n) {
            case 0: {
                dTMAxisTraverser = new AncestorTraverser();
                break;
            }
            case 1: {
                dTMAxisTraverser = new AncestorOrSelfTraverser();
                break;
            }
            case 2: {
                dTMAxisTraverser = new AttributeTraverser();
                break;
            }
            case 3: {
                dTMAxisTraverser = new ChildTraverser();
                break;
            }
            case 4: {
                dTMAxisTraverser = new DescendantTraverser();
                break;
            }
            case 5: {
                dTMAxisTraverser = new DescendantOrSelfTraverser();
                break;
            }
            case 6: {
                dTMAxisTraverser = new FollowingTraverser();
                break;
            }
            case 7: {
                dTMAxisTraverser = new FollowingSiblingTraverser();
                break;
            }
            case 9: {
                dTMAxisTraverser = new NamespaceTraverser();
                break;
            }
            case 8: {
                dTMAxisTraverser = new NamespaceDeclsTraverser();
                break;
            }
            case 10: {
                dTMAxisTraverser = new ParentTraverser();
                break;
            }
            case 11: {
                dTMAxisTraverser = new PrecedingTraverser();
                break;
            }
            case 12: {
                dTMAxisTraverser = new PrecedingSiblingTraverser();
                break;
            }
            case 13: {
                dTMAxisTraverser = new SelfTraverser();
                break;
            }
            case 16: {
                dTMAxisTraverser = new AllFromRootTraverser();
                break;
            }
            case 14: {
                dTMAxisTraverser = new AllFromNodeTraverser();
                break;
            }
            case 15: {
                dTMAxisTraverser = new PrecedingAndAncestorTraverser();
                break;
            }
            case 17: {
                dTMAxisTraverser = new DescendantFromRootTraverser();
                break;
            }
            case 18: {
                dTMAxisTraverser = new DescendantOrSelfFromRootTraverser();
                break;
            }
            case 19: {
                dTMAxisTraverser = new RootTraverser();
                break;
            }
            case 20: {
                return null;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(168, new Object[]{Integer.toString(n)}));
            }
        }
        if (dTMAxisTraverser == null) {
            throw new DTMException("Axis traverser not supported: " + Axis.names[n]);
        }
        this.m_traversers[n] = dTMAxisTraverser;
        return dTMAxisTraverser;
    }

    private class AncestorTraverser
    extends DTMAxisTraverser {
        AncestorTraverser() {
        }

        public int next(int n, int n2) {
            return DTMDefaultBaseTraversers.this.m_parent.elementAt(n2 & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n, int n2, int n3) {
            n2 &= 0x3FFFFF;
            while ((n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2)) != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) != n3) continue;
                return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return -1;
        }
    }

    private class AncestorOrSelfTraverser
    extends AncestorTraverser {
        AncestorOrSelfTraverser() {
        }

        public int first(int n) {
            return n;
        }

        public int first(int n, int n2) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(n & 0x3FFFFF) == n2 ? n : this.next(n, n, n2);
        }
    }

    private class AttributeTraverser
    extends DTMAxisTraverser {
        AttributeTraverser() {
        }

        public int next(int n, int n2) {
            return n == n2 ? DTMDefaultBaseTraversers.this.getFirstAttribute(n) : DTMDefaultBaseTraversers.this.getNextAttribute(n2);
        }

        public int next(int n, int n2, int n3) {
            int n4 = n2 = n == n2 ? DTMDefaultBaseTraversers.this.getFirstAttribute(n) : DTMDefaultBaseTraversers.this.getNextAttribute(n2);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) != n3) continue;
                return n2;
            } while ((n2 = DTMDefaultBaseTraversers.this.getNextAttribute(n2)) != -1);
            return -1;
        }
    }

    private class ChildTraverser
    extends DTMAxisTraverser {
        ChildTraverser() {
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this._firstch(n & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int first(int n, int n2) {
            int n3 = n & 0x3FFFFF;
            int n4 = this.getNextIndexed(n3, DTMDefaultBaseTraversers.this._firstch(n3), n2);
            return n4 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        protected int getNextIndexed(int n, int n2, int n3) {
            int n4 = ExpandedNameTable.getNamespaceID(n3);
            int n5 = ExpandedNameTable.getLocalNameID(n3);
            while (true) {
                int n6;
                if ((n6 = DTMDefaultBaseTraversers.this.findElementFromIndex(n4, n5, n2)) != -2) {
                    int n7 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n6);
                    if (n7 == n) {
                        return n6;
                    }
                    if (n7 < n) {
                        return -1;
                    }
                    do {
                        if ((n7 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n7)) >= n) continue;
                        return -1;
                    } while (n7 > n);
                    n2 = n6 + 1;
                    continue;
                }
                DTMDefaultBaseTraversers.this.nextNode();
                if (DTMDefaultBaseTraversers.this.m_nextsib.elementAt(n) != -2) break;
            }
            return -1;
        }

        public int next(int n, int n2) {
            return DTMDefaultBaseTraversers.this._nextsib(n2 & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n, int n2, int n3) {
            n2 = DTMDefaultBaseTraversers.this._nextsib(n2 & 0x3FFFFF);
            while (n2 != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) == n3) {
                    return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                n2 = DTMDefaultBaseTraversers.this._nextsib(n2);
            }
            return -1;
        }
    }

    private abstract class IndexedDTMAxisTraverser
    extends DTMAxisTraverser {
        IndexedDTMAxisTraverser() {
        }

        protected abstract boolean axisHasBeenProcessed(int var1);

        protected int getNextIndexed(int n, int n2, int n3) {
            int n4 = ExpandedNameTable.getNamespaceID(n3);
            int n5 = ExpandedNameTable.getLocalNameID(n3);
            while (true) {
                int n6;
                if ((n6 = DTMDefaultBaseTraversers.this.findElementFromIndex(n4, n5, n2)) != -2) {
                    if (this.isAfterAxis(n, n6)) {
                        return -1;
                    }
                    return n6;
                }
                if (this.axisHasBeenProcessed(n)) break;
                DTMDefaultBaseTraversers.this.nextNode();
            }
            return -1;
        }

        protected abstract boolean isAfterAxis(int var1, int var2);

        protected final boolean isIndexed(int n) {
            return DTMDefaultBaseTraversers.this.m_indexing && ExpandedNameTable.ELEMENT == (n & ExpandedNameTable.MASK_NODETYPE);
        }
    }

    private class DescendantTraverser
    extends IndexedDTMAxisTraverser {
        DescendantTraverser() {
        }

        protected boolean axisHasBeenProcessed(int n) {
            return DTMDefaultBaseTraversers.this.m_nextsib.elementAt(n) != -2;
        }

        public int first(int n, int n2) {
            if (this.isIndexed(n2)) {
                int n3 = this.getSubtreeRoot(n);
                int n4 = this.getFirstPotential(n3);
                return this.getNextIndexed(n3, n4, n2) | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return this.next(n, n, n2);
        }

        protected int getFirstPotential(int n) {
            return n + 1;
        }

        protected int getSubtreeRoot(int n) {
            return n & 0x3FFFFF;
        }

        protected boolean isAfterAxis(int n, int n2) {
            do {
                if (n2 != n) continue;
                return false;
            } while ((n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2)) >= n);
            return true;
        }

        protected boolean isDescendant(int n, int n2) {
            return DTMDefaultBaseTraversers.this._parent(n2) >= n;
        }

        public int next(int n, int n2) {
            int n3 = this.getSubtreeRoot(n);
            n2 = (n2 & 0x3FFFFF) + 1;
            while (true) {
                short s = DTMDefaultBaseTraversers.this._type(n2);
                if (!this.isDescendant(n3, n2)) {
                    return -1;
                }
                if (s != 2 && s != 13) {
                    return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++n2;
            }
        }

        public int next(int n, int n2, int n3) {
            int n4 = this.getSubtreeRoot(n);
            n2 = (n2 & 0x3FFFFF) + 1;
            if (this.isIndexed(n3)) {
                return this.getNextIndexed(n4, n2, n3) | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            while (true) {
                int n5 = DTMDefaultBaseTraversers.this._exptype(n2);
                if (!this.isDescendant(n4, n2)) {
                    return -1;
                }
                if (n5 == n3) {
                    return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++n2;
            }
        }
    }

    private class DescendantOrSelfTraverser
    extends DescendantTraverser {
        DescendantOrSelfTraverser() {
        }

        public int first(int n) {
            return n;
        }

        protected int getFirstPotential(int n) {
            return n;
        }
    }

    private class AllFromNodeTraverser
    extends DescendantOrSelfTraverser {
        AllFromNodeTraverser() {
        }

        public int next(int n, int n2) {
            int n3 = n & 0x3FFFFF;
            n2 = (n2 & 0x3FFFFF) + 1;
            DTMDefaultBaseTraversers.this._exptype(n2);
            if (!this.isDescendant(n3, n2)) {
                return -1;
            }
            return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }
    }

    private class FollowingTraverser
    extends DescendantTraverser {
        FollowingTraverser() {
        }

        public int first(int n) {
            int n2;
            short s = DTMDefaultBaseTraversers.this._type(n);
            if ((s == 2 || s == 13) && (n2 = DTMDefaultBaseTraversers.this.getFirstChild(n = DTMDefaultBaseTraversers.this.getParent(n))) != -1) {
                return n2;
            }
            do {
                if ((n2 = DTMDefaultBaseTraversers.this.getNextSibling(n)) != -1) continue;
                n = DTMDefaultBaseTraversers.this.getParent(n);
            } while (n2 == -1 && n != -1);
            return n2;
        }

        public int first(int n, int n2) {
            int n3;
            short s = DTMDefaultBaseTraversers.this._type(n);
            if ((s == 2 || s == 13) && (n3 = DTMDefaultBaseTraversers.this.getFirstChild(n = DTMDefaultBaseTraversers.this.getParent(n))) != -1) {
                if (DTMDefaultBaseTraversers.this._exptype(n3) == n2) {
                    return n3;
                }
                return this.next(n, n3, n2);
            }
            do {
                if ((n3 = DTMDefaultBaseTraversers.this.getNextSibling(n)) != -1) {
                    if (DTMDefaultBaseTraversers.this._exptype(n3) == n2) {
                        return n3;
                    }
                    return this.next(n, n3, n2);
                }
                n = DTMDefaultBaseTraversers.this.getParent(n);
            } while (n3 == -1 && n != -1);
            return n3;
        }

        public int next(int n, int n2) {
            short s;
            do {
                if ((s = DTMDefaultBaseTraversers.this._type(++n2)) != -1) continue;
                return -1;
            } while (s == 2 || s == 13);
            return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n, int n2, int n3) {
            int n4;
            do {
                if ((n4 = DTMDefaultBaseTraversers.this._exptype(++n2)) != -1) continue;
                return -1;
            } while (n4 != n3);
            return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }
    }

    private class FollowingSiblingTraverser
    extends DTMAxisTraverser {
        FollowingSiblingTraverser() {
        }

        public int next(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getNextSibling(n2);
        }

        public int next(int n, int n2, int n3) {
            while ((n2 = DTMDefaultBaseTraversers.this.getNextSibling(n2)) != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2 & 0x3FFFFF) != n3) continue;
                return n2;
            }
            return -1;
        }
    }

    private class NamespaceDeclsTraverser
    extends DTMAxisTraverser {
        NamespaceDeclsTraverser() {
        }

        public int next(int n, int n2) {
            return n == n2 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, false);
        }

        public int next(int n, int n2, int n3) {
            int n4 = n2 = n == n2 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, false);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) != n3) continue;
                return n2;
            } while ((n2 = DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, false)) != -1);
            return -1;
        }
    }

    private class NamespaceTraverser
    extends DTMAxisTraverser {
        NamespaceTraverser() {
        }

        public int next(int n, int n2) {
            return n == n2 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, true);
        }

        public int next(int n, int n2, int n3) {
            int n4 = n2 = n == n2 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, true);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) != n3) continue;
                return n2;
            } while ((n2 = DTMDefaultBaseTraversers.this.getNextNamespaceNode(n, n2, true)) != -1);
            return -1;
        }
    }

    private class ParentTraverser
    extends DTMAxisTraverser {
        ParentTraverser() {
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this.m_parent.elementAt(n & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int first(int n, int n2) {
            n &= 0x3FFFFF;
            while ((n = DTMDefaultBaseTraversers.this.m_parent.elementAt(n)) != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n) != n2) continue;
                return n | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return -1;
        }

        public int next(int n, int n2) {
            return -1;
        }

        public int next(int n, int n2, int n3) {
            return -1;
        }
    }

    private class PrecedingTraverser
    extends DTMAxisTraverser {
        PrecedingTraverser() {
        }

        protected boolean isAncestor(int n, int n2) {
            n = DTMDefaultBaseTraversers.this.m_parent.elementAt(n);
            while (n != -1) {
                if (n == n2) {
                    return true;
                }
                n = DTMDefaultBaseTraversers.this.m_parent.elementAt(n);
            }
            return false;
        }

        public int next(int n, int n2) {
            int n3 = n & 0x3FFFFF;
            n2 = (n2 & 0x3FFFFF) - 1;
            while (n2 >= 0) {
                int n4 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2);
                short s = ExpandedNameTable.getType(n4);
                if (s != 2 && s != 13 && !this.isAncestor(n3, n2)) {
                    return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --n2;
            }
            return -1;
        }

        public int next(int n, int n2, int n3) {
            int n4 = n & 0x3FFFFF;
            n2 = (n2 & 0x3FFFFF) - 1;
            while (n2 >= 0) {
                int n5 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2);
                short s = ExpandedNameTable.getType(n5);
                if (n5 == n3 && !this.isAncestor(n4, n2)) {
                    return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --n2;
            }
            return -1;
        }
    }

    private class PrecedingAndAncestorTraverser
    extends DTMAxisTraverser {
        PrecedingAndAncestorTraverser() {
        }

        public int next(int n, int n2) {
            int n3 = n & 0x3FFFFF;
            n2 = (n2 & 0x3FFFFF) - 1;
            while (n2 >= 0) {
                int n4 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2);
                short s = ExpandedNameTable.getType(n4);
                if (s != 2 && s != 13) {
                    return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --n2;
            }
            return -1;
        }

        public int next(int n, int n2, int n3) {
            int n4 = n & 0x3FFFFF;
            n2 = (n2 & 0x3FFFFF) - 1;
            while (n2 >= 0) {
                int n5 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2);
                short s = ExpandedNameTable.getType(n5);
                if (n5 == n3) {
                    return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --n2;
            }
            return -1;
        }
    }

    private class PrecedingSiblingTraverser
    extends DTMAxisTraverser {
        PrecedingSiblingTraverser() {
        }

        public int next(int n, int n2) {
            return DTMDefaultBaseTraversers.this.getPreviousSibling(n2);
        }

        public int next(int n, int n2, int n3) {
            while ((n2 = DTMDefaultBaseTraversers.this.getPreviousSibling(n2)) != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2 & 0x3FFFFF) != n3) continue;
                return n2;
            }
            return -1;
        }
    }

    private class SelfTraverser
    extends DTMAxisTraverser {
        SelfTraverser() {
        }

        public int first(int n) {
            return n;
        }

        public int first(int n, int n2) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(n & 0x3FFFFF) == n2 ? n : -1;
        }

        public int next(int n, int n2) {
            return -1;
        }

        public int next(int n, int n2, int n3) {
            return -1;
        }
    }

    private class AllFromRootTraverser
    extends AllFromNodeTraverser {
        AllFromRootTraverser() {
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this.getDocument();
        }

        public int first(int n, int n2) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(DTMDefaultBaseTraversers.this.getDocument() & 0x3FFFFF) == n2 ? n : this.next(n, n, n2);
        }

        public int next(int n, int n2) {
            int n3 = n & 0x3FFFFF;
            short s = DTMDefaultBaseTraversers.this._type(n2 = (n2 & 0x3FFFFF) + 1);
            if (s == -1) {
                return -1;
            }
            return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n, int n2, int n3) {
            int n4 = n & 0x3FFFFF;
            n2 = (n2 & 0x3FFFFF) + 1;
            int n5;
            while ((n5 = DTMDefaultBaseTraversers.this._exptype(n2)) != -1) {
                if (n5 == n3) {
                    return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++n2;
            }
            return -1;
        }
    }

    private class RootTraverser
    extends AllFromRootTraverser {
        RootTraverser() {
        }

        public int next(int n, int n2) {
            return -1;
        }

        public int next(int n, int n2, int n3) {
            return -1;
        }
    }

    private class DescendantOrSelfFromRootTraverser
    extends DescendantTraverser {
        DescendantOrSelfFromRootTraverser() {
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this.getDocument();
        }

        protected int getFirstPotential(int n) {
            return n;
        }

        protected int getSubtreeRoot(int n) {
            return DTMDefaultBaseTraversers.this.getDocument() & 0x3FFFFF;
        }
    }

    private class DescendantFromRootTraverser
    extends DescendantTraverser {
        DescendantFromRootTraverser() {
        }

        public int first(int n) {
            return DTMDefaultBaseTraversers.this._firstch(0) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        protected int getFirstPotential(int n) {
            return DTMDefaultBaseTraversers.this._firstch(0);
        }

        protected int getSubtreeRoot(int n) {
            return 0;
        }
    }
}

