/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.type.ValidationException;

public class NamespaceReducer
extends ProxyReceiver {
    private int nscodeXML;
    private int nscodeNull;
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int countStackTop = 0;
    private int[] pendingUndeclarations = null;

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        NamePool namePool = configuration.getNamePool();
        this.nscodeXML = namePool.getNamespaceCode("xml", "http://www.w3.org/XML/1998/namespace");
        this.nscodeNull = namePool.getNamespaceCode("", "");
        super.setConfiguration(configuration);
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        super.startElement(n, n2, n3);
        if ((n3 & 0x80) != 0) {
            this.pendingUndeclarations = new int[this.namespacesSize];
            System.arraycopy(this.namespaces, 0, this.pendingUndeclarations, 0, this.namespacesSize);
        } else {
            this.pendingUndeclarations = null;
        }
        this.countStack[this.countStackTop] = 0;
        if (++this.countStackTop >= this.countStack.length) {
            int[] nArray = new int[this.countStackTop * 2];
            System.arraycopy(this.countStack, 0, nArray, 0, this.countStackTop);
            this.countStack = nArray;
        }
        if ((n3 & 0x40) == 0) {
            this.namespace(this.getNamePool().allocateNamespaceCode(n), 0);
        }
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.isNeeded(n)) {
            this.addToStack(n);
            int n3 = this.countStackTop - 1;
            this.countStack[n3] = this.countStack[n3] + 1;
            super.namespace(n, n2);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        if ((n3 & 0x200) != 0) {
            String string = charSequence.toString();
            if (string.indexOf(32) < 0) {
                this.checkQNamePrefix(string);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    this.checkQNamePrefix(string2);
                }
            }
            n3 &= 0xFFFFFDFF;
        }
        super.attribute(n, n2, charSequence, n3);
    }

    private void checkQNamePrefix(String string) throws ValidationException {
        try {
            String[] stringArray = Name.getQNameParts(string);
            if (stringArray[0].equals("")) {
                return;
            }
            short s = this.getConfiguration().getNamePool().getCodeForPrefix(stringArray[0]);
            if (s == -1) {
                throw new ValidationException("Unknown prefix in QName content " + Err.wrap(string));
            }
            int n = this.namespacesSize - 1;
            while (n >= 0) {
                if (this.namespaces[n] >> 16 == s) {
                    return;
                }
                --n;
            }
        }
        catch (QNameException qNameException) {
            throw new ValidationException("Invalid QName in content " + Err.wrap(string));
        }
        throw new ValidationException("Undeclared prefix in QName content " + Err.wrap(string));
    }

    private boolean isNeeded(int n) {
        int n2;
        if (n == this.nscodeXML) {
            return false;
        }
        if (this.pendingUndeclarations != null) {
            n2 = 0;
            while (n2 < this.pendingUndeclarations.length) {
                if (n >> 16 == this.pendingUndeclarations[n2] >> 16) {
                    this.pendingUndeclarations[n2] = -1;
                    break;
                }
                ++n2;
            }
        }
        n2 = this.namespacesSize - 1;
        while (n2 >= 0) {
            if (this.namespaces[n2] == n) {
                return false;
            }
            if (this.namespaces[n2] >> 16 == n >> 16) {
                return true;
            }
            --n2;
        }
        return n != this.nscodeNull;
    }

    private void addToStack(int n) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n;
    }

    public void startContent() throws TransformerException {
        if (this.pendingUndeclarations != null) {
            int n = 0;
            while (n < this.pendingUndeclarations.length) {
                int n2 = this.pendingUndeclarations[n];
                if (n2 != -1) {
                    super.namespace(n2 & 0xFFFF0000, 0);
                }
                ++n;
            }
        }
        this.pendingUndeclarations = null;
        super.startContent();
    }

    public void endElement() throws TransformerException {
        if (this.countStackTop-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        int n = this.countStack[this.countStackTop];
        this.namespacesSize -= n;
        super.endElement();
    }

    protected int getURICode(short s) {
        int n = this.namespacesSize - 1;
        while (n >= 0) {
            if (this.namespaces[n] >> 16 == s) {
                return this.namespaces[n] & 0xFFFF;
            }
            --n;
        }
        if (s == 0) {
            return 0;
        }
        return -1;
    }
}

