/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class SequenceChecker
extends ProxyReceiver
implements SequenceReceiver {
    private ItemType itemType;
    private int cardinality;
    private int count = 0;
    private int level = 0;
    private boolean atomize;
    private boolean allowAnyNode;
    private StringBuffer buffer = null;

    public void setRequiredType(SequenceType sequenceType) {
        this.itemType = sequenceType.getPrimaryType();
        this.cardinality = sequenceType.getCardinality();
        this.atomize = this.itemType instanceof AtomicType;
        this.allowAnyNode = this.itemType instanceof AnyItemType || this.itemType instanceof AnyNodeTest;
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (this.level++ == 0) {
            if (this.atomize) {
                this.buffer = new StringBuffer();
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(1, n2 & 0xFFFFF, n2)) {
                throw new TransformerException("This element node does not conform to the required type");
            }
        }
        super.startElement(n, n2, n3);
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(13, -1, -1)) {
                throw new TransformerException("The output sequence is not allowed to contain namespace nodes");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.namespace(n, n2);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new StringValue(charSequence).convert((AtomicType)this.itemType));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(2, n & 0xFFFFF, n2)) {
                throw new TransformerException("This attribute node does not conform to the required type");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.attribute(n, n2, charSequence, n3);
    }

    public void endElement() throws TransformerException {
        --this.level;
        if (this.buffer != null) {
            if (this.level == 0) {
                this.append(new UntypedAtomicValue(this.buffer));
                this.buffer = null;
                return;
            }
            return;
        }
        super.endElement();
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(charSequence));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).allowsTextNodes()) {
                throw new TransformerException("The output sequence is not allowed to contain text nodes");
            }
        } else if (this.buffer != null) {
            this.buffer.append((Object)charSequence);
            return;
        }
        super.characters(charSequence, n);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(charSequence));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(7, -1, -1)) {
                throw new TransformerException("The result sequence does not allow processing instructions");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.processingInstruction(string, charSequence, n);
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(charSequence));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(8, -1, -1)) {
                throw new TransformerException("The result sequence does not allow comment nodes");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.comment(charSequence, n);
    }

    public void append(Item item) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize && item instanceof NodeInfo) {
                Item item2;
                SequenceIterator sequenceIterator = item.getTypedValue(this.config);
                while ((item2 = sequenceIterator.next()) != null) {
                    this.append(item2);
                }
                return;
            }
            if (this.count == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.itemType.matchesItem(item)) {
                if (item instanceof UntypedAtomicValue) {
                    item = ((UntypedAtomicValue)item).convert((AtomicType)this.itemType);
                } else {
                    throw new TransformerException("The output sequence is not allowed to contain items of type " + Type.displayTypeName(item));
                }
            }
        }
        ((SequenceReceiver)this.baseReceiver).append(item);
        ++this.count;
    }

    public void finalCheck() throws TransformerException {
        if (this.count == 0 && (this.cardinality & 0x100) == 0) {
            throw new TransformerException("The output sequence is not allowed to be empty");
        }
    }
}

