/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.OutputURIResolver;

public class StandardOutputResolver
implements OutputURIResolver {
    private static StandardOutputResolver theInstance = new StandardOutputResolver();

    public static StandardOutputResolver getInstance() {
        return theInstance;
    }

    public Result resolve(String string, String string2) throws TransformerException {
        try {
            Object object;
            URI uRI;
            if (string.equals("")) {
                if (string2 == null) {
                    throw new TransformerException("The system identifier of the principal output file is unknown");
                }
                uRI = new URI(string2);
            } else {
                uRI = new URI(string);
            }
            if (!uRI.isAbsolute()) {
                if (string2 == null) {
                    throw new TransformerException("The system identifier of the principal output file is unknown");
                }
                object = new URI(string2);
                uRI = ((URI)object).resolve(string);
            }
            if (uRI.getScheme().equals("file")) {
                object = new File(uRI);
                try {
                    Object object2;
                    if (!((File)object).exists() && (object2 = ((File)object).getParent()) != null) {
                        File file = new File((String)object2);
                        if (file != null && !file.exists()) {
                            file.mkdirs();
                        }
                        ((File)object).createNewFile();
                    }
                    object2 = new StreamResult(((File)object).toURI().toASCIIString());
                    return object2;
                }
                catch (IOException iOException) {
                    throw new TransformerException("Failed to create output file " + uRI, iOException);
                }
            }
            object = uRI.toURL().openConnection();
            ((URLConnection)object).setDoInput(false);
            ((URLConnection)object).setDoOutput(true);
            ((URLConnection)object).connect();
            OutputStream outputStream = ((URLConnection)object).getOutputStream();
            StreamResult streamResult = new StreamResult(outputStream);
            streamResult.setSystemId(uRI.toASCIIString());
            return streamResult;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new TransformerException("Invalid syntax for base URI", uRISyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TransformerException("Invalid URI syntax", illegalArgumentException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TransformerException("Resolved URL is malformed", malformedURLException);
        }
        catch (UnknownServiceException unknownServiceException) {
            throw new TransformerException("Specified protocol does not allow output", unknownServiceException);
        }
        catch (IOException iOException) {
            throw new TransformerException("Cannot open connection to specified URL", iOException);
        }
    }

    public void close(Result result) throws TransformerException {
        OutputStream outputStream;
        if (result instanceof StreamResult && (outputStream = ((StreamResult)result).getOutputStream()) != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new TransformerException("Failed while closing output file", iOException);
            }
        }
    }
}

