/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.om.XMLChar;
import org.xml.sax.Locator;

public class XMLEmitter
extends Emitter {
    protected boolean empty = true;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    protected int elementCode;
    protected boolean preferHex = false;
    protected boolean undeclareNamespaces = false;
    private boolean warningIssued = false;
    protected Stack elementStack = new Stack();
    private String[] nameLookup = new String[1024];
    static boolean[] specialInText = new boolean[128];
    static boolean[] specialInAtt;
    private char[] charref = new char[10];

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws TransformerException {
    }

    protected void openDocument() throws TransformerException {
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.characterSet == null) {
            this.characterSet = UnicodeCharacterSet.getInstance();
        }
        this.writeDeclaration();
        String string = this.outputProperties.getProperty("{http://saxon.sf.net/}character-representation");
        if (string != null) {
            this.preferHex = string.trim().equalsIgnoreCase("hex");
        }
        if ((string = this.outputProperties.getProperty("{http://saxon.sf.net/}undeclare-namespaces")) != null) {
            this.undeclareNamespaces = string.trim().equalsIgnoreCase("yes");
        }
    }

    public void writeDeclaration() throws TransformerException {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String string;
            String string2;
            String string3;
            String string4 = this.outputProperties.getProperty("{http://saxon.sf.net/}byte-order-mark");
            if ("yes".equals(string4)) {
                this.writer.write(65279);
            }
            if ((string3 = this.outputProperties.getProperty("omit-xml-declaration")) == null) {
                string3 = "no";
            }
            if ((string2 = this.outputProperties.getProperty("version")) == null) {
                string2 = "1.0";
            }
            if ((string = this.outputProperties.getProperty("encoding")) == null || string.equalsIgnoreCase("utf8")) {
                string = "UTF-8";
            }
            if (string3.equals("yes") && !string.equalsIgnoreCase("UTF-8") || string.equalsIgnoreCase("utf-16") || string.equalsIgnoreCase("us-ascii") || string.equalsIgnoreCase("ascii")) {
                string3 = "no";
            }
            String string5 = this.outputProperties.getProperty("standalone");
            if (string3.equals("no")) {
                this.writer.write("<?xml version=\"" + string2 + "\" " + "encoding=\"" + string + "\"" + (string5 != null ? " standalone=\"" + string5 + "\"" : "") + "?>");
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected void writeDocType(String string, String string2, String string3) throws TransformerException {
        try {
            if (this.declarationIsWritten) {
                this.writer.write("\n");
            }
            this.writer.write("<!DOCTYPE " + string + "\n");
            if (string2 != null && string3 == null) {
                this.writer.write("  SYSTEM \"" + string2 + "\">\n");
            } else if (string2 == null && string3 != null) {
                this.writer.write("  PUBLIC \"" + string3 + "\">\n");
            } else {
                this.writer.write("  PUBLIC \"" + string3 + "\" \"" + string2 + "\">\n");
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void endDocument() throws TransformerException {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (this.empty) {
            this.openDocument();
        }
        String string = null;
        if (n < 1024) {
            string = this.nameLookup[n];
        }
        if (string == null) {
            int n4;
            string = this.namePool.getDisplayName(n);
            if (n < 1024) {
                this.nameLookup[n] = string;
            }
            if ((n4 = this.testCharacters(string)) != 0) {
                throw new TransformerException("Element name contains a character (decimal + " + n4 + ") not available in the selected encoding");
            }
        }
        this.elementStack.push(string);
        this.elementCode = n;
        try {
            if (this.empty) {
                String string2 = this.outputProperties.getProperty("doctype-system");
                String string3 = this.outputProperties.getProperty("doctype-public");
                if (string2 != null) {
                    this.writeDocType(string, string2, string3);
                }
                this.empty = false;
            }
            if (this.openStartTag) {
                this.closeStartTag(string, false);
            }
            this.writer.write(60);
            this.writer.write(string);
            this.openStartTag = true;
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void namespace(int n, int n2) throws TransformerException {
        try {
            String string = this.namePool.getPrefixFromNamespaceCode(n);
            String string2 = this.namePool.getURIFromNamespaceCode(n);
            if (string.equals("")) {
                this.writer.write(32);
                this.writeAttribute(this.elementCode, "xmlns", string2, 0);
            } else {
                int n3 = this.testCharacters(string);
                if (n3 != 0) {
                    throw new TransformerException("Namespace prefix contains a character (decimal + " + n3 + ") not available in the selected encoding");
                }
                if (this.undeclareNamespaces || !string2.equals("")) {
                    this.writer.write(32);
                    this.writeAttribute(this.elementCode, "xmlns:" + string, string2, 0);
                }
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        String string = null;
        if (n < 1024) {
            string = this.nameLookup[n];
        }
        if (string == null) {
            int n4;
            string = this.namePool.getDisplayName(n);
            if (n < 1024) {
                this.nameLookup[n] = string;
            }
            if ((n4 = this.testCharacters(string)) != 0) {
                throw new TransformerException("Attribute name contains a character (decimal + " + n4 + ") not available in the selected encoding");
            }
        }
        try {
            this.writer.write(32);
            this.writeAttribute(this.elementCode, string, charSequence, n3);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void startContent() throws TransformerException {
    }

    public void closeStartTag(String string, boolean bl) throws TransformerException {
        try {
            if (this.openStartTag) {
                if (bl) {
                    this.writer.write(this.emptyElementTagCloser(string));
                } else {
                    this.writer.write(62);
                }
                this.openStartTag = false;
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected String emptyElementTagCloser(String string) {
        return "/>";
    }

    protected void writeAttribute(int n, String string, CharSequence charSequence, int n2) throws TransformerException {
        try {
            String string2 = charSequence.toString();
            this.writer.write(string);
            if ((n2 & 4) != 0) {
                this.writer.write(61);
                this.writer.write(34);
                this.writer.write(string2);
                this.writer.write(34);
            } else if ((n2 & 0x100) != 0) {
                this.writer.write(61);
                int n3 = string2.indexOf(34) >= 0 ? 39 : 34;
                this.writer.write(n3);
                this.writeEscape(charSequence, true);
                this.writer.write(n3);
            } else {
                this.writer.write("=\"");
                this.writeEscape(charSequence, true);
                this.writer.write(34);
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected int testCharacters(CharSequence charSequence) throws TransformerException {
        int n = 0;
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            if (c > '\u007f') {
                if (XMLChar.isHighSurrogate(c)) {
                    int n2;
                    if (!this.characterSet.inCharset(n2 = XMLChar.supplemental(c, charSequence.charAt(++n)))) {
                        return n2;
                    }
                } else if (!this.characterSet.inCharset(c)) {
                    return c;
                }
            }
            ++n;
        }
        return 0;
    }

    public void endElement() throws TransformerException {
        String string = (String)this.elementStack.pop();
        try {
            if (this.openStartTag) {
                this.closeStartTag(string, true);
            } else {
                this.writer.write("</");
                this.writer.write(string);
                this.writer.write(62);
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (this.empty) {
            this.openDocument();
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag(null, false);
            }
            if ((n & 1) != 0) {
                if (this.testCharacters(charSequence) == 0) {
                    this.writer.write(charSequence.toString());
                } else {
                    if (!this.warningIssued) {
                        this.getConfiguration().getErrorListener().warning(new TransformerException("disable-output-escaping is ignored for characters not available in the chosen encoding"));
                        this.warningIssued = true;
                    }
                    this.writeEscape(charSequence, false);
                }
            } else {
                this.writeEscape(charSequence, false);
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (this.empty) {
            this.openDocument();
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag(null, false);
            }
            this.writer.write("<?" + string + (charSequence.length() > 0 ? ' ' + charSequence.toString() : "") + "?>");
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected void writeEscape(CharSequence charSequence, boolean bl) throws IOException {
        int n = 0;
        boolean bl2 = false;
        boolean[] blArray = bl ? specialInAtt : specialInText;
        while (n < charSequence.length()) {
            char c;
            int n2 = n;
            while (n2 < charSequence.length()) {
                c = charSequence.charAt(n2);
                if (c < '\u0080') {
                    if (blArray[c]) break;
                    ++n2;
                    continue;
                }
                if (XMLChar.isHighSurrogate(c) || !this.characterSet.inCharset(c)) break;
                ++n2;
            }
            if (n2 > n) {
                this.writer.write(charSequence.subSequence(n, n2).toString());
            }
            if (n2 >= charSequence.length()) {
                return;
            }
            c = charSequence.charAt(n2);
            if (c == '\u0000') {
                bl2 = !bl2;
            } else if (bl2) {
                this.writer.write(c);
            } else if (c > '\u007f') {
                if (XMLChar.isHighSurrogate(c)) {
                    char c2;
                    int n3;
                    if (this.characterSet.inCharset(n3 = XMLChar.supplemental(c, c2 = charSequence.charAt(++n2)))) {
                        this.writer.write(c);
                        this.writer.write(c2);
                    } else {
                        this.outputCharacterReference(n3);
                    }
                } else {
                    this.outputCharacterReference(c);
                }
            } else if (c == '<') {
                this.writer.write("&lt;");
            } else if (c == '>') {
                this.writer.write("&gt;");
            } else if (c == '&') {
                this.writer.write("&amp;");
            } else if (c == '\"') {
                this.writer.write("&#34;");
            } else if (c == '\n') {
                this.writer.write("&#xA;");
            } else if (c == '\r') {
                this.writer.write("&#xD;");
            } else if (c == '\t') {
                this.writer.write("&#x9;");
            }
            n = ++n2;
        }
    }

    protected void outputCharacterReference(int n) throws IOException {
        if (this.preferHex) {
            int n2 = 0;
            this.charref[n2++] = 38;
            this.charref[n2++] = 35;
            this.charref[n2++] = 120;
            String string = Integer.toHexString(n);
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                this.charref[n2++] = string.charAt(n4);
                ++n4;
            }
            this.charref[n2++] = 59;
            this.writer.write(this.charref, 0, n2);
        } else {
            int n5 = 0;
            this.charref[n5++] = 38;
            this.charref[n5++] = 35;
            String string = Integer.toString(n);
            int n6 = string.length();
            int n7 = 0;
            while (n7 < n6) {
                this.charref[n5++] = string.charAt(n7);
                ++n7;
            }
            this.charref[n5++] = 59;
            this.writer.write(this.charref, 0, n5);
        }
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        if (this.empty) {
            this.openDocument();
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag(null, false);
            }
            this.writer.write("<!--");
            this.writer.write(charSequence.toString());
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    static {
        int n = 0;
        while (n <= 127) {
            XMLEmitter.specialInText[n] = false;
            ++n;
        }
        XMLEmitter.specialInText[0] = true;
        XMLEmitter.specialInText[13] = true;
        XMLEmitter.specialInText[60] = true;
        XMLEmitter.specialInText[62] = true;
        XMLEmitter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        int n2 = 0;
        while (n2 <= 127) {
            XMLEmitter.specialInAtt[n2] = false;
            ++n2;
        }
        XMLEmitter.specialInAtt[0] = true;
        XMLEmitter.specialInAtt[13] = true;
        XMLEmitter.specialInAtt[10] = true;
        XMLEmitter.specialInAtt[9] = true;
        XMLEmitter.specialInAtt[60] = true;
        XMLEmitter.specialInAtt[62] = true;
        XMLEmitter.specialInAtt[38] = true;
        XMLEmitter.specialInAtt[34] = true;
    }
}

