/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class AppendExpression
extends BinaryExpression {
    public AppendExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public final ItemType getItemType() {
        ItemType itemType = this.operands[0].getItemType();
        ItemType itemType2 = this.operands[1].getItemType();
        return Type.getCommonSuperType(itemType, itemType2);
    }

    public final int computeCardinality() {
        int n = this.operands[0].getCardinality();
        int n2 = this.operands[1].getCardinality();
        if (this.operands[0] instanceof EmptySequence) {
            return n2;
        }
        if (this.operands[1] instanceof EmptySequence) {
            return n;
        }
        if ((n & 0x100) != 0 && (n2 & 0x100) != 0) {
            return 1792;
        }
        return 1536;
    }

    public Expression simplify() throws XPathException {
        this.operands[0] = this.operands[0].simplify();
        this.operands[1] = this.operands[1].simplify();
        if (this.operands[0] instanceof EmptySequence) {
            return this.operands[1];
        }
        if (this.operands[1] instanceof EmptySequence) {
            return this.operands[0];
        }
        if (this.isAtomicSequence()) {
            try {
                return new SequenceExtent(this.iterate(null));
            }
            catch (XPathException xPathException) {
                throw new XPathException.Static(xPathException);
            }
        }
        if (this.operands[0] instanceof Value && this.operands[1] instanceof AppendExpression && ((AppendExpression)this.operands[1]).operands[0] instanceof Value) {
            return new AppendExpression(new AppendExpression(this.operands[0], this.operator, ((AppendExpression)this.operands[1]).operands[0]), this.operator, ((AppendExpression)this.operands[1]).operands[1]).simplify();
        }
        return this;
    }

    private boolean isAtomicSequence() {
        return this.isAtomic(this.operands[0]) && this.isAtomic(this.operands[1]);
    }

    private boolean isAtomic(Expression expression) {
        return expression instanceof AtomicValue || expression instanceof SequenceExtent;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return new AppendIterator(this.operands[0].iterate(xPathContext), this.operands[1], xPathContext);
    }

    public static class AppendIterator
    implements SequenceIterator {
        private SequenceIterator first;
        private Expression second;
        private XPathContext context;
        private SequenceIterator currentIterator;

        public AppendIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) throws XPathException {
            this.first = sequenceIterator;
            this.second = expression;
            this.context = xPathContext;
            this.currentIterator = sequenceIterator;
        }

        public Item next() throws XPathException {
            Item item = this.currentIterator.next();
            if (item == null && this.currentIterator == this.first) {
                this.currentIterator = this.second.iterate(this.context);
                return this.currentIterator.next();
            }
            return item;
        }

        public Item current() {
            return this.currentIterator.current();
        }

        public int position() {
            if (this.currentIterator == this.first) {
                return this.first.position();
            }
            return this.first.position() + this.currentIterator.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new AppendIterator(this.first.getAnother(), this.second, this.context);
        }
    }
}

