/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

public class SingletonComparison
extends BinaryExpression {
    private AtomicComparer comparer;
    private boolean backwardsCompatible = false;

    public SingletonComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public void setComparator(Comparator comparator) {
        this.comparer = comparator instanceof AtomicComparer ? (AtomicComparer)comparator : new AtomicComparer(comparator);
    }

    public int computeCardinality() {
        return 512;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.backwardsCompatible = staticContext.isInBackwardsCompatibleMode();
        return super.analyze(staticContext);
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return false;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.operands[1].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return false;
        }
        try {
            return GeneralComparison.compare(atomicValue, this.operator, atomicValue2, this.comparer, this.backwardsCompatible);
        }
        catch (XPathException.Type type) {
            this.typeError(type.getMessage());
            return false;
        }
    }

    protected String displayOperator() {
        return "singleton " + super.displayOperator();
    }
}

