/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class ValueComparison
extends BinaryExpression {
    private AtomicComparer comparer;

    public ValueComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        Comparator comparator;
        Object object;
        int n;
        this.operands[0] = this.operands[0].analyze(staticContext);
        if (this.operands[0] instanceof EmptySequence) {
            return this.operands[0];
        }
        this.operands[1] = this.operands[1].analyze(staticContext);
        if (this.operands[1] instanceof EmptySequence) {
            return this.operands[1];
        }
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator roleLocator = new RoleLocator(1, Tokenizer.tokens[this.operator], 0);
        this.operands[0] = TypeChecker.staticTypeCheck(this.operands[0], sequenceType, false, roleLocator);
        RoleLocator roleLocator2 = new RoleLocator(1, Tokenizer.tokens[this.operator], 1);
        this.operands[1] = TypeChecker.staticTypeCheck(this.operands[1], sequenceType, false, roleLocator2);
        AtomicType atomicType = this.operands[0].getItemType().getAtomizedItemType();
        AtomicType atomicType2 = this.operands[1].getItemType().getAtomizedItemType();
        int n2 = atomicType.getPrimitiveType();
        if (n2 == 642) {
            n2 = 513;
        }
        if ((n = atomicType2.getPrimitiveType()) == 642) {
            n = 513;
        }
        if (!Type.isComparable(n2, n)) {
            boolean bl = Cardinality.allowsZero(this.operands[0].getCardinality());
            boolean bl2 = Cardinality.allowsZero(this.operands[1].getCardinality());
            if (bl || bl2) {
                try {
                    object = null;
                    if (bl) {
                        object = "the first operand is";
                    }
                    if (bl2) {
                        object = "the second operand is";
                    }
                    if (bl && bl2) {
                        object = "one or both operands are";
                    }
                    staticContext.issueWarning("Comparison of " + atomicType.toString() + (bl ? "?" : "") + " to " + atomicType2.toString() + (bl2 ? "?" : "") + " will fail unless " + (String)object + " empty");
                }
                catch (Exception exception) {}
            } else {
                throw new XPathException.Type("Cannot compare " + atomicType.toString() + " to " + atomicType2.toString());
            }
        }
        if (this.operator != 44 && this.operator != 45) {
            if (!Type.isOrdered(n2)) {
                throw new XPathException.Type("Type " + atomicType.toString() + " is not an ordered type");
            }
            if (!Type.isOrdered(n)) {
                throw new XPathException.Type("Type " + atomicType2.toString() + " is not an ordered type");
            }
        }
        if ((comparator = staticContext.getCollation(staticContext.getDefaultCollationName())) == null) {
            comparator = CodepointCollator.getInstance();
        }
        this.comparer = new AtomicComparer(comparator);
        if (this.operands[0] instanceof FunctionCall && ((FunctionCall)this.operands[0]).getName().equals("count") && ((FunctionCall)this.operands[0]).getNumberOfArguments() == 1 && this.operands[1] instanceof AtomicValue) {
            if (ValueComparison.isZero(this.operands[1])) {
                if (this.operator == 44 || this.operator == 49) {
                    FunctionCall functionCall = SystemFunction.makeSystemFunction("empty");
                    object = new Expression[]{((FunctionCall)this.operands[0]).argument[0]};
                    functionCall.setArguments((Expression[])object);
                    return functionCall;
                }
                if (this.operator == 45 || this.operator == 46) {
                    FunctionCall functionCall = SystemFunction.makeSystemFunction("exists");
                    object = new Expression[]{((FunctionCall)this.operands[0]).argument[0]};
                    functionCall.setArguments((Expression[])object);
                    return functionCall;
                }
                if (this.operator == 48) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            if (this.operands[1] instanceof IntegerValue && (this.operator == 46 || this.operator == 48)) {
                long l = ((IntegerValue)this.operands[1]).getValue();
                if (this.operator == 46) {
                    ++l;
                }
                FunctionCall functionCall = SystemFunction.makeSystemFunction("exists");
                Expression[] expressionArray = new Expression[1];
                FilterExpression filterExpression = new FilterExpression(((FunctionCall)this.operands[0]).argument[0], new IntegerValue(l));
                expressionArray[0] = filterExpression;
                functionCall.setArguments(expressionArray);
                return functionCall;
            }
        }
        if (this.operands[1] instanceof FunctionCall && ((FunctionCall)this.operands[1]).getName().equals("count") && ((FunctionCall)this.operands[1]).getNumberOfArguments() == 1 && ValueComparison.isZero(this.operands[0])) {
            Expression expression = new ValueComparison(this.operands[1], Value.inverse(this.operator), this.operands[0]).analyze(staticContext);
            return expression;
        }
        if (this.operands[0] instanceof StringLength && ((StringLength)this.operands[0]).getNumberOfArguments() == 1 && ValueComparison.isZero(this.operands[1])) {
            ((StringLength)this.operands[0]).setShortcut();
        }
        if (this.operands[1] instanceof StringLength && ((StringLength)this.operands[1]).getNumberOfArguments() == 1 && ValueComparison.isZero(this.operands[0])) {
            ((StringLength)this.operands[1]).setShortcut();
        }
        if (this.operands[0] instanceof Position && this.operands[1] instanceof IntegerValue) {
            long l = ((IntegerValue)this.operands[1]).getValue();
            if (l < 0L) {
                l = 0L;
            }
            if (l < Integer.MAX_VALUE) {
                switch (this.operator) {
                    case 44: {
                        return new PositionRange((int)l, (int)l);
                    }
                    case 48: {
                        return new PositionRange((int)l, Integer.MAX_VALUE);
                    }
                    case 45: {
                        if (l != 1L) break;
                        return new PositionRange(2, Integer.MAX_VALUE);
                    }
                    case 47: {
                        return new PositionRange(1, (int)l - 1);
                    }
                    case 46: {
                        return new PositionRange((int)l + 1, Integer.MAX_VALUE);
                    }
                    case 49: {
                        return new PositionRange(1, (int)l);
                    }
                }
            }
        }
        if (this.operands[0] instanceof IntegerValue && this.operands[1] instanceof Position) {
            long l = ((IntegerValue)this.operands[0]).getValue();
            if (l < 0L) {
                l = 0L;
            }
            if (l < Integer.MAX_VALUE) {
                switch (this.operator) {
                    case 44: {
                        return new PositionRange((int)l, (int)l);
                    }
                    case 49: {
                        return new PositionRange((int)l, Integer.MAX_VALUE);
                    }
                    case 45: {
                        if (l != 1L) break;
                        return new PositionRange(2, Integer.MAX_VALUE);
                    }
                    case 46: {
                        return new PositionRange(1, (int)l - 1);
                    }
                    case 47: {
                        return new PositionRange((int)l + 1, Integer.MAX_VALUE);
                    }
                    case 48: {
                        return new PositionRange(1, (int)l);
                    }
                }
            }
        }
        if (this.operands[0] instanceof Position && this.operands[1] instanceof Last) {
            switch (this.operator) {
                case 44: 
                case 48: {
                    return new IsLastExpression(true);
                }
                case 45: 
                case 47: {
                    return new IsLastExpression(false);
                }
                case 46: {
                    return BooleanValue.FALSE;
                }
                case 49: {
                    return BooleanValue.TRUE;
                }
            }
        }
        if (this.operands[0] instanceof Last && this.operands[1] instanceof Position) {
            switch (this.operator) {
                case 44: 
                case 49: {
                    return new IsLastExpression(true);
                }
                case 45: 
                case 46: {
                    return new IsLastExpression(false);
                }
                case 47: {
                    return BooleanValue.FALSE;
                }
                case 48: {
                    return BooleanValue.TRUE;
                }
            }
        }
        if (this.operands[0] instanceof NamePart && this.operands[1] instanceof NamePart) {
            FunctionCall functionCall = (FunctionCall)this.operands[0];
            object = (FunctionCall)this.operands[1];
            if (functionCall.getName().equals("generate-id") && ((FunctionCall)object).getName().equals("generate-id") && !Cardinality.allowsMany(functionCall.argument[0].getCardinality()) && !Cardinality.allowsMany(((FunctionCall)object).argument[0].getCardinality()) && this.operator == 44) {
                IdentityComparison identityComparison = new IdentityComparison(functionCall.argument[0], 20, ((FunctionCall)object).argument[0]);
                identityComparison.setGenerateIdEmulation(true);
                return identityComparison.simplify().analyze(staticContext);
            }
        }
        if (this.operands[0] instanceof Value && this.operands[1] instanceof Value) {
            return (AtomicValue)this.evaluateItem(null);
        }
        return this;
    }

    private static boolean isZero(Expression expression) {
        try {
            if (!(expression instanceof AtomicValue)) {
                return false;
            }
            if (expression instanceof IntegerValue) {
                return ((IntegerValue)expression).getValue() == 0L;
            }
            if (expression instanceof BigIntegerValue) {
                return ((BigIntegerValue)expression).compareTo(BigIntegerValue.ZERO) == 0;
            }
            AtomicValue atomicValue = ((AtomicValue)expression).convert(532);
            return ValueComparison.isZero(atomicValue);
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return false;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = atomicValue2.convert(513);
            }
            if ((atomicValue = (AtomicValue)this.operands[1].evaluateItem(xPathContext)) == null) {
                return false;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                atomicValue = atomicValue.convert(513);
            }
            return ValueComparison.compare(atomicValue2, this.operator, atomicValue, this.comparer);
        }
        catch (XPathException.Type type) {
            this.typeError(type.getMessage());
            return false;
        }
    }

    protected static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer) throws XPathException.Type {
        if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) {
            return false;
        }
        if (atomicValue2 instanceof NumericValue && ((NumericValue)atomicValue2).isNaN()) {
            return false;
        }
        try {
            switch (n) {
                case 44: {
                    return atomicComparer.comparesEqual(atomicValue, atomicValue2);
                }
                case 45: {
                    return !atomicComparer.comparesEqual(atomicValue, atomicValue2);
                }
                case 46: {
                    return atomicComparer.compare(atomicValue, atomicValue2) > 0;
                }
                case 47: {
                    return atomicComparer.compare(atomicValue, atomicValue2) < 0;
                }
                case 48: {
                    return atomicComparer.compare(atomicValue, atomicValue2) >= 0;
                }
                case 49: {
                    return atomicComparer.compare(atomicValue, atomicValue2) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + n);
        }
        catch (ClassCastException classCastException) {
            throw new XPathException.Type("Cannot compare " + atomicValue.getItemType() + " to " + atomicValue2.getItemType());
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = atomicValue2.convert(513);
            }
            if ((atomicValue = (AtomicValue)this.operands[1].evaluateItem(xPathContext)) == null) {
                return null;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                atomicValue = atomicValue.convert(513);
            }
            return BooleanValue.get(ValueComparison.compare(atomicValue2, this.operator, atomicValue, this.comparer));
        }
        catch (XPathException.Type type) {
            this.typeError(type.getMessage());
            return null;
        }
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }
}

