/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xpath.XPathException;

public class Aggregate
extends SystemFunction {
    public static final int SUM = 0;
    public static final int AVG = 1;
    public static final int COUNT = 4;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.argument[0] = ExpressionTool.unsorted(this.argument[0], true);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 4: {
                SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
                return new IntegerValue(Aggregate.count(sequenceIterator));
            }
            case 0: {
                return this.total(this.argument[0].iterate(xPathContext));
            }
            case 1: {
                return this.average(this.argument[0].iterate(xPathContext));
            }
        }
        throw new UnsupportedOperationException("Unknown aggregate function");
    }

    private NumericValue total(SequenceIterator sequenceIterator) throws XPathException {
        AtomicValue atomicValue;
        NumericValue numericValue;
        NumericValue numericValue2 = new IntegerValue(0L);
        do {
            if ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) continue;
            return numericValue2;
        } while (!(numericValue2 = numericValue2.arithmetic(15, numericValue = (NumericValue)atomicValue.getPrimitiveValue())).isNaN());
        return numericValue2;
    }

    private NumericValue average(SequenceIterator sequenceIterator) throws XPathException {
        AtomicValue atomicValue;
        NumericValue numericValue = new IntegerValue(0L);
        int n = 0;
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            NumericValue numericValue2 = (NumericValue)atomicValue.getPrimitiveValue();
            numericValue = ((NumericValue)numericValue).arithmetic(15, numericValue2);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return ((NumericValue)numericValue).arithmetic(18, new IntegerValue(n));
    }

    public static int count(SequenceIterator sequenceIterator) throws XPathException {
        if (sequenceIterator instanceof LastPositionFinder) {
            return ((LastPositionFinder)sequenceIterator).getLastPosition();
        }
        int n = 0;
        while (sequenceIterator.next() != null) {
            ++n;
        }
        return n;
    }
}

