/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xpath.XPathException;

public class Remove
extends SystemFunction {
    public Expression simplify() throws XPathException {
        Expression expression = super.simplify();
        if (expression instanceof Remove) {
            return ((Remove)expression).simplifyAsTailExpression();
        }
        return expression;
    }

    private Expression simplifyAsTailExpression() {
        if (this.argument[1] instanceof IntegerValue && ((IntegerValue)this.argument[1]).getValue() == 1L) {
            return new TailExpression(this.argument[0], 2);
        }
        return this;
    }

    public ItemType getItemType() {
        return this.argument[0].getItemType();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        int n = (int)numericValue.asLong();
        if (n < 1) {
            return sequenceIterator;
        }
        return new RemoveIterator(sequenceIterator, n);
    }

    private class RemoveIterator
    implements SequenceIterator {
        SequenceIterator base;
        int removePosition;
        int position = 0;
        Item current = null;

        public RemoveIterator(SequenceIterator sequenceIterator, int n) throws XPathException {
            this.base = sequenceIterator;
            this.removePosition = n;
        }

        public Item next() throws XPathException {
            this.current = this.base.next();
            if (this.current != null && this.base.position() == this.removePosition) {
                this.current = this.base.next();
            }
            if (this.current != null) {
                ++this.position;
            }
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new RemoveIterator(this.base.getAnother(), this.removePosition);
        }
    }
}

