/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.xpath.XPathException;

public final class NamespaceContext
implements Serializable,
NamespaceResolver {
    private int[] namespaceCodes;
    private NamePool namePool;

    public NamespaceContext(int[] nArray, NamePool namePool) {
        this.namespaceCodes = nArray;
        this.namePool = namePool;
    }

    public int[] getNamespaceCodes() {
        return this.namespaceCodes;
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (string.equals("") && !bl) {
            return "";
        }
        int n = this.namespaceCodes.length - 1;
        while (n >= 0) {
            if (this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[n]).equals(string)) {
                return this.namePool.getURIFromNamespaceCode(this.namespaceCodes[n]);
            }
            --n;
        }
        if (string.equals("") && bl) {
            return "";
        }
        return null;
    }

    public int getFingerprint(String string, boolean bl, NamePool namePool) throws XPathException {
        String[] stringArray;
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Dynamic(qNameException.getMessage());
        }
        String string2 = this.getURIForPrefix(stringArray[0], bl);
        if (string2 == null) {
            throw new XPathException.Dynamic("Namespace prefix " + stringArray[0] + " has not been declared");
        }
        return namePool.getFingerprint(string2, stringArray[1]);
    }
}

