/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.xpath.XPathException;

public final class Navigator {
    public static final boolean isWhite(CharSequence charSequence) {
        int n = 0;
        while (n < charSequence.length()) {
            if (charSequence.charAt(n++) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static String getAttributeValue(NodeInfo nodeInfo, String string, String string2) {
        int n = nodeInfo.getNamePool().allocate("", string, string2);
        return nodeInfo.getAttributeValue(n);
    }

    public static String getPath(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return "";
        }
        NodeInfo nodeInfo2 = nodeInfo.getParent();
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                return "/";
            }
            case 1: {
                if (nodeInfo2 == null) {
                    return nodeInfo.getDisplayName();
                }
                String string = Navigator.getPath(nodeInfo2);
                if (string.equals("/")) {
                    return "/" + nodeInfo.getDisplayName();
                }
                return string + "/" + nodeInfo.getDisplayName() + "[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 2: {
                return Navigator.getPath(nodeInfo2) + "/@" + nodeInfo.getDisplayName();
            }
            case 3: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/text()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 8: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/comment()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 7: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/processing-instruction()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 13: {
                String string = nodeInfo.getLocalPart();
                if (string.equals("")) {
                    string = "*[not(local-name()]";
                }
                return Navigator.getPath(nodeInfo2) + "/namespace::" + string;
            }
        }
        return "";
    }

    public static int getNumberSimple(NodeInfo nodeInfo, Controller controller) throws XPathException {
        NodeInfo nodeInfo2;
        int n = nodeInfo.getFingerprint();
        NodeTest nodeTest = n == -1 ? NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind()) : new NameTest(nodeInfo);
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)11, nodeTest);
        int n2 = 1;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            int n3 = controller.getRememberedNumber(nodeInfo2);
            if (n3 > 0) {
                controller.setRememberedNumber(nodeInfo, n3 += n2);
                return n3;
            }
            ++n2;
        }
        controller.setRememberedNumber(nodeInfo, n2);
        return n2;
    }

    private static int getNumberSimple(NodeInfo nodeInfo) {
        int n = nodeInfo.getFingerprint();
        NodeTest nodeTest = n == -1 ? NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind()) : new NameTest(nodeInfo);
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)11, nodeTest);
        int n2 = 1;
        while (axisIterator.next() != null) {
            ++n2;
        }
        return n2;
    }

    public static int getNumberSingle(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Controller controller) throws XPathException {
        if (pattern == null && pattern2 == null) {
            return Navigator.getNumberSimple(nodeInfo, controller);
        }
        boolean bl = false;
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind()) : new NameTest(nodeInfo);
            bl = true;
        }
        NodeInfo nodeInfo2 = nodeInfo;
        while (!bl && !pattern.matches(nodeInfo2, controller)) {
            if ((nodeInfo2 = nodeInfo2.getParent()) == null) {
                return 0;
            }
            if (pattern2 == null || !pattern2.matches(nodeInfo2, controller)) continue;
            return 0;
        }
        AxisIterator axisIterator = nodeInfo2.iterateAxis((byte)11, pattern.getNodeTest());
        boolean bl2 = pattern instanceof NodeTest;
        int n = 1;
        NodeInfo nodeInfo3;
        while ((nodeInfo3 = (NodeInfo)axisIterator.next()) != null) {
            if (!bl2 && !pattern.matches(nodeInfo3, controller)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberAny(Instruction instruction, NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Controller controller, boolean bl) throws XPathException {
        Object[] objectArray;
        Object[] objectArray2;
        boolean bl2;
        NodeInfo nodeInfo2 = null;
        int n = 0;
        boolean bl3 = bl2 = !bl && pattern != null;
        if (bl2 && (objectArray2 = (Object[])controller.getUserData(instruction, "xsl:number")) != null) {
            nodeInfo2 = (NodeInfo)objectArray2[0];
            n = (Integer)objectArray2[1];
        }
        int n2 = 0;
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind()) : new NameTest(nodeInfo);
            n2 = 1;
        } else if (pattern.matches(nodeInfo, controller)) {
            n2 = 1;
        }
        NodeTest nodeTest = pattern2 == null ? pattern.getNodeTest() : (pattern2.getNodeKind() == 1 && pattern.getNodeKind() == 1 ? NodeKindTest.ELEMENT : AnyNodeTest.getInstance());
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)13, nodeTest);
        while ((objectArray = (Object[])axisIterator.next()) != null) {
            if (pattern2 != null && pattern2.matches((NodeInfo)objectArray, controller)) {
                return n2;
            }
            if (!pattern.matches((NodeInfo)objectArray, controller)) continue;
            if (n2 == 1 && nodeInfo2 != null && objectArray.isSameNode(nodeInfo2)) {
                n2 = n + 1;
                break;
            }
            ++n2;
        }
        if (bl2) {
            objectArray = new Object[]{nodeInfo, new Integer(n2)};
            controller.setUserData(instruction, "xsl:number", objectArray);
        }
        return n2;
    }

    public static List getNumberMulti(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Controller controller) throws XPathException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind()) : new NameTest(nodeInfo);
        }
        NodeInfo nodeInfo2 = nodeInfo;
        do {
            if (!pattern.matches(nodeInfo2, controller)) continue;
            int n = Navigator.getNumberSingle(nodeInfo2, pattern, null, controller);
            arrayList.add(0, new Long(n));
        } while ((nodeInfo2 = nodeInfo2.getParent()) != null && (pattern2 == null || !pattern2.matches(nodeInfo2, controller)));
        return arrayList;
    }

    public static void copy(NodeInfo nodeInfo, Receiver receiver, NamePool namePool, int n, boolean bl) throws TransformerException {
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3, new AnyNodeTest());
                while (true) {
                    NodeInfo nodeInfo2;
                    if ((nodeInfo2 = (NodeInfo)axisIterator.next()) == null) {
                        return;
                    }
                    nodeInfo2.copy(receiver, n, bl);
                }
            }
            case 1: {
                NodeInfo nodeInfo3;
                Object object;
                receiver.startElement(nodeInfo.getNameCode(), bl ? nodeInfo.getTypeAnnotation() : -1, 0);
                if (n != 0) {
                    nodeInfo.outputNamespaceNodes(receiver, true);
                }
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2, new AnyNodeTest());
                while ((object = (NodeInfo)axisIterator.next()) != null) {
                    object.copy(receiver, n, bl);
                }
                receiver.startContent();
                object = nodeInfo.iterateAxis((byte)3, new AnyNodeTest());
                while ((nodeInfo3 = (NodeInfo)object.next()) != null) {
                    nodeInfo3.copy(receiver, n, bl);
                }
                receiver.endElement();
                return;
            }
            case 2: {
                receiver.attribute(nodeInfo.getNameCode(), bl ? nodeInfo.getTypeAnnotation() : -1, nodeInfo.getStringValue(), 0);
                return;
            }
            case 3: {
                receiver.characters(nodeInfo.getStringValue(), 0);
                return;
            }
            case 8: {
                receiver.comment(nodeInfo.getStringValue(), 0);
                return;
            }
            case 7: {
                receiver.processingInstruction(nodeInfo.getLocalPart(), nodeInfo.getStringValue(), 0);
                return;
            }
            case 13: {
                receiver.namespace(namePool.allocateNamespaceCode(nodeInfo.getLocalPart(), nodeInfo.getStringValue()), 0);
                return;
            }
        }
    }

    public static int compareOrder(SiblingCountingNode siblingCountingNode, SiblingCountingNode siblingCountingNode2) {
        SiblingCountingNode siblingCountingNode3 = siblingCountingNode2;
        if (siblingCountingNode.isSameNode(siblingCountingNode2)) {
            return 0;
        }
        if (siblingCountingNode.getParent().isSameNode(siblingCountingNode2.getParent())) {
            return siblingCountingNode.getSiblingPosition() - siblingCountingNode2.getSiblingPosition();
        }
        int n = 0;
        int n2 = 0;
        NodeInfo nodeInfo = siblingCountingNode;
        NodeInfo nodeInfo2 = siblingCountingNode2;
        while (nodeInfo != null) {
            ++n;
            nodeInfo = nodeInfo.getParent();
        }
        while (nodeInfo2 != null) {
            ++n2;
            nodeInfo2 = nodeInfo2.getParent();
        }
        nodeInfo = siblingCountingNode;
        while (n > n2) {
            if ((nodeInfo = nodeInfo.getParent()).isSameNode(siblingCountingNode2)) {
                return 1;
            }
            --n;
        }
        nodeInfo2 = siblingCountingNode3;
        while (n2 > n) {
            if ((nodeInfo2 = nodeInfo2.getParent()).isSameNode(siblingCountingNode)) {
                return -1;
            }
            --n2;
        }
        while (true) {
            NodeInfo nodeInfo3 = nodeInfo.getParent();
            NodeInfo nodeInfo4 = nodeInfo2.getParent();
            if (nodeInfo3 == null || nodeInfo4 == null) {
                throw new NullPointerException("DOM tree compare - internal error");
            }
            if (nodeInfo3.isSameNode(nodeInfo4)) {
                return ((SiblingCountingNode)nodeInfo).getSiblingPosition() - ((SiblingCountingNode)nodeInfo2).getSiblingPosition();
            }
            nodeInfo = nodeInfo3;
            nodeInfo2 = nodeInfo4;
        }
    }

    public static String getSequentialKey(SiblingCountingNode siblingCountingNode) {
        StringBuffer stringBuffer = new StringBuffer();
        while (siblingCountingNode != null && !(siblingCountingNode instanceof DocumentInfo)) {
            stringBuffer.insert(0, Navigator.alphaKey(siblingCountingNode.getSiblingPosition()));
            siblingCountingNode = (SiblingCountingNode)siblingCountingNode.getParent();
        }
        stringBuffer.insert(0, "w" + siblingCountingNode.getDocumentNumber());
        return stringBuffer.toString().intern();
    }

    public static String alphaKey(int n) {
        if (n < 1) {
            return "a";
        }
        if (n < 10) {
            return "b" + n;
        }
        if (n < 100) {
            return "c" + n;
        }
        if (n < 1000) {
            return "d" + n;
        }
        if (n < 10000) {
            return "e" + n;
        }
        if (n < 100000) {
            return "f" + n;
        }
        if (n < 1000000) {
            return "g" + n;
        }
        if (n < 10000000) {
            return "h" + n;
        }
        if (n < 100000000) {
            return "i" + n;
        }
        if (n < 1000000000) {
            return "j" + n;
        }
        return "k" + n;
    }

    public static final class PrecedingEnumeration
    extends BaseEnumeration {
        private NodeInfo start;
        private AxisIterator ancestorEnum = null;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;
        private boolean includeAncestors;

        public PrecedingEnumeration(NodeInfo nodeInfo, boolean bl) {
            this.start = nodeInfo;
            this.includeAncestors = bl;
            this.ancestorEnum = new AncestorEnumeration(nodeInfo, false);
            switch (nodeInfo.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = nodeInfo.iterateAxis((byte)11);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.getInstance();
                }
            }
        }

        public void advance() {
            Item item;
            if (this.descendEnum != null) {
                item = this.descendEnum.next();
                if (item != null) {
                    this.current = item;
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                item = this.siblingEnum.next();
                if (item != null) {
                    NodeInfo nodeInfo = (NodeInfo)item;
                    if (nodeInfo.hasChildNodes()) {
                        this.descendEnum = new DescendantEnumeration(nodeInfo, true, false);
                        this.advance();
                    } else {
                        this.descendEnum = null;
                        this.current = nodeInfo;
                    }
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if ((item = this.ancestorEnum.next()) != null) {
                this.current = item;
                NodeInfo nodeInfo = (NodeInfo)this.current;
                this.siblingEnum = nodeInfo.getNodeKind() == 9 ? EmptyIterator.getInstance() : nodeInfo.iterateAxis((byte)11);
                if (!this.includeAncestors) {
                    this.advance();
                }
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new PrecedingEnumeration(this.start, this.includeAncestors);
        }
    }

    public static final class FollowingEnumeration
    extends BaseEnumeration {
        private NodeInfo start;
        private AxisIterator ancestorEnum = null;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;

        public FollowingEnumeration(NodeInfo nodeInfo) {
            this.start = nodeInfo;
            this.ancestorEnum = new AncestorEnumeration(nodeInfo, false);
            switch (nodeInfo.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = nodeInfo.iterateAxis((byte)7);
                    break;
                }
                case 2: 
                case 13: {
                    NodeInfo nodeInfo2 = nodeInfo.getParent();
                    if (nodeInfo2 == null) {
                        this.siblingEnum = EmptyIterator.getInstance();
                        break;
                    }
                    this.siblingEnum = nodeInfo2.iterateAxis((byte)3);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.getInstance();
                }
            }
        }

        public void advance() {
            Item item;
            if (this.descendEnum != null) {
                item = this.descendEnum.next();
                if (item != null) {
                    this.current = item;
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                item = this.siblingEnum.next();
                if (item != null) {
                    this.current = item;
                    NodeInfo nodeInfo = (NodeInfo)this.current;
                    this.descendEnum = nodeInfo.hasChildNodes() ? new DescendantEnumeration(nodeInfo, false, true) : null;
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if ((item = this.ancestorEnum.next()) != null) {
                this.current = item;
                NodeInfo nodeInfo = (NodeInfo)this.current;
                this.siblingEnum = nodeInfo.getNodeKind() == 9 ? EmptyIterator.getInstance() : nodeInfo.iterateAxis((byte)7);
                this.advance();
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new FollowingEnumeration(this.start);
        }
    }

    public static final class DescendantEnumeration
    extends BaseEnumeration {
        private AxisIterator children = null;
        private AxisIterator descendants = null;
        private NodeInfo start;
        private boolean includeSelf;
        private boolean forwards;
        private boolean atEnd = false;

        public DescendantEnumeration(NodeInfo nodeInfo, boolean bl, boolean bl2) {
            this.start = nodeInfo;
            this.includeSelf = bl;
            this.forwards = bl2;
        }

        public void advance() {
            Item item;
            if (this.descendants != null) {
                item = this.descendants.next();
                if (item != null) {
                    this.current = item;
                    return;
                }
                this.descendants = null;
            }
            if (this.children != null) {
                item = (NodeInfo)this.children.next();
                if (item != null) {
                    if (item.hasChildNodes()) {
                        if (this.forwards) {
                            this.descendants = new DescendantEnumeration((NodeInfo)item, false, this.forwards);
                            this.current = item;
                        } else {
                            this.descendants = new DescendantEnumeration((NodeInfo)item, true, this.forwards);
                            this.advance();
                        }
                    } else {
                        this.current = item;
                    }
                } else if (this.forwards || !this.includeSelf) {
                    this.current = null;
                } else {
                    this.atEnd = true;
                    this.children = null;
                    this.current = this.start;
                }
            } else if (this.atEnd) {
                this.current = null;
            } else {
                if (this.start.hasChildNodes()) {
                    this.children = this.start.iterateAxis((byte)3);
                    if (!this.forwards) {
                        if (this.children instanceof ReversibleIterator) {
                            this.children = (AxisIterator)((ReversibleIterator)((Object)this.children)).getReverseIterator();
                        } else {
                            try {
                                this.children = new SequenceExtent(this.start.iterateAxis((byte)3)).reverseIterate();
                            }
                            catch (XPathException xPathException) {
                                xPathException.printStackTrace();
                            }
                        }
                    }
                } else {
                    this.children = EmptyIterator.getInstance();
                }
                if (this.forwards && this.includeSelf) {
                    this.current = this.start;
                } else {
                    this.advance();
                }
            }
        }

        public SequenceIterator getAnother() {
            return new DescendantEnumeration(this.start, this.includeSelf, this.forwards);
        }
    }

    public static final class AncestorEnumeration
    extends BaseEnumeration {
        private boolean includeSelf;
        private boolean atStart;
        private NodeInfo start;

        public AncestorEnumeration(NodeInfo nodeInfo, boolean bl) {
            this.start = nodeInfo;
            this.includeSelf = bl;
            this.current = nodeInfo;
            this.atStart = true;
        }

        public void advance() {
            if (this.atStart) {
                this.atStart = false;
                if (this.includeSelf) {
                    return;
                }
            }
            this.current = ((NodeInfo)this.current).getParent();
        }

        public SequenceIterator getAnother() {
            return new AncestorEnumeration(this.start, this.includeSelf);
        }
    }

    public static abstract class BaseEnumeration
    extends AxisIteratorImpl {
        public final Item next() {
            this.advance();
            return this.current;
        }

        public abstract void advance();

        public abstract SequenceIterator getAnother();
    }

    public static class AxisFilter
    extends AxisIteratorImpl {
        private AxisIterator base;
        private NodeTest nodeTest;
        private int last = -1;

        public AxisFilter(AxisIterator axisIterator, NodeTest nodeTest) {
            this.base = axisIterator;
            this.nodeTest = nodeTest;
            this.position = 0;
        }

        public Item next() {
            NodeInfo nodeInfo;
            do {
                this.current = this.base.next();
                if (this.current != null) continue;
                return null;
            } while (!this.nodeTest.matches((nodeInfo = (NodeInfo)this.current).getNodeKind(), nodeInfo.getFingerprint(), nodeInfo.getTypeAnnotation()));
            ++this.position;
            return this.current;
        }

        public int getLastPosition() {
            if (this.last >= 0) {
                return this.last;
            }
            this.last = 0;
            AxisIterator axisIterator = (AxisIterator)this.base.getAnother();
            NodeInfo nodeInfo;
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!this.nodeTest.matches(nodeInfo.getNodeKind(), nodeInfo.getFingerprint(), nodeInfo.getTypeAnnotation())) continue;
                ++this.last;
            }
            return this.last;
        }

        public SequenceIterator getAnother() {
            return new AxisFilter((AxisIterator)this.base.getAnother(), this.nodeTest);
        }
    }
}

