/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.AppendExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Attribute;
import net.sf.saxon.instruct.Comment;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Element;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.Instr;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.ProcessingInstruction;
import net.sf.saxon.instruct.SequenceInstruction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.TupleExpression;
import net.sf.saxon.sort.TupleSorter;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.type.GlobalValidationContext;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationContext;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class QueryParser
extends ExpressionParser {
    private boolean preserveSpace = false;
    private int errorCount = 0;
    private Executable executable;
    private boolean haveSeenBaseURI = false;

    public XQueryExpression makeXQueryExpression(String string, StaticQueryContext staticQueryContext, Configuration configuration) throws XPathException {
        DocumentInstr documentInstr;
        Executable executable = new Executable();
        this.setExecutable(executable);
        Expression expression = this.parseQuery(string, 0, 0, staticQueryContext);
        XQueryExpression xQueryExpression = new XQueryExpression(expression, executable, staticQueryContext, configuration);
        if (expression instanceof DocumentInstr) {
            documentInstr = (DocumentInstr)expression;
        } else {
            documentInstr = new DocumentInstr(false, null, staticQueryContext.getSystemId());
            this.makeContentConstructor(expression, documentInstr, 1);
        }
        xQueryExpression.setDocumentInstruction(documentInstr);
        return xQueryExpression;
    }

    public final Expression parseQuery(String string, int n, int n2, StaticQueryContext staticQueryContext) throws XPathException {
        this.env = staticQueryContext;
        this.numberOfRangeVariables = 0;
        this.t = new Tokenizer();
        this.t.recognizePragmas = true;
        this.t.tokenize(string, n, -1);
        this.parseVersionDeclaration();
        this.parseProlog();
        Expression expression = this.parseExpression();
        if (this.t.currentToken != n2) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of query");
        }
        if (this.errorCount == 0) {
            try {
                this.setLocation(expression);
                staticQueryContext.bindUnboundFunctionCalls();
                staticQueryContext.fixupGlobalVariables(staticQueryContext.getNumberOfGlobalVariables());
                staticQueryContext.fixupGlobalFunctions();
                expression = expression.simplify();
                expression = expression.analyze(staticQueryContext);
                int n3 = ExpressionTool.allocateSlots(expression, 0);
                staticQueryContext.allocateLocalSlots(n3);
            }
            catch (XPathException xPathException) {
                try {
                    staticQueryContext.getConfiguration().getErrorListener().fatalError(xPathException);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof XPathException) {
                        throw (XPathException)transformerException;
                    }
                    throw new XPathException.Static(transformerException);
                }
            }
        }
        if (this.errorCount == 0) {
            return expression;
        }
        throw new XPathException.Static("Query Parsing failed");
    }

    public final void parseLibraryModule(String string, StaticQueryContext staticQueryContext, int n) throws XPathException.Static {
        this.env = staticQueryContext;
        this.numberOfRangeVariables = 0;
        this.t = new Tokenizer();
        this.t.tokenize(string, 0, -1);
        this.parseVersionDeclaration();
        this.parseModuleDeclaration();
        this.parseProlog();
        if (this.errorCount == 0) {
            staticQueryContext.bindUnboundFunctionCalls();
            staticQueryContext.fixupGlobalVariables(n);
            staticQueryContext.fixupGlobalFunctions();
        }
        if (this.errorCount != 0) {
            throw new XPathException.Static("Query parsing failed");
        }
    }

    protected void grumble(String string) throws XPathException.Static {
        ++this.errorCount;
        String string2 = this.t.recentText();
        int n = this.t.getLineNumber();
        String string3 = "on line " + n + " ";
        String string4 = ((StaticQueryContext)this.env).getModuleNamespace();
        string3 = string3 + (string4 == null ? "" : "of " + string4 + " ");
        String string5 = this.getLanguage() + " syntax error " + string3 + (string.startsWith("...") ? "near" : "in") + " `" + string2 + "`:\n    ";
        XPathException.Static static_ = new XPathException.Static(string5 + string);
        try {
            this.env.getConfiguration().getErrorListener().error(static_);
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof XPathException.Static) {
                throw (XPathException.Static)transformerException;
            }
            throw new XPathException.Static(transformerException);
        }
        throw new XPathException.Static("XQuery syntax error");
    }

    protected void setLocation(Expression expression, int n, Executable executable) {
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setLineNumber((short)n);
        }
        if (expression instanceof Instruction) {
            ((Instruction)((Object)expression)).setSourceLocation(0, n);
            ((Instruction)((Object)expression)).setExecutable(executable);
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    private void parseVersionDeclaration() throws XPathException.Static {
        if (this.t.currentToken == 70) {
            this.nextToken();
            this.expect(102);
            if (!this.t.currentTokenValue.equals("1.0")) {
                this.grumble("XQuery version must be 1.0");
            }
            this.nextToken();
            this.expect(90);
            this.nextToken();
        }
    }

    private void parseModuleDeclaration() throws XPathException.Static {
        this.expect(80);
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String string2 = this.t.currentTokenValue;
        this.nextToken();
        this.expect(90);
        this.nextToken();
        ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2);
        ((StaticQueryContext)this.env).setModuleNamespace(string2);
    }

    /*
     * Unable to fully structure code
     */
    private void parseProlog() throws XPathException.Static {
        var1_1 = true;
        var2_2 = true;
        block2: while (true) {
            try {
                while (true) {
                    if (this.t.currentToken == 80) {
                        var3_3 = ((StaticQueryContext)this.env).getModuleNamespace();
                        if (var3_3 == null) {
                            this.grumble("Module declaration should not be used in a main module");
                        } else {
                            this.grumble("Module declaration appears more than once");
                        }
                        if (!var2_2) {
                            this.grumble("Module declaration must precede other declarations in the query prolog");
                        }
                    }
                    var2_2 = false;
                    if (this.t.currentToken == 71) {
                        var1_1 = false;
                        this.parseNamespaceDeclaration();
                    } else if (this.t.currentToken == 72) {
                        this.nextToken();
                        this.expect(101);
                        if (!var1_1) {
                            this.grumble("'declare default " + this.t.currentTokenValue + "' must appear earlier in the query prolog");
                        }
                        if (this.t.currentTokenValue == "element") {
                            this.parseDefaultElementNamespace();
                        } else if (this.t.currentTokenValue == "function") {
                            this.parseDefaultFunctionNamespace();
                        } else if (this.t.currentTokenValue == "collation") {
                            this.parseDefaultCollation();
                        } else {
                            this.grumble("After 'declare default', expected 'element', 'function', or 'collation'");
                        }
                    } else if (this.t.currentToken == 75) {
                        if (!var1_1) {
                            this.grumble("'declare xmlspace' must appear earlier in the query prolog");
                        }
                        this.parseXmlSpaceDeclaration();
                    } else if (this.t.currentToken == 74) {
                        if (!var1_1) {
                            this.grumble("'declare base-uri' must appear earlier in the query prolog");
                        }
                        this.parseBaseURIDeclaration();
                    } else if (this.t.currentToken == 76) {
                        var1_1 = false;
                        this.parseSchemaImport();
                    } else if (this.t.currentToken == 77) {
                        var1_1 = false;
                        this.parseModuleImport();
                    } else if (this.t.currentToken == 78) {
                        var1_1 = false;
                        this.parseVariableDeclaration();
                    } else if (this.t.currentToken == 79) {
                        var1_1 = false;
                        this.parseFunctionDeclaration();
                    } else {
                        if (this.t.currentToken != 73) break block2;
                        if (!var1_1) {
                            this.grumble("'declare validation' must appear earlier in the query prolog");
                        }
                        this.parseValidationDeclaration();
                    }
                    this.expect(90);
                    this.nextToken();
                }
            }
            catch (XPathException.Static var3_4) {
                ** while (this.t.currentToken != 90)
            }
lbl-1000:
            // 1 sources

            {
                this.nextToken();
                if (this.t.currentToken == 0) {
                    return;
                }
                if (this.t.currentToken == 115) {
                    this.t.lookAhead();
                    continue;
                }
                if (this.t.currentToken != 117) continue;
                this.parsePseudoXML(true);
                continue;
            }
lbl80:
            // 1 sources

            this.nextToken();
        }
    }

    private void parseDefaultCollation() throws XPathException.Static {
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        try {
            ((StaticQueryContext)this.env).declareDefaultCollation(string);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        this.nextToken();
    }

    private void parseXmlSpaceDeclaration() throws XPathException.Static {
        this.nextToken();
        this.expect(101);
        if (this.t.currentTokenValue.equals("preserve")) {
            this.preserveSpace = true;
        } else if (this.t.currentTokenValue.equals("strip")) {
            this.preserveSpace = false;
        } else {
            this.grumble("xmlspace must be 'preserve' or 'strip'");
        }
        this.nextToken();
    }

    private void parseValidationDeclaration() throws XPathException.Static {
        int n;
        this.nextToken();
        this.expect(101);
        if (this.t.currentTokenValue.equals("strict")) {
            n = 1;
        } else if (this.t.currentTokenValue.equals("lax")) {
            n = 2;
        } else if (this.t.currentTokenValue.equals("skip")) {
            n = 4;
        } else {
            this.grumble("default validation mode must be 'strict', 'lax', or 'skip'");
            n = 4;
        }
        ((StaticQueryContext)this.env).pushValidationMode(n);
        this.nextToken();
    }

    private void parseSchemaImport() throws XPathException.Static {
        Configuration configuration;
        if (!this.env.getConfiguration().isSchemaAware()) {
            this.grumble("To import a schema, you need the schema-aware version of Saxon");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        this.nextToken();
        if (this.isKeyword("namespace")) {
            this.nextToken();
            this.expect(101);
            string = this.t.currentTokenValue;
            this.nextToken();
            this.expect(6);
            this.nextToken();
        } else if (this.isKeyword("default")) {
            this.nextToken();
            if (!this.isKeyword("element")) {
                this.grumble("In 'import schema', expected 'element namespace'");
            }
            this.nextToken();
            if (!this.isKeyword("namespace")) {
                this.grumble("In 'import schema', expected keyword 'namespace'");
            }
            this.nextToken();
            string = "";
        }
        if (this.t.currentToken == 102) {
            string2 = this.t.currentTokenValue;
            this.nextToken();
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(102);
                string3 = this.t.currentTokenValue;
                this.nextToken();
            } else if (this.t.currentToken != 90) {
                this.grumble("After the target namespace URI, expected 'at' or ';'");
            }
        } else {
            this.grumble("After 'import schema', expected 'namespace', 'default', or a string-literal");
        }
        if (string != null) {
            if (string.equals("")) {
                ((StaticQueryContext)this.env).setDefaultElementNamespace(string2);
            } else {
                ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2);
            }
        }
        if ((configuration = this.env.getConfiguration()).getSchema(string2) == null) {
            if (string3 != null) {
                try {
                    string2 = configuration.readSchema(this.env.getBaseURI(), string3, string2);
                }
                catch (TransformerException transformerException) {
                    this.grumble("Error in schema. " + transformerException.getMessage());
                }
            } else {
                this.grumble("Unable to locate requested schema");
            }
        }
        ((StaticQueryContext)this.env).addImportedSchema(string2);
    }

    private void parseModuleImport() throws XPathException.Static {
        Object object;
        String string;
        StaticQueryContext staticQueryContext = (StaticQueryContext)this.env;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        this.nextToken();
        if (this.t.currentToken == 101 && this.t.currentTokenValue == "namespace") {
            this.nextToken();
            this.expect(101);
            string2 = this.t.currentTokenValue;
            this.nextToken();
            this.expect(6);
            this.nextToken();
        }
        if (this.t.currentToken == 102) {
            string3 = this.t.currentTokenValue;
            this.nextToken();
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(102);
                string4 = this.t.currentTokenValue;
                this.nextToken();
            }
        } else {
            this.grumble("After 'import module', expected 'namespace' or a string-literal");
        }
        if (string2 != null) {
            staticQueryContext.declarePassiveNamespace(string2, string3);
        }
        if ((string = staticQueryContext.getModuleNamespace()) != null && string.equals(string3)) {
            this.grumble("A module cannot import itself");
        }
        StaticQueryContext staticQueryContext2 = staticQueryContext.loadModule(string3, string4, staticQueryContext.getNumberOfGlobalVariables());
        short s = staticQueryContext2.getModuleNamespaceCode();
        NamePool namePool = this.env.getNamePool();
        Iterator iterator = staticQueryContext2.getFunctionDefinitions();
        while (iterator.hasNext()) {
            object = (XQueryFunction)iterator.next();
            if (namePool.getURICode(((XQueryFunction)object).getFunctionFingerprint()) != s) continue;
            staticQueryContext.declareFunction((XQueryFunction)object);
        }
        iterator = staticQueryContext2.getVariableDeclarations();
        while (iterator.hasNext()) {
            object = (VariableDeclaration)iterator.next();
            if (namePool.getURICode(object.getVariableFingerprint()) != s) continue;
            staticQueryContext.declareVariable((VariableDeclaration)object);
        }
        staticQueryContext.setNumberOfGlobalVariables(staticQueryContext.getNumberOfGlobalVariables() + staticQueryContext2.getNumberOfGlobalVariables());
    }

    private void parseBaseURIDeclaration() throws XPathException.Static {
        if (this.haveSeenBaseURI) {
            this.grumble("Base URI Declaration may only appear once");
        }
        this.haveSeenBaseURI = true;
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setBaseURI(string);
        this.nextToken();
    }

    private void parseDefaultFunctionNamespace() throws XPathException.Static {
        this.nextToken();
        this.expect(101);
        if (!this.t.currentTokenValue.equals("namespace")) {
            this.grumble("After 'declare default function', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setDefaultFunctionNamespace(string);
        this.nextToken();
    }

    private void parseDefaultElementNamespace() throws XPathException.Static {
        this.nextToken();
        this.expect(101);
        if (!this.t.currentTokenValue.equals("namespace")) {
            this.grumble("After 'declare default element', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setDefaultElementNamespace(string);
        this.nextToken();
    }

    private void parseNamespaceDeclaration() throws XPathException.Static {
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        if (!XMLChar.isValidNCName(string)) {
            this.grumble("Invalid namespace prefix " + Err.wrap(string));
        }
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String string2 = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2);
        this.nextToken();
    }

    private void parseVariableDeclaration() throws XPathException.Static {
        Object object;
        Expression expression;
        GlobalVariableDefinition globalVariableDefinition = new GlobalVariableDefinition();
        globalVariableDefinition.setLineNumber(this.t.getLineNumber());
        this.nextToken();
        this.expect(21);
        this.t.setState(1);
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        globalVariableDefinition.setVariableName(string);
        int n = this.makeNameCode(this.t.currentTokenValue, false);
        int n2 = n & 0xFFFFF;
        globalVariableDefinition.setFingerprint(n2);
        this.nextToken();
        SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            sequenceType = this.parseSequenceType();
        }
        globalVariableDefinition.setRequiredType(sequenceType);
        if (this.t.currentToken == 53) {
            this.t.setState(0);
            this.nextToken();
            expression = this.parseExpression();
            globalVariableDefinition.setIsParameter(false);
            globalVariableDefinition.setValueExpression(expression);
            this.expect(115);
            this.lookAhead();
        } else if (this.t.currentToken == 101) {
            if (this.t.currentTokenValue.equals("external")) {
                globalVariableDefinition.setIsParameter(true);
            } else {
                this.grumble("Variable must either be initialized or be declared as external");
            }
        } else {
            this.grumble("Expected '{' or 'external' in variable declaration");
        }
        this.nextToken();
        expression = null;
        while (this.t.lastPragma != null) {
            try {
                String string2;
                block21: {
                    object = new StringTokenizer(this.t.lastPragma);
                    this.t.lastPragma = null;
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object).nextToken();
                        String[] stringArray = Name.getQNameParts(string2);
                        if (!stringArray[1].equals("default")) break;
                        try {
                            if (!this.env.getURIForPrefix(stringArray[0]).equals("http://saxon.sf.net/")) {
                            }
                            break block21;
                        }
                        catch (XPathException xPathException) {
                            this.grumble("Unrecognized namespace prefix in pragma name {" + string2 + "}");
                        }
                        break;
                    }
                }
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                string2 = ((StringTokenizer)object).nextToken();
                if (string2.charAt(0) == '\"' || string2.charAt(0) == '\'') {
                    expression = new StringValue(string2.substring(1, string2.length() - 1));
                    continue;
                }
                try {
                    expression = new StringValue(string2).convert(646);
                }
                catch (XPathException xPathException) {
                    this.grumble("Default value of query parameter must be a string or numeric literal");
                }
            }
            catch (QNameException qNameException) {
                // empty catch block
            }
        }
        globalVariableDefinition.setRequiredType(sequenceType);
        if (expression != null) {
            globalVariableDefinition.setValueExpression(expression);
        }
        if (((StaticQueryContext)(object = (StaticQueryContext)this.env)).getModuleNamespace() != null && this.env.getNamePool().getURICode(n2) != ((StaticQueryContext)object).getModuleNamespaceCode()) {
            this.grumble("Variable " + Err.wrap(string, 5) + " is not defined in the module namespace");
        }
        try {
            ((StaticQueryContext)object).declareVariable(globalVariableDefinition);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private void parseFunctionDeclaration() throws XPathException.Static {
        this.nextToken();
        this.expect(34);
        if (this.t.currentTokenValue.indexOf(58) < 0) {
            this.grumble("Saxon requires user-defined functions to have a namespace prefix");
        }
        XQueryFunction xQueryFunction = new XQueryFunction();
        xQueryFunction.displayName = this.t.currentTokenValue;
        xQueryFunction.fingerprint = this.makeNameCode(this.t.currentTokenValue, false) & 0xFFFFF;
        xQueryFunction.arguments = new ArrayList();
        xQueryFunction.resultType = SequenceType.ANY_SEQUENCE;
        xQueryFunction.body = null;
        xQueryFunction.lineNumber = this.t.getLineNumber();
        this.nextToken();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (this.t.currentToken != 104) {
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            int n = this.makeNameCode(string, false) & 0xFFFFF;
            Integer n2 = new Integer(n);
            if (hashSet.contains(n2)) {
                this.grumble("Duplicate parameter name " + Err.wrap(this.t.currentTokenValue, 5));
            }
            hashSet.add(n2);
            SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
            this.nextToken();
            if (this.t.currentToken == 101 && this.t.currentTokenValue.equals("as")) {
                this.nextToken();
                sequenceType = this.parseSequenceType();
            }
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setVariableFingerprint(n);
            rangeVariableDeclaration.setRequiredType(sequenceType);
            rangeVariableDeclaration.setVariableName(string);
            xQueryFunction.arguments.add(rangeVariableDeclaration);
            this.declareRangeVariable(rangeVariableDeclaration);
            if (this.t.currentToken == 104) break;
            if (this.t.currentToken == 7) {
                this.nextToken();
                continue;
            }
            this.grumble("Expected ',' or ')' after function argument, found '" + Tokenizer.tokens[this.t.currentToken] + "'");
        }
        this.t.setState(1);
        this.nextToken();
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            xQueryFunction.resultType = this.parseSequenceType();
        }
        if (this.isKeyword("external")) {
            this.grumble("Saxon does not allow external functions to be declared");
        } else {
            this.expect(53);
            this.t.setState(0);
            this.nextToken();
            xQueryFunction.body = this.parseExpression();
            this.expect(115);
            this.lookAhead();
        }
        int n = 0;
        while (n < xQueryFunction.arguments.size()) {
            this.undeclareRangeVariable();
            ++n;
        }
        this.t.setState(0);
        this.nextToken();
        StaticQueryContext staticQueryContext = (StaticQueryContext)this.env;
        if (staticQueryContext.getModuleNamespace() != null && this.env.getNamePool().getURICode(xQueryFunction.fingerprint) != staticQueryContext.getModuleNamespaceCode()) {
            this.grumble("Function " + Err.wrap(xQueryFunction.displayName, 3) + " is not defined in the module namespace");
        }
        try {
            staticQueryContext.declareFunction(xQueryFunction);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    protected Expression parseForExpression() throws XPathException.Static {
        Object object;
        Object object2;
        Expression expression = null;
        ArrayList arrayList = new ArrayList();
        while (true) {
            if (this.t.currentToken == 111) {
                this.parseForClause(arrayList);
                continue;
            }
            if (this.t.currentToken != 116) break;
            this.parseLetClause(arrayList);
        }
        if (this.t.currentToken == 28 || this.isKeyword("where")) {
            this.nextToken();
            expression = this.parseExpression();
        }
        if (this.isKeyword("stable")) {
            this.nextToken();
            if (!this.isKeyword("order")) {
                this.grumble("'stable' must be followed by 'order by'");
            }
        }
        List list = null;
        if (this.isKeyword("order")) {
            this.t.setState(1);
            this.nextToken();
            if (!this.isKeyword("by")) {
                this.grumble("'order' must be followed by 'by'");
            }
            this.t.setState(0);
            this.nextToken();
            list = this.parseSortDefinition();
        }
        this.expect(25);
        this.t.setState(0);
        this.nextToken();
        Object object3 = this.parseExprSingle();
        if (expression != null) {
            object3 = new IfExpression(expression, (Expression)object3, EmptySequence.getInstance());
            this.setLocation((Expression)object3);
        }
        if (list != null) {
            TupleExpression tupleExpression = new TupleExpression(1 + list.size());
            this.setLocation(tupleExpression);
            tupleExpression.setExpression(0, (Expression)object3);
            int n = 0;
            while (n < list.size()) {
                try {
                    object2 = TypeChecker.staticTypeCheck(((SortSpec)list.get((int)n)).sortKey, SequenceType.OPTIONAL_ATOMIC, false, new RoleLocator(6, "FLWR", n));
                    tupleExpression.setExpression(n + 1, (Expression)object2);
                }
                catch (XPathException.Type type) {
                    this.grumble(type.getMessage());
                }
                ++n;
            }
            object3 = tupleExpression;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            Object e = arrayList.get(n);
            if (e instanceof ExpressionParser.ForClause) {
                object2 = (ExpressionParser.ForClause)e;
                object = new ForExpression();
                ((Assignation)object).setVariableDeclaration(((ExpressionParser.ForClause)object2).rangeVariable);
                ((ForExpression)object).setPositionVariable(((ExpressionParser.ForClause)object2).positionVariable);
                ((ComputedExpression)object).setLineNumber((short)((ExpressionParser.ForClause)object2).lineNumber);
                ((Assignation)object).setSequence(((ExpressionParser.ForClause)object2).sequence);
                ((ForExpression)object).setAction((Expression)object3);
                object3 = object;
            } else {
                object2 = (LetClause)e;
                object = new LetExpression();
                ((Assignation)object).setVariableDeclaration(((LetClause)object2).variable);
                ((ComputedExpression)object).setLineNumber((short)((LetClause)object2).lineNumber);
                ((Assignation)object).setSequence(((LetClause)object2).value);
                ((Assignation)object).setAction((Expression)object3);
                object3 = object;
            }
            --n;
        }
        if (list != null) {
            FixedSortKeyDefinition[] fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[list.size()];
            int n2 = 0;
            while (n2 < list.size()) {
                object = (SortSpec)list.get(n2);
                FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
                fixedSortKeyDefinition.setSortKey(((SortSpec)list.get((int)n2)).sortKey);
                fixedSortKeyDefinition.setOrder(new StringValue(((SortSpec)object).ascending ? "ascending" : "descending"));
                fixedSortKeyDefinition.setEmptyFirst(((SortSpec)object).ascending ? ((SortSpec)object).emptyLeast : !((SortSpec)object).emptyLeast);
                try {
                    if (((SortSpec)object).collation != null) {
                        fixedSortKeyDefinition.setCollation(this.env.getCollation(((SortSpec)object).collation));
                    }
                    fixedSortKeyDefinition.bindComparer();
                    fixedSortKeyDefinitionArray[n2] = fixedSortKeyDefinition;
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                }
                ++n2;
            }
            object = new TupleSorter((Expression)object3, fixedSortKeyDefinitionArray);
            this.setLocation((Expression)object);
            object3 = object;
        }
        int n3 = arrayList.size() - 1;
        while (n3 >= 0) {
            Object e = arrayList.get(n3);
            if (e instanceof ExpressionParser.ForClause && ((ExpressionParser.ForClause)e).positionVariable != null) {
                this.undeclareRangeVariable();
            }
            this.undeclareRangeVariable();
            --n3;
        }
        return object3;
    }

    private void parseForClause(List list) throws XPathException.Static {
        do {
            Object object;
            ExpressionParser.ForClause forClause = new ExpressionParser.ForClause();
            forClause.lineNumber = this.t.getLineNumber();
            list.add(forClause);
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setVariableFingerprint(this.makeNameCode(string, false) & 0xFFFFF);
            rangeVariableDeclaration.setRequiredType(SequenceType.SINGLE_ITEM);
            rangeVariableDeclaration.setVariableName(string);
            forClause.rangeVariable = rangeVariableDeclaration;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                object = this.parseSequenceType();
                rangeVariableDeclaration.setRequiredType((SequenceType)object);
                if (((SequenceType)object).getCardinality() != 512) {
                    this.grumble("Cardinality of range variable must be exactly one");
                }
            }
            forClause.positionVariable = null;
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(21);
                this.nextToken();
                this.expect(101);
                object = new RangeVariableDeclaration();
                ((RangeVariableDeclaration)object).setVariableFingerprint(this.makeNameCode(this.t.currentTokenValue, false) & 0xFFFFF);
                ((RangeVariableDeclaration)object).setRequiredType(SequenceType.SINGLE_INTEGER);
                ((RangeVariableDeclaration)object).setVariableName(this.t.currentTokenValue);
                forClause.positionVariable = object;
                this.declareRangeVariable((VariableDeclaration)object);
                this.nextToken();
            }
            this.expect(30);
            this.nextToken();
            forClause.sequence = this.parseExprSingle();
            this.declareRangeVariable(forClause.rangeVariable);
            if (forClause.positionVariable == null) continue;
            this.declareRangeVariable(forClause.positionVariable);
        } while (this.t.currentToken == 7);
    }

    private void parseLetClause(List list) throws XPathException.Static {
        do {
            LetClause letClause = new LetClause();
            letClause.lineNumber = this.t.getLineNumber();
            list.add(letClause);
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setVariableFingerprint(this.makeNameCode(string, false) & 0xFFFFF);
            rangeVariableDeclaration.setRequiredType(SequenceType.ANY_SEQUENCE);
            rangeVariableDeclaration.setVariableName(string);
            letClause.variable = rangeVariableDeclaration;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                rangeVariableDeclaration.setRequiredType(this.parseSequenceType());
            }
            this.expect(52);
            this.nextToken();
            letClause.value = this.parseExprSingle();
            this.declareRangeVariable(rangeVariableDeclaration);
        } while (this.t.currentToken == 7);
    }

    private List parseSortDefinition() throws XPathException.Static {
        ArrayList<SortSpec> arrayList = new ArrayList<SortSpec>();
        while (true) {
            SortSpec sortSpec = new SortSpec();
            sortSpec.sortKey = this.parseExprSingle();
            sortSpec.ascending = true;
            sortSpec.emptyLeast = true;
            sortSpec.collation = this.env.getDefaultCollationName();
            if (this.isKeyword("ascending")) {
                this.nextToken();
            } else if (this.isKeyword("descending")) {
                sortSpec.ascending = false;
                this.nextToken();
            }
            if (this.isKeyword("empty")) {
                this.nextToken();
                if (this.isKeyword("greatest")) {
                    sortSpec.emptyLeast = false;
                    this.nextToken();
                } else if (this.isKeyword("least")) {
                    sortSpec.emptyLeast = true;
                    this.nextToken();
                } else {
                    this.grumble("'empty' must be followed by 'greatest' or 'least'");
                }
            }
            if (this.isKeyword("collation")) {
                this.nextToken();
                this.expect(102);
                sortSpec.collation = this.t.currentTokenValue;
                this.nextToken();
            }
            arrayList.add(sortSpec);
            if (this.t.currentToken != 7) break;
            this.nextToken();
        }
        return arrayList;
    }

    protected Expression parseTypeswitchExpression() throws XPathException.Static {
        Object object;
        Object object2;
        this.nextToken();
        Expression expression = this.parseExpression();
        ArrayList<SequenceType> arrayList = new ArrayList<SequenceType>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        this.expect(104);
        this.nextToken();
        LetExpression letExpression = new LetExpression();
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
        rangeVariableDeclaration.setVariableFingerprint(this.makeNameCode("typeswitchVar", false) & 0xFFFFF);
        rangeVariableDeclaration.setRequiredType(SequenceType.ANY_SEQUENCE);
        rangeVariableDeclaration.setVariableName("typeswitchVar");
        letExpression.setVariableDeclaration(rangeVariableDeclaration);
        letExpression.setSequence(expression);
        while (this.t.currentToken == 59) {
            this.nextToken();
            if (this.t.currentToken == 21) {
                this.nextToken();
                this.expect(101);
                String string = this.t.currentTokenValue;
                this.nextToken();
                this.expect(101);
                if (!this.t.currentTokenValue.equals("as")) {
                    this.grumble("After 'case $" + string + "', expected 'as'");
                }
                this.nextToken();
                object2 = this.parseSequenceType();
                object = this.parseTypeswitchReturnClause(string, (SequenceType)object2, rangeVariableDeclaration);
            } else {
                object2 = this.parseSequenceType();
                this.t.treatCurrentAsOperator();
                this.expect(25);
                this.nextToken();
                object = this.parseExprSingle();
            }
            arrayList.add((SequenceType)object2);
            arrayList2.add(object);
        }
        if (arrayList.size() == 0) {
            this.grumble("At least one case clause is required in a typeswitch");
        }
        this.expect(60);
        this.nextToken();
        if (this.t.currentToken == 21) {
            this.nextToken();
            this.expect(101);
            object = this.t.currentTokenValue;
            this.nextToken();
            object2 = this.parseTypeswitchReturnClause((String)object, SequenceType.ANY_SEQUENCE, rangeVariableDeclaration);
        } else {
            this.t.treatCurrentAsOperator();
            this.expect(25);
            this.nextToken();
            object2 = this.parseExprSingle();
        }
        object = object2;
        int n = arrayList.size() - 1;
        while (n >= 0) {
            IfExpression ifExpression = new IfExpression(new InstanceOfExpression(new VariableReference(rangeVariableDeclaration), (SequenceType)arrayList.get(n)), (Expression)arrayList2.get(n), (Expression)object);
            object = ifExpression;
            --n;
        }
        letExpression.setAction((Expression)object);
        return letExpression;
    }

    private Expression parseTypeswitchReturnClause(String string, SequenceType sequenceType, RangeVariableDeclaration rangeVariableDeclaration) throws XPathException.Static {
        this.t.treatCurrentAsOperator();
        this.expect(25);
        this.nextToken();
        RangeVariableDeclaration rangeVariableDeclaration2 = new RangeVariableDeclaration();
        rangeVariableDeclaration2.setVariableFingerprint(this.makeNameCode(string, false) & 0xFFFFF);
        rangeVariableDeclaration2.setRequiredType(sequenceType);
        rangeVariableDeclaration2.setVariableName(string);
        this.declareRangeVariable(rangeVariableDeclaration2);
        Expression expression = this.parseExprSingle();
        this.undeclareRangeVariable();
        LetExpression letExpression = new LetExpression();
        letExpression.setVariableDeclaration(rangeVariableDeclaration2);
        letExpression.setSequence(new VariableReference(rangeVariableDeclaration));
        letExpression.setAction(expression);
        expression = letExpression;
        return expression;
    }

    protected Expression parseValidateExpression() throws XPathException.Static {
        int n = ((StaticQueryContext)this.env).getValidationMode();
        ValidationContext validationContext = ((StaticQueryContext)this.env).getValidationContext();
        if (this.t.currentToken == 82 || this.t.currentToken == 83 || this.t.currentToken == 84) {
            switch (this.t.currentToken) {
                case 82: {
                    n = 1;
                    break;
                }
                case 83: {
                    n = 2;
                    break;
                }
                case 84: {
                    n = 4;
                }
            }
            this.nextToken();
            if (this.t.currentToken == 54 && this.t.currentTokenValue.equals("global")) {
                validationContext = GlobalValidationContext.getInstance();
            } else if (this.isKeyword("context")) {
                this.nextToken();
                validationContext = this.parseValidationContext();
            } else if (this.t.currentToken == 53) {
                // empty if block
            }
            this.nextToken();
        } else if (this.t.currentToken == 85) {
            validationContext = GlobalValidationContext.getInstance();
            this.nextToken();
            this.expect(53);
            this.nextToken();
        } else if (this.t.currentToken == 86) {
            this.nextToken();
            validationContext = this.parseValidationContext();
            this.nextToken();
        }
        ((StaticQueryContext)this.env).pushValidationMode(n);
        ((StaticQueryContext)this.env).pushValidationContext(validationContext);
        Expression expression = this.parseExpression();
        if (!(expression instanceof FixedElement) && !(expression instanceof DocumentInstr)) {
            try {
                expression = TypeChecker.staticTypeCheck(expression, SequenceType.SINGLE_NODE, false, new RoleLocator(2, "validate", 0));
            }
            catch (XPathException.Type type) {
                this.grumble(type.getMessage());
            }
            expression = new CopyOf(expression, true, n, null);
            this.setLocation(expression);
            ((CopyOf)expression).setRequireDocumentOrElement(true);
            ((CopyOf)expression).setValidationContext(validationContext);
        }
        this.expect(115);
        this.t.lookAhead();
        this.nextToken();
        ((StaticQueryContext)this.env).popValidationMode();
        ((StaticQueryContext)this.env).popValidationContext();
        return expression;
    }

    public ValidationContext parseValidationContext() throws XPathException.Static {
        ValidationContext validationContext;
        block6: {
            validationContext = GlobalValidationContext.getInstance();
            Configuration configuration = this.env.getConfiguration();
            int n = -1;
            boolean bl = false;
            if (this.t.currentToken == 114) {
                bl = true;
                this.nextToken();
                this.expect(101);
                n = this.makeNameCode(this.t.currentTokenValue, true) & 0xFFFFF;
                this.nextToken();
                this.expect(104);
            } else {
                n = this.makeNameCode(this.t.currentTokenValue, true) & 0xFFFFF;
            }
            while (true) {
                try {
                    validationContext = configuration.getContainedValidationContext(validationContext, n, bl);
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                    return null;
                }
                bl = false;
                if (validationContext.isVoidValidationContext()) {
                    this.grumble("Element " + Err.wrap(this.t.currentTokenValue, 1) + " cannot be used as validation context: element is undefined or has simple content");
                }
                if (this.t.currentToken == 54) break block6;
                this.nextToken();
                if (this.t.currentToken == 53) break block6;
                if (this.t.currentToken != 2) break;
                this.nextToken();
                n = this.makeNameCode(this.t.currentTokenValue, true) & 0xFFFFF;
            }
            this.grumble("expected '/' or '{'");
            return null;
        }
        return validationContext;
    }

    protected Expression parseConstructor() throws XPathException.Static {
        int n = this.t.getLineNumber();
        switch (this.t.currentToken) {
            case 117: {
                Expression expression = this.parsePseudoXML(false);
                this.lookAhead();
                this.t.setState(3);
                this.nextToken();
                return expression;
            }
            case 54: {
                String string = this.t.currentTokenValue;
                if (string.equals("validate")) {
                    return this.parseValidateExpression();
                }
                if (string.equals("document")) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    DocumentInstr documentInstr = new DocumentInstr(false, null, this.env.getBaseURI());
                    this.makeContentConstructor(expression, documentInstr, n);
                    return documentInstr;
                }
                if (string.equals("element")) {
                    ExprInstruction exprInstruction;
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression2 = null;
                    if (this.t.currentToken != 115) {
                        expression2 = this.parseExpression();
                        if (expression2 instanceof ElementCreator) {
                            ((ElementCreator)expression2).setValidationMode(3);
                        }
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    if (expression instanceof Value) {
                        int n2;
                        if (expression instanceof StringValue) {
                            String string2 = ((StringValue)expression).getStringValue();
                            n2 = this.makeNameCode(string2, true);
                        } else if (expression instanceof QNameValue) {
                            n2 = this.env.getNamePool().allocate("", ((QNameValue)expression).getNamespaceURI(), ((QNameValue)expression).getLocalName());
                        } else {
                            this.grumble("Element name must be either a string or a QName");
                            return null;
                        }
                        exprInstruction = new FixedElement(n2, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), null, null, ((StaticQueryContext)this.env).getValidationMode());
                    } else {
                        exprInstruction = new Element(expression, null, ((StaticQueryContext)this.env).getNamespaceContext(), null, null, ((StaticQueryContext)this.env).getValidationMode());
                    }
                    this.makeContentConstructor(expression2, exprInstruction, n);
                    if (this.env.getConfiguration().getTraceListener() != null) {
                        exprInstruction = new TraceInstruction(exprInstruction);
                    }
                    return exprInstruction;
                }
                if (string.equals("attribute")) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression3 = null;
                    if (this.t.currentToken != 115) {
                        expression3 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    Attribute attribute = new Attribute(expression, null, ((StaticQueryContext)this.env).getNamespaceContext(), 4, null, -1);
                    attribute.setRejectDuplicates();
                    this.makeSimpleContent(expression3, attribute, n);
                    return attribute;
                }
                if (string.equals("text")) {
                    this.nextToken();
                    if (this.t.currentToken == 115) {
                        this.lookAhead();
                        this.nextToken();
                        return EmptySequence.getInstance();
                    }
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    ValueOf valueOf = new ValueOf(this.stringify(expression), false);
                    this.setLocation(valueOf, n, this.executable);
                    return valueOf;
                }
                if (string.equals("comment")) {
                    this.nextToken();
                    if (this.t.currentToken == 115) {
                        this.lookAhead();
                        this.nextToken();
                        return EmptySequence.getInstance();
                    }
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    Comment comment = new Comment();
                    this.makeSimpleContent(expression, comment, n);
                    return comment;
                }
                if (string.equals("processing-instruction")) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression4 = null;
                    if (this.t.currentToken != 115) {
                        expression4 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    ProcessingInstruction processingInstruction = new ProcessingInstruction(expression);
                    this.makeSimpleContent(expression4, processingInstruction, n);
                    return processingInstruction;
                }
                this.grumble("Unrecognized node constructor " + this.t.currentTokenValue + "{}");
            }
            case 55: {
                int n3 = this.makeNameCode(this.t.currentTokenValue, true);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                FixedElement fixedElement = new FixedElement(n3, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), null, null, ((StaticQueryContext)this.env).getValidationMode());
                this.makeContentConstructor(expression, fixedElement, n);
                if (this.env.getConfiguration().getTraceListener() != null) {
                    return new TraceInstruction(fixedElement);
                }
                return fixedElement;
            }
            case 56: {
                int n4 = this.makeNameCode(this.t.currentTokenValue, false);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                FixedAttribute fixedAttribute = new FixedAttribute(n4, 4, null, -1);
                fixedAttribute.setRejectDuplicates();
                this.makeSimpleContent(expression, fixedAttribute, n);
                return fixedAttribute;
            }
            case 57: {
                StringValue stringValue = new StringValue(this.t.currentTokenValue);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                ProcessingInstruction processingInstruction = new ProcessingInstruction(stringValue);
                this.makeSimpleContent(expression, processingInstruction, n);
                return processingInstruction;
            }
        }
        return null;
    }

    private void makeSimpleContent(Expression expression, SimpleNodeConstructor simpleNodeConstructor, int n) {
        if (expression == null) {
            simpleNodeConstructor.setSelect(StringValue.EMPTY_STRING);
        } else {
            simpleNodeConstructor.setSelect(this.stringify(expression));
        }
        this.setLocation(simpleNodeConstructor, n, this.executable);
    }

    private void makeContentConstructor(Expression expression, ExprInstruction exprInstruction, int n) {
        if (expression == null) {
            exprInstruction.setChildren(null);
        } else if (expression instanceof AppendExpression) {
            ArrayList arrayList = new ArrayList();
            this.convertAppendExpression((AppendExpression)expression, arrayList);
            exprInstruction.setChildren(arrayList.toArray(new Instr[arrayList.size()]));
        } else if (expression instanceof Instr) {
            Instr[] instrArray = new Instr[]{(Instr)((Object)expression)};
            exprInstruction.setChildren(instrArray);
        } else {
            Instr[] instrArray = new Instruction[1];
            SequenceInstruction sequenceInstruction = new SequenceInstruction(expression, null);
            instrArray[0] = sequenceInstruction;
            this.setLocation(sequenceInstruction, n, this.executable);
            exprInstruction.setChildren(instrArray);
        }
        this.setLocation(exprInstruction, n, this.executable);
    }

    private void convertAppendExpression(AppendExpression appendExpression, List list) {
        Expression[] expressionArray = appendExpression.getSubExpressions();
        int n = 0;
        while (n < expressionArray.length) {
            if (expressionArray[n] instanceof AppendExpression) {
                this.convertAppendExpression((AppendExpression)expressionArray[n], list);
            } else if (expressionArray[n] instanceof Instr) {
                list.add(expressionArray[n]);
            } else {
                SequenceInstruction sequenceInstruction = new SequenceInstruction(expressionArray[n], null);
                if (expressionArray[n] instanceof ComputedExpression) {
                    this.setLocation(sequenceInstruction, ((ComputedExpression)expressionArray[n]).getLineNumber(), this.executable);
                } else {
                    this.setLocation(sequenceInstruction, appendExpression.getLineNumber(), this.executable);
                }
                list.add(sequenceInstruction);
            }
            ++n;
        }
    }

    private Expression parsePseudoXML(boolean bl) throws XPathException.Static {
        Expression expression = null;
        int n = this.t.getLineNumber();
        char c = this.t.nextChar();
        switch (c) {
            case '!': {
                c = this.t.nextChar();
                if (c == '-') {
                    expression = this.parseCommentConstructor();
                    break;
                }
                if (c == '[') {
                    expression = this.parseCDATAConstructor();
                    break;
                }
                this.grumble("Expected '--' or '[CDATA[' after '<!'");
                break;
            }
            case '?': {
                expression = this.parsePIConstructor();
                break;
            }
            case '/': {
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((c = this.t.nextChar()) != '>') {
                        stringBuffer.append(c);
                    }
                    return new StringValue(stringBuffer);
                }
                this.grumble("Unmatched XML end tag");
                break;
            }
            default: {
                this.t.unreadChar();
                expression = this.parseDirectElementConstructor();
            }
        }
        this.setLocation(expression, n, this.executable);
        return expression;
    }

    private Expression parseDirectElementConstructor() throws XPathException.Static {
        Instr[] instrArray;
        Object object;
        Object object2;
        Object object3;
        String string;
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
            stringBuffer.append(c);
        }
        String string2 = stringBuffer.toString();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while ((c = this.skipSpaces(c)) != '/' && c != '>') {
            Expression expression;
            stringBuffer.setLength(0);
            do {
                stringBuffer.append(c);
            } while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '=');
            string = stringBuffer.toString();
            if (!Name.isQName(string)) {
                this.grumble("Invalid attribute name " + Err.wrap(string, 2));
            }
            c = this.skipSpaces(c);
            this.expectChar(c, '=');
            c = this.t.nextChar();
            c = this.skipSpaces(c);
            try {
                expression = AttributeValueTemplate.make(this.t.input, this.t.inputIndex, c, this.env, this.rangeVariables, true);
            }
            catch (XPathException xPathException) {
                throw xPathException.makeStatic();
            }
            int n2 = (int)((IntegerValue)expression).getValue();
            object3 = this.t.input.substring(this.t.inputIndex, n2);
            this.t.inputIndex = n2 + 1;
            c = this.t.nextChar();
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
                this.grumble("There must be whitespace after every attribute except the last");
            }
            if (string.equals("xmlns") || string.startsWith("xmlns:")) {
                if (((String)object3).indexOf(123) >= 0) {
                    this.grumble("Namespace URI must be a constant value");
                }
                if (string.equals("xmlns")) {
                    object2 = "";
                    object = object3;
                } else {
                    object2 = string.substring(6);
                    object = object3;
                    if (((String)object).equals("")) {
                        this.grumble("Namespace URI must not be empty");
                    }
                }
                ++n;
                ((StaticQueryContext)this.env).declareActiveNamespace((String)object2, (String)object);
            }
            hashMap.put(string, object3);
        }
        string = null;
        int n3 = 0;
        try {
            String[] stringArray = Name.getQNameParts(string2);
            string = ((StaticQueryContext)this.env).checkURIForPrefix(stringArray[0]);
            if (string == null) {
                this.grumble("Undeclared prefix in element name " + Err.wrap(string2, 1));
            }
            n3 = this.env.getNamePool().allocate(stringArray[0], string, stringArray[1]);
        }
        catch (QNameException qNameException) {
            this.grumble("Invalid element name " + Err.wrap(string2, 1));
        }
        int n4 = ((StaticQueryContext)this.env).getValidationMode();
        object3 = ((StaticQueryContext)this.env).getValidationContext();
        if (n4 == 1 && object3.isVoidValidationContext()) {
            this.grumble("Element " + Err.wrap(string2, 1) + " is not permitted in the current validation context");
        }
        object2 = new FixedElement(n3, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), null, null, n4);
        this.setLocation((Expression)object2);
        if (this.env.getConfiguration().isSchemaAware()) {
            ((ElementCreator)object2).setValidationContext((ValidationContext)object3);
            try {
                ((StaticQueryContext)this.env).setContainedValidationContext(n3 & 0xFFFFF);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
            }
        }
        object = new ArrayList();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Expression expression;
            Object object4;
            instrArray = (Instr[])iterator.next();
            String string3 = (String)hashMap.get(instrArray);
            if (instrArray.equals("xmlns") || instrArray.startsWith("xmlns:")) continue;
            int n5 = 0;
            String string4 = null;
            try {
                object4 = Name.getQNameParts((String)instrArray);
                string4 = ((StaticQueryContext)this.env).checkURIForPrefix(object4[0]);
                if (string4 == null) {
                    this.grumble("Undeclared prefix in attribute name " + Err.wrap((CharSequence)instrArray, 2));
                }
                n5 = this.env.getNamePool().allocate(object4[0], string4, object4[1]);
            }
            catch (QNameException qNameException) {
                this.grumble("Invalid attribute name " + Err.wrap((CharSequence)instrArray, 2));
            }
            object4 = new FixedAttribute(n5, 4, null, -1);
            this.setLocation((Expression)object4);
            try {
                expression = AttributeValueTemplate.make(string3 + '\u0000', 0, '\u0000', this.env, this.rangeVariables, false);
            }
            catch (XPathException xPathException) {
                throw xPathException.makeStatic();
            }
            ((SimpleNodeConstructor)object4).setSelect(expression);
            ((FixedAttribute)object4).setRejectDuplicates();
            this.setLocation((Expression)object4);
            object.add(object4);
        }
        if (c == '/') {
            this.expectChar(this.t.nextChar(), '>');
        } else {
            this.readElementContent(string2, (List)object);
        }
        instrArray = new Instr[object.size()];
        int n6 = 0;
        while (n6 < object.size()) {
            if (object.get(n6) instanceof Instr) {
                if (n4 != 4 && object.get(n6) instanceof ElementCreator && ((ElementCreator)object.get(n6)).getValidationMode() == n4) {
                    ((ElementCreator)object.get(n6)).setValidationMode(3);
                }
                instrArray[n6] = (Instr)object.get(n6);
            } else {
                SequenceInstruction sequenceInstruction = new SequenceInstruction((Expression)object.get(n6), null);
                this.setLocation(sequenceInstruction);
                instrArray[n6] = sequenceInstruction;
                if (n6 + 1 < object.size() && !(object.get(n6) instanceof Instruction)) {
                    sequenceInstruction.setCloseTextNode(true);
                }
            }
            ++n6;
        }
        ((Instruction)object2).setChildren(instrArray);
        this.setLocation((Expression)object2);
        int n7 = 0;
        while (n7 < n) {
            ((StaticQueryContext)this.env).undeclareNamespace();
            ++n7;
        }
        if (this.env.getConfiguration().isSchemaAware()) {
            ((StaticQueryContext)this.env).popValidationContext();
        }
        if (this.env.getConfiguration().getTraceListener() != null) {
            return new TraceInstruction((Instruction)object2);
        }
        return object2;
    }

    private void readElementContent(String string, List list) throws XPathException.Static {
        try {
            while (true) {
                Expression expression;
                char c;
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                while ((c = this.t.nextChar()) != '<') {
                    if (c == '&') {
                        stringBuffer.append(this.readEntityReference());
                        bl = true;
                        continue;
                    }
                    if (c == '}') {
                        c = this.t.nextChar();
                        if (c != '}') {
                            this.grumble("'}' must be written as '}}' within element content");
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    if (c == '{') {
                        c = this.t.nextChar();
                        if (c != '{') {
                            c = '{';
                            break;
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer.length() > 0 && bl | this.preserveSpace | !Navigator.isWhite(stringBuffer)) {
                    expression = new ValueOf(new StringValue(stringBuffer.toString()), false);
                    this.setLocation(expression);
                    list.add(expression);
                }
                if (c != '<') {
                    this.t.unreadChar();
                    this.t.setState(0);
                    this.lookAhead();
                    this.nextToken();
                    expression = this.parseExpression();
                    list.add(expression);
                    this.expect(115);
                    continue;
                }
                expression = this.parsePseudoXML(true);
                if (expression instanceof StringValue) {
                    String string2 = ((StringValue)expression).getStringValue().trim();
                    if (string2.equals(string)) {
                        return;
                    }
                    this.grumble("end tag </" + string2 + "> does not match start tag <" + string + ">");
                    continue;
                }
                list.add(expression);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing end tag found for direct element constructor");
            return;
        }
    }

    private Expression parsePIConstructor() throws XPathException.Static {
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            int n = -1;
            while (!stringBuffer.toString().endsWith("?>")) {
                char c = this.t.nextChar();
                if (n < 0 && " \t\r\n".indexOf(c) >= 0) {
                    n = stringBuffer.length();
                }
                stringBuffer.append(c);
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            String string2 = "";
            if (n < 0) {
                string = stringBuffer.toString();
            } else {
                string = stringBuffer.substring(0, n);
                string2 = stringBuffer.substring(n + 1).trim();
            }
            if (!XMLChar.isValidNCName(string)) {
                this.grumble("Invalid processing instruction name " + Err.wrap(string));
            }
            ProcessingInstruction processingInstruction = new ProcessingInstruction(new StringValue(string));
            processingInstruction.setSelect(new StringValue(string2));
            this.setLocation(processingInstruction);
            return processingInstruction;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '?>' found for processing instruction");
            return null;
        }
    }

    private Expression parseCDATAConstructor() throws XPathException.Static {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, 'C');
            c = this.t.nextChar();
            this.expectChar(c, 'D');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, 'T');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, '[');
            StringBuffer stringBuffer = new StringBuffer();
            while (!stringBuffer.toString().endsWith("]]>")) {
                stringBuffer.append(this.t.nextChar());
            }
            String string = stringBuffer.substring(0, stringBuffer.length() - 3);
            ValueOf valueOf = new ValueOf(new StringValue(string), false);
            this.setLocation(valueOf);
            return valueOf;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ']]>' found for CDATA section");
            return null;
        }
    }

    private Expression parseCommentConstructor() throws XPathException.Static {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, '-');
            StringBuffer stringBuffer = new StringBuffer();
            while (!stringBuffer.toString().endsWith("--")) {
                stringBuffer.append(this.t.nextChar());
            }
            if (this.t.nextChar() != '>') {
                this.grumble("'--' is not permitted in an XML comment");
            }
            String string = stringBuffer.substring(0, stringBuffer.length() - 2);
            Comment comment = new Comment();
            comment.setSelect(new StringValue(string));
            this.setLocation(comment);
            return comment;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '-->' found for comment constructor");
            return null;
        }
    }

    private Expression stringify(Expression expression) {
        expression = new Atomizer(expression);
        expression = new AtomicSequenceConverter(expression, Type.STRING_TYPE);
        StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join");
        Expression[] expressionArray = new Expression[]{expression, new StringValue(" ")};
        stringJoin.setArguments(expressionArray);
        return stringJoin;
    }

    protected StringValue makeStringLiteral(String string) throws XPathException.Static {
        if (string.indexOf(38) == -1) {
            return new StringValue(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '&') {
                int n2 = string.indexOf(59, n);
                if (n2 < 0) {
                    this.grumble("No closing ';' found for entity or character reference");
                } else {
                    String string2 = string.substring(n + 1, n2);
                    stringBuffer.append(this.analyzeEntityReference(string2));
                    n = n2;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return new StringValue(stringBuffer);
    }

    private String readEntityReference() throws XPathException.Static {
        try {
            char c;
            StringBuffer stringBuffer = new StringBuffer();
            while ((c = this.t.nextChar()) != ';') {
                stringBuffer.append(c);
            }
            String string = stringBuffer.toString();
            return this.analyzeEntityReference(string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ';' found for entity or character reference");
            return null;
        }
    }

    private String analyzeEntityReference(String string) throws XPathException.Static {
        if (string.equals("lt")) {
            return "<";
        }
        if (string.equals("gt")) {
            return ">";
        }
        if (string.equals("amp")) {
            return "&";
        }
        if (string.equals("quot")) {
            return "\"";
        }
        if (string.equals("apos")) {
            return "'";
        }
        if (string.length() < 2 || string.charAt(0) != '#') {
            this.grumble("invalid entity reference &" + string + ";");
            return null;
        }
        string = string.toLowerCase();
        return this.parseCharacterReference(string);
    }

    private String parseCharacterReference(String string) throws XPathException.Static {
        int n = 0;
        if (string.charAt(1) == 'x') {
            int n2 = 2;
            while (n2 < string.length()) {
                int n3 = "0123456789abcdef".indexOf(string.charAt(n2));
                if (n3 < 0) {
                    this.grumble("invalid character '" + string.charAt(n2) + "' in hex character reference");
                }
                n = n * 16 + n3;
                ++n2;
            }
        } else {
            int n4 = 1;
            while (n4 < string.length()) {
                int n5 = "0123456789".indexOf(string.charAt(n4));
                if (n5 < 0) {
                    this.grumble("invalid character '" + string.charAt(n4) + "' in decimal character reference");
                }
                n = n * 10 + n5;
                ++n4;
            }
        }
        if (n < 32 && n != 10 && n != 9 && n != 13 || n >= 55296 && n <= 57343 || n == 65534 || n == 65535 || n > 0x10FFFF) {
            this.grumble("Invalid XML character reference x" + Integer.toHexString(n));
        }
        if (n <= 65535) {
            return "" + (char)n;
        }
        if (n <= 0x10FFFF) {
            return "" + (char)(0xD800 | (n -= 65536) >> 10) + (char)(0xDC00 | n & 0x3FF);
        }
        this.grumble("Character reference x" + Integer.toHexString(n) + " is too large");
        return null;
    }

    private void lookAhead() throws XPathException.Static {
        try {
            this.t.lookAhead();
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private char skipSpaces(char c) {
        while (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
            c = this.t.nextChar();
        }
        return c;
    }

    private void expectChar(char c, char c2) throws XPathException.Static {
        if (c != c2) {
            this.grumble("Expected '" + c2 + "', found '" + c + "'");
        }
    }

    protected String getLanguage() {
        return "XQuery";
    }

    private static class SortSpec {
        public Expression sortKey;
        public boolean ascending;
        public boolean emptyLeast;
        public String collation;

        private SortSpec() {
        }
    }

    private static class LetClause {
        public RangeVariableDeclaration variable;
        public Expression value;
        public int lineNumber;

        private LetClause() {
        }
    }
}

