/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import java.util.HashMap;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.saxon.Loader;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.ExtensionElementFactory;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.SaxonAssign;
import net.sf.saxon.style.SaxonCallTemplate;
import net.sf.saxon.style.SaxonCollation;
import net.sf.saxon.style.SaxonDoctype;
import net.sf.saxon.style.SaxonEntityRef;
import net.sf.saxon.style.SaxonImportQuery;
import net.sf.saxon.style.SaxonScript;
import net.sf.saxon.style.SaxonWhile;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAnalyzeString;
import net.sf.saxon.style.XSLApplyImports;
import net.sf.saxon.style.XSLApplyTemplates;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLChoose;
import net.sf.saxon.style.XSLComment;
import net.sf.saxon.style.XSLCopy;
import net.sf.saxon.style.XSLCopyOf;
import net.sf.saxon.style.XSLDecimalFormat;
import net.sf.saxon.style.XSLDocument;
import net.sf.saxon.style.XSLElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEach;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLIf;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLKey;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.style.XSLMessage;
import net.sf.saxon.style.XSLNamespace;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLNextMatch;
import net.sf.saxon.style.XSLNumber;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLPerformSort;
import net.sf.saxon.style.XSLPreserveSpace;
import net.sf.saxon.style.XSLProcessingInstruction;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLText;
import net.sf.saxon.style.XSLValueOf;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeFactory;
import org.xml.sax.Locator;

public class StyleNodeFactory
implements NodeFactory {
    HashMap userStyles = new HashMap();
    NamePool namePool;
    boolean allowExtensions;
    static /* synthetic */ Class class$net$sf$saxon$style$LiteralResultElement;
    static /* synthetic */ Class class$net$sf$saxon$style$AbsentExtensionElement;

    public StyleNodeFactory(NamePool namePool, boolean bl) {
        this.namePool = namePool;
        this.allowExtensions = bl;
    }

    public ElementImpl makeElementNode(NodeInfo nodeInfo, int n, AttributeCollection attributeCollection, int[] nArray, int n2, Locator locator, int n3) {
        Object object;
        Class clazz;
        boolean bl = nodeInfo instanceof XSLStyleSheet;
        String string = null;
        int n4 = -1;
        if (locator != null) {
            string = locator.getSystemId();
            n4 = locator.getLineNumber();
        }
        if (nodeInfo instanceof DataElement) {
            DataElement dataElement = new DataElement();
            dataElement.setNamespaceDeclarations(nArray, n2);
            dataElement.initialise(n, attributeCollection, nodeInfo, string, n4, n3);
            return dataElement;
        }
        int n5 = n & 0xFFFFF;
        StyleElement styleElement = this.makeXSLElement(n5);
        if (styleElement != null) {
            try {
                styleElement.setNamespaceDeclarations(nArray, n2);
                styleElement.setLineNumber(n4);
                styleElement.initialise(n, attributeCollection, nodeInfo, string, -1, n3);
                styleElement.processExtensionElementAttribute("extension-element-prefixes");
                styleElement.processExcludedNamespaces("exclude-result-prefixes");
                styleElement.processVersionAttribute("version");
                styleElement.processDefaultXPathNamespaceAttribute("xpath-default-namespace");
            }
            catch (TransformerException transformerException) {
                styleElement.setValidationError(transformerException, 1);
            }
            return styleElement;
        }
        short s = this.namePool.getURICode(n);
        String string2 = this.namePool.getLocalName(n);
        StyleElement styleElement2 = null;
        if (s == 2 && nodeInfo instanceof XSLStyleSheet && ((XSLStyleSheet)nodeInfo).getVersion().compareTo(BigDecimal.valueOf(50L)) <= 0) {
            styleElement2 = new AbsentExtensionElement();
            styleElement2.setValidationError(new TransformerException("Unknown top-level XSLT declaration"), 2);
        }
        Class clazz2 = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
        boolean bl2 = false;
        if (styleElement2 == null) {
            if (s == 3) {
                styleElement2 = this.makeSaxonElement(n5);
                if (styleElement2 != null) {
                    clazz2 = styleElement2.getClass();
                    bl2 = true;
                }
            } else if (bl && s != 0) {
                DataElement dataElement = new DataElement();
                dataElement.setNamespaceDeclarations(nArray, n2);
                dataElement.initialise(n, attributeCollection, nodeInfo, string, n4, n3);
                return dataElement;
            }
        }
        if (styleElement2 == null) {
            styleElement2 = new LiteralResultElement();
        }
        styleElement2.setNamespaceDeclarations(nArray, n2);
        try {
            styleElement2.initialise(n, attributeCollection, nodeInfo, string, n4, n3);
            styleElement2.setLineNumber(n4);
            styleElement2.processExtensionElementAttribute("{http://www.w3.org/1999/XSL/Transform}extension-element-prefixes");
            styleElement2.processExcludedNamespaces("{http://www.w3.org/1999/XSL/Transform}exclude-result-prefixes");
            styleElement2.processVersionAttribute("{http://www.w3.org/1999/XSL/Transform}version");
            styleElement2.processDefaultXPathNamespaceAttribute("{http://www.w3.org/1999/XSL/Transform}xpath-default-namespace");
        }
        catch (TransformerException transformerException) {
            styleElement2.setValidationError(transformerException, 2);
        }
        TransformerConfigurationException transformerConfigurationException = null;
        Class clazz3 = clazz = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
        if (s == 2) {
            transformerConfigurationException = new TransformerConfigurationException("Unknown XSLT element: " + string2);
            clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
            styleElement2.setValidationError(transformerConfigurationException, 2);
        } else if (s == 3 || s == 7) {
            if (bl || styleElement2.isExtensionNamespace(s)) {
                if (bl2) {
                    clazz = clazz2;
                } else {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    transformerConfigurationException = new TransformerConfigurationException("Unknown Saxon extension element: " + string2);
                    styleElement2.setValidationError(transformerConfigurationException, 3);
                }
            } else {
                clazz = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
            }
        } else if (styleElement2.isExtensionNamespace(s) && !bl) {
            object = new Integer(n & 0xFFFFF);
            clazz = (Class)this.userStyles.get(object);
            if (clazz == null) {
                if (!this.allowExtensions) {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    transformerConfigurationException = new TransformerConfigurationException("Extension elements are disabled");
                    styleElement2.setValidationError(transformerConfigurationException, 3);
                } else {
                    ExtensionElementFactory extensionElementFactory = this.getFactory(s);
                    if (extensionElementFactory != null && (clazz = extensionElementFactory.getExtensionClass(string2)) != null) {
                        this.userStyles.put(object, clazz);
                    }
                }
                if (clazz == null) {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    transformerConfigurationException = new TransformerConfigurationException("Unknown extension element", styleElement2);
                    styleElement2.setValidationError(transformerConfigurationException, 3);
                }
            }
        } else {
            Class clazz4 = clazz = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
        }
        if (!clazz.equals(clazz2)) {
            try {
                object = (StyleElement)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new TransformerFactoryConfigurationError(instantiationException, "Failed to create instance of " + clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TransformerFactoryConfigurationError(illegalAccessException, "Failed to access class " + clazz.getName());
            }
            ((StyleElement)object).substituteFor(styleElement2);
        } else {
            object = styleElement2;
        }
        return object;
    }

    private StyleElement makeXSLElement(int n) {
        switch (n) {
            case 128: {
                return new XSLAnalyzeString();
            }
            case 129: {
                return new XSLApplyImports();
            }
            case 130: {
                return new XSLApplyTemplates();
            }
            case 131: {
                return new XSLAttribute();
            }
            case 132: {
                return new XSLAttributeSet();
            }
            case 133: {
                return new XSLCallTemplate();
            }
            case 134: {
                return new XSLCharacterMap();
            }
            case 135: {
                return new XSLChoose();
            }
            case 138: {
                return new XSLComment();
            }
            case 139: {
                return new XSLCopy();
            }
            case 140: {
                return new XSLCopyOf();
            }
            case 141: {
                return new XSLDecimalFormat();
            }
            case 142: {
                return new XSLDocument();
            }
            case 143: {
                return new XSLElement();
            }
            case 144: {
                return new XSLFallback();
            }
            case 145: {
                return new XSLForEach();
            }
            case 148: {
                return new XSLForEachGroup();
            }
            case 149: {
                return new XSLFunction();
            }
            case 150: {
                return new XSLIf();
            }
            case 151: {
                return new XSLImport();
            }
            case 152: {
                return new XSLImportSchema();
            }
            case 153: {
                return new XSLInclude();
            }
            case 154: {
                return new XSLKey();
            }
            case 155: {
                return new XSLMatchingSubstring();
            }
            case 158: {
                return new XSLMessage();
            }
            case 159: {
                return new XSLNextMatch();
            }
            case 163: {
                return new XSLMatchingSubstring();
            }
            case 160: {
                return new XSLNumber();
            }
            case 161: {
                return new XSLNamespace();
            }
            case 162: {
                return new XSLNamespaceAlias();
            }
            case 164: {
                return new XSLOtherwise();
            }
            case 165: {
                return new XSLOutput();
            }
            case 169: {
                return new XSLOutputCharacter();
            }
            case 170: {
                return new XSLParam();
            }
            case 171: {
                return new XSLPerformSort();
            }
            case 172: {
                return new XSLPreserveSpace();
            }
            case 173: {
                return new XSLProcessingInstruction();
            }
            case 174: {
                return new XSLResultDocument();
            }
            case 175: {
                return new XSLSequence();
            }
            case 178: {
                return new XSLSort();
            }
            case 179: {
                return new XSLPreserveSpace();
            }
            case 180: {
                return new XSLStyleSheet();
            }
            case 181: {
                return new XSLTemplate();
            }
            case 182: {
                return new XSLText();
            }
            case 183: {
                return new XSLStyleSheet();
            }
            case 184: {
                return new XSLValueOf();
            }
            case 185: {
                return new XSLVariable();
            }
            case 188: {
                return new XSLWithParam();
            }
            case 189: {
                return new XSLWhen();
            }
        }
        return null;
    }

    private StyleElement makeSaxonElement(int n) {
        switch (n) {
            case 257: {
                return new SaxonAssign();
            }
            case 261: {
                return new SaxonEntityRef();
            }
            case 258: {
                return new SaxonCallTemplate();
            }
            case 259: {
                return new SaxonCollation();
            }
            case 260: {
                return new SaxonDoctype();
            }
            case 262: {
                return new SaxonImportQuery();
            }
            case 263: {
                return new SaxonScript();
            }
            case 264: {
                return new SaxonWhile();
            }
        }
        return null;
    }

    private ExtensionElementFactory getFactory(short s) {
        ExtensionElementFactory extensionElementFactory;
        String string = this.namePool.getURIFromNamespaceCode(s);
        int n = string.lastIndexOf(47);
        if (n < 0 || n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        try {
            extensionElementFactory = (ExtensionElementFactory)Loader.getInstance(string2);
        }
        catch (Exception exception) {
            return null;
        }
        return extensionElementFactory;
    }

    public boolean isElementAvailable(String string, String string2) {
        StyleElement styleElement;
        int n = this.namePool.getFingerprint(string, string2);
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (n == -1) {
                return false;
            }
            styleElement = this.makeXSLElement(n);
            if (styleElement != null) {
                return styleElement.isInstruction();
            }
        }
        if (string.equals("http://saxon.sf.net/")) {
            if (n == -1) {
                return false;
            }
            styleElement = this.makeSaxonElement(n);
            if (styleElement != null) {
                return styleElement.isInstruction();
            }
        }
        if (!this.allowExtensions) {
            return false;
        }
        short s = this.namePool.getCodeForURI(string);
        ExtensionElementFactory extensionElementFactory = this.getFactory(s);
        if (extensionElementFactory == null) {
            return false;
        }
        Class clazz = extensionElementFactory.getExtensionClass(string2);
        return clazz != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

