/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.instruct.CallableFunction;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FunctionInstr;
import net.sf.saxon.instruct.FunctionSignature;
import net.sf.saxon.instruct.Instr;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Param;
import net.sf.saxon.instruct.SequenceInstruction;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.Variable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class XSLFunction
extends StyleElement
implements FunctionSignature {
    private int functionFingerprint = -1;
    private SequenceType resultType;
    private String functionName;
    private Procedure procedure = new Procedure();
    private boolean memoFunction = false;
    private boolean override = true;
    private int numberOfArguments = -1;
    List references = new ArrayList();

    public void registerReference(UserFunctionCall userFunctionCall) {
        this.references.add(userFunctionCall);
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string3 = this.getNamePool().getClarkName(n2);
            if (string3 == "name") {
                string = attributeCollection.getValue(n).trim();
                if (string.indexOf(58) < 0) {
                    this.compileError("Function name must have a namespace prefix");
                }
                try {
                    int n3 = this.makeNameCode(string.trim());
                    this.functionFingerprint = n3 & 0xFFFFF;
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException.getMessage());
                }
            } else if (string3 == "as") {
                string2 = attributeCollection.getValue(n);
            } else if (string3 == "override") {
                String string4 = attributeCollection.getValue(n).trim();
                if (string4.equals("yes")) {
                    this.override = true;
                } else if (string4.equals("no")) {
                    this.override = false;
                } else {
                    this.compileError("override must be 'yes' or 'no'");
                }
            } else if (string3 == "{http://saxon.sf.net/}memo-function") {
                String string5 = attributeCollection.getValue(n).trim();
                if (string5.equals("yes")) {
                    this.memoFunction = true;
                } else if (string5.equals("no")) {
                    this.memoFunction = false;
                } else {
                    this.compileError("saxon:memo-function must be 'yes' or 'no'");
                }
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
        }
        this.resultType = string2 == null ? SequenceType.ANY_SEQUENCE : this.makeSequenceType(string2);
        this.functionName = string;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public boolean isOverriding() {
        return this.override;
    }

    public void fixupReferences() throws TransformerConfigurationException {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            ((UserFunctionCall)iterator.next()).setStaticType(this.resultType);
        }
        super.fixupReferences();
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.getNumberOfArguments();
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (e instanceof XSLFunction && e != this && ((XSLFunction)e).getFunctionFingerprint() == this.getFunctionFingerprint() && ((XSLFunction)e).getNumberOfArguments() == this.numberOfArguments && ((XSLFunction)e).getPrecedence() == this.getPrecedence()) {
                this.compileError("Duplicate function declaration");
            }
            --n;
        }
    }

    public ItemType getContextItemType() {
        return NoNodeTest.getInstance();
    }

    private boolean isCompilableAsExpression() {
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (true) {
            NodeInfo nodeInfo;
            if ((nodeInfo = (NodeInfo)axisIterator.next()) == null) {
                return true;
            }
            if (nodeInfo.getNodeKind() == 3) {
                return false;
            }
            if (nodeInfo instanceof XSLParam && n == 0) continue;
            if (nodeInfo instanceof XSLVariable && n < 2) {
                if (nodeInfo.hasChildNodes()) {
                    return false;
                }
                n = 1;
                continue;
            }
            if (!(nodeInfo instanceof XSLSequence) || n >= 2) break;
            if (nodeInfo.hasChildNodes()) {
                return false;
            }
            n = 2;
        }
        return false;
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
        if (this.isCompilableAsExpression()) {
            this.compileAsExpression(executable);
        } else {
            this.compileAsTemplate(executable);
        }
        return null;
    }

    private void compileAsExpression(Executable executable) throws TransformerConfigurationException {
        Serializable serializable;
        SequenceInstruction sequenceInstruction = new SequenceInstruction(null, this.resultType);
        Instruction[] instructionArray = this.compileChildren(executable, sequenceInstruction);
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        int n = 0;
        while (n < instructionArray.length) {
            if (!(instructionArray[n] instanceof Param)) {
                arrayList.add(instructionArray[n]);
            }
            ++n;
        }
        Expression expression = this.convertToExpression(arrayList, 0);
        try {
            if (this.resultType != null) {
                serializable = new RoleLocator(5, this.functionName, 0);
                expression = TypeChecker.staticTypeCheck(expression, this.resultType, false, (RoleLocator)serializable);
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        serializable = new UserFunction(expression);
        ((UserFunction)serializable).setFunctionName(this.functionName);
        ((UserFunction)serializable).setLineNumber(this.getLineNumber());
        ((UserFunction)serializable).setSystemId(this.getSystemId());
        this.fixupInstruction((CallableFunction)((Object)serializable));
    }

    private Expression convertToExpression(List list, int n) {
        if (list.size() <= n) {
            return EmptySequence.getInstance();
        }
        Instr instr = (Instr)list.get(n);
        if (instr instanceof TraceInstruction) {
            instr = ((TraceInstruction)instr).getChildren()[0];
        }
        if (instr instanceof Expression) {
            return (Expression)((Object)instr);
        }
        if (instr instanceof Variable) {
            Variable variable = (Variable)instr;
            LetExpression letExpression = new LetExpression();
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setRequiredType(variable.getRequiredType());
            rangeVariableDeclaration.setVariableFingerprint(variable.getVariableFingerprint());
            rangeVariableDeclaration.setVariableName(variable.getVariableName());
            letExpression.setVariableDeclaration(rangeVariableDeclaration);
            letExpression.setSequence(variable.getSelectExpression());
            letExpression.setSlotNumber(((Variable)instr).getSlotNumber());
            letExpression.setAction(this.convertToExpression(list, n + 1));
            return letExpression;
        }
        if (instr instanceof SequenceInstruction) {
            Expression expression = ((SequenceInstruction)instr).getSelectExpression();
            ExpressionTool.markTailFunctionCalls(expression);
            return expression;
        }
        throw new AssertionError((Object)"Function contains inappropriate instructions for compiling as an expression");
    }

    private void compileAsTemplate(Executable executable) throws TransformerConfigurationException {
        SequenceInstruction sequenceInstruction = new SequenceInstruction(null, this.resultType);
        Instruction[] instructionArray = this.compileChildren(executable, sequenceInstruction);
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        int n = 0;
        while (n < instructionArray.length) {
            if (!(instructionArray[n] instanceof Param)) {
                arrayList.add(instructionArray[n]);
            }
            ++n;
        }
        Instr[] instrArray = new Instruction[arrayList.size()];
        instrArray = arrayList.toArray(instrArray);
        sequenceInstruction.setChildren(instrArray);
        FunctionInstr functionInstr = new FunctionInstr();
        functionInstr.initialize(sequenceInstruction, this.getBaseURI(), this.functionName, this.memoFunction);
        functionInstr.setLineNumber(this.getLineNumber());
        this.fixupInstruction(functionInstr);
    }

    private void fixupInstruction(CallableFunction callableFunction) throws TransformerConfigurationException {
        try {
            Iterator iterator = this.references.iterator();
            while (iterator.hasNext()) {
                ((UserFunctionCall)iterator.next()).setFunction(this, callableFunction);
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public int getFunctionFingerprint() {
        if (this.functionFingerprint == -1) {
            try {
                this.prepareAttributes();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                return -1;
            }
        }
        return this.functionFingerprint;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public int getNumberOfArguments() {
        if (this.numberOfArguments == -1) {
            Item item;
            this.numberOfArguments = 0;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((item = axisIterator.next()) instanceof XSLParam) {
                ++this.numberOfArguments;
            }
            return this.numberOfArguments;
        }
        return this.numberOfArguments;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] sequenceTypeArray = new SequenceType[this.getNumberOfArguments()];
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLParam)) continue;
            sequenceTypeArray[n++] = ((XSLParam)nodeInfo).getRequiredType();
        }
        return sequenceTypeArray;
    }
}

