/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public abstract class XSLGeneralVariable
extends StyleElement {
    protected int variableFingerprint = -1;
    protected Expression select = null;
    protected SequenceType requiredType = null;
    protected String constantText = null;
    protected boolean global;
    protected Procedure procedure = null;
    protected boolean assignable = false;
    protected boolean redundant = false;
    protected boolean requiredParam = false;
    protected boolean tunnel = false;
    private boolean textonly;

    protected ItemType getReturnedItemType() {
        return NoNodeTest.getInstance();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean allowsAsAttribute() {
        return true;
    }

    protected boolean allowsTunnelAttribute() {
        return false;
    }

    protected boolean allowsValue() {
        return true;
    }

    protected boolean allowsRequired() {
        return false;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public boolean isTunnelParam() {
        return this.tunnel;
    }

    public boolean isRequiredParam() {
        return this.requiredParam;
    }

    public String getVariableName() {
        return this.getAttributeValue("name");
    }

    public void setRedundant() {
        this.redundant = true;
    }

    public int getVariableFingerprint() {
        block4: {
            if (this.variableFingerprint != -1) break block4;
            String string = this.getAttributeValue("name");
            if (string == null) {
                return -1;
            }
            try {
                this.variableFingerprint = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.variableFingerprint = -1;
            }
            catch (XPathException xPathException) {
                this.variableFingerprint = -1;
            }
        }
        return this.variableFingerprint;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        this.getVariableFingerprint();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string7 = this.getNamePool().getClarkName(n2);
            if (string7 == "name") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string7 == "select") {
                string = attributeCollection.getValue(n);
            } else if (string7 == "as" && this.allowsAsAttribute()) {
                string4 = attributeCollection.getValue(n);
            } else if (string7 == "required" && this.allowsRequired()) {
                string5 = attributeCollection.getValue(n).trim();
            } else if (string7 == "tunnel" && this.allowsTunnelAttribute()) {
                string6 = attributeCollection.getValue(n).trim();
            } else if (string7 == "{http://saxon.sf.net/}assignable" && this instanceof XSLVariableDeclaration) {
                string2 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string3 == null) {
            this.reportAbsence("name");
        } else {
            try {
                this.variableFingerprint = this.makeNameCode(string3.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
            }
        }
        if (string != null) {
            if (!this.allowsValue()) {
                this.compileError("Function parameters cannot have a default value");
            }
            this.select = this.makeExpression(string);
        }
        if (string2 != null && string2.equals("yes")) {
            this.assignable = true;
        }
        if (string5 != null) {
            if (string5.equals("yes")) {
                this.requiredParam = true;
            } else if (string5.equals("no")) {
                this.requiredParam = false;
            } else {
                this.compileError("The attribute 'required' must be set to 'yes' or 'no'");
            }
        }
        if (string6 != null) {
            if (string6.equals("yes")) {
                this.tunnel = true;
            } else if (string6.equals("no")) {
                this.tunnel = false;
            } else {
                this.compileError("The attribute 'tunnel' must be set to 'yes' or 'no'");
            }
        }
        if (string4 != null) {
            this.requiredType = this.makeSequenceType(string4);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.global = this.getParentNode() instanceof XSLStyleSheet;
        if (this.global) {
            this.procedure = new Procedure();
        }
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty");
        }
        this.checkAgainstRequiredType(this.requiredType);
        if (this.select == null && this.allowsValue()) {
            this.textonly = true;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (nodeInfo == null) {
                if (this.requiredType == null) {
                    this.select = StringValue.EMPTY_STRING;
                } else if (this instanceof XSLParam) {
                    if (!this.requiredParam) {
                        if (Cardinality.allowsZero(this.requiredType.getCardinality())) {
                            this.select = EmptySequence.getInstance();
                        } else {
                            this.requiredParam = true;
                        }
                    }
                } else if (Cardinality.allowsZero(this.requiredType.getCardinality())) {
                    this.select = EmptySequence.getInstance();
                } else {
                    this.compileError("Default value () is not valid for the declared type");
                }
            } else {
                if (axisIterator.next() == null && nodeInfo.getNodeKind() == 3) {
                    this.constantText = nodeInfo.getStringValue();
                }
                this.textonly = this.getCommonChildItemType() == NodeKindTest.TEXT;
            }
        }
        this.select = this.typeCheck("select", this.select);
    }

    protected void checkAgainstRequiredType(SequenceType sequenceType) throws TransformerConfigurationException {
        try {
            RoleLocator roleLocator = new RoleLocator(3, this.getVariableName(), 0);
            if (this.requiredType != null && this.select != null) {
                this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, roleLocator);
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    protected void initializeInstruction(Executable executable, GeneralVariable generalVariable) throws TransformerConfigurationException {
        generalVariable.init(this.select, this.requiredType, this.variableFingerprint);
        generalVariable.setGlobal(this.global);
        generalVariable.setAssignable(this.assignable);
        generalVariable.setRequiredParam(this.requiredParam);
        generalVariable.setTunnel(this.tunnel);
        generalVariable.setContainsLocals(this.global && this.procedure.getNumberOfVariables() > 0);
        if (this.hasChildNodes() && this.requiredType == null) {
            DocumentInstr documentInstr = new DocumentInstr(this.textonly, this.constantText, this.getBaseURI());
            this.compileChildren(executable, documentInstr);
            generalVariable.setSelect(documentInstr);
        } else {
            this.compileChildren(executable, generalVariable);
        }
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    protected void setAdditionalTraceProperties(TraceInstruction traceInstruction) {
        traceInstruction.setProperty("name", this.getVariableName());
    }
}

