/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public final class SequenceType
implements Serializable {
    private ItemType primaryType;
    private int cardinality;
    public static final SequenceType ANY_SEQUENCE = new SequenceType(AnyItemType.getInstance(), 1792);
    public static final SequenceType SINGLE_ITEM = new SequenceType(AnyItemType.getInstance(), 512);
    public static final SequenceType SINGLE_ATOMIC = new SequenceType(Type.ANY_ATOMIC_TYPE, 512);
    public static final SequenceType OPTIONAL_ATOMIC = new SequenceType(Type.ANY_ATOMIC_TYPE, 768);
    public static final SequenceType ATOMIC_SEQUENCE = new SequenceType(Type.ANY_ATOMIC_TYPE, 1792);
    public static final SequenceType SINGLE_STRING = new SequenceType(Type.STRING_TYPE, 512);
    public static final SequenceType OPTIONAL_STRING = new SequenceType(Type.STRING_TYPE, 768);
    public static final SequenceType SINGLE_INTEGER = new SequenceType(Type.INTEGER_TYPE, 512);
    public static final SequenceType OPTIONAL_INTEGER = new SequenceType(Type.INTEGER_TYPE, 768);
    public static final SequenceType OPTIONAL_NODE = new SequenceType(AnyNodeTest.getInstance(), 768);
    public static final SequenceType SINGLE_NODE = new SequenceType(AnyNodeTest.getInstance(), 512);
    public static final SequenceType NODE_SEQUENCE = new SequenceType(AnyNodeTest.getInstance(), 1792);
    public static final SequenceType NUMERIC_SEQUENCE = new SequenceType(Type.NUMBER_TYPE, 1792);

    public SequenceType(ItemType itemType, int n) {
        this.primaryType = itemType;
        this.cardinality = n;
    }

    public ItemType getPrimaryType() {
        return this.primaryType;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String toString() {
        String string = this.primaryType.toString();
        if (this.cardinality == 1536) {
            string = string + " +";
        } else if (this.cardinality == 1792) {
            string = string + " *";
        } else if (this.cardinality == 768) {
            string = string + " ?";
        }
        return string;
    }
}

