.\" DO NOT MODIFY THIS FILE!  It was generated by help2man 1.40.4.
.TH DCONV "1" "January 2014" "dateutils 0.2.7" "User Commands"
.SH NAME
dconv - Convert dates between calendars or time zones
.SH SYNOPSIS
.B dconv
[\fIOPTION\fR]... [\fIDATE/TIME\fR]...
.SH DESCRIPTION
dconv 0.2.7
.PP
Convert DATE/TIMEs between calendrical systems.
If DATE/TIME is omitted date/times are read from stdin.
.PP
DATE/TIME can also be one of the following specials
.TP
\- `now'
interpreted as the current (UTC) time stamp
.TP
\- `time'
the time part of the current (UTC) time stamp
.TP
\- `today'
the current date (according to UTC)
.TP
\- `tomo[rrow]'
tomorrow's date (according to UTC)
.TP
\- `y[ester]day'
yesterday's date (according to UTC)
.TP
\fB\-h\fR, \fB\-\-help\fR
Print help and exit
.TP
\fB\-V\fR, \fB\-\-version\fR
Print version and exit
.TP
\fB\-q\fR, \fB\-\-quiet\fR
Suppress message about date/time and duration
parser errors.
.TP
\fB\-f\fR, \fB\-\-format\fR=\fISTRING\fR
Output format.  This can either be a specifier
string (similar to strftime()'s FMT) or the name
of a calendar.
.TP
\fB\-i\fR, \fB\-\-input\-format\fR=\fISTRING\fR
Input format, can be used multiple times.
Each date/time will be passed to the input
format parsers in the order they are given, if a
date/time can be read successfully with a given
input format specifier string, that value will
be used.
.TP
\fB\-\-default\fR=\fIDT\fR
For underspecified input use DT as a fallback to
fill in missing fields.  Must be a date/time in
ISO8601 format.  If omitted the default value is
the current date/time.
.TP
\fB\-e\fR, \fB\-\-backslash\-escapes\fR
Enable interpretation of backslash escapes in the
output and input format specifier strings.
.TP
\fB\-S\fR, \fB\-\-sed\-mode\fR
Copy parts from the input before and after a
matching date/time.
Note that all occurrences of date/times within a
line will be processed.
.TP
\fB\-\-from\-zone\fR=\fIZONE\fR
Interpret dates on stdin or the command line as
coming from the time zone ZONE.
.TP
\fB\-z\fR, \fB\-\-zone\fR=\fIZONE\fR
Convert dates printed on stdout to time zone ZONE,
default: UTC.
.SH EXAMPLES

  $ dconv 2012-03-01
  2012-03-01
  $


  $ dconv -i "%d/%b/%y" 01/Mar/12
  2012-03-01
  $


  $ dconv -f "%d/%b/%y" 2012-03-01
  01/Mar/12
  $


  $ dconv -f "%d/%b/%y" -i "%OY %Om %Od" "MCMXCVIII IX XVII"
  17/Sep/98
  $


  $ dconv 12:03:01
  12:03:01
  $


  $ dconv -i "%I:%M:%S %p" "11:22:33 PM"
  23:22:33
  $


  $ dconv '2012-03-01 00:00:00'
  2012-03-01T00:00:00
  $


  $ dconv 2012-03-01T12:34:56
  2012-03-01T12:34:56
  $


  $ dconv --zone America/Chicago <<EOF
  2012-03-01T07:05:06
  2012-03-01T08:12:34
  2012-03-11T01:05:06
  2012-03-11T02:05:06
  2012-03-11T07:05:06
  2012-03-11T08:05:06
  2012-03-11T17:05:06
  EOF
  2012-03-01T01:05:06
  2012-03-01T02:12:34
  2012-03-10T19:05:06
  2012-03-10T20:05:06
  2012-03-11T01:05:06
  2012-03-11T03:05:06
  2012-03-11T12:05:06
  $


  $ dconv --from-zone America/Chicago <<EOF
  2012-03-01T01:05:06
  2012-03-01T02:12:34
  2012-03-10T19:05:06
  2012-03-10T20:05:06
  2012-03-11T01:05:06
  2012-03-11T03:05:06
  2012-03-11T12:05:06
  EOF
  2012-03-01T07:05:06
  2012-03-01T08:12:34
  2012-03-11T01:05:06
  2012-03-11T02:05:06
  2012-03-11T07:05:06
  2012-03-11T08:05:06
  2012-03-11T17:05:06
  $


  $ dconv --from-zone America/Chicago -z Europe/Berlin '2012-03-01 12:00' -i '%F %H:%M' -f '%F %T'
  2012-03-01 19:00:00
  $
.SH AUTHOR
Written by Sebastian Freundt <freundt@fresse.org>
.SH "REPORTING BUGS"
Report bugs to: https://github.com/hroptatyr/dateutils/issues
.SH "SEE ALSO"
The full documentation for
.B dconv
is maintained as a Texinfo manual.  If the
.B info
and
.B dconv
programs are properly installed at your site, the command
.IP
.B info (dateutils)dconv
.PP
should give you access to the complete manual.
